/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.relation;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collections;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import org.openstreetmap.josm.gui.dialogs.relation.MemberTableModel;
import org.openstreetmap.josm.gui.dialogs.relation.SelectionTableColumnModel;
import org.openstreetmap.josm.gui.dialogs.relation.SelectionTableModel;

public class SelectionTable
extends JTable {
    private final SelectionTableModel model;
    private final MemberTableModel memberTableModel;

    public SelectionTable(SelectionTableModel model, MemberTableModel memberTableModel) {
        super(model, new SelectionTableColumnModel(memberTableModel));
        this.model = model;
        this.memberTableModel = memberTableModel;
        this.build();
    }

    protected void build() {
        this.setSelectionMode(0);
        this.addMouseListener(new DoubleClickAdapter());
        this.memberTableModel.addTableModelListener(e -> this.repaint());
    }

    class DoubleClickAdapter
    extends MouseAdapter {
        DoubleClickAdapter() {
        }

        @Override
        public void mouseClicked(MouseEvent evt) {
            if (!SwingUtilities.isLeftMouseButton(evt) || evt.getClickCount() <= 1) {
                return;
            }
            int row = SelectionTable.this.rowAtPoint(evt.getPoint());
            SelectionTable.this.memberTableModel.selectMembersReferringTo(Collections.singleton(SelectionTable.this.model.getPrimitive(row)));
        }
    }
}

