/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.update;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.LongSupplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.DocWriteResponse;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.action.update.UpdateResponse;
import org.elasticsearch.client.Requests;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.VersionType;
import org.elasticsearch.index.engine.DocumentMissingException;
import org.elasticsearch.index.engine.DocumentSourceMissingException;
import org.elasticsearch.index.get.GetResult;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.script.Script;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.script.UpdateScript;
import org.elasticsearch.search.lookup.SourceLookup;

public class UpdateHelper {
    private static final Logger logger = LogManager.getLogger(UpdateHelper.class);
    private final ScriptService scriptService;

    public UpdateHelper(ScriptService scriptService) {
        this.scriptService = scriptService;
    }

    public Result prepare(UpdateRequest request, IndexShard indexShard, LongSupplier nowInMillis) {
        GetResult getResult = indexShard.getService().getForUpdate(request.type(), request.id(), request.ifSeqNo(), request.ifPrimaryTerm());
        return this.prepare(indexShard.shardId(), request, getResult, nowInMillis);
    }

    protected Result prepare(ShardId shardId, UpdateRequest request, GetResult getResult, LongSupplier nowInMillis) {
        if (!getResult.isExists()) {
            return this.prepareUpsert(shardId, request, getResult, nowInMillis);
        }
        if (getResult.internalSourceRef() == null) {
            throw new DocumentSourceMissingException(shardId, request.type(), request.id());
        }
        if (request.script() == null && request.doc() != null) {
            return this.prepareUpdateIndexRequest(shardId, request, getResult, request.detectNoop());
        }
        return this.prepareUpdateScriptRequest(shardId, request, getResult, nowInMillis);
    }

    Tuple<UpdateOpType, Map<String, Object>> executeScriptedUpsert(IndexRequest upsert, Script script, LongSupplier nowInMillis) {
        Map<String, Object> upsertDoc = upsert.sourceAsMap();
        Map<String, Object> ctx = new HashMap<String, Object>(3);
        ctx.put("op", UpdateOpType.CREATE.toString());
        ctx.put("_source", upsertDoc);
        ctx.put("_now", nowInMillis.getAsLong());
        ctx = this.executeScript(script, ctx);
        UpdateOpType operation = UpdateOpType.lenientFromString((String)ctx.get("op"), logger, script.getIdOrCode());
        Map newSource = (Map)ctx.get("_source");
        if (operation != UpdateOpType.CREATE && operation != UpdateOpType.NONE) {
            logger.warn("Invalid upsert operation [{}] for script [{}], doing nothing...", (Object)operation, (Object)script.getIdOrCode());
            operation = UpdateOpType.NONE;
        }
        return new Tuple((Object)operation, (Object)newSource);
    }

    Result prepareUpsert(ShardId shardId, UpdateRequest request, GetResult getResult, LongSupplier nowInMillis) {
        IndexRequest indexRequest;
        if (request.upsertRequest() == null && !request.docAsUpsert()) {
            throw new DocumentMissingException(shardId, request.type(), request.id());
        }
        IndexRequest indexRequest2 = indexRequest = request.docAsUpsert() ? request.doc() : request.upsertRequest();
        if (request.scriptedUpsert() && request.script() != null) {
            IndexRequest upsert = request.upsertRequest();
            Tuple<UpdateOpType, Map<String, Object>> upsertResult = this.executeScriptedUpsert(upsert, request.script, nowInMillis);
            switch ((UpdateOpType)((Object)upsertResult.v1())) {
                case CREATE: {
                    indexRequest.source((Map)upsertResult.v2());
                    break;
                }
                case NONE: {
                    UpdateResponse update = new UpdateResponse(shardId, getResult.getType(), getResult.getId(), getResult.getVersion(), DocWriteResponse.Result.NOOP);
                    update.setGetResult(getResult);
                    return new Result(update, DocWriteResponse.Result.NOOP, (Map)upsertResult.v2(), XContentType.JSON);
                }
                default: {
                    throw new IllegalArgumentException("unknown upsert operation, got: " + upsertResult.v1());
                }
            }
        }
        ((IndexRequest)((IndexRequest)((IndexRequest)((IndexRequest)indexRequest.index(request.index())).type(request.type()).id(request.id()).setRefreshPolicy(request.getRefreshPolicy())).routing(request.routing()).timeout(request.timeout())).waitForActiveShards(request.waitForActiveShards())).create(true);
        if (request.versionType() != VersionType.INTERNAL) {
            indexRequest.version(request.version()).versionType(request.versionType());
        }
        return new Result(indexRequest, DocWriteResponse.Result.CREATED, null, null);
    }

    @Nullable
    static String calculateRouting(GetResult getResult, @Nullable IndexRequest updateIndexRequest) {
        if (updateIndexRequest != null && updateIndexRequest.routing() != null) {
            return updateIndexRequest.routing();
        }
        if (getResult.getFields().containsKey("_routing")) {
            return getResult.field("_routing").getValue().toString();
        }
        return null;
    }

    Result prepareUpdateIndexRequest(ShardId shardId, UpdateRequest request, GetResult getResult, boolean detectNoop) {
        boolean noop;
        IndexRequest currentRequest = request.doc();
        String routing = UpdateHelper.calculateRouting(getResult, currentRequest);
        Tuple<XContentType, Map<String, Object>> sourceAndContent = XContentHelper.convertToMap(getResult.internalSourceRef(), true);
        XContentType updateSourceContentType = (XContentType)sourceAndContent.v1();
        Map updatedSourceAsMap = (Map)sourceAndContent.v2();
        boolean bl = noop = !XContentHelper.update(updatedSourceAsMap, currentRequest.sourceAsMap(), detectNoop);
        if (detectNoop && noop) {
            UpdateResponse update = new UpdateResponse(shardId, getResult.getType(), getResult.getId(), getResult.getVersion(), DocWriteResponse.Result.NOOP);
            update.setGetResult(UpdateHelper.extractGetResult(request, request.index(), getResult.getSeqNo(), getResult.getPrimaryTerm(), getResult.getVersion(), updatedSourceAsMap, updateSourceContentType, getResult.internalSourceRef()));
            return new Result(update, DocWriteResponse.Result.NOOP, updatedSourceAsMap, updateSourceContentType);
        }
        IndexRequest finalIndexRequest = (IndexRequest)((IndexRequest)((IndexRequest)Requests.indexRequest(request.index()).type(request.type()).id(request.id()).routing(routing).source(updatedSourceAsMap, updateSourceContentType).setIfSeqNo(getResult.getSeqNo()).setIfPrimaryTerm(getResult.getPrimaryTerm()).waitForActiveShards(request.waitForActiveShards())).timeout(request.timeout())).setRefreshPolicy(request.getRefreshPolicy());
        return new Result(finalIndexRequest, DocWriteResponse.Result.UPDATED, updatedSourceAsMap, updateSourceContentType);
    }

    Result prepareUpdateScriptRequest(ShardId shardId, UpdateRequest request, GetResult getResult, LongSupplier nowInMillis) {
        IndexRequest currentRequest = request.doc();
        String routing = UpdateHelper.calculateRouting(getResult, currentRequest);
        Tuple<XContentType, Map<String, Object>> sourceAndContent = XContentHelper.convertToMap(getResult.internalSourceRef(), true);
        XContentType updateSourceContentType = (XContentType)sourceAndContent.v1();
        Map sourceAsMap = (Map)sourceAndContent.v2();
        Map<String, Object> ctx = new HashMap<String, Object>(16);
        ctx.put("op", UpdateOpType.INDEX.toString());
        ctx.put("_index", getResult.getIndex());
        ctx.put("_type", getResult.getType());
        ctx.put("_id", getResult.getId());
        ctx.put("_version", getResult.getVersion());
        ctx.put("_routing", routing);
        ctx.put("_source", sourceAsMap);
        ctx.put("_now", nowInMillis.getAsLong());
        ctx = this.executeScript(request.script, ctx);
        UpdateOpType operation = UpdateOpType.lenientFromString((String)ctx.get("op"), logger, request.script.getIdOrCode());
        Map updatedSourceAsMap = (Map)ctx.get("_source");
        switch (operation) {
            case INDEX: {
                IndexRequest indexRequest = (IndexRequest)((IndexRequest)((IndexRequest)Requests.indexRequest(request.index()).type(request.type()).id(request.id()).routing(routing).source(updatedSourceAsMap, updateSourceContentType).setIfSeqNo(getResult.getSeqNo()).setIfPrimaryTerm(getResult.getPrimaryTerm()).waitForActiveShards(request.waitForActiveShards())).timeout(request.timeout())).setRefreshPolicy(request.getRefreshPolicy());
                return new Result(indexRequest, DocWriteResponse.Result.UPDATED, updatedSourceAsMap, updateSourceContentType);
            }
            case DELETE: {
                DeleteRequest deleteRequest = (DeleteRequest)((DeleteRequest)((DeleteRequest)Requests.deleteRequest(request.index()).type(request.type()).id(request.id()).routing(routing).setIfSeqNo(getResult.getSeqNo()).setIfPrimaryTerm(getResult.getPrimaryTerm()).waitForActiveShards(request.waitForActiveShards())).timeout(request.timeout())).setRefreshPolicy(request.getRefreshPolicy());
                return new Result(deleteRequest, DocWriteResponse.Result.DELETED, updatedSourceAsMap, updateSourceContentType);
            }
        }
        UpdateResponse update = new UpdateResponse(shardId, getResult.getType(), getResult.getId(), getResult.getVersion(), DocWriteResponse.Result.NOOP);
        update.setGetResult(UpdateHelper.extractGetResult(request, request.index(), getResult.getSeqNo(), getResult.getPrimaryTerm(), getResult.getVersion(), updatedSourceAsMap, updateSourceContentType, getResult.internalSourceRef()));
        return new Result(update, DocWriteResponse.Result.NOOP, updatedSourceAsMap, updateSourceContentType);
    }

    private Map<String, Object> executeScript(Script script, Map<String, Object> ctx) {
        try {
            if (this.scriptService != null) {
                UpdateScript.Factory factory = this.scriptService.compile(script, UpdateScript.CONTEXT);
                UpdateScript executableScript = factory.newInstance(script.getParams(), ctx);
                executableScript.execute();
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("failed to execute script", e);
        }
        return ctx;
    }

    public static GetResult extractGetResult(UpdateRequest request, String concreteIndex, long seqNo, long primaryTerm, long version, Map<String, Object> source, XContentType sourceContentType, @Nullable BytesReference sourceAsBytes) {
        if (request.fetchSource() == null || !request.fetchSource().fetchSource()) {
            return null;
        }
        BytesReference sourceFilteredAsBytes = sourceAsBytes;
        if (request.fetchSource().includes().length > 0 || request.fetchSource().excludes().length > 0) {
            SourceLookup sourceLookup = new SourceLookup();
            sourceLookup.setSource(source);
            Object value = sourceLookup.filter(request.fetchSource());
            try {
                int initialCapacity = Math.min(1024, sourceAsBytes.length());
                BytesStreamOutput streamOutput = new BytesStreamOutput(initialCapacity);
                try (XContentBuilder builder = new XContentBuilder(sourceContentType.xContent(), (OutputStream)streamOutput);){
                    builder.value(value);
                    sourceFilteredAsBytes = BytesReference.bytes(builder);
                }
            }
            catch (IOException e) {
                throw new ElasticsearchException("Error filtering source", (Throwable)e, new Object[0]);
            }
        }
        return new GetResult(concreteIndex, request.type(), request.id(), seqNo, primaryTerm, version, true, sourceFilteredAsBytes, Collections.emptyMap(), Collections.emptyMap());
    }

    public static class ContextFields {
        public static final String CTX = "ctx";
        public static final String OP = "op";
        public static final String SOURCE = "_source";
        public static final String NOW = "_now";
        public static final String INDEX = "_index";
        public static final String TYPE = "_type";
        public static final String ID = "_id";
        public static final String VERSION = "_version";
        public static final String ROUTING = "_routing";
    }

    static enum UpdateOpType {
        CREATE("create"),
        INDEX("index"),
        DELETE("delete"),
        NONE("none");

        private final String name;

        private UpdateOpType(String name) {
            this.name = name;
        }

        public static UpdateOpType lenientFromString(String operation, Logger logger, String scriptId) {
            switch (operation) {
                case "create": {
                    return CREATE;
                }
                case "index": {
                    return INDEX;
                }
                case "delete": {
                    return DELETE;
                }
                case "none": {
                    return NONE;
                }
            }
            logger.warn("Used upsert operation [{}] for script [{}], doing nothing...", (Object)operation, (Object)scriptId);
            return NONE;
        }

        public String toString() {
            return this.name;
        }
    }

    public static class Result {
        private final Streamable action;
        private final DocWriteResponse.Result result;
        private final Map<String, Object> updatedSourceAsMap;
        private final XContentType updateSourceContentType;

        public Result(Streamable action, DocWriteResponse.Result result, Map<String, Object> updatedSourceAsMap, XContentType updateSourceContentType) {
            this.action = action;
            this.result = result;
            this.updatedSourceAsMap = updatedSourceAsMap;
            this.updateSourceContentType = updateSourceContentType;
        }

        public <T extends Streamable> T action() {
            return (T)this.action;
        }

        public DocWriteResponse.Result getResponseResult() {
            return this.result;
        }

        public Map<String, Object> updatedSourceAsMap() {
            return this.updatedSourceAsMap;
        }

        public XContentType updateSourceContentType() {
            return this.updateSourceContentType;
        }
    }
}

