/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.chromium.debug.ui.liveedit;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.jsdt.chromium.CallbackSemaphore;
import org.eclipse.wst.jsdt.chromium.RelayOk;
import org.eclipse.wst.jsdt.chromium.SyncCallback;
import org.eclipse.wst.jsdt.chromium.UpdatableScript;
import org.eclipse.wst.jsdt.chromium.debug.core.model.PushChangesPlan;
import org.eclipse.wst.jsdt.chromium.debug.core.util.ScriptTargetMapping;
import org.eclipse.wst.jsdt.chromium.debug.ui.WizardUtils;
import org.eclipse.wst.jsdt.chromium.debug.ui.actions.ChooseVmControl;
import org.eclipse.wst.jsdt.chromium.debug.ui.liveedit.LiveEditDiffViewer;
import org.eclipse.wst.jsdt.chromium.debug.ui.liveedit.LiveEditResultDialog;
import org.eclipse.wst.jsdt.chromium.debug.ui.liveedit.Messages;
import org.eclipse.wst.jsdt.chromium.debug.ui.liveedit.PushResultParser;
import org.eclipse.wst.jsdt.chromium.debug.ui.liveedit.WizardLogicBuilder;

public class PushChangesWizard {
    private static final WizardUtils.PageElementsFactory<ChooseVmPageElements> CHOOSE_VM_PAGE_FACTORY = new WizardUtils.PageElementsFactory<ChooseVmPageElements>(){

        @Override
        public ChooseVmPageElements create(Composite parent) {
            final ChooseVmControl.Logic chooseVm = ChooseVmControl.create(parent);
            chooseVm.getControl().setLayoutData((Object)new GridData(1808));
            return new ChooseVmPageElements(){

                @Override
                public ChooseVmControl.Logic getChooseVm() {
                    return chooseVm;
                }

                @Override
                public Control getMainControl() {
                    return chooseVm.getControl();
                }
            };
        }
    };
    private static final WizardUtils.PageElementsFactory<V8PreviewPageElements> V8_PREVIEW_PAGE_FACTORY = new WizardUtils.PageElementsFactory<V8PreviewPageElements>(){

        @Override
        public V8PreviewPageElements create(Composite parent) {
            final Composite page = new Composite(parent, 0);
            page.setLayout((Layout)new GridLayout(1, false));
            LiveEditDiffViewer.Configuration configuration = new LiveEditDiffViewer.Configuration(){

                @Override
                public String getNewLabel() {
                    return Messages.PushChangesWizard_CHANGED_SCRIPT;
                }

                @Override
                public String getOldLabel() {
                    return Messages.PushChangesWizard_SCRIPT_IN_VM;
                }

                @Override
                public boolean oldOnLeft() {
                    return false;
                }
            };
            final LiveEditDiffViewer viewer = LiveEditDiffViewer.create(page, configuration);
            return new V8PreviewPageElements(){

                @Override
                public Control getMainControl() {
                    return page;
                }

                @Override
                public LiveEditDiffViewer getPreviewViewer() {
                    return viewer;
                }
            };
        }
    };
    private static final WizardUtils.PageElementsFactory<WizardUtils.PageElements> MULTIPLE_VM_STUB_PAGE_FACTORY = new WizardUtils.PageElementsFactory<WizardUtils.PageElements>(){

        @Override
        public WizardUtils.PageElements create(Composite parent) {
            final Label label = new Label(parent, 0);
            return new WizardUtils.PageElements(){

                @Override
                public Control getMainControl() {
                    return label;
                }
            };
        }
    };

    public static void start(final List<? extends ScriptTargetMapping> filePairs, Shell shell, final LiveEditResultDialog.ErrorPositionHighlighter positionHighlighter) {
        final WizardUtils.PageImpl<ChooseVmPageElements> chooseVmPage = new WizardUtils.PageImpl<ChooseVmPageElements>("choose VM", CHOOSE_VM_PAGE_FACTORY, Messages.PushChangesWizard_CHOOSE_VM, Messages.PushChangesWizard_CHOOSE_VM_DESCRIPTION);
        final WizardUtils.PageImpl<V8PreviewPageElements> v8PreviewPage = new WizardUtils.PageImpl<V8PreviewPageElements>("v8 preview", V8_PREVIEW_PAGE_FACTORY, Messages.PushChangesWizard_V8_PREVIEW, Messages.PushChangesWizard_V8_PREVIEW_DESCRIPTION);
        final WizardUtils.PageImpl<WizardUtils.PageElements> multipleVmStubPage = new WizardUtils.PageImpl<WizardUtils.PageElements>("multiple vm", MULTIPLE_VM_STUB_PAGE_FACTORY, Messages.PushChangesWizard_MULTIPLE_VM, Messages.PushChangesWizard_MULTIPLE_VM_DESCRIPTION);
        PageSet pageSet = new PageSet(){

            @Override
            public List<? extends WizardUtils.PageImpl<?>> getAllPages() {
                return Arrays.asList(chooseVmPage, v8PreviewPage, multipleVmStubPage);
            }

            @Override
            public WizardUtils.PageImpl<ChooseVmPageElements> getChooseVmPage() {
                return chooseVmPage;
            }

            @Override
            public WizardUtils.PageImpl<V8PreviewPageElements> getV8PreviewPage() {
                return v8PreviewPage;
            }

            @Override
            public WizardUtils.PageImpl<WizardUtils.PageElements> getMultipleVmStubPage() {
                return multipleVmStubPage;
            }

            @Override
            public WizardUtils.WizardLogic createLogic(WizardUtils.LogicBasedWizard wizardImpl) {
                WizardLogicBuilder logicBuilder = new WizardLogicBuilder(this, wizardImpl);
                return logicBuilder.create(filePairs, positionHighlighter);
            }
        };
        WizardUtils.LogicBasedWizard wizard = new WizardUtils.LogicBasedWizard(pageSet);
        wizard.setWindowTitle(Messages.PushChangesWizard_TITLE);
        WizardDialog wizardDialog = new WizardDialog(shell, (IWizard)wizard);
        wizardDialog.open();
    }

    private static LiveEditResultDialog.SingleInput performSingleVmUpdate(final PushChangesPlan changesPlan, IProgressMonitor monitor) {
        final LiveEditResultDialog.SingleInput[] input = new LiveEditResultDialog.SingleInput[1];
        UpdatableScript.UpdateCallback callback = new UpdatableScript.UpdateCallback(){

            public void failure(String message, UpdatableScript.Failure failure) {
                String text = NLS.bind((String)"Failure: {0}", (Object)message);
                input[0] = LiveEditResultDialog.createTextInput(text, changesPlan, failure);
            }

            public void success(boolean resumed, Object report, final UpdatableScript.ChangeDescription changeDescription) {
                if (changeDescription == null) {
                    input[0] = LiveEditResultDialog.createTextInput(Messages.PushChangesWizard_EMPTY_CHANGE, changesPlan);
                } else {
                    LiveEditResultDialog.OldScriptData oldScriptData;
                    final String oldScriptName = changeDescription.getCreatedScriptName();
                    if (oldScriptName == null) {
                        oldScriptData = null;
                    } else {
                        final LiveEditDiffViewer.Input previewInput = PushResultParser.createViewerInput(changeDescription, changesPlan, false);
                        oldScriptData = new LiveEditResultDialog.OldScriptData(){

                            @Override
                            public LiveEditDiffViewer.Input getScriptStructure() {
                                return previewInput;
                            }

                            @Override
                            public String getOldScriptName() {
                                return oldScriptName;
                            }
                        };
                    }
                    final LiveEditResultDialog.SuccessResult successResult = new LiveEditResultDialog.SuccessResult(){

                        @Override
                        public LiveEditResultDialog.OldScriptData getOldScriptData() {
                            return oldScriptData;
                        }

                        @Override
                        public boolean hasDroppedFrames() {
                            return changeDescription.isStackModified();
                        }
                    };
                    input[0] = new LiveEditResultDialog.SingleInput(){

                        @Override
                        public <RES> RES accept(LiveEditResultDialog.InputVisitor<RES> visitor) {
                            return this.acceptSingle(visitor);
                        }

                        @Override
                        public <RES> RES acceptSingle(LiveEditResultDialog.SingleInputVisitor<RES> visitor) {
                            return visitor.visitSuccess(successResult);
                        }

                        @Override
                        public ScriptTargetMapping getFilePair() {
                            return changesPlan.getScriptTargetMapping();
                        }
                    };
                }
            }
        };
        CallbackSemaphore syncCallback = new CallbackSemaphore();
        RelayOk relayOk = changesPlan.execute(false, callback, (SyncCallback)syncCallback);
        syncCallback.acquireDefault(relayOk);
        monitor.done();
        return input[0];
    }

    static interface ChooseVmPageElements
    extends WizardUtils.PageElements {
        public ChooseVmControl.Logic getChooseVm();
    }

    static interface FinisherDelegate {
        public LiveEditResultDialog.Input run(IProgressMonitor var1);
    }

    static class FinisherImpl
    implements WizardUtils.WizardFinisher {
        private final FinisherDelegate delegate;
        private final LiveEditResultDialog.ErrorPositionHighlighter positionHighlighter;

        FinisherImpl(FinisherDelegate delegate, LiveEditResultDialog.ErrorPositionHighlighter positionHighlighter) {
            this.delegate = delegate;
            this.positionHighlighter = positionHighlighter;
        }

        @Override
        public boolean performFinish(IWizard wizard, IProgressMonitor monitor) {
            LiveEditResultDialog.Input dialogInput = this.delegate.run(monitor);
            LiveEditResultDialog dialog = new LiveEditResultDialog(wizard.getContainer().getShell(), dialogInput, this.positionHighlighter);
            dialog.open();
            return true;
        }
    }

    static class MultipleVmFinisher
    implements FinisherDelegate {
        private final List<PushChangesPlan> targets;

        public MultipleVmFinisher(List<PushChangesPlan> targets) {
            this.targets = targets;
        }

        @Override
        public LiveEditResultDialog.Input run(IProgressMonitor monitor) {
            monitor.beginTask(null, this.targets.size());
            final ArrayList<LiveEditResultDialog.SingleInput> results = new ArrayList<LiveEditResultDialog.SingleInput>();
            for (PushChangesPlan plan : this.targets) {
                LiveEditResultDialog.SingleInput dialogInput = PushChangesWizard.performSingleVmUpdate(plan, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                results.add(dialogInput);
            }
            monitor.done();
            final LiveEditResultDialog.MultipleResult multipleResult = new LiveEditResultDialog.MultipleResult(){

                @Override
                public List<? extends LiveEditResultDialog.SingleInput> getList() {
                    return results;
                }
            };
            return new LiveEditResultDialog.Input(){

                @Override
                public <RES> RES accept(LiveEditResultDialog.InputVisitor<RES> visitor) {
                    return visitor.visitMultipleResult(multipleResult);
                }
            };
        }
    }

    static interface PageSet
    extends WizardUtils.WizardPageSet {
        public WizardUtils.PageImpl<ChooseVmPageElements> getChooseVmPage();

        public WizardUtils.PageImpl<V8PreviewPageElements> getV8PreviewPage();

        public WizardUtils.PageImpl<WizardUtils.PageElements> getMultipleVmStubPage();
    }

    static class SingleVmFinisher
    implements FinisherDelegate {
        private final PushChangesPlan pushChangesPlan;

        public SingleVmFinisher(PushChangesPlan pushChangesPlan) {
            this.pushChangesPlan = pushChangesPlan;
        }

        @Override
        public LiveEditResultDialog.Input run(IProgressMonitor monitor) {
            return PushChangesWizard.performSingleVmUpdate(this.pushChangesPlan, monitor);
        }
    }

    static interface V8PreviewPageElements
    extends WizardUtils.PageElements {
        public LiveEditDiffViewer getPreviewViewer();
    }
}

