/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.ResourceImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.wst.wsdl.Definition;
import org.eclipse.wst.wsdl.ExtensibilityElement;
import org.eclipse.wst.wsdl.Types;
import org.eclipse.wst.wsdl.WSDLFactory;
import org.eclipse.wst.wsdl.WSDLPlugin;
import org.eclipse.wst.wsdl.XSDSchemaExtensibilityElement;
import org.eclipse.wst.wsdl.internal.impl.DefinitionImpl;
import org.eclipse.wst.wsdl.internal.util.XSDSchemaLocatorAdapterFactory;
import org.eclipse.wst.wsdl.util.WSDLConstants;
import org.eclipse.wst.wsdl.util.WSDLDiagnostic;
import org.eclipse.wst.wsdl.util.WSDLParser;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.util.DefaultJAXPConfiguration;
import org.eclipse.xsd.util.JAXPConfiguration;
import org.eclipse.xsd.util.JAXPPool;
import org.eclipse.xsd.util.XSDSchemaLocator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class WSDLResourceImpl
extends ResourceImpl {
    private boolean useExtensionFactories = true;
    private boolean continueOnLoadError = true;
    public static final String USE_EXTENSION_FACTORIES = "USE_EXTENSION_FACTORIES";
    public static final String CONTINUE_ON_LOAD_ERROR = "CONTINUE_ON_LOAD_ERROR";
    public static final String WSDL_ENCODING = "WSDL_ENCODING";
    public static final String WSDL_PROGRESS_MONITOR = "WSDL_PROGRESS_MONITOR";
    public static final String TRACK_LOCATION = "TRACK_LOCATION";
    public static final String WSDL_JAXP_POOL = "WSDL_JAXP_POOL";
    public static final String WSDL_JAXP_CONFIG = "WSDL_JAXP_CONFIG";
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public WSDLResourceImpl(URI uri) {
        super(uri);
    }

    protected void doSave(OutputStream os, Map options) throws IOException {
        Definition definition = this.getDefinition();
        if (definition != null) {
            Document document = definition.getDocument();
            if (document == null) {
                ((DefinitionImpl)definition).updateDocument();
                document = definition.getDocument();
            }
            if (definition.getElement() == null) {
                ((DefinitionImpl)definition).updateElement();
            }
            WSDLResourceImpl.doSerialize(os, document, options);
        }
    }

    public Definition getDefinition() {
        return this.getContents().size() == 1 && this.getContents().get(0) instanceof Definition ? (Definition)this.getContents().get(0) : null;
    }

    private static void doSerialize(OutputStream outputStream, Document document, String encoding) {
        try {
            Transformer transformer = new DefaultJAXPConfiguration().createTransformer(encoding);
            encoding = transformer.getOutputProperty("encoding");
            OutputStreamWriter writer = encoding == null ? new OutputStreamWriter(outputStream) : new OutputStreamWriter(outputStream, encoding);
            transformer.transform(new DOMSource(document), new StreamResult(writer));
        }
        catch (Exception exception) {
            WSDLPlugin.INSTANCE.log(exception);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void doSerialize(OutputStream outputStream, Document document, Map options) throws IOException {
        JAXPPool jaxpPool = null;
        JAXPConfiguration config = null;
        String encoding = null;
        if (options != null) {
            jaxpPool = (JAXPPool)options.get(WSDL_JAXP_POOL);
            config = (JAXPConfiguration)options.get(WSDL_JAXP_CONFIG);
            encoding = (String)options.get(WSDL_ENCODING);
        }
        if (jaxpPool == null) {
            if (config == null) {
                WSDLResourceImpl.doSerialize(outputStream, document, encoding);
                return;
            }
            try {
                Transformer transformer = config.createTransformer(encoding);
                encoding = transformer.getOutputProperty("encoding");
                OutputStreamWriter writer = encoding == null ? new OutputStreamWriter(outputStream) : new OutputStreamWriter(outputStream, encoding);
                transformer.transform(new DOMSource(document), new StreamResult(writer));
                return;
            }
            catch (TransformerException exception) {
                WSDLPlugin.getPlugin().log(exception);
                return;
            }
        }
        Transformer transformer = null;
        try {
            try {
                transformer = jaxpPool.getTransformer(encoding);
                OutputStreamWriter writer = encoding == null ? new OutputStreamWriter(outputStream) : new OutputStreamWriter(outputStream, encoding);
                transformer.transform(new DOMSource(document), new StreamResult(writer));
            }
            catch (TransformerException exception) {
                WSDLPlugin.INSTANCE.log(exception);
            }
        }
        catch (Throwable throwable) {
            Object var8_13 = null;
            jaxpPool.releaseTransformer(transformer);
            throw throwable;
        }
        {
            Object var8_14 = null;
        }
        jaxpPool.releaseTransformer(transformer);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void doLoad(InputSource inputSource, Map options) throws IOException {
        Object continueOnError;
        Object bindings;
        Object monitor;
        IProgressMonitor progressMonitor = null;
        Object v0 = monitor = options == null ? null : options.get(WSDL_PROGRESS_MONITOR);
        if (monitor != null) {
            progressMonitor = monitor;
            progressMonitor.setTaskName(WSDLPlugin.INSTANCE.getString("_UI_ResourceLoad_progress"));
            progressMonitor.subTask(this.getURI().toString());
        }
        Object v1 = bindings = options == null ? null : options.get(USE_EXTENSION_FACTORIES);
        if (bindings != null && bindings instanceof Boolean) {
            this.useExtensionFactories = bindings;
        }
        Object v2 = continueOnError = options == null ? null : options.get(CONTINUE_ON_LOAD_ERROR);
        if (continueOnError != null && continueOnError instanceof Boolean) {
            this.continueOnLoadError = continueOnError;
        }
        Document doc = null;
        try {
            boolean trackLocation = options != null && Boolean.TRUE.equals(options.get(TRACK_LOCATION));
            doc = trackLocation ? this.getDocumentUsingSAX(inputSource, options) : WSDLResourceImpl.getDocument(inputSource, new InternalErrorHandler(), options);
            if (doc != null && doc.getDocumentElement() != null) {
                if (!this.findDefinition(doc.getDocumentElement())) {
                    if (!this.continueOnLoadError) throw new IOException(WSDLPlugin.getPlugin().getString("_ERROR_INVALID_WSDL"));
                    this.handleDefinitionElement(doc.getDocumentElement());
                }
            } else {
                this.handleDefinitionElement(null);
            }
        }
        catch (IOException exception) {
            if (!this.continueOnLoadError) throw exception;
            WSDLPlugin.INSTANCE.log(exception);
            this.handleDefinitionElement(null);
        }
        Definition definition = null;
        Iterator i = this.getContents().iterator();
        while (i.hasNext()) {
            definition = (Definition)i.next();
            Types types = definition.getETypes();
            if (types == null) continue;
            XSDSchemaExtensibilityElement el = null;
            Iterator j = types.getEExtensibilityElements().iterator();
            while (j.hasNext()) {
                XSDSchema schema;
                ExtensibilityElement extensibilityElement = (ExtensibilityElement)j.next();
                if (!(extensibilityElement instanceof XSDSchemaExtensibilityElement) || (schema = (el = (XSDSchemaExtensibilityElement)extensibilityElement).getSchema()) == null) continue;
                schema.setSchemaLocation(this.getURI().toString());
            }
        }
        if (progressMonitor == null) return;
        progressMonitor.worked(1);
    }

    protected void doLoad(InputStream inputStream, Map options) throws IOException {
        InputSource inputSource;
        InputSource inputSource2 = inputSource = inputStream instanceof URIConverter.ReadableInputStream ? new InputSource(((URIConverter.ReadableInputStream)inputStream).asReader()) : new InputSource(inputStream);
        if (this.getURI() != null) {
            String id = this.getURI().toString();
            inputSource.setPublicId(id);
            inputSource.setSystemId(id);
        }
        this.doLoad(inputSource, options);
    }

    private Document getDocumentUsingSAX(InputSource inputSource, Map options) {
        WSDLParser wsdlParser = new WSDLParser(options);
        wsdlParser.parse(inputSource);
        Collection errors = wsdlParser.getDiagnostics();
        if (errors != null) {
            Iterator iterator = errors.iterator();
            while (iterator.hasNext()) {
                WSDLDiagnostic wsdlDiagnostic = (WSDLDiagnostic)iterator.next();
                switch (wsdlDiagnostic.getSeverity().getValue()) {
                    case 0: 
                    case 1: {
                        this.getErrors().add((Object)wsdlDiagnostic);
                        break;
                    }
                    case 2: 
                    case 3: {
                        this.getWarnings().add((Object)wsdlDiagnostic);
                    }
                }
            }
        }
        Document doc = wsdlParser.getDocument();
        if (wsdlParser.getEncoding() != null) {
            this.getDefaultSaveOptions().put(WSDL_ENCODING, wsdlParser.getEncoding());
        }
        return doc;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Document getDocument(InputSource inputSource, ErrorHandler errorHandler) throws IOException {
        ClassLoader previousClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            try {
                Document document;
                Thread thread = Thread.currentThread();
                Class<?> clazz = class$0;
                if (clazz == null) {
                    Class<?> clazz2;
                    try {
                        clazz2 = Class.forName("org.eclipse.wst.wsdl.internal.util.WSDLResourceFactoryImpl");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    clazz = class$0 = clazz2;
                }
                thread.setContextClassLoader(clazz.getClassLoader());
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                documentBuilderFactory.setNamespaceAware(true);
                documentBuilderFactory.setValidating(false);
                try {
                    documentBuilderFactory.setAttribute("http://apache.org/xml/features/dom/defer-node-expansion", Boolean.FALSE);
                }
                catch (IllegalArgumentException illegalArgumentException) {}
                DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                documentBuilder.setErrorHandler(errorHandler);
                Document document2 = document = documentBuilder.parse(inputSource);
                Object var6_9 = null;
                Thread.currentThread().setContextClassLoader(previousClassLoader);
                return document2;
            }
            catch (ParserConfigurationException exception) {
                throw new Resource.IOWrappedException((Exception)exception);
            }
            catch (SAXException exception) {
                throw new Resource.IOWrappedException((Exception)exception);
            }
        }
        catch (Throwable throwable) {
            Object var6_10 = null;
            Thread.currentThread().setContextClassLoader(previousClassLoader);
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Document getDocument(InputSource inputSource, ErrorHandler errorHandler, Map options) throws IOException {
        Document document;
        JAXPPool jaxpPool = null;
        JAXPConfiguration config = null;
        if (options != null) {
            jaxpPool = (JAXPPool)options.get(WSDL_JAXP_POOL);
            config = (JAXPConfiguration)options.get(WSDL_JAXP_CONFIG);
        }
        if (jaxpPool == null) {
            if (config == null) {
                return WSDLResourceImpl.getDocument(inputSource, errorHandler);
            }
            try {
                DocumentBuilder documentBuilder = config.createDocumentBuilder(errorHandler);
                return documentBuilder.parse(inputSource);
            }
            catch (ParserConfigurationException exception) {
                throw new Resource.IOWrappedException((Exception)exception);
            }
            catch (SAXException exception) {
                throw new Resource.IOWrappedException((Exception)exception);
            }
        }
        DocumentBuilder documentBuilder = null;
        try {
            try {
                Document document2;
                documentBuilder = jaxpPool.getDocumentBuilder(errorHandler);
                document = document2 = documentBuilder.parse(inputSource);
                Object var7_14 = null;
            }
            catch (ParserConfigurationException exception) {
                throw new Resource.IOWrappedException((Exception)exception);
            }
            catch (SAXException exception) {
                throw new Resource.IOWrappedException((Exception)exception);
            }
        }
        catch (Throwable throwable) {
            Object var7_15 = null;
            jaxpPool.releaseDocumentBuilder(documentBuilder);
            throw throwable;
        }
        jaxpPool.releaseDocumentBuilder(documentBuilder);
        return document;
    }

    private boolean findDefinition(Element element) {
        if (WSDLConstants.nodeType(element) == 1) {
            this.handleDefinitionElement(element);
            return true;
        }
        boolean result = false;
        return result;
    }

    private void handleDefinitionElement(Element element) {
        Definition definition = null;
        if (element == null) {
            definition = WSDLFactory.eINSTANCE.createDefinition();
            ((DefinitionImpl)definition).setUseExtensionFactories(this.useExtensionFactories);
        } else {
            definition = DefinitionImpl.createDefinition(element, this.getURI().toString(), this.useExtensionFactories);
        }
        this.getContents().add((Object)definition);
        ((DefinitionImpl)definition).reconcileReferences(true);
    }

    public static void serialize(OutputStream outputStream, Document document) {
        WSDLResourceImpl.serialize(outputStream, document, null);
    }

    public static void serialize(OutputStream outputStream, Document document, String encoding) {
        WSDLResourceImpl.doSerialize(outputStream, document, encoding);
    }

    public static void serialize(OutputStream outputStream, Element element) {
        WSDLResourceImpl.serialize(outputStream, element, null);
    }

    public static void serialize(OutputStream outputStream, Element element, String encoding) {
        try {
            WSDLResourceImpl.doSerialize(outputStream, element, encoding);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private static void doSerialize(OutputStream outputStream, Element element, String encoding) throws IOException {
        try {
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("method", "xml");
            if (encoding != null) {
                transformer.setOutputProperty("encoding", encoding);
            }
            transformer.transform(new DOMSource(element), new StreamResult(outputStream));
        }
        catch (TransformerException exception) {
            WSDLPlugin.INSTANCE.log(exception);
        }
    }

    public void attached(EObject eObject) {
        XSDSchemaLocator xsdSchemaLocator;
        super.attached(eObject);
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.xsd.util.XSDSchemaLocator");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((xsdSchemaLocator = (XSDSchemaLocator)EcoreUtil.getRegisteredAdapter((Resource)this, (Object)clazz)) == null) {
            this.getResourceSet().getAdapterFactories().add((Object)new XSDSchemaLocatorAdapterFactory());
        }
        if (eObject instanceof DefinitionImpl) {
            DefinitionImpl definition = (DefinitionImpl)eObject;
            definition.setInlineSchemaLocations((Resource)this);
        }
    }

    public Map getDefaultSaveOptions() {
        if (this.defaultSaveOptions == null) {
            this.defaultSaveOptions = new HashMap();
        }
        return this.defaultSaveOptions;
    }

    private class InternalErrorHandler
    implements ErrorHandler {
        private InternalErrorHandler() {
        }

        public void error(SAXParseException e) {
            System.out.println("WSDL PARSE ERROR: " + e);
        }

        public void fatalError(SAXParseException e) {
            System.out.println("WSDL PARSE FATAL ERROR: " + e);
        }

        public void warning(SAXParseException e) {
            System.out.println("WSDL PARSE WARNING: " + e);
        }
    }
}

