/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jee.ui.internal.navigator.ear;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jst.j2ee.componentcore.util.EARVirtualComponent;
import org.eclipse.jst.j2ee.project.EarUtilities;
import org.eclipse.jst.javaee.application.Application;
import org.eclipse.jst.javaee.core.JavaEEObject;
import org.eclipse.jst.jee.ui.internal.Messages;
import org.eclipse.jst.jee.ui.internal.navigator.ear.AbstractEarGroupProvider;
import org.eclipse.jst.jee.ui.internal.navigator.ear.AbstractEarNode;
import org.eclipse.jst.jee.ui.internal.navigator.ear.BundledNode;
import org.eclipse.jst.jee.ui.internal.navigator.ear.ModulesNode;
import org.eclipse.jst.jee.ui.plugin.JEEUIPlugin;
import org.eclipse.jst.jee.ui.plugin.JEEUIPluginIcons;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;

public class GroupEARProvider
extends AbstractEarGroupProvider
implements IAdaptable {
    private static final String PROJECT_RELATIVE_PATH = "META-INF/application.xml";
    public static final String EAR_DEFAULT_LIB = "lib";
    private static Image ear50Image;
    private static Image ear60Image;
    private static Image ear70Image;
    private static Image ear80Image;
    private EARVirtualComponent earComponent;
    private IFile ddFile;
    private BundledNode bundledLibsNode;
    private ModulesNode modulesNode;

    public GroupEARProvider(Application application, EARVirtualComponent wtpComponent) {
        super((JavaEEObject)application);
        this.earComponent = wtpComponent;
    }

    public IProject getProject() {
        return this.earComponent.getProject();
    }

    public String getText() {
        return NLS.bind((String)Messages.DEPLOYMENT_DESCRIPTOR, (Object)this.earComponent.getName());
    }

    public EARVirtualComponent getEARVirtualComponent() {
        return this.earComponent;
    }

    public List getChildren() {
        ArrayList<AbstractEarNode> children = new ArrayList<AbstractEarNode>();
        IProject project = this.getProject();
        try {
            IFacetedProject facetedProject = ProjectFacetsManager.create((IProject)project);
            IProjectFacet earFacet = ProjectFacetsManager.getProjectFacet((String)"jst.ear");
            if (facetedProject != null && (facetedProject.hasProjectFacet(earFacet.getVersion("5.0")) || facetedProject.hasProjectFacet(earFacet.getVersion("6.0")) || facetedProject.hasProjectFacet(earFacet.getVersion("7.0")) || facetedProject.hasProjectFacet(earFacet.getVersion("8.0")))) {
                if (this.bundledLibsNode == null) {
                    BundledNode bundledLibsDirectoryNode = new BundledNode(project, String.valueOf(Messages.LIBRARY_DIRECTORY) + ": " + EarUtilities.getEARLibDir((IVirtualComponent)this.earComponent), null);
                    this.bundledLibsNode = new BundledNode(project, Messages.BUNDLED_LIBRARIES_NODE, bundledLibsDirectoryNode);
                } else {
                    this.bundledLibsNode.getBundledLibsDirectoryNode().setText(String.valueOf(Messages.LIBRARY_DIRECTORY) + ": " + EarUtilities.getEARLibDir((IVirtualComponent)this.earComponent));
                }
                if (this.modulesNode == null) {
                    this.modulesNode = new ModulesNode(project);
                }
                children.add(this.modulesNode);
                children.add(this.bundledLibsNode);
            }
        }
        catch (CoreException e) {
            String msg = "Error in the JEEContentProvider.getChildren() for parent:" + this;
            JEEUIPlugin.logError(msg, (Exception)((Object)e));
        }
        return children;
    }

    public Image getImage() {
        String version = ((Application)this.javaee).getVersion();
        if ("5".equals(version)) {
            return this.getEar50Image();
        }
        if ("6".equals(version)) {
            return this.getEar60Image();
        }
        if ("7".equals(version)) {
            return this.getEar70Image();
        }
        if ("8".equals(version)) {
            return this.getEar80Image();
        }
        return this.getEar50Image();
    }

    public IFile getDDFile() {
        if (this.ddFile != null) {
            return this.ddFile;
        }
        IVirtualFolder virtualFolder = ComponentCore.createComponent((IProject)this.getProject()).getRootFolder();
        this.ddFile = virtualFolder.getFile(PROJECT_RELATIVE_PATH).getUnderlyingFile();
        return this.ddFile;
    }

    public Object getAdapter(Class adapter) {
        if (IProject.class == adapter) {
            return this.getProject();
        }
        return null;
    }

    private Image getEar50Image() {
        if (ear50Image == null) {
            ear50Image = JEEUIPlugin.getDefault().getImageDescriptor(JEEUIPluginIcons.EAR_IMAGE).createImage();
        }
        return ear50Image;
    }

    private Image getEar60Image() {
        if (ear60Image == null) {
            ear60Image = JEEUIPlugin.getDefault().getImageDescriptor(JEEUIPluginIcons.EAR6_IMAGE).createImage();
        }
        return ear60Image;
    }

    private Image getEar70Image() {
        if (ear70Image == null) {
            ear70Image = JEEUIPlugin.getDefault().getImageDescriptor(JEEUIPluginIcons.EAR7_IMAGE).createImage();
        }
        return ear70Image;
    }

    private Image getEar80Image() {
        if (ear80Image == null) {
            ear80Image = JEEUIPlugin.getDefault().getImageDescriptor(JEEUIPluginIcons.EAR8_IMAGE).createImage();
        }
        return ear80Image;
    }
}

