/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.sourcelookup.ui.internal;

import java.io.File;
import java.util.Collection;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.core.DebugException;
import org.eclipse.jdt.launching.sourcelookup.advanced.AdvancedSourceLookup;
import org.eclipse.jdt.launching.sourcelookup.advanced.AdvancedSourceLookupParticipant;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.m2e.binaryproject.internal.AbstractBinaryProjectsImportJob;
import org.eclipse.m2e.core.embedder.ArtifactKey;
import org.eclipse.m2e.sourcelookup.internal.launch.MavenArtifactIdentifier;
import org.eclipse.ui.handlers.HandlerUtil;

public class ImportBinaryProjectHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection selection = HandlerUtil.getCurrentSelectionChecked((ExecutionEvent)event);
        if (selection instanceof IStructuredSelection && !selection.isEmpty()) {
            try {
                ImportBinaryProjectHandler.importBinaryProjects(((IStructuredSelection)selection).getFirstElement());
            }
            catch (DebugException e) {
                throw new ExecutionException("Could not import binary project", (Throwable)e);
            }
        }
        return null;
    }

    public static void importBinaryProjects(final Object debugElement) throws DebugException {
        final File location = AdvancedSourceLookup.getClassesLocation((Object)debugElement);
        if (location == null) {
            return;
        }
        AbstractBinaryProjectsImportJob job = new AbstractBinaryProjectsImportJob(){

            protected IStatus run(IProgressMonitor monitor) {
                IStatus status = super.run(monitor);
                if (status.isOK()) {
                    AdvancedSourceLookupParticipant sourceLookup = AdvancedSourceLookupParticipant.getSourceLookup((Object)debugElement);
                    try {
                        sourceLookup.getSourceContainer(debugElement, true, monitor);
                    }
                    catch (CoreException e) {
                        status = e.getStatus();
                    }
                }
                return status;
            }

            protected Collection<ArtifactKey> getArtifactKeys(IProgressMonitor monitor) throws CoreException {
                return new MavenArtifactIdentifier().identify(location, monitor);
            }
        };
        job.setUser(true);
        job.schedule();
    }
}

