/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.oprofile.core.opxml.info;

import java.util.ArrayList;
import org.eclipse.linuxtools.internal.oprofile.core.daemon.OpEvent;
import org.eclipse.linuxtools.internal.oprofile.core.daemon.OpUnitMask;
import org.eclipse.linuxtools.internal.oprofile.core.opxml.OprofileSAXHandler;
import org.eclipse.linuxtools.internal.oprofile.core.opxml.XMLProcessor;
import org.xml.sax.Attributes;

public class EventListProcessor
extends XMLProcessor {
    private OpEvent currentEvent;
    private int counter;
    private ArrayList<OpEvent> currentEventList;
    private UnitMaskProcessor umProcessor = new UnitMaskProcessor();
    private static final String EVENT_TAG = "event";
    private static final String UNIT_MASK_TAG = "unit-mask";
    private static final String NAME_TAG = "name";
    private static final String VALUE_TAG = "value";
    private static final String DESCRIPTION_TAG = "description";
    private static final String MASK_TAG = "mask";
    private static final String MINIMUM_COUNT_TAG = "minimum";
    private static final String ATTR_EVENT_LIST_COUNTER = "counter";

    @Override
    public void reset(Object callData) {
        this.currentEventList = new ArrayList();
    }

    @Override
    public void startElement(String name, Attributes attrs, Object callData) {
        if (name.equals(EVENT_TAG)) {
            this.currentEvent = new OpEvent();
        } else if (name.equals(UNIT_MASK_TAG)) {
            OprofileSAXHandler.getInstance(callData).push(this.umProcessor);
        } else if (name.equals("event-list")) {
            this.counter = Integer.parseInt(attrs.getValue(ATTR_EVENT_LIST_COUNTER));
        } else {
            super.startElement(name, attrs, callData);
        }
    }

    @Override
    public void endElement(String name, Object callData) {
        if (name.equals(EVENT_TAG)) {
            this.currentEventList.add(this.currentEvent);
        } else if (name.equals(UNIT_MASK_TAG)) {
            this.currentEvent.setUnitMask(this.umProcessor.getResult());
        } else if (name.equals(NAME_TAG)) {
            this.currentEvent.setText(this.characters);
        } else if (name.equals(DESCRIPTION_TAG)) {
            this.currentEvent.setTextDescription(this.characters);
        } else if (name.equals(MINIMUM_COUNT_TAG)) {
            this.currentEvent.setMinCount(Integer.parseInt(this.characters));
        } else if (name.equals("event-list")) {
            OprofileSAXHandler.getInstance(callData).pop(name);
        }
    }

    public int getCounterNum() {
        return this.counter;
    }

    public OpEvent[] getEvents() {
        OpEvent[] events = new OpEvent[this.currentEventList.size()];
        this.currentEventList.toArray(events);
        return events;
    }

    private static class MaskProcessor
    extends XMLProcessor {
        private OpUnitMask.MaskInfo info;

        private MaskProcessor() {
        }

        @Override
        public void reset(Object callData) {
            this.info = new OpUnitMask.MaskInfo();
        }

        @Override
        public void endElement(String name, Object callData) {
            if (name.equals(EventListProcessor.VALUE_TAG)) {
                this.info.value = Integer.parseInt(this.characters);
            } else if (name.equals(EventListProcessor.DESCRIPTION_TAG)) {
                this.info.description = this.characters;
            } else if (name.equals(EventListProcessor.NAME_TAG)) {
                this.info.name = this.characters;
            } else if (name.equals(EventListProcessor.MASK_TAG)) {
                OprofileSAXHandler.getInstance(callData).pop(EventListProcessor.MASK_TAG);
            }
        }

        public OpUnitMask.MaskInfo getResult() {
            return this.info;
        }
    }

    private class UnitMaskProcessor
    extends XMLProcessor {
        private ArrayList<OpUnitMask.MaskInfo> masks;
        private OpUnitMask unitMask;
        private MaskProcessor maskProcessor = new MaskProcessor();
        private static final String MASK_TYPE_TAG = "type";
        private static final String MASK_DEFAULT_TAG = "default";
        private static final String MASK_TYPE_BITMASK = "bitmask";
        private static final String MASK_TYPE_MANDATORY = "mandatory";
        private static final String MASK_TYPE_EXCLUSIVE = "exclusive";

        public UnitMaskProcessor() {
            this.masks = new ArrayList();
        }

        @Override
        public void reset(Object callData) {
            this.unitMask = new OpUnitMask();
            this.masks.clear();
        }

        @Override
        public void startElement(String name, Attributes attrs, Object callData) {
            if (name.equals(EventListProcessor.MASK_TAG)) {
                OprofileSAXHandler.getInstance(callData).push(this.maskProcessor);
            } else {
                super.startElement(name, attrs, callData);
            }
        }

        @Override
        public void endElement(String name, Object callData) {
            if (name.equals(MASK_TYPE_TAG)) {
                this.unitMask.setType(this.getTypeFromString(this.characters));
            } else if (name.equals(MASK_DEFAULT_TAG)) {
                this.unitMask.setDefault(Integer.parseInt(this.characters));
            } else if (name.equals(EventListProcessor.MASK_TAG)) {
                this.masks.add(this.maskProcessor.getResult());
            } else if (name.equals(EventListProcessor.UNIT_MASK_TAG)) {
                OpUnitMask.MaskInfo[] descs = new OpUnitMask.MaskInfo[this.masks.size()];
                this.masks.toArray(descs);
                this.unitMask.setMaskDescriptions(descs);
                OprofileSAXHandler.getInstance(callData).pop(EventListProcessor.UNIT_MASK_TAG);
            }
        }

        public OpUnitMask getResult() {
            return this.unitMask;
        }

        private int getTypeFromString(String string) {
            if (string.equals(MASK_TYPE_MANDATORY)) {
                return 1;
            }
            if (string.equals(MASK_TYPE_BITMASK)) {
                return 3;
            }
            if (string.equals(MASK_TYPE_EXCLUSIVE)) {
                return 2;
            }
            return -1;
        }
    }
}

