/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ltk.internal.ui.refactoring.actions;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ltk.internal.ui.refactoring.RefactoringUIMessages;
import org.eclipse.ltk.internal.ui.refactoring.RefactoringUIPlugin;
import org.eclipse.ltk.internal.ui.refactoring.actions.AbstractResourcesHandler;
import org.eclipse.ltk.ui.refactoring.RefactoringWizardOpenOperation;
import org.eclipse.ltk.ui.refactoring.resource.RenameResourceWizard;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;

public class RenameResourceHandler
extends AbstractResourcesHandler {
    private static final String LTK_RENAME_COMMAND_NEWNAME_PARAMETER_KEY = "org.eclipse.ltk.ui.refactoring.commands.renameResource.newName.parameter.key";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IResource resource;
        Shell activeShell = HandlerUtil.getActiveShell((ExecutionEvent)event);
        Object newNameValue = HandlerUtil.getVariable((ExecutionEvent)event, (String)LTK_RENAME_COMMAND_NEWNAME_PARAMETER_KEY);
        String newName = null;
        if (newNameValue instanceof String) {
            newName = (String)newNameValue;
        } else if (newNameValue != null) {
            RefactoringUIPlugin.logErrorMessage(NLS.bind((String)RefactoringUIMessages.RenameResourceHandler_ERROR_EXPECTED_STRING, (Object)newNameValue.getClass().getName()));
        }
        ISelection sel = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (sel instanceof IStructuredSelection && (resource = this.getCurrentResource((IStructuredSelection)sel)) != null) {
            RenameResourceWizard refactoringWizard = newName != null ? new RenameResourceWizard(resource, newName) : new RenameResourceWizard(resource);
            RefactoringWizardOpenOperation op = new RefactoringWizardOpenOperation(refactoringWizard);
            try {
                op.run(activeShell, RefactoringUIMessages.RenameResourceHandler_title);
            }
            catch (InterruptedException interruptedException) {}
        }
        return null;
    }

    private IResource getCurrentResource(IStructuredSelection sel) {
        IResource[] resources = this.getSelectedResources(sel);
        if (resources.length == 1) {
            return resources[0];
        }
        return null;
    }
}

