"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const electron_1 = require("electron");
const electron_util_1 = require("electron-util");
function getWindow() {
    const [win] = electron_1.BrowserWindow.getAllWindows();
    return win;
}
exports.getWindow = getWindow;
function sendAction(action, ...args) {
    const win = getWindow();
    if (electron_util_1.is.macos) {
        win.restore();
    }
    win.webContents.send(action, ...args);
}
exports.sendAction = sendAction;
function sendBackgroundAction(action, ...args) {
    getWindow().webContents.send(action, ...args);
}
exports.sendBackgroundAction = sendBackgroundAction;
function showRestartDialog(message) {
    const buttonIndex = electron_1.dialog.showMessageBoxSync({
        message,
        detail: 'Do you want to restart the app now?',
        buttons: ['Restart', 'Ignore'],
        defaultId: 0,
        cancelId: 1
    });
    if (buttonIndex === 0) {
        electron_1.app.relaunch();
        electron_1.app.quit();
    }
}
exports.showRestartDialog = showRestartDialog;
//# sourceMappingURL=util.js.map