/*
 * Decompiled with CFR 0.152.
 */
package hughai.mapping;

import com.springrts.ai.oo.clb.Map;
import com.springrts.ai.oo.clb.OOAICallback;
import hughai.CSAI;
import hughai.PlayerObjects;
import hughai.basictypes.Float3;
import hughai.basictypes.Int2;
import hughai.basictypes.TerrainPos;
import hughai.mapping.HeightMap;
import hughai.ui.MainUI;
import hughai.utils.LogFile;
import hughai.utils.MapHelper;

public class SlopeMap {
    public static final int granularity = 2;
    CSAI csai;
    OOAICallback aicallback;
    LogFile logfile;
    Map gameMap;
    PlayerObjects playerObjects;
    private float[][] SlopeMap;

    public SlopeMap(PlayerObjects playerObjects) {
        this.csai = playerObjects.getCSAI();
        this.aicallback = this.csai.aicallback;
        this.logfile = playerObjects.getLogFile();
        this.gameMap = this.aicallback.getMap();
        this.playerObjects = playerObjects;
        playerObjects.getMainUI().registerButton("Dump slopemap distribution", new ButtonSlopeDistribution());
    }

    public float getSlopeAt(SlopeMapPos slopeMapPos) {
        this.GetSlopeMap();
        return this.SlopeMap[slopeMapPos.x][slopeMapPos.y];
    }

    private float[][] GetSlopeMap() {
        if (this.SlopeMap != null) {
            return this.SlopeMap;
        }
        int n = this.gameMap.getWidth();
        int n2 = this.gameMap.getHeight();
        int n3 = n / 2;
        int n4 = n2 / 2;
        int n5 = this.playerObjects.getMaps().getMovementMaps().SQUARE_SIZE;
        HeightMap heightMap = this.playerObjects.getMaps().getHeightMap();
        this.logfile.WriteLine("Getting heightmap, this could take a while... ");
        this.logfile.WriteLine("calculating slopes...");
        this.logfile.WriteLine("mapwidth: " + n3 + " " + n4);
        this.SlopeMap = new float[n3][n4];
        for (int i = 2; i < n2 - 2; i += 2) {
            for (int j = 2; j < n - 2; j += 2) {
                Float3 float3 = new Float3(-n5 * 4, heightMap.getElevationAt(new HeightMap.HeightMapPos(j - 1, i - 1)) - heightMap.getElevationAt(new HeightMap.HeightMapPos(j + 3, i - 1)), 0.0f);
                Float3 float32 = new Float3(0.0f, heightMap.getElevationAt(new HeightMap.HeightMapPos(j - 1, i - 1)) - heightMap.getElevationAt(new HeightMap.HeightMapPos(j - 1, i + 3)), -n5 * 4);
                Float3 float33 = float32.Cross(float3);
                float33.Normalize();
                float3 = new Float3(n5 * 4, heightMap.getElevationAt(new HeightMap.HeightMapPos(j + 3, i + 3)) - heightMap.getElevationAt(new HeightMap.HeightMapPos(j - 1, i + 3)), 0.0f);
                float32 = new Float3(0.0f, heightMap.getElevationAt(new HeightMap.HeightMapPos(j + 3, i + 3)) - heightMap.getElevationAt(new HeightMap.HeightMapPos(j + 3, i - 1)), n5 * 4);
                Float3 float34 = float32.Cross(float3);
                float34.Normalize();
                this.SlopeMap[j / 2][i / 2] = 1.0f - (float33.y + float34.y) * 0.5f;
            }
        }
        this.logfile.WriteLine("... slopes calculated");
        return this.SlopeMap;
    }

    class ButtonSlopeDistribution
    implements MainUI.ButtonHandler {
        ButtonSlopeDistribution() {
        }

        @Override
        public void go() {
            float[][] fArray = SlopeMap.this.GetSlopeMap();
            SlopeMap.this.logfile.WriteLine("Slopemap distribution:");
            new MapHelper(SlopeMap.this.playerObjects).DumpMapDistribution(fArray);
        }
    }

    public static class SlopeMapPos
    extends Int2 {
        public SlopeMapPos() {
        }

        public SlopeMapPos(Int2 int2) {
            this.x = int2.x;
            this.y = int2.y;
        }

        public SlopeMapPos(int n, int n2) {
            super(n, n2);
        }

        public TerrainPos toTerrainPos() {
            return new TerrainPos(this.x * 8 * 2, 0.0f, this.y * 8 * 2);
        }

        public static SlopeMapPos fromTerrainPos(TerrainPos terrainPos) {
            return new SlopeMapPos((int)terrainPos.x / 8 / 2, (int)terrainPos.z / 8 / 2);
        }

        public static SlopeMapPos fromHeightMapPos(HeightMap.HeightMapPos heightMapPos) {
            return new SlopeMapPos(heightMapPos.x / 2, heightMapPos.y / 2);
        }
    }
}

