"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
function importBabelCore() {
    var mod = tryRequire('@babel/core') || tryRequire('babel-core');
    if (!mod) {
        throw new Error("[ts-jest] You must install the '@babel/core' or 'babel-core'" +
            " package (depending on the version you want to use).");
    }
    return mod;
}
exports.importBabelCore = importBabelCore;
function importBabelPresetEnv() {
    var mod = tryRequire('@babel/preset-env') || tryRequire('babel-preset-env');
    if (!mod) {
        throw new Error("[ts-jest] You must install the 'babel-jest' package if you're using babel.");
    }
    return mod;
}
exports.importBabelPresetEnv = importBabelPresetEnv;
function importBabelPresetJest() {
    var mod = tryRequire('babel-preset-jest');
    if (!mod) {
        throw new Error("[ts-jest] You must install the 'babel-jest' package if you're using babel.");
    }
    return mod;
}
exports.importBabelPresetJest = importBabelPresetJest;
function importBabelPluginIstanbul() {
    var mod = tryRequire('babel-plugin-istanbul');
    if (!mod) {
        throw new Error("[ts-jest] You must install the 'babel-jest' package if you're using babel.");
    }
    return mod.default;
}
exports.importBabelPluginIstanbul = importBabelPluginIstanbul;
function tryRequire(packageName) {
    var mod;
    try {
        mod = require(packageName);
    }
    catch (err) {
        if (err.code !== 'MODULE_NOT_FOUND')
            throw err;
    }
    return mod;
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW1wb3J0cy5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uL3NyYy91dGlscy9pbXBvcnRzLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7O0FBT0E7SUFDRSxJQUFNLEdBQUcsR0FBRyxVQUFVLENBQUMsYUFBYSxDQUFDLElBQUksVUFBVSxDQUFDLFlBQVksQ0FBQyxDQUFDO0lBQ2xFLElBQUksQ0FBQyxHQUFHLEVBQUU7UUFDUixNQUFNLElBQUksS0FBSyxDQUNiLDhEQUE4RDtZQUM1RCxzREFBc0QsQ0FDekQsQ0FBQztLQUNIO0lBQ0QsT0FBTyxHQUFHLENBQUM7QUFDYixDQUFDO0FBVEQsMENBU0M7QUFFRDtJQUNFLElBQU0sR0FBRyxHQUFHLFVBQVUsQ0FBQyxtQkFBbUIsQ0FBQyxJQUFJLFVBQVUsQ0FBQyxrQkFBa0IsQ0FBQyxDQUFDO0lBQzlFLElBQUksQ0FBQyxHQUFHLEVBQUU7UUFDUixNQUFNLElBQUksS0FBSyxDQUNiLDRFQUE0RSxDQUM3RSxDQUFDO0tBQ0g7SUFDRCxPQUFPLEdBQUcsQ0FBQztBQUNiLENBQUM7QUFSRCxvREFRQztBQUVEO0lBQ0UsSUFBTSxHQUFHLEdBQUcsVUFBVSxDQUFDLG1CQUFtQixDQUFDLENBQUM7SUFDNUMsSUFBSSxDQUFDLEdBQUcsRUFBRTtRQUNSLE1BQU0sSUFBSSxLQUFLLENBQ2IsNEVBQTRFLENBQzdFLENBQUM7S0FDSDtJQUNELE9BQU8sR0FBRyxDQUFDO0FBQ2IsQ0FBQztBQVJELHNEQVFDO0FBRUQ7SUFDRSxJQUFNLEdBQUcsR0FBRyxVQUFVLENBQUMsdUJBQXVCLENBQUMsQ0FBQztJQUNoRCxJQUFJLENBQUMsR0FBRyxFQUFFO1FBQ1IsTUFBTSxJQUFJLEtBQUssQ0FDYiw0RUFBNEUsQ0FDN0UsQ0FBQztLQUNIO0lBQ0QsT0FBTyxHQUFHLENBQUMsT0FBTyxDQUFDO0FBQ3JCLENBQUM7QUFSRCw4REFRQztBQUVELG9CQUE2QixXQUFtQjtJQUM5QyxJQUFJLEdBQU0sQ0FBQztJQUNYLElBQUk7UUFDRixHQUFHLEdBQUcsT0FBTyxDQUFDLFdBQVcsQ0FBQyxDQUFDO0tBQzVCO0lBQUMsT0FBTyxHQUFHLEVBQUU7UUFDWixJQUFJLEdBQUcsQ0FBQyxJQUFJLEtBQUssa0JBQWtCO1lBQUUsTUFBTSxHQUFHLENBQUM7S0FDaEQ7SUFDRCxPQUFPLEdBQUcsQ0FBQztBQUNiLENBQUMifQ==