'use strict';

Object.defineProperty(exports, '__esModule', {
  value: true
});
exports.default = _default;

function _istanbulLibInstrument() {
  const data = require('istanbul-lib-instrument');

  _istanbulLibInstrument = function _istanbulLibInstrument() {
    return data;
  };

  return data;
}

function _istanbulLibCoverage() {
  const data = require('istanbul-lib-coverage');

  _istanbulLibCoverage = function _istanbulLibCoverage() {
    return data;
  };

  return data;
}

function _jestRuntime() {
  const data = _interopRequireDefault(require('jest-runtime'));

  _jestRuntime = function _jestRuntime() {
    return data;
  };

  return data;
}

function _interopRequireDefault(obj) {
  return obj && obj.__esModule ? obj : {default: obj};
}

/**
 * Copyright (c) Facebook, Inc. and its affiliates. All Rights Reserved.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 *
 *
 */
const FileCoverage = _istanbulLibCoverage().classes.FileCoverage;

function _default(source, filename, globalConfig, config) {
  const coverageOptions = {
    collectCoverage: globalConfig.collectCoverage,
    collectCoverageFrom: globalConfig.collectCoverageFrom,
    collectCoverageOnlyFrom: globalConfig.collectCoverageOnlyFrom
  };

  if (
    _jestRuntime().default.shouldInstrument(filename, coverageOptions, config)
  ) {
    // Transform file with instrumentation to make sure initial coverage data is well mapped to original code.
    const _transformSource = new (_jestRuntime()).default.ScriptTransformer(
        config
      ).transformSource(filename, source, true),
      code = _transformSource.code,
      mapCoverage = _transformSource.mapCoverage,
      sourceMapPath = _transformSource.sourceMapPath;

    const extracted = (0, _istanbulLibInstrument().readInitialCoverage)(code);
    return {
      coverage: new FileCoverage(extracted.coverageData),
      sourceMapPath: mapCoverage ? sourceMapPath : null
    };
  } else {
    return null;
  }
}
