"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var electron_1 = require("electron");
var eventType_1 = require("../lib/eventType");
var ConfigurationPersistence_1 = require("../settings/ConfigurationPersistence");
var Squirrel_1 = require("../update/Squirrel");
var WindowManager_1 = require("../window/WindowManager");
var EnvironmentUtil = require("./EnvironmentUtil");
exports.isFirstInstance = undefined;
exports.checkForUpdate = function () {
    if (EnvironmentUtil.platform.IS_WINDOWS) {
        Squirrel_1.Squirrel.handleSquirrelEvent(exports.isFirstInstance);
        electron_1.ipcMain.on(eventType_1.EVENT_TYPE.WRAPPER.UPDATE, function () { return Squirrel_1.Squirrel.installUpdate(); });
    }
};
exports.checkSingleInstance = function () {
    if (process.mas) {
        exports.isFirstInstance = true;
    }
    else {
        exports.isFirstInstance = electron_1.app.requestSingleInstanceLock();
        if (!EnvironmentUtil.platform.IS_WINDOWS && !exports.isFirstInstance) {
            exports.quit();
        }
        else {
            electron_1.app.on('second-instance', function () { return WindowManager_1.WindowManager.showPrimaryWindow(); });
        }
    }
};
exports.quit = function () {
    ConfigurationPersistence_1.settings.persistToFile();
    electron_1.app.exit();
};
exports.relaunch = function () {
    if (EnvironmentUtil.platform.IS_MAC_OS) {
        WindowManager_1.WindowManager.sendActionToPrimaryWindow(eventType_1.EVENT_TYPE.WRAPPER.RELOAD);
    }
    else {
        electron_1.app.relaunch();
        exports.quit();
    }
};
//# sourceMappingURL=lifecycle.js.map