/*
 * Decompiled with CFR 0.152.
 */
package sbt.internal.util.complete;

import java.io.Serializable;
import java.util.Collection;
import jline.console.ConsoleReader;
import jline.console.CursorBuffer;
import jline.console.completer.Completer;
import jline.console.completer.CompletionHandler;
import sbt.internal.util.complete.Completion;
import sbt.internal.util.complete.Completions;
import sbt.internal.util.complete.JLineCompletion;
import sbt.internal.util.complete.JLineCompletion$DummyCompletor$;
import sbt.internal.util.complete.Parser;
import sbt.internal.util.complete.Parser$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.immutable.StringOps$;
import scala.math.Ordering;
import scala.math.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class JLineCompletion$ {
    public static JLineCompletion$ MODULE$;

    static {
        new JLineCompletion$();
    }

    public void installCustomCompletor(ConsoleReader reader, Parser<?> parser) {
        this.installCustomCompletor(reader, this.parserAsCompletor(parser));
    }

    public void installCustomCompletor(ConsoleReader reader, Function2<String, Object, Tuple2<Seq<String>, Seq<String>>> complete) {
        this.installCustomCompletor(this.customCompletor(complete), reader);
    }

    public void installCustomCompletor(Function2<ConsoleReader, Object, Object> complete, ConsoleReader reader) {
        reader.removeCompleter((Completer)JLineCompletion$DummyCompletor$.MODULE$);
        reader.addCompleter((Completer)JLineCompletion$DummyCompletor$.MODULE$);
        reader.setCompletionHandler((CompletionHandler)new JLineCompletion.CustomHandler(complete));
    }

    public Function2<String, Object, Tuple2<Seq<String>, Seq<String>>> parserAsCompletor(Parser<?> p) {
        return (Function2 & Serializable & scala.Serializable)(str, level) -> JLineCompletion$.MODULE$.convertCompletions(Parser$.MODULE$.completions(p, str, BoxesRunTime.unboxToInt((Object)level)));
    }

    public Tuple2<Seq<String>, Seq<String>> convertCompletions(Completions c) {
        Tuple2 tuple2;
        Set<Completion> cs = c.get();
        if (cs.isEmpty()) {
            String string = "{invalid input}";
            Tuple2 tuple22 = new Tuple2((Object)Nil$.MODULE$, (Object)Nil$.MODULE$.$colon$colon((Object)string));
            tuple2 = tuple22;
        } else {
            tuple2 = this.convertCompletions(cs);
        }
        return tuple2;
    }

    public Tuple2<Seq<String>, Seq<String>> convertCompletions(Set<Completion> cs) {
        Tuple2 tuple2 = new Tuple2((Object)Predef$.MODULE$.Set().empty(), (Object)Predef$.MODULE$.Set().empty());
        Tuple2 tuple22 = (Tuple2)cs.$div$colon((Object)tuple2, (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
            Completion comp;
            Tuple2 t;
            block3: {
                Tuple2 tuple2;
                block2: {
                    tuple2 = new Tuple2(x0$1, x1$1);
                    if (tuple2 == null) break block2;
                    t = (Tuple2)tuple2._1();
                    comp = (Completion)tuple2._2();
                    if (t != null) break block3;
                }
                throw new MatchError((Object)tuple2);
            }
            Set insert = (Set)t._1();
            Set display = (Set)t._2();
            Tuple2 tuple2 = comp.isEmpty() ? t : new Tuple2(MODULE$.appendNonEmpty((Set<String>)insert, comp.append()), MODULE$.appendNonEmpty((Set<String>)display, comp.display()));
            return tuple2;
        });
        if (tuple22 == null) {
            throw new MatchError((Object)tuple22);
        }
        Set insert = (Set)tuple22._1();
        Set display = (Set)tuple22._2();
        Tuple2 tuple23 = new Tuple2((Object)insert, (Object)display);
        Tuple2 tuple24 = tuple23;
        Set insert2 = (Set)tuple24._1();
        Set display2 = (Set)tuple24._2();
        return new Tuple2((Object)insert2.toSeq(), display2.toSeq().sorted((Ordering)Ordering.String$.MODULE$));
    }

    /*
     * Enabled aggressive block sorting
     */
    public Set<String> appendNonEmpty(Set<String> set, String add) {
        Set set2;
        block3: {
            block2: {
                String trimmed = add.trim();
                if (trimmed.isEmpty()) break block2;
                String string = trimmed;
                String string2 = ";";
                if (string != null ? !string.equals(string2) : string2 != null) break block3;
            }
            set2 = set;
            return set2;
        }
        set2 = (Set)set.$plus((Object)add);
        return set2;
    }

    public Function2<ConsoleReader, Object, Object> customCompletor(Function2<String, Object, Tuple2<Seq<String>, Seq<String>>> f) {
        return (Function2 & Serializable & scala.Serializable)(reader, level) -> BoxesRunTime.boxToBoolean((boolean)JLineCompletion$.$anonfun$customCompletor$1(f, reader, BoxesRunTime.unboxToInt((Object)level)));
    }

    public Tuple2<String, Object> bufferSnapshot(ConsoleReader reader) {
        CursorBuffer b = reader.getCursorBuffer();
        return new Tuple2((Object)b.buffer.toString(), (Object)BoxesRunTime.boxToInteger((int)b.cursor));
    }

    public String beforeCursor(ConsoleReader reader) {
        CursorBuffer b = reader.getCursorBuffer();
        return b.buffer.substring(0, b.cursor);
    }

    public boolean complete(String beforeCursor, Function1<String, Tuple2<Seq<String>, Seq<String>>> completions, ConsoleReader reader) {
        Tuple2 tuple2 = (Tuple2)completions.apply((Object)beforeCursor);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Seq insert = (Seq)tuple2._1();
        Seq display = (Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)insert, (Object)display);
        Tuple2 tuple23 = tuple22;
        Seq insert2 = (Seq)tuple23._1();
        Seq display2 = (Seq)tuple23._2();
        String common = this.commonPrefix((Seq<String>)insert2);
        if (common.isEmpty()) {
            if (!display2.isEmpty()) {
                this.showCompletions((Seq<String>)display2, reader);
            }
        } else {
            this.appendCompletion(common, reader);
        }
        return !common.isEmpty() || !display2.isEmpty();
    }

    public void appendCompletion(String common, ConsoleReader reader) {
        reader.getCursorBuffer().write((CharSequence)common);
        reader.redrawLine();
    }

    public void showCompletions(Seq<String> display, ConsoleReader reader) {
        this.printCompletions(display, reader);
        reader.drawLine();
    }

    public void printCompletions(Seq<String> cs, ConsoleReader reader) {
        block0: {
            boolean print = this.shouldPrint(cs, reader);
            reader.println();
            if (!print) break block0;
            this.printLinesAndColumns(cs, reader);
        }
    }

    public void printLinesAndColumns(Seq<String> cs, ConsoleReader reader) {
        Tuple2 tuple2 = cs.partition((Function1 & Serializable & scala.Serializable)s -> BoxesRunTime.boxToBoolean((boolean)JLineCompletion$.MODULE$.hasNewline(s)));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Seq lines = (Seq)tuple2._1();
        Seq columns = (Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)lines, (Object)columns);
        Tuple2 tuple23 = tuple22;
        Seq lines2 = (Seq)tuple23._1();
        Seq columns2 = (Seq)tuple23._2();
        lines2.foreach((Function1 & Serializable & scala.Serializable)line -> {
            JLineCompletion$.$anonfun$printLinesAndColumns$2(reader, line);
            return BoxedUnit.UNIT;
        });
        reader.printColumns((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)columns2.map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.trim(), Seq$.MODULE$.canBuildFrom())).asJava());
    }

    public boolean hasNewline(String s) {
        return s.indexOf(10) >= 0;
    }

    public boolean shouldPrint(Seq<String> cs, ConsoleReader reader) {
        int size = cs.size();
        return size <= reader.getAutoprintThreshold() || this.confirm(new StringOps(Predef$.MODULE$.augmentString("Display all %d possibilities? (y or n) ")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)size)})), 'y', 'n', reader);
    }

    public boolean confirm(String prompt, char trueC, char falseC, ConsoleReader reader) {
        reader.println();
        reader.print((CharSequence)prompt);
        reader.flush();
        return reader.readCharacter(new char[]{trueC, falseC}) == trueC;
    }

    public String commonPrefix(Seq<String> s) {
        return s.isEmpty() ? "" : (String)s.reduceLeft((Function2 & Serializable & scala.Serializable)(a, b) -> MODULE$.commonPrefix((String)a, (String)b));
    }

    public String commonPrefix(String a, String b) {
        int len = package$.MODULE$.min(a.length(), b.length());
        return a.substring(0, this.loop$1(0, len, a, b));
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ boolean $anonfun$customCompletor$1(Function2 f$1, ConsoleReader reader2, int level) {
        void var3_3;
        boolean success = MODULE$.complete(MODULE$.beforeCursor(reader2), (Function1<String, Tuple2<Seq<String>, Seq<String>>>)(Function1 & Serializable & scala.Serializable)reader -> (Tuple2)f$1.apply(reader, (Object)BoxesRunTime.boxToInteger((int)level)), reader2);
        reader2.flush();
        return (boolean)var3_3;
    }

    public static final /* synthetic */ void $anonfun$printLinesAndColumns$2(ConsoleReader reader$1, String line) {
        block0: {
            reader$1.print((CharSequence)line);
            if (line.charAt(line.length() - 1) == '\n') break block0;
            reader$1.println();
        }
    }

    private final int loop$1(int i, int len$1, String a$1, String b$1) {
        int n;
        while (true) {
            if (i >= len$1) {
                n = len$1;
                break;
            }
            if (StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(a$1), i) != StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(b$1), i)) {
                n = i;
                break;
            }
            ++i;
        }
        return n;
    }

    private JLineCompletion$() {
        MODULE$ = this;
    }
}

