/*
 * Decompiled with CFR 0.152.
 */
package sbt.internal;

import java.io.File;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.net.URI;
import sbt.BuildPaths$;
import sbt.BuiltinCommands$;
import sbt.Command$;
import sbt.Extracted;
import sbt.Keys$;
import sbt.Project$;
import sbt.ProjectRef;
import sbt.ProjectReference;
import sbt.Reference$;
import sbt.ResolvedProject;
import sbt.State;
import sbt.State$;
import sbt.compiler.Eval;
import sbt.internal.BuildStructure;
import sbt.internal.SessionSettings;
import sbt.internal.parser.SbtRefactorings$;
import sbt.internal.util.Init;
import sbt.internal.util.LineRange;
import sbt.internal.util.RangePosition;
import sbt.internal.util.SourcePosition;
import sbt.internal.util.complete.DefaultParsers$;
import sbt.internal.util.complete.Parser;
import sbt.io.IO$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple6;
import scala.collection.GenSeq;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.sys.package$;

public final class SessionSettings$
implements scala.Serializable {
    public static SessionSettings$ MODULE$;
    private Parser<SessionSettings.SessionCommand> parser;
    private Parser<SessionSettings.Remove> remove;
    private volatile byte bitmap$0;

    static {
        new SessionSettings$();
    }

    public State reapply(SessionSettings session, State s) {
        return BuiltinCommands$.MODULE$.reapply(session, Project$.MODULE$.structure(s), s);
    }

    public State clearSettings(State s) {
        return this.withSettings(s, (Function1<SessionSettings, State>)(Function1 & Serializable & scala.Serializable)session -> {
            Map x$1 = (Map)session.append().$minus((Object)session.current());
            URI x$2 = session.copy$default$1();
            Map<URI, String> x$3 = session.copy$default$2();
            Seq<Init.Setting<?>> x$4 = session.copy$default$3();
            Seq<Init.Setting<?>> x$5 = session.copy$default$5();
            Function0<Eval> x$6 = session.copy$default$6();
            return MODULE$.reapply(session.copy(x$2, x$3, x$4, x$1, x$5, x$6), s);
        });
    }

    public State clearAllSettings(State s) {
        return this.withSettings(s, (Function1<SessionSettings, State>)(Function1 & Serializable & scala.Serializable)session -> MODULE$.reapply(session.clearExtraSettings(), s));
    }

    public State withSettings(State s, Function1<SessionSettings, State> f) {
        State state;
        Extracted extracted = Project$.MODULE$.extract(s);
        if (extracted.session().append().isEmpty()) {
            State.StateOpsImpl$.MODULE$.log$extension(State$.MODULE$.StateOpsImpl(s)).info((Function0 & Serializable & scala.Serializable)() -> "No session settings defined.");
            state = s;
        } else {
            state = (State)f.apply((Object)extracted.session());
        }
        return state;
    }

    public String pluralize(int size, String of) {
        return new StringBuilder(0).append(((Object)BoxesRunTime.boxToInteger((int)size)).toString()).append((Object)(size == 1 ? of : new StringBuilder(1).append(of).append("s").toString())).toString();
    }

    public void checkSession(SessionSettings newSession, State oldState) {
        block0: {
            List oldSettings = (List)((List)State.StateOpsImpl$.MODULE$.get$extension(State$.MODULE$.StateOpsImpl(oldState), Keys$.MODULE$.sessionSettings()).toList().flatMap((Function1 & Serializable & scala.Serializable)x$3 -> x$3.append(), List$.MODULE$.canBuildFrom())).flatMap((Function1 & Serializable & scala.Serializable)x$4 -> (Seq)x$4._2(), List$.MODULE$.canBuildFrom());
            if (!newSession.append().isEmpty() || !oldSettings.nonEmpty()) break block0;
            State.StateOpsImpl$.MODULE$.log$extension(State$.MODULE$.StateOpsImpl(oldState)).warn((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(61).append("Discarding ").append(MODULE$.pluralize(oldSettings.size(), " session setting")).append(".  Use 'session save' to persist session settings.").toString());
        }
    }

    public <T> Seq<T> removeRanges(Seq<T> in, Seq<Tuple2<Object, Object>> ranges) {
        Set set = Predef$.MODULE$.Set().empty();
        Set asSet = (Set)ranges.$div$colon((Object)set, (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2;
            Set s;
            block3: {
                Tuple2 tuple22;
                block2: {
                    tuple22 = new Tuple2(x0$1, x1$1);
                    if (tuple22 == null) break block2;
                    s = (Set)tuple22._1();
                    tuple2 = (Tuple2)tuple22._2();
                    if (tuple2 != null) break block3;
                }
                throw new MatchError((Object)tuple22);
            }
            int hi = tuple2._1$mcI$sp();
            int lo = tuple2._2$mcI$sp();
            Set set = (Set)s.$plus$plus((GenTraversableOnce)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(hi), lo));
            return set;
        });
        return (Seq)((TraversableLike)in.zipWithIndex(Seq$.MODULE$.canBuildFrom())).flatMap((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Nil$ nil$;
            Tuple2 tuple2 = x0$2;
            if (tuple2 != null) {
                Object t = tuple2._1();
                int index = tuple2._2$mcI$sp();
                if (asSet.apply((Object)BoxesRunTime.boxToInteger((int)(index + 1)))) {
                    nil$ = Nil$.MODULE$;
                } else {
                    Object object = t;
                    nil$ = Nil$.MODULE$.$colon$colon(object);
                }
            } else {
                throw new MatchError((Object)tuple2);
            }
            Nil$ nil$2 = nil$;
            return nil$2;
        }, Seq$.MODULE$.canBuildFrom());
    }

    public State removeSettings(State s, Seq<Tuple2<Object, Object>> ranges) {
        return this.withSettings(s, (Function1<SessionSettings, State>)(Function1 & Serializable & scala.Serializable)session -> {
            Map newAppend;
            ProjectRef current = session.current();
            Map x$1 = newAppend = session.append().updated((Object)current, MODULE$.removeRanges((Seq)session.append().getOrElse((Object)current, (Function0 & Serializable & scala.Serializable)() -> Nil$.MODULE$), ranges));
            URI x$2 = session.copy$default$1();
            Map<URI, String> x$3 = session.copy$default$2();
            Seq<Init.Setting<?>> x$4 = session.copy$default$3();
            Seq<Init.Setting<?>> x$5 = session.copy$default$5();
            Function0<Eval> x$6 = session.copy$default$6();
            return MODULE$.reapply(session.copy(x$2, x$3, x$4, x$1, x$5, x$6), s);
        });
    }

    public State saveAllSettings(State s) {
        return this.saveSomeSettings(s, (Function1<ProjectRef, Object>)(Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)SessionSettings$.$anonfun$saveAllSettings$1(x$7)));
    }

    public State saveSettings(State s) {
        ProjectRef current = Project$.MODULE$.session(s).current();
        return this.saveSomeSettings(s, (Function1<ProjectRef, Object>)(Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)SessionSettings$.$anonfun$saveSettings$1(current, x$8)));
    }

    public State saveSomeSettings(State s, Function1<ProjectRef, Object> include) {
        return this.withSettings(s, (Function1<SessionSettings, State>)(Function1 & Serializable & scala.Serializable)session -> {
            Map newSettings = (Map)session.append().withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)SessionSettings$.$anonfun$saveSomeSettings$2(check$ifrefutable$1))).withFilter((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)SessionSettings$.$anonfun$saveSomeSettings$3(include, x$10))).map((Function1 & Serializable & scala.Serializable)x$11 -> {
                Tuple2 tuple2;
                ProjectRef ref;
                Tuple2 tuple22 = x$11;
                if (tuple22 != null) {
                    Seq settings;
                    ref = (ProjectRef)tuple22._1();
                    Tuple2<Seq<Tuple2<Init.Setting<?>, Seq<String>>>, Seq<Init.Setting<?>>> tuple23 = MODULE$.writeSettings(ref, (settings = (Seq)tuple22._2()).toList(), session.original(), Project$.MODULE$.structure(s));
                    if (tuple23 == null) {
                        throw new MatchError(tuple23);
                    }
                    Seq news = (Seq)tuple23._1();
                    Seq olds = (Seq)tuple23._2();
                    tuple2 = new Tuple2((Object)news, (Object)olds);
                } else {
                    throw new MatchError((Object)tuple22);
                }
                Tuple2 tuple24 = tuple2;
                Seq news = (Seq)tuple24._1();
                Seq olds = (Seq)tuple24._2();
                Tuple2 tuple25 = new Tuple2((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ref), (Object)news), (Object)olds);
                return tuple25;
            }, Map$.MODULE$.canBuildFrom());
            Tuple2 tuple2 = newSettings.unzip((Function1)Predef$.MODULE$.$conforms());
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Iterable newAppend = (Iterable)tuple2._1();
            Iterable newOriginal = (Iterable)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)newAppend, (Object)newOriginal);
            Tuple2 tuple23 = tuple22;
            Iterable newAppend2 = (Iterable)tuple23._1();
            Iterable newOriginal2 = (Iterable)tuple23._2();
            Map x$1 = newAppend2.toMap(Predef$.MODULE$.$conforms());
            Seq x$2 = ((TraversableOnce)newOriginal2.flatten((Function1)Predef$.MODULE$.$conforms())).toSeq();
            URI x$3 = session.copy$default$1();
            Map<URI, String> x$4 = session.copy$default$2();
            Seq<Init.Setting<?>> x$5 = session.copy$default$5();
            Function0<Eval> x$6 = session.copy$default$6();
            SessionSettings newSession = session.copy(x$3, x$4, x$2, x$1, x$5, x$6);
            Seq<Init.Setting<?>> x$7 = newSession.mergeSettings();
            Map x$8 = Predef$.MODULE$.Map().empty();
            URI x$9 = newSession.copy$default$1();
            Map<URI, String> x$102 = newSession.copy$default$2();
            Seq<Init.Setting<?>> x$112 = newSession.copy$default$5();
            Function0<Eval> x$12 = newSession.copy$default$6();
            return MODULE$.reapply(newSession.copy(x$9, x$102, x$7, x$8, x$112, x$12), s);
        });
    }

    public Tuple2<Seq<Tuple2<Init.Setting<?>, Seq<String>>>, Seq<Init.Setting<?>>> writeSettings(ProjectRef pref, List<Tuple2<Init.Setting<?>, Seq<String>>> settings, Seq<Init.Setting<?>> original, BuildStructure structure) {
        List newWithPos;
        Seq exist;
        ResolvedProject project = (ResolvedProject)Project$.MODULE$.getProject(pref, structure).getOrElse((Function0 & Serializable & scala.Serializable)() -> package$.MODULE$.error(new StringBuilder(26).append("Invalid project reference ").append(pref).toString()));
        File writeTo = (File)BuildPaths$.MODULE$.configurationSources(project.base()).headOption().getOrElse((Function0 & Serializable & scala.Serializable)() -> new File(project.base(), "build.sbt"));
        writeTo.createNewFile();
        String path = writeTo.getAbsolutePath();
        Tuple3 tuple3 = new Tuple3((Object)Nil$.MODULE$, (Object)Nil$.MODULE$, (Object)Predef$.MODULE$.Set().empty());
        Tuple3 tuple32 = (Tuple3)((TraversableOnce)original.reverse()).$div$colon((Object)tuple3, (arg_0, arg_1) -> SessionSettings$.$anonfun$writeSettings$3(path, arg_0, arg_1));
        if (tuple32 == null) {
            throw new MatchError((Object)tuple32);
        }
        List inFile = (List)tuple32._1();
        List other = (List)tuple32._2();
        Tuple2 tuple2 = new Tuple2((Object)inFile, (Object)other);
        Tuple2 tuple22 = tuple2;
        List inFile2 = (List)tuple22._1();
        List other2 = (List)tuple22._2();
        Tuple3 tuple33 = new Tuple3((Object)BoxesRunTime.boxToInteger((int)0), (Object)Nil$.MODULE$, (Object)Seq$.MODULE$.apply((Seq)Nil$.MODULE$));
        Tuple3 tuple34 = (Tuple3)inFile2.$div$colon((Object)tuple33, (arg_0, arg_1) -> SessionSettings$.$anonfun$writeSettings$4(settings, path, arg_0, arg_1));
        if (tuple34 == null) {
            throw new MatchError((Object)tuple34);
        }
        List oldShifted = (List)tuple34._2();
        Seq replace = (Seq)tuple34._3();
        Tuple2 tuple23 = new Tuple2((Object)oldShifted, (Object)replace);
        Tuple2 tuple24 = tuple23;
        List oldShifted2 = (List)tuple24._1();
        Seq replace2 = (Seq)tuple24._2();
        List newSettings = (List)settings.diff((GenSeq)replace2);
        List oldContent = IO$.MODULE$.readLines(writeTo, IO$.MODULE$.readLines$default$2());
        Tuple2<File, Seq<String>> tuple25 = SbtRefactorings$.MODULE$.applySessionSettings((Tuple2<File, Seq<String>>)new Tuple2((Object)writeTo, (Object)oldContent), replace2);
        if (tuple25 == null) {
            throw new MatchError(tuple25);
        }
        Seq seq = exist = (Seq)tuple25._2();
        Seq exist2 = seq;
        Seq adjusted = newSettings.nonEmpty() && this.needsTrailingBlank((Seq<String>)exist2) ? (Seq)exist2.$colon$plus((Object)"", Seq$.MODULE$.canBuildFrom()) : exist2;
        Seq lines = (Seq)adjusted.$plus$plus((GenTraversableOnce)newSettings.flatMap((Function1 & Serializable & scala.Serializable)x -> (Seq)((SeqLike)x._2()).$colon$plus((Object)"", Seq$.MODULE$.canBuildFrom()), List$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom());
        IO$.MODULE$.writeLines(writeTo, lines, IO$.MODULE$.writeLines$default$3(), IO$.MODULE$.writeLines$default$4());
        Tuple2 tuple26 = new Tuple2((Object)Nil$.MODULE$, (Object)BoxesRunTime.boxToInteger((int)(adjusted.size() + 1)));
        Tuple2 tuple27 = (Tuple2)newSettings.$div$colon((Object)tuple26, (Function2 & Serializable & scala.Serializable)(x0$3, x1$3) -> {
            int line;
            List acc;
            Tuple2 tuple2;
            block3: {
                Tuple2 tuple22;
                block2: {
                    tuple22 = new Tuple2(x0$3, x1$3);
                    if (tuple22 == null) break block2;
                    Tuple2 tuple23 = (Tuple2)tuple22._1();
                    tuple2 = (Tuple2)tuple22._2();
                    if (tuple23 == null) break block2;
                    acc = (List)tuple23._1();
                    line = tuple23._2$mcI$sp();
                    if (tuple2 != null) break block3;
                }
                throw new MatchError((Object)tuple22);
            }
            Init.Setting s = (Init.Setting)tuple2._1();
            Seq newLines = (Seq)tuple2._2();
            int endLine = line + newLines.size();
            Tuple2 tuple24 = new Tuple2((Object)s.withPos((SourcePosition)new RangePosition(path, new LineRange(line, endLine))), (Object)newLines);
            Tuple2 tuple25 = new Tuple2((Object)acc.$colon$colon((Object)tuple24), (Object)BoxesRunTime.boxToInteger((int)(endLine + 1)));
            return tuple25;
        });
        if (tuple27 == null) {
            throw new MatchError((Object)tuple27);
        }
        List list = newWithPos = (List)tuple27._1();
        List newWithPos2 = list;
        return new Tuple2((Object)newWithPos2.reverse(), other2.$plus$plus((GenTraversableOnce)oldShifted2, List$.MODULE$.canBuildFrom()));
    }

    public boolean needsTrailingBlank(Seq<String> lines) {
        return lines.nonEmpty() && !((IterableLike)lines.takeRight(1)).exists((Function1 & Serializable & scala.Serializable)x$26 -> BoxesRunTime.boxToBoolean((boolean)SessionSettings$.$anonfun$needsTrailingBlank$1(x$26)));
    }

    public State printAllSettings(State s) {
        return this.withSettings(s, (Function1<SessionSettings, State>)(Function1 & Serializable & scala.Serializable)session -> {
            session.append().withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$2 -> BoxesRunTime.boxToBoolean((boolean)SessionSettings$.$anonfun$printAllSettings$2(check$ifrefutable$2))).withFilter((Function1 & Serializable & scala.Serializable)x$27 -> BoxesRunTime.boxToBoolean((boolean)SessionSettings$.$anonfun$printAllSettings$3(x$27))).foreach((Function1 & Serializable & scala.Serializable)x$28 -> {
                SessionSettings$.$anonfun$printAllSettings$4(x$28);
                return BoxedUnit.UNIT;
            });
            return s;
        });
    }

    public State printSettings(State s) {
        return this.withSettings(s, (Function1<SessionSettings, State>)(Function1 & Serializable & scala.Serializable)session -> {
            MODULE$.printSettings((Seq)session.append().getOrElse((Object)session.current(), (Function0 & Serializable & scala.Serializable)() -> Nil$.MODULE$));
            return s;
        });
    }

    public void printSettings(Seq<Tuple2<Init.Setting<?>, Seq<String>>> settings) {
        ((TraversableLike)settings.zipWithIndex(Seq$.MODULE$.canBuildFrom())).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$3 -> BoxesRunTime.boxToBoolean((boolean)SessionSettings$.$anonfun$printSettings$3(check$ifrefutable$3))).foreach((Function1 & Serializable & scala.Serializable)x$29 -> {
            SessionSettings$.$anonfun$printSettings$4(x$29);
            return BoxedUnit.UNIT;
        });
    }

    public String Help() {
        return "session <command>\n\nManipulates session settings, which are temporary settings that do not persist past the current sbt execution (that is, the current session).\nValid commands are:\n\nclear, clear-all\n\n\tRemoves temporary settings added using 'set' and re-evaluates all settings.\n\tFor 'clear', only the settings defined for the current project are cleared.\n\tFor 'clear-all', all settings in all projects are cleared.\n\nlist, list-all\n\n\tPrints a numbered list of session settings defined.\n\tThe numbers may be used to remove individual settings or ranges of settings using 'remove'.\n\tFor 'list', only the settings for the current project are printed.\n\tFor 'list-all', all settings in all projets are printed.\n\nremove <range-spec>\n\n\t<range-spec> is a comma-separated list of individual numbers or ranges of numbers.\n\tFor example, 'remove 1,3,5-7'.\n\tThe temporary settings at the given indices for the current project are removed and all settings are re-evaluated.\n\tUse the 'list' command to see a numbered list of settings for the current project.\n\nsave, save-all\n\n\tMakes the session settings permanent by writing them to a '.sbt' configuration file.\n\tFor 'save', only the current project's settings are saved (the settings for other projects are left alone).\n\tFor 'save-all', the session settings are saved for all projects.\n\tThe session settings defined for a project are appended to the first '.sbt' configuration file in that project.\n\tIf no '.sbt' configuration file exists, the settings are written to 'build.sbt' in the project's base directory.";
    }

    private Parser<SessionSettings.SessionCommand> parser$lzycompute() {
        SessionSettings$ sessionSettings$ = this;
        synchronized (sessionSettings$) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.parser = DefaultParsers$.MODULE$.richParser(DefaultParsers$.MODULE$.token(DefaultParsers$.MODULE$.Space())).$tilde$greater(DefaultParsers$.MODULE$.richParser(DefaultParsers$.MODULE$.richParser(DefaultParsers$.MODULE$.richParser(DefaultParsers$.MODULE$.richParser(DefaultParsers$.MODULE$.richParser(DefaultParsers$.MODULE$.richParser(DefaultParsers$.MODULE$.token(DefaultParsers$.MODULE$.literalRichStringParser("list-all").$up$up$up((Object)new SessionSettings.Print(true)))).$bar(DefaultParsers$.MODULE$.token(DefaultParsers$.MODULE$.literalRichStringParser("list").$up$up$up((Object)new SessionSettings.Print(false))))).$bar(DefaultParsers$.MODULE$.token(DefaultParsers$.MODULE$.literalRichStringParser("clear").$up$up$up((Object)new SessionSettings.Clear(false))))).$bar(DefaultParsers$.MODULE$.token(DefaultParsers$.MODULE$.literalRichStringParser("save-all").$up$up$up((Object)new SessionSettings.Save(true))))).$bar(DefaultParsers$.MODULE$.token(DefaultParsers$.MODULE$.literalRichStringParser("save").$up$up$up((Object)new SessionSettings.Save(false))))).$bar(DefaultParsers$.MODULE$.token(DefaultParsers$.MODULE$.literalRichStringParser("clear-all").$up$up$up((Object)new SessionSettings.Clear(true))))).$bar(this.remove()));
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.parser;
    }

    public Parser<SessionSettings.SessionCommand> parser() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.parser$lzycompute() : this.parser;
    }

    private Parser<SessionSettings.Remove> remove$lzycompute() {
        SessionSettings$ sessionSettings$ = this;
        synchronized (sessionSettings$) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.remove = DefaultParsers$.MODULE$.richParser(DefaultParsers$.MODULE$.richParser(DefaultParsers$.MODULE$.token(DefaultParsers$.MODULE$.literal("remove"))).$tilde$greater(DefaultParsers$.MODULE$.token(DefaultParsers$.MODULE$.Space()))).$tilde$greater(DefaultParsers$.MODULE$.richParser(this.natSelect()).map((Function1 & Serializable & scala.Serializable)ranges -> new SessionSettings.Remove((Seq<Tuple2<Object, Object>>)ranges)));
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.remove;
    }

    public Parser<SessionSettings.Remove> remove() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.remove$lzycompute() : this.remove;
    }

    public Parser<Seq<Tuple2<Object, Object>>> natSelect() {
        return DefaultParsers$.MODULE$.rep1sep(DefaultParsers$.MODULE$.token(this.range(), "<range>"), DefaultParsers$.MODULE$.literal(','));
    }

    public Parser<Tuple2<Object, Object>> range() {
        return DefaultParsers$.MODULE$.richParser(DefaultParsers$.MODULE$.richParser(DefaultParsers$.MODULE$.NatBasic()).$tilde(DefaultParsers$.MODULE$.richParser(DefaultParsers$.MODULE$.literalRichCharParser('-').$tilde$greater(DefaultParsers$.MODULE$.NatBasic())).$qmark())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            Some some = DefaultParsers$.MODULE$.$tilde().unapply(tuple2);
            if (some.isEmpty()) {
                throw new MatchError((Object)tuple2);
            }
            int lo = ((Tuple2)some.get())._1$mcI$sp();
            Option hi = (Option)((Tuple2)some.get())._2();
            Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(lo, BoxesRunTime.unboxToInt((Object)hi.getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> lo)));
            return sp2;
        });
    }

    public Parser<Function0<State>> command(State s) {
        return Command$.MODULE$.applyEffect(this.parser(), (Function1 & Serializable & scala.Serializable)x0$1 -> {
            State state;
            SessionSettings.SessionCommand sessionCommand = x0$1;
            if (sessionCommand instanceof SessionSettings.Print) {
                SessionSettings.Print print = (SessionSettings.Print)sessionCommand;
                state = print.all() ? MODULE$.printAllSettings(s) : MODULE$.printSettings(s);
            } else if (sessionCommand instanceof SessionSettings.Save) {
                SessionSettings.Save save = (SessionSettings.Save)sessionCommand;
                state = save.all() ? MODULE$.saveAllSettings(s) : MODULE$.saveSettings(s);
            } else if (sessionCommand instanceof SessionSettings.Clear) {
                SessionSettings.Clear clear = (SessionSettings.Clear)sessionCommand;
                state = clear.all() ? MODULE$.clearAllSettings(s) : MODULE$.clearSettings(s);
            } else if (sessionCommand instanceof SessionSettings.Remove) {
                SessionSettings.Remove remove = (SessionSettings.Remove)sessionCommand;
                state = MODULE$.removeSettings(s, remove.ranges());
            } else {
                throw new MatchError((Object)sessionCommand);
            }
            return state;
        });
    }

    public SessionSettings apply(URI currentBuild, Map<URI, String> currentProject, Seq<Init.Setting<?>> original, Map<ProjectRef, Seq<Tuple2<Init.Setting<?>, Seq<String>>>> append, Seq<Init.Setting<?>> rawAppend, Function0<Eval> currentEval) {
        return new SessionSettings(currentBuild, currentProject, original, append, rawAppend, currentEval);
    }

    public Option<Tuple6<URI, Map<URI, String>, Seq<Init.Setting<?>>, Map<ProjectRef, Seq<Tuple2<Init.Setting<?>, Seq<String>>>>, Seq<Init.Setting<?>>, Function0<Eval>>> unapply(SessionSettings x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple6((Object)x$0.currentBuild(), x$0.currentProject(), x$0.original(), x$0.append(), x$0.rawAppend(), x$0.currentEval()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    public static final /* synthetic */ boolean $anonfun$saveAllSettings$1(ProjectRef x$7) {
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$saveSettings$1(ProjectRef current$1, ProjectRef x$8) {
        ProjectRef projectRef = x$8;
        ProjectRef projectRef2 = current$1;
        return !(projectRef != null ? !projectRef.equals(projectRef2) : projectRef2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$saveSomeSettings$2(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$saveSomeSettings$3(Function1 include$1, Tuple2 x$10) {
        Tuple2 tuple2 = x$10;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        ProjectRef ref = (ProjectRef)tuple2._1();
        Seq settings = (Seq)tuple2._2();
        boolean bl = settings.nonEmpty() && BoxesRunTime.unboxToBoolean((Object)include$1.apply((Object)ref));
        return bl;
    }

    /*
     * Unable to fully structure code
     */
    public static final /* synthetic */ Tuple3 $anonfun$writeSettings$3(String path$1, Tuple3 x0$1, Init.Setting x1$1) {
        block3: {
            block2: {
                var5_3 = new Tuple2((Object)x0$1, (Object)x1$1);
                if (var5_3 == null) break block2;
                var6_4 = (Tuple3)var5_3._1();
                s = (Init.Setting)var5_3._2();
                if (var6_4 == null) break block2;
                in = (List)var6_4._1();
                oth = (List)var6_4._2();
                keys = (Set)var6_4._3();
                var11_9 = s.pos();
                if (!(var11_9 instanceof RangePosition)) ** GOTO lbl-1000
                var12_10 = (RangePosition)var11_9;
                var13_11 = var12_10.path();
                v0 = path$1;
                var14_12 = var13_11;
                if (!(v0 != null ? v0.equals(var14_12) == false : var14_12 != null) && !keys.contains((Object)s.key())) {
                    var15_13 = s;
                    var4_14 = new Tuple3((Object)in.$colon$colon((Object)var15_13), (Object)oth, (Object)keys.$plus((Object)s.key()));
                } else lbl-1000:
                // 2 sources

                {
                    var16_15 = s;
                    var4_14 = new Tuple3((Object)in, (Object)oth.$colon$colon((Object)var16_15), (Object)keys);
                }
                break block3;
            }
            throw new MatchError((Object)var5_3);
        }
        var3_16 = var4_14;
        return var3_16;
    }

    public static final /* synthetic */ boolean $anonfun$writeSettings$5(Init.Setting s$6, Tuple2 x$19) {
        Init.ScopedKey scopedKey = ((Init.Setting)x$19._1()).key();
        Init.ScopedKey scopedKey2 = s$6.key();
        return !(scopedKey != null ? !scopedKey.equals(scopedKey2) : scopedKey2 != null);
    }

    /*
     * Unable to fully structure code
     */
    public static final /* synthetic */ Tuple3 $anonfun$writeSettings$4(List settings$1, String path$1, Tuple3 x0$2, Init.Setting x1$2) {
        block4: {
            block3: {
                var7_4 = new Tuple2((Object)x0$2, (Object)x1$2);
                if (var7_4 == null) break block3;
                var8_5 = (Tuple3)var7_4._1();
                s = (Init.Setting)var7_4._2();
                if (var8_5 == null) break block3;
                offs = BoxesRunTime.unboxToInt((Object)var8_5._1());
                olds = (List)var8_5._2();
                repl = (Seq)var8_5._3();
                var14_10 = s.pos();
                if (!(var14_10 instanceof RangePosition) || (r = (var15_11 = (RangePosition)var14_10).range()) == null) {
                    throw new MatchError((Object)var14_10);
                }
                start = r.start();
                end = r.end();
                var6_15 = new Tuple3((Object)r, (Object)BoxesRunTime.boxToInteger((int)start), (Object)BoxesRunTime.boxToInteger((int)end));
                var13_16 = var6_15;
                r = (LineRange)var13_16._1();
                start = BoxesRunTime.unboxToInt((Object)var13_16._2());
                end = BoxesRunTime.unboxToInt((Object)var13_16._3());
                var22_20 = settings$1.find((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$writeSettings$5$adapted(sbt.internal.util.Init$Setting scala.Tuple2 ), (Lscala/Tuple2;)Ljava/lang/Object;)((Init.Setting)s));
                if (!(var22_20 instanceof Some) || (ss = (Tuple2)(var23_21 = (Some)var22_20).value()) == null) ** GOTO lbl-1000
                ns = (Init.Setting)ss._1();
                newLines = (Seq)ss._2();
                if (!ns.init().dependencies().contains((Object)ns.key())) {
                    var28_26 = shifted = ns.withPos((SourcePosition)new RangePosition(path$1, new LineRange(start - offs, start - offs + newLines.size())));
                    var29_27 = ss;
                    var5_28 = new Tuple3((Object)BoxesRunTime.boxToInteger((int)(offs + end - start - newLines.size())), (Object)olds.$colon$colon((Object)var28_26), repl.$plus$colon((Object)var29_27, Seq$.MODULE$.canBuildFrom()));
                } else lbl-1000:
                // 2 sources

                {
                    var31_30 = shifted = s.withPos((SourcePosition)new RangePosition(path$1, r.shift(-offs)));
                    var5_28 = new Tuple3((Object)BoxesRunTime.boxToInteger((int)offs), (Object)olds.$colon$colon((Object)var31_30), (Object)repl);
                }
                break block4;
            }
            throw new MatchError((Object)var7_4);
        }
        var4_31 = var5_28;
        return var4_31;
    }

    public static final /* synthetic */ boolean $anonfun$needsTrailingBlank$1(String x$26) {
        return x$26.trim().isEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$printAllSettings$2(Tuple2 check$ifrefutable$2) {
        Tuple2 tuple2 = check$ifrefutable$2;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$printAllSettings$3(Tuple2 x$27) {
        Tuple2 tuple2 = x$27;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Seq settings = (Seq)tuple2._2();
        boolean bl = settings.nonEmpty();
        return bl;
    }

    public static final /* synthetic */ void $anonfun$printAllSettings$4(Tuple2 x$28) {
        Tuple2 tuple2 = x$28;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        ProjectRef ref = (ProjectRef)tuple2._1();
        Seq settings = (Seq)tuple2._2();
        Predef$.MODULE$.println((Object)new StringBuilder(3).append("In ").append(Reference$.MODULE$.display((ProjectReference)ref)).toString());
        MODULE$.printSettings(settings);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ boolean $anonfun$printSettings$3(Tuple2 check$ifrefutable$3) {
        Tuple2 tuple2;
        Tuple2 tuple22 = check$ifrefutable$3;
        boolean bl = tuple22 != null && (tuple2 = (Tuple2)tuple22._1()) != null;
        return bl;
    }

    public static final /* synthetic */ void $anonfun$printSettings$4(Tuple2 x$29) {
        int index;
        Tuple2 tuple2;
        block3: {
            Tuple2 tuple22;
            block2: {
                tuple22 = x$29;
                if (tuple22 == null) break block2;
                tuple2 = (Tuple2)tuple22._1();
                index = tuple22._2$mcI$sp();
                if (tuple2 != null) break block3;
            }
            throw new MatchError((Object)tuple22);
        }
        Seq stringRep = (Seq)tuple2._2();
        Predef$.MODULE$.println((Object)new StringBuilder(4).append("  ").append(index + 1).append(". ").append(stringRep.mkString("\n")).toString());
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private SessionSettings$() {
        MODULE$ = this;
    }

    public static final /* synthetic */ Object $anonfun$writeSettings$5$adapted(Init.Setting s$6, Tuple2 x$19) {
        return BoxesRunTime.boxToBoolean((boolean)SessionSettings$.$anonfun$writeSettings$5(s$6, x$19));
    }
}

