/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.osgi.p2;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.ivy.osgi.core.BundleCapability;
import org.apache.ivy.osgi.core.BundleInfo;
import org.apache.ivy.osgi.core.BundleRequirement;
import org.apache.ivy.osgi.core.ExportPackage;
import org.apache.ivy.osgi.p2.P2Artifact;
import org.apache.ivy.osgi.p2.P2Descriptor;
import org.apache.ivy.osgi.p2.PropertiesParser;
import org.apache.ivy.osgi.p2.XMLInputParser;
import org.apache.ivy.osgi.util.DelegetingHandler;
import org.apache.ivy.osgi.util.Version;
import org.apache.ivy.osgi.util.VersionRange;
import org.apache.ivy.util.Message;
import org.apache.ivy.util.XMLHelper;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class P2MetadataParser
implements XMLInputParser {
    private final P2Descriptor p2Descriptor;

    public P2MetadataParser(P2Descriptor p2Descriptor) {
        this.p2Descriptor = p2Descriptor;
    }

    @Override
    public void parse(InputStream inputStream) throws ParseException, IOException, SAXException {
        RepositoryHandler repositoryHandler = new RepositoryHandler(this.p2Descriptor);
        try {
            XMLHelper.parse(inputStream, null, (DefaultHandler)repositoryHandler, null);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new SAXException(parserConfigurationException);
        }
    }

    private static String namespace2Type(String string) {
        if (string.equals("java.package")) {
            return "package";
        }
        if (string.equals("osgi.bundle")) {
            return "bundle";
        }
        return null;
    }

    static class LifeCycleHandler
    extends AbstractRequirementHandler {
        private static final String LIFE_CYCLE = "lifeCycle";

        public LifeCycleHandler() {
            super(LIFE_CYCLE);
        }
    }

    static class ScopeHandler
    extends DelegetingHandler {
        private static final String SCOPE = "scope";

        public ScopeHandler() {
            super(SCOPE);
            this.addChild(new RequiresHandler(), new DelegetingHandler.ChildElementHandler(){

                @Override
                public void childHanlded(DelegetingHandler delegetingHandler) {
                }
            });
        }
    }

    static class PatchScopeHandler
    extends DelegetingHandler {
        private static final String PATCH_SCOPE = "patchScope";

        public PatchScopeHandler() {
            super(PATCH_SCOPE);
            this.addChild(new PatchScopeHandler(), new DelegetingHandler.ChildElementHandler(){

                @Override
                public void childHanlded(DelegetingHandler delegetingHandler) {
                }
            });
        }

        @Override
        protected void handleAttributes(Attributes attributes) {
        }
    }

    static class ToHandler
    extends AbstractRequirementHandler {
        private static final String TO = "to";

        public ToHandler() {
            super(TO);
        }
    }

    static class FromHandler
    extends AbstractRequirementHandler {
        private static final String FROM = "from";

        public FromHandler() {
            super(FROM);
        }
    }

    static class ChangeHandler
    extends DelegetingHandler {
        private static final String CHANGE = "change";

        public ChangeHandler() {
            super(CHANGE);
        }
    }

    static class ChangesHandler
    extends DelegetingHandler {
        private static final String CHANGES = "changes";

        public ChangesHandler() {
            super(CHANGES);
            this.addChild(new ChangeHandler(), new DelegetingHandler.ChildElementHandler(){

                @Override
                public void childHanlded(DelegetingHandler delegetingHandler) {
                }
            });
        }

        @Override
        protected void handleAttributes(Attributes attributes) {
        }
    }

    static class ArtifactHandler
    extends DelegetingHandler {
        private static final String ARTIFACT = "artifact";
        private static final String ID = "id";
        private static final String VERSION = "version";
        private static final String CLASSIFIER = "classifier";
        P2Artifact artifact;

        public ArtifactHandler() {
            super(ARTIFACT);
        }

        @Override
        protected void handleAttributes(Attributes attributes) throws SAXException {
            String string = attributes.getValue(ID);
            String string2 = attributes.getValue(VERSION);
            String string3 = attributes.getValue(CLASSIFIER);
            try {
                this.artifact = new P2Artifact(string, new Version(string2), string3);
            }
            catch (ParseException parseException) {
                throw new SAXException("Incorrect version on artifact '" + string + "': " + string2 + " (" + parseException.getMessage() + ")");
            }
        }
    }

    static class ArtifactsHandler
    extends DelegetingHandler {
        private static final String ARTIFACTS = "artifacts";
        private static final String SIZE = "size";
        List artifacts;

        public ArtifactsHandler() {
            super(ARTIFACTS);
            this.addChild(new ArtifactHandler(), new DelegetingHandler.ChildElementHandler(){

                @Override
                public void childHanlded(DelegetingHandler delegetingHandler) {
                    ArtifactsHandler.this.artifacts.add(((ArtifactHandler)delegetingHandler).artifact);
                }
            });
        }

        @Override
        protected void handleAttributes(Attributes attributes) {
            int n = Integer.parseInt(attributes.getValue(SIZE));
            this.artifacts = new ArrayList(n);
        }
    }

    static class MetaRequirementsHandler
    extends AbstractRequirementHandler {
        private static final String META_REQUIREMENTS = "metaRequirements";

        public MetaRequirementsHandler() {
            super(META_REQUIREMENTS);
        }
    }

    static class HostRequirementsHandler
    extends AbstractRequirementHandler {
        private static final String HOST_REQUIREMENTS = "hostRequirements";

        public HostRequirementsHandler() {
            super(HOST_REQUIREMENTS);
        }
    }

    static class RequiredHandler
    extends DelegetingHandler {
        private static final String REQUIRED = "required";
        private static final String NAMESPACE = "namespace";
        private static final String NAME = "name";
        private static final String RANGE = "range";
        String namespace;
        String name;
        VersionRange range;
        String filter;

        public RequiredHandler() {
            super(REQUIRED);
            this.addChild(new FilterHandler(), new DelegetingHandler.ChildElementHandler(){

                @Override
                public void childHanlded(DelegetingHandler delegetingHandler) {
                    RequiredHandler.this.filter = delegetingHandler.getBufferedChars().trim();
                }
            });
        }

        @Override
        protected void handleAttributes(Attributes attributes) {
            this.namespace = attributes.getValue(NAMESPACE);
            this.name = attributes.getValue(NAME);
            try {
                this.range = new VersionRange(attributes.getValue(RANGE));
            }
            catch (ParseException parseException) {
                throw new RuntimeException(parseException);
            }
        }
    }

    static class RequiresHandler
    extends AbstractRequirementHandler {
        private static final String REQUIRES = "requires";

        public RequiresHandler() {
            super(REQUIRES);
        }
    }

    static abstract class AbstractRequirementHandler
    extends DelegetingHandler {
        private static final String SIZE = "size";
        List requirements;

        public AbstractRequirementHandler(String string) {
            super(string);
            this.addChild(new RequiredHandler(), new DelegetingHandler.ChildElementHandler(){

                @Override
                public void childHanlded(DelegetingHandler delegetingHandler) {
                    String string = ((RequiredHandler)delegetingHandler).name;
                    VersionRange versionRange = ((RequiredHandler)delegetingHandler).range;
                    String string2 = P2MetadataParser.namespace2Type(((RequiredHandler)delegetingHandler).namespace);
                    if (string2 == null) {
                        Message.debug("Unsupported required capability " + ((RequiredHandler)delegetingHandler).namespace + " " + string + " " + versionRange);
                    } else {
                        AbstractRequirementHandler.this.requirements.add(new BundleRequirement(string2, string, versionRange, null));
                    }
                }
            });
        }

        @Override
        protected void handleAttributes(Attributes attributes) {
            int n = Integer.parseInt(attributes.getValue(SIZE));
            this.requirements = new ArrayList(n);
        }
    }

    static class ProvidedHandler
    extends DelegetingHandler {
        private static final String PROVIDED = "provided";
        private static final String NAMESPACE = "namespace";
        private static final String NAME = "name";
        private static final String VERSION = "version";
        String namespace;
        String name;
        Version version;

        public ProvidedHandler() {
            super(PROVIDED);
        }

        @Override
        protected void handleAttributes(Attributes attributes) throws SAXException {
            this.namespace = attributes.getValue(NAMESPACE);
            this.name = attributes.getValue(NAME);
            try {
                this.version = new Version(attributes.getValue(VERSION));
            }
            catch (ParseException parseException) {
                throw new SAXException("Incorrect version on provided capability: " + this.version + " (" + parseException.getMessage() + ")");
            }
        }
    }

    static class ProvidesHandler
    extends DelegetingHandler {
        private static final String PROVIDES = "provides";
        private static final String SIZE = "size";
        List capabilities;

        public ProvidesHandler() {
            super(PROVIDES);
            this.addChild(new ProvidedHandler(), new DelegetingHandler.ChildElementHandler(){

                @Override
                public void childHanlded(DelegetingHandler delegetingHandler) {
                    String string = ((ProvidedHandler)delegetingHandler).name;
                    Version version = ((ProvidedHandler)delegetingHandler).version;
                    String string2 = P2MetadataParser.namespace2Type(((ProvidedHandler)delegetingHandler).namespace);
                    if (string2 == null) {
                        Message.debug("Unsupported provided capability " + ((ProvidedHandler)delegetingHandler).namespace + " " + string + " " + version);
                        return;
                    }
                    BundleCapability bundleCapability = string2 == "package" ? new ExportPackage(string, version) : new BundleCapability(string2, string, version);
                    ProvidesHandler.this.capabilities.add(bundleCapability);
                }
            });
        }

        @Override
        protected void handleAttributes(Attributes attributes) {
            int n = Integer.parseInt(attributes.getValue(SIZE));
            this.capabilities = new ArrayList(n);
        }
    }

    static class FilterHandler
    extends DelegetingHandler {
        private static final String FILTER = "filter";

        public FilterHandler() {
            super(FILTER);
            this.setBufferingChar(true);
        }
    }

    static class UnitHandler
    extends DelegetingHandler {
        private static final String UNIT = "unit";
        private static final String ID = "id";
        private static final String VERSION = "version";
        BundleInfo bundleInfo;

        public UnitHandler() {
            super(UNIT);
            this.addChild(new PropertiesParser.PropertiesHandler(), new DelegetingHandler.ChildElementHandler(){

                @Override
                public void childHanlded(DelegetingHandler delegetingHandler) {
                    Map map = ((PropertiesParser.PropertiesHandler)delegetingHandler).properties;
                    String string = (String)map.get("org.eclipse.equinox.p2.type.category");
                    if (string != null && Boolean.valueOf(string).booleanValue()) {
                        delegetingHandler.getParent().skip();
                    }
                }
            });
            this.addChild(new ProvidesHandler(), new DelegetingHandler.ChildElementHandler(){

                @Override
                public void childHanlded(DelegetingHandler delegetingHandler) {
                    Iterator iterator = ((ProvidesHandler)delegetingHandler).capabilities.iterator();
                    while (iterator.hasNext()) {
                        UnitHandler.this.bundleInfo.addCapability((BundleCapability)iterator.next());
                    }
                }
            });
            this.addChild(new FilterHandler(), new DelegetingHandler.ChildElementHandler(){

                @Override
                public void childHanlded(DelegetingHandler delegetingHandler) {
                }
            });
            this.addChild(new RequiresHandler(), new DelegetingHandler.ChildElementHandler(){

                @Override
                public void childHanlded(DelegetingHandler delegetingHandler) {
                    Iterator iterator = ((RequiresHandler)delegetingHandler).requirements.iterator();
                    while (iterator.hasNext()) {
                        UnitHandler.this.bundleInfo.addRequirement((BundleRequirement)iterator.next());
                    }
                }
            });
            this.addChild(new HostRequirementsHandler(), new DelegetingHandler.ChildElementHandler(){

                @Override
                public void childHanlded(DelegetingHandler delegetingHandler) {
                }
            });
            this.addChild(new MetaRequirementsHandler(), new DelegetingHandler.ChildElementHandler(){

                @Override
                public void childHanlded(DelegetingHandler delegetingHandler) {
                }
            });
            this.addChild(new ArtifactsHandler(), new DelegetingHandler.ChildElementHandler(){

                @Override
                public void childHanlded(DelegetingHandler delegetingHandler) {
                }
            });
            this.addChild(new ChangesHandler(), new DelegetingHandler.ChildElementHandler(){

                @Override
                public void childHanlded(DelegetingHandler delegetingHandler) {
                }
            });
        }

        @Override
        protected void handleAttributes(Attributes attributes) throws SAXException {
            String string = attributes.getValue(ID);
            String string2 = attributes.getValue(VERSION);
            try {
                this.bundleInfo = new BundleInfo(string, new Version(string2));
            }
            catch (ParseException parseException) {
                throw new SAXException("Incorrect version on bundle '" + string + "': " + string2 + " (" + parseException.getMessage() + ")");
            }
        }
    }

    static class UnitsHandler
    extends DelegetingHandler {
        private static final String UNITS = "units";
        private static final String SIZE = "size";
        List bundles;

        public UnitsHandler() {
            super(UNITS);
            this.addChild(new UnitHandler(), new DelegetingHandler.ChildElementHandler(){

                @Override
                public void childHanlded(DelegetingHandler delegetingHandler) {
                    BundleInfo bundleInfo = ((UnitHandler)delegetingHandler).bundleInfo;
                    if (!bundleInfo.getCapabilities().isEmpty()) {
                        UnitsHandler.this.bundles.add(((UnitHandler)delegetingHandler).bundleInfo);
                    }
                }
            });
        }

        @Override
        protected void handleAttributes(Attributes attributes) {
            int n = Integer.parseInt(attributes.getValue(SIZE));
            this.bundles = new ArrayList(n);
        }
    }

    static class RepositoryReferenceHandler
    extends DelegetingHandler {
        private static final String REPOSITORY = "repository";
        private static final String TYPE = "type";
        private static final String OPTIONS = "options";
        private static final String NAME = "name";
        private static final String URI = "uri";
        private static final String URL = "url";
        int type;
        int options;
        String name;
        URI uri;

        public RepositoryReferenceHandler() {
            super(REPOSITORY);
        }

        @Override
        protected void handleAttributes(Attributes attributes) throws SAXException {
            this.type = Integer.parseInt(attributes.getValue(TYPE));
            this.options = Integer.parseInt(attributes.getValue(OPTIONS));
            this.name = attributes.getValue(NAME);
            try {
                String string = attributes.getValue(URI);
                String string2 = attributes.getValue(URL);
                if (this.uri != null) {
                    this.uri = new URI(string);
                } else if (string2 != null) {
                    this.uri = new URI(string2);
                }
            }
            catch (URISyntaxException uRISyntaxException) {
                uRISyntaxException.printStackTrace();
            }
        }
    }

    static class ReferencesHandler
    extends DelegetingHandler {
        private static final String REFERENCES = "references";
        private static final String SIZE = "size";
        List repositoryUris;

        public ReferencesHandler() {
            super(REFERENCES);
            this.addChild(new RepositoryReferenceHandler(), new DelegetingHandler.ChildElementHandler(){

                @Override
                public void childHanlded(DelegetingHandler delegetingHandler) {
                    ReferencesHandler.this.repositoryUris.add(((RepositoryReferenceHandler)delegetingHandler).uri);
                }
            });
        }

        @Override
        protected void handleAttributes(Attributes attributes) throws SAXException {
            int n = Integer.parseInt(attributes.getValue(SIZE));
            this.repositoryUris = new ArrayList(n);
        }
    }

    static class RepositoryHandler
    extends DelegetingHandler {
        private static final String REPOSITORY = "repository";

        public RepositoryHandler(final P2Descriptor p2Descriptor) {
            super(REPOSITORY);
            this.addChild(new PropertiesParser.PropertiesHandler(), new DelegetingHandler.ChildElementHandler(){

                @Override
                public void childHanlded(DelegetingHandler delegetingHandler) {
                    Map map = ((PropertiesParser.PropertiesHandler)delegetingHandler).properties;
                    String string = (String)map.get("p2.timestamp");
                    if (string != null) {
                        p2Descriptor.setTimestamp(Long.parseLong(string));
                    }
                }
            });
            this.addChild(new UnitsHandler(), new DelegetingHandler.ChildElementHandler(){

                @Override
                public void childHanlded(DelegetingHandler delegetingHandler) {
                    Iterator iterator = ((UnitsHandler)delegetingHandler).bundles.iterator();
                    while (iterator.hasNext()) {
                        p2Descriptor.addBundle((BundleInfo)iterator.next());
                    }
                }
            });
            this.addChild(new ReferencesHandler(), new DelegetingHandler.ChildElementHandler(){

                @Override
                public void childHanlded(DelegetingHandler delegetingHandler) {
                }
            });
        }
    }
}

