/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.integrate;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.api.Url;
import org.jetbrains.idea.svn.dialogs.WCInfo;

public class MergeContext {
    @NotNull
    private final Project myProject;
    @NotNull
    private final String myBranchName;
    @NotNull
    private final VirtualFile myRoot;
    @NotNull
    private final WCInfo myWcInfo;
    @NotNull
    private final Url mySourceUrl;
    @NotNull
    private final SvnVcs myVcs;
    @NotNull
    private final String myTitle;
    @NotNull
    private final String myRepositoryRelativeSourcePath;
    @NotNull
    private final String myRepositoryRelativeWorkingCopyPath;

    public MergeContext(@NotNull SvnVcs vcs, @NotNull Url sourceUrl, @NotNull WCInfo wcInfo, @NotNull String branchName, @NotNull VirtualFile root) {
        if (vcs == null) {
            MergeContext.$$$reportNull$$$0(0);
        }
        if (sourceUrl == null) {
            MergeContext.$$$reportNull$$$0(1);
        }
        if (wcInfo == null) {
            MergeContext.$$$reportNull$$$0(2);
        }
        if (branchName == null) {
            MergeContext.$$$reportNull$$$0(3);
        }
        if (root == null) {
            MergeContext.$$$reportNull$$$0(4);
        }
        this.myVcs = vcs;
        this.myProject = vcs.getProject();
        this.myBranchName = branchName;
        this.myRoot = root;
        this.mySourceUrl = sourceUrl;
        this.myWcInfo = wcInfo;
        this.myTitle = "Merge from " + this.myBranchName;
        this.myRepositoryRelativeSourcePath = SvnUtil.ensureStartSlash(SvnUtil.getRelativeUrl(this.myWcInfo.getRepoUrl(), this.mySourceUrl));
        this.myRepositoryRelativeWorkingCopyPath = SvnUtil.ensureStartSlash(SvnUtil.getRelativeUrl(this.myWcInfo.getRepoUrl(), this.myWcInfo.getUrl()));
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            MergeContext.$$$reportNull$$$0(5);
        }
        return project;
    }

    @NotNull
    public String getBranchName() {
        String string = this.myBranchName;
        if (string == null) {
            MergeContext.$$$reportNull$$$0(6);
        }
        return string;
    }

    @NotNull
    public VirtualFile getRoot() {
        VirtualFile virtualFile = this.myRoot;
        if (virtualFile == null) {
            MergeContext.$$$reportNull$$$0(7);
        }
        return virtualFile;
    }

    @NotNull
    public WCInfo getWcInfo() {
        WCInfo wCInfo = this.myWcInfo;
        if (wCInfo == null) {
            MergeContext.$$$reportNull$$$0(8);
        }
        return wCInfo;
    }

    @NotNull
    public Url getSourceUrl() {
        Url url = this.mySourceUrl;
        if (url == null) {
            MergeContext.$$$reportNull$$$0(9);
        }
        return url;
    }

    @NotNull
    public String getRepositoryRelativeSourcePath() {
        String string = this.myRepositoryRelativeSourcePath;
        if (string == null) {
            MergeContext.$$$reportNull$$$0(10);
        }
        return string;
    }

    @NotNull
    public String getRepositoryRelativeWorkingCopyPath() {
        String string = this.myRepositoryRelativeWorkingCopyPath;
        if (string == null) {
            MergeContext.$$$reportNull$$$0(11);
        }
        return string;
    }

    @NotNull
    public SvnVcs getVcs() {
        SvnVcs svnVcs = this.myVcs;
        if (svnVcs == null) {
            MergeContext.$$$reportNull$$$0(12);
        }
        return svnVcs;
    }

    @NotNull
    public String getTitle() {
        String string = this.myTitle;
        if (string == null) {
            MergeContext.$$$reportNull$$$0(13);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcs";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceUrl";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wcInfo";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "branchName";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/svn/integrate/MergeContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/svn/integrate/MergeContext";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getBranchName";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getRoot";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getWcInfo";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getSourceUrl";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getRepositoryRelativeSourcePath";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getRepositoryRelativeWorkingCopyPath";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getVcs";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getTitle";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

