/*
 * Decompiled with CFR 0.152.
 */
package com.jediterm.terminal;

import com.jediterm.terminal.HyperlinkStyle;
import com.jediterm.terminal.TerminalColor;
import java.lang.ref.WeakReference;
import java.util.EnumSet;
import java.util.Objects;
import java.util.WeakHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TextStyle {
    private static final EnumSet<Option> NO_OPTIONS = EnumSet.noneOf(Option.class);
    public static final TextStyle EMPTY = new TextStyle();
    private static final WeakHashMap<TextStyle, WeakReference<TextStyle>> styles = new WeakHashMap();
    private final TerminalColor myForeground;
    private final TerminalColor myBackground;
    private final EnumSet<Option> myOptions;

    public TextStyle() {
        this(null, null, NO_OPTIONS);
    }

    public TextStyle(@Nullable TerminalColor foreground, @Nullable TerminalColor background) {
        this(foreground, background, NO_OPTIONS);
    }

    public TextStyle(@Nullable TerminalColor foreground, @Nullable TerminalColor background, @NotNull EnumSet<Option> options) {
        this.myForeground = foreground;
        this.myBackground = background;
        this.myOptions = options.clone();
    }

    @NotNull
    public static TextStyle getCanonicalStyle(TextStyle currentStyle) {
        TextStyle canonStyle;
        if (currentStyle instanceof HyperlinkStyle) {
            return currentStyle;
        }
        WeakReference<TextStyle> canonRef = styles.get(currentStyle);
        if (canonRef != null && (canonStyle = (TextStyle)canonRef.get()) != null) {
            return canonStyle;
        }
        styles.put(currentStyle, new WeakReference<TextStyle>(currentStyle));
        return currentStyle;
    }

    @Nullable
    public TerminalColor getForeground() {
        return this.myForeground;
    }

    @Nullable
    public TerminalColor getBackground() {
        return this.myBackground;
    }

    public TextStyle createEmptyWithColors() {
        return new TextStyle(this.myForeground, this.myBackground);
    }

    public int getId() {
        return this.hashCode();
    }

    public boolean hasOption(Option option) {
        return this.myOptions.contains((Object)option);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TextStyle textStyle = (TextStyle)o;
        return Objects.equals(this.myForeground, textStyle.myForeground) && Objects.equals(this.myBackground, textStyle.myBackground) && this.myOptions.equals(textStyle.myOptions);
    }

    public int hashCode() {
        return Objects.hash(this.myForeground, this.myBackground, this.myOptions);
    }

    public TerminalColor getBackgroundForRun() {
        return this.myOptions.contains((Object)Option.INVERSE) ? this.myForeground : this.myBackground;
    }

    public TerminalColor getForegroundForRun() {
        return this.myOptions.contains((Object)Option.INVERSE) ? this.myBackground : this.myForeground;
    }

    @NotNull
    public Builder toBuilder() {
        return new Builder(this);
    }

    public static class Builder {
        private TerminalColor myForeground;
        private TerminalColor myBackground;
        private EnumSet<Option> myOptions;

        public Builder(@NotNull TextStyle textStyle) {
            this.myForeground = textStyle.myForeground;
            this.myBackground = textStyle.myBackground;
            this.myOptions = textStyle.myOptions.clone();
        }

        public Builder() {
            this.myForeground = null;
            this.myBackground = null;
            this.myOptions = EnumSet.noneOf(Option.class);
        }

        @NotNull
        public Builder setForeground(@Nullable TerminalColor foreground) {
            this.myForeground = foreground;
            return this;
        }

        @NotNull
        public Builder setBackground(@Nullable TerminalColor background) {
            this.myBackground = background;
            return this;
        }

        @NotNull
        public Builder setOption(@NotNull Option option, boolean val) {
            option.set(this.myOptions, val);
            return this;
        }

        @NotNull
        public TextStyle build() {
            return new TextStyle(this.myForeground, this.myBackground, this.myOptions);
        }
    }

    public static enum Option {
        BOLD,
        ITALIC,
        BLINK,
        DIM,
        INVERSE,
        UNDERLINED,
        HIDDEN;


        private void set(@NotNull EnumSet<Option> options, boolean val) {
            if (val) {
                options.add(this);
            } else {
                options.remove((Object)this);
            }
        }
    }
}

