/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.configurations;

import com.intellij.execution.DefaultExecutionResult;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.ExecutionTarget;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.TextConsoleBuilder;
import com.intellij.execution.filters.TextConsoleBuilderFactory;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopes;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CommandLineState
implements RunProfileState {
    private TextConsoleBuilder myConsoleBuilder;
    private final ExecutionEnvironment myEnvironment;

    protected CommandLineState(ExecutionEnvironment environment) {
        this.myEnvironment = environment;
        if (this.myEnvironment != null) {
            Project project = this.myEnvironment.getProject();
            GlobalSearchScope searchScope = GlobalSearchScopes.executionScope(project, this.myEnvironment.getRunProfile());
            this.myConsoleBuilder = TextConsoleBuilderFactory.getInstance().createBuilder(project, searchScope);
        }
    }

    public ExecutionEnvironment getEnvironment() {
        return this.myEnvironment;
    }

    @Nullable
    public RunnerSettings getRunnerSettings() {
        return this.myEnvironment.getRunnerSettings();
    }

    @NotNull
    public ExecutionTarget getExecutionTarget() {
        ExecutionTarget executionTarget = this.myEnvironment.getExecutionTarget();
        if (executionTarget == null) {
            CommandLineState.$$$reportNull$$$0(0);
        }
        return executionTarget;
    }

    public void addConsoleFilters(Filter ... filters) {
        this.myConsoleBuilder.filters(filters);
    }

    @Override
    @NotNull
    public ExecutionResult execute(@NotNull Executor executor, @NotNull ProgramRunner runner) throws ExecutionException {
        if (executor == null) {
            CommandLineState.$$$reportNull$$$0(1);
        }
        if (runner == null) {
            CommandLineState.$$$reportNull$$$0(2);
        }
        ProcessHandler processHandler = this.startProcess();
        ConsoleView console = this.createConsole(executor);
        if (console != null) {
            console.attachToProcess(processHandler);
        }
        DefaultExecutionResult defaultExecutionResult = new DefaultExecutionResult(console, processHandler, this.createActions(console, processHandler, executor));
        if (defaultExecutionResult == null) {
            CommandLineState.$$$reportNull$$$0(3);
        }
        return defaultExecutionResult;
    }

    @Nullable
    protected ConsoleView createConsole(@NotNull Executor executor) throws ExecutionException {
        TextConsoleBuilder builder;
        if (executor == null) {
            CommandLineState.$$$reportNull$$$0(4);
        }
        return (builder = this.getConsoleBuilder()) != null ? builder.getConsole() : null;
    }

    @NotNull
    protected abstract ProcessHandler startProcess() throws ExecutionException;

    @NotNull
    protected AnAction[] createActions(ConsoleView console, ProcessHandler processHandler) {
        AnAction[] anActionArray = this.createActions(console, processHandler, null);
        if (anActionArray == null) {
            CommandLineState.$$$reportNull$$$0(5);
        }
        return anActionArray;
    }

    @NotNull
    protected AnAction[] createActions(ConsoleView console, ProcessHandler processHandler, Executor executor) {
        if (AnAction.EMPTY_ARRAY == null) {
            CommandLineState.$$$reportNull$$$0(6);
        }
        return AnAction.EMPTY_ARRAY;
    }

    public TextConsoleBuilder getConsoleBuilder() {
        return this.myConsoleBuilder;
    }

    public void setConsoleBuilder(TextConsoleBuilder consoleBuilder) {
        this.myConsoleBuilder = consoleBuilder;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/configurations/CommandLineState";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runner";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getExecutionTarget";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/configurations/CommandLineState";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "execute";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createActions";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createConsole";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

