/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.util.io.ByteBufferUtil;
import com.intellij.util.io.ByteBufferWrapper;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;

abstract class DirectBufferWrapper
extends ByteBufferWrapper {
    private volatile ByteBuffer myBuffer;

    DirectBufferWrapper(File file, long offset, long length) {
        super(file, offset, length);
    }

    @Override
    public ByteBuffer getCachedBuffer() {
        return this.myBuffer;
    }

    @Override
    public ByteBuffer getBuffer() throws IOException {
        ByteBuffer buffer = this.myBuffer;
        if (buffer == null) {
            this.myBuffer = buffer = this.create();
        }
        return buffer;
    }

    protected abstract ByteBuffer create() throws IOException;

    @Override
    public void unmap() {
        if (this.isDirty()) {
            this.flush();
        }
        if (this.myBuffer != null) {
            ByteBufferUtil.cleanBuffer(this.myBuffer);
            this.myBuffer = null;
        }
    }
}

