/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.credentialStore.kdbx;

import com.intellij.credentialStore.CredentialStoreKt;
import com.intellij.credentialStore.kdbx.KdbxEntry;
import com.intellij.credentialStore.kdbx.KdbxGroupKt;
import com.intellij.credentialStore.kdbx.KeePassDatabase;
import com.intellij.credentialStore.kdbx.KeePassDatabaseKt;
import com.intellij.util.JdomKt;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashMap;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import org.jdom.Content;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0000\u00a2\u0006\u0002\u0010\u0007J\u000e\u0010 \u001a\u00020\f2\u0006\u0010!\u001a\u00020\fJ\u0018\u0010\"\u001a\u00020\f2\u0006\u0010#\u001a\u00020\u00132\b\u0010$\u001a\u0004\u0018\u00010\u0013J\u0010\u0010%\u001a\u00020\u00002\u0006\u0010\u001b\u001a\u00020\u0013H\u0002J+\u0010&\u001a\u0004\u0018\u00010\f2!\u0010'\u001a\u001d\u0012\u0013\u0012\u00110\f\u00a2\u0006\f\b)\u0012\b\b\u001b\u0012\u0004\b\b(!\u0012\u0004\u0012\u00020*0(J\u001a\u0010&\u001a\u0004\u0018\u00010\f2\u0006\u0010#\u001a\u00020\u00132\b\u0010$\u001a\u0004\u0018\u00010\u0013J\u0010\u0010+\u001a\u0004\u0018\u00010\u00002\u0006\u0010\u001b\u001a\u00020\u0013J\u000e\u0010,\u001a\u00020\u00002\u0006\u0010\u001b\u001a\u00020\u0013J\u0010\u0010-\u001a\u00020\f2\u0006\u0010!\u001a\u00020\fH\u0002J\u001a\u0010-\u001a\u0004\u0018\u00010\f2\u0006\u0010#\u001a\u00020\u00132\b\u0010$\u001a\u0004\u0018\u00010\u0013J\u0010\u0010.\u001a\u00020/2\u0006\u00100\u001a\u00020\u0000H\u0002J\u000e\u0010.\u001a\u00020/2\u0006\u0010\u001b\u001a\u00020\u0013R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR!\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00000\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0014\u001a\u00020\u00158B@BX\u0082\u000e\u00a2\u0006\f\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR$\u0010\u001b\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00138F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0000X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lcom/intellij/credentialStore/kdbx/KdbxGroup;", "", "element", "Lorg/jdom/Element;", "database", "Lcom/intellij/credentialStore/kdbx/KeePassDatabase;", "parent", "(Lorg/jdom/Element;Lcom/intellij/credentialStore/kdbx/KeePassDatabase;Lcom/intellij/credentialStore/kdbx/KdbxGroup;)V", "getElement$intellij_platform_credentialStore", "()Lorg/jdom/Element;", "entries", "", "Lcom/intellij/credentialStore/kdbx/KdbxEntry;", "getEntries", "()Ljava/util/List;", "entries$delegate", "Lkotlin/Lazy;", "groups", "", "", "value", "", "locationChanged", "getLocationChanged", "()J", "setLocationChanged", "(J)V", "name", "getName", "()Ljava/lang/String;", "setName", "(Ljava/lang/String;)V", "addEntry", "entry", "createEntry", "title", "userName", "createGroup", "getEntry", "matcher", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "", "getGroup", "getOrCreateGroup", "removeEntry", "removeGroup", "", "group", "intellij.platform.credentialStore"})
public final class KdbxGroup {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    private final Map<String, KdbxGroup> groups;
    private final Lazy entries$delegate;
    @NotNull
    private final Element element;
    private final KeePassDatabase database;
    private volatile KdbxGroup parent;

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(KdbxGroup.class), "entries", "getEntries()Ljava/util/List;"))};
    }

    @NotNull
    public final synchronized String getName() {
        String string = this.element.getChildText("Name");
        if (string == null) {
            string = "Unnamed";
        }
        return string;
    }

    public final synchronized void setName(@NotNull String value) {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        Element nameElement = JdomKt.getOrCreate((Element)this.element, (String)"Name");
        if (Intrinsics.areEqual((Object)nameElement.getText(), (Object)value)) {
            return;
        }
        nameElement.setText(value);
        this.database.setDirty$intellij_platform_credentialStore(true);
    }

    private final List<KdbxEntry> getEntries() {
        Lazy lazy = this.entries$delegate;
        KdbxGroup kdbxGroup = this;
        KProperty kProperty = $$delegatedProperties[0];
        boolean bl = false;
        return (List)lazy.getValue();
    }

    private final long getLocationChanged() {
        long l;
        Object object = this.element.getChild("Times");
        if (object != null && (object = object.getChild("LocationChanged")) != null && (object = object.getText()) != null) {
            Object object2 = object;
            boolean bl = false;
            boolean bl2 = false;
            Object p1 = object2;
            boolean bl3 = false;
            l = KdbxGroupKt.access$parseTime((String)p1);
        } else {
            l = 0L;
        }
        return l;
    }

    private final void setLocationChanged(long value) {
        JdomKt.getOrCreate((Element)JdomKt.getOrCreate((Element)this.element, (String)"Times"), (String)"LocationChanged").setText(Instant.ofEpochMilli(value).atZone(ZoneOffset.UTC).format(KeePassDatabaseKt.getDateFormatter()));
    }

    @Nullable
    public final synchronized KdbxGroup getGroup(@NotNull String name) {
        Content groupElement;
        Object v1;
        KdbxGroup result;
        block4: {
            Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
            result = this.groups.get(name);
            if (result != null) {
                return result;
            }
            List list = this.element.getContent();
            Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"element.content");
            Iterable $this$firstOrNull$iv = list;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Content it = (Content)element$iv;
                boolean bl = false;
                if (!(it instanceof Element && Intrinsics.areEqual((Object)((Element)it).getChildText("Name"), (Object)name))) continue;
                v1 = element$iv;
                break block4;
            }
            v1 = null;
        }
        Content content = v1;
        if (content == null) {
            return null;
        }
        Content content2 = groupElement = content;
        if (content2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jdom.Element");
        }
        result = new KdbxGroup((Element)content2, this.database, this);
        this.groups.put(name, result);
        return result;
    }

    private final synchronized void removeGroup(KdbxGroup group) {
        KdbxGroup removedGroup = this.groups.remove(group.getName());
        CredentialStoreKt.getLOG().assertTrue(group == removedGroup);
        this.element.getContent().remove(group.element);
        group.parent = null;
        this.database.setDirty$intellij_platform_credentialStore(true);
    }

    public final synchronized void removeGroup(@NotNull String name) {
        block0: {
            Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
            KdbxGroup kdbxGroup = this.getGroup(name);
            if (kdbxGroup == null) break block0;
            KdbxGroup kdbxGroup2 = kdbxGroup;
            boolean bl = false;
            boolean bl2 = false;
            KdbxGroup it = kdbxGroup2;
            boolean bl3 = false;
            this.removeGroup(it);
        }
    }

    @NotNull
    public final synchronized KdbxGroup getOrCreateGroup(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        KdbxGroup kdbxGroup = this.getGroup(name);
        if (kdbxGroup == null) {
            kdbxGroup = this.createGroup(name);
        }
        return kdbxGroup;
    }

    private final KdbxGroup createGroup(String name) {
        KdbxGroup result = KdbxGroupKt.createGroup(this.database, this);
        result.setName(name);
        if (Intrinsics.areEqual((Object)result, (Object)this.database.getRootGroup$intellij_platform_credentialStore())) {
            throw (Throwable)new IllegalStateException("Cannot set root group as child of another group");
        }
        this.groups.put(result.getName(), result);
        result.parent = this;
        result.setLocationChanged(LocalDateTime.now(ZoneOffset.UTC).toEpochSecond(ZoneOffset.UTC));
        this.element.addContent(result.element);
        this.database.setDirty$intellij_platform_credentialStore(true);
        return result;
    }

    @Nullable
    public final synchronized KdbxEntry getEntry(@NotNull Function1<? super KdbxEntry, Boolean> matcher) {
        Object v0;
        block1: {
            Intrinsics.checkParameterIsNotNull(matcher, (String)"matcher");
            Iterable $this$firstOrNull$iv = this.getEntries();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                if (!((Boolean)matcher.invoke(element$iv)).booleanValue()) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    @NotNull
    public final synchronized KdbxEntry addEntry(@NotNull KdbxEntry entry) {
        Intrinsics.checkParameterIsNotNull((Object)entry, (String)"entry");
        KdbxGroup kdbxGroup = entry.getGroup$intellij_platform_credentialStore();
        if (kdbxGroup != null) {
            kdbxGroup.removeEntry(entry);
        }
        this.getEntries().add(entry);
        entry.setGroup$intellij_platform_credentialStore(this);
        this.database.setDirty$intellij_platform_credentialStore(true);
        this.element.addContent(entry.getEntryElement$intellij_platform_credentialStore());
        return entry;
    }

    private final KdbxEntry removeEntry(KdbxEntry entry) {
        if (this.getEntries().remove(entry)) {
            entry.setGroup$intellij_platform_credentialStore(null);
            this.element.getContent().remove(entry.getEntryElement$intellij_platform_credentialStore());
            this.database.setDirty$intellij_platform_credentialStore(true);
        }
        return entry;
    }

    @Nullable
    public final synchronized KdbxEntry getEntry(@NotNull String title, @Nullable String userName) {
        Intrinsics.checkParameterIsNotNull((Object)title, (String)"title");
        return this.getEntry((Function1<? super KdbxEntry, Boolean>)((Function1)new Function1<KdbxEntry, Boolean>(title, userName){
            final /* synthetic */ String $title;
            final /* synthetic */ String $userName;

            public final boolean invoke(@NotNull KdbxEntry it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return Intrinsics.areEqual((Object)it.getTitle(), (Object)this.$title) && (Intrinsics.areEqual((Object)it.getUserName(), (Object)this.$userName) || this.$userName == null);
            }
            {
                this.$title = string;
                this.$userName = string2;
                super(1);
            }
        }));
    }

    @NotNull
    public final synchronized KdbxEntry createEntry(@NotNull String title, @Nullable String userName) {
        Intrinsics.checkParameterIsNotNull((Object)title, (String)"title");
        KdbxEntry entry = this.database.createEntry$intellij_platform_credentialStore(title);
        entry.setUserName(userName);
        this.addEntry(entry);
        return entry;
    }

    @Nullable
    public final synchronized KdbxEntry removeEntry(@NotNull String title, @Nullable String userName) {
        KdbxEntry kdbxEntry;
        Intrinsics.checkParameterIsNotNull((Object)title, (String)"title");
        KdbxEntry kdbxEntry2 = this.getEntry(title, userName);
        if (kdbxEntry2 != null) {
            KdbxEntry kdbxEntry3 = kdbxEntry2;
            boolean bl = false;
            boolean bl2 = false;
            KdbxEntry it = kdbxEntry3;
            boolean bl3 = false;
            kdbxEntry = this.removeEntry(it);
        } else {
            kdbxEntry = null;
        }
        return kdbxEntry;
    }

    @NotNull
    public final Element getElement$intellij_platform_credentialStore() {
        return this.element;
    }

    public KdbxGroup(@NotNull Element element, @NotNull KeePassDatabase database, @Nullable KdbxGroup parent) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        Intrinsics.checkParameterIsNotNull((Object)database, (String)"database");
        this.element = element;
        this.database = database;
        this.parent = parent;
        this.groups = (Map)new THashMap();
        this.entries$delegate = LazyKt.lazy((Function0)((Function0)new Function0<List<KdbxEntry>>(this){
            final /* synthetic */ KdbxGroup this$0;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final List<KdbxEntry> invoke() {
                void $this$mapTo$iv$iv;
                List list = this.this$0.getElement$intellij_platform_credentialStore().getChildren("Entry");
                Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"element.getChildren(KdbxDbElementNames.entry)");
                Iterable $this$map$iv = list;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    Element element = (Element)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    void v1 = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)v1, (String)"it");
                    KdbxEntry kdbxEntry = new KdbxEntry((Element)v1, KdbxGroup.access$getDatabase$p(this.this$0), this.this$0);
                    collection.add(kdbxEntry);
                }
                return ContainerUtil.createLockFreeCopyOnWriteList((Collection)((List)destination$iv$iv));
            }
            {
                this.this$0 = kdbxGroup;
                super(0);
            }
        }));
    }

    public static final /* synthetic */ KeePassDatabase access$getDatabase$p(KdbxGroup $this) {
        return $this.database;
    }
}

