/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework.propertyBased;

import com.intellij.lang.Language;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.impl.PushedFilePropertiesUpdater;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.impl.source.PostprocessReformattingAspect;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.testFramework.fixtures.CodeInsightTestFixture;
import com.intellij.util.FileContentUtilCore;
import com.intellij.util.ref.GCUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.Assert;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0003\u0015\u0016\u0017B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\t0\u0004J'\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0012\u0010\u0012\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u0013\"\u00020\u0005\u00a2\u0006\u0002\u0010\u0014R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0007\u00a8\u0006\u0018"}, d2={"Lcom/intellij/testFramework/propertyBased/PsiIndexConsistencyTester;", "", "()V", "commonActions", "", "Lcom/intellij/testFramework/propertyBased/PsiIndexConsistencyTester$Action;", "getCommonActions", "()Ljava/util/List;", "commonRefs", "Lcom/intellij/testFramework/propertyBased/PsiIndexConsistencyTester$RefKind;", "getCommonRefs", "refActions", "", "refs", "runActions", "", "model", "Lcom/intellij/testFramework/propertyBased/PsiIndexConsistencyTester$Model;", "actions", "", "(Lcom/intellij/testFramework/propertyBased/PsiIndexConsistencyTester$Model;[Lcom/intellij/testFramework/propertyBased/PsiIndexConsistencyTester$Action;)V", "Action", "Model", "RefKind", "intellij.platform.testFramework"})
public final class PsiIndexConsistencyTester {
    @NotNull
    private static final List<RefKind> commonRefs;
    @NotNull
    private static final List<Action> commonActions;
    public static final PsiIndexConsistencyTester INSTANCE;

    @NotNull
    public final List<RefKind> getCommonRefs() {
        return commonRefs;
    }

    @NotNull
    public final List<Action> getCommonActions() {
        return commonActions;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Iterable<Action> refActions(@NotNull List<? extends RefKind> refs) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkParameterIsNotNull(refs, (String)"refs");
        Iterable $this$flatMap$iv = refs;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            RefKind it = (RefKind)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = CollectionsKt.listOf((Object[])new Action[]{new Action.LoadRef(it), new Action.ClearRef(it)});
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public final void runActions(@NotNull Model model, Action ... actions) {
        Intrinsics.checkParameterIsNotNull((Object)model, (String)"model");
        Intrinsics.checkParameterIsNotNull((Object)actions, (String)"actions");
        WriteCommandAction.runWriteCommandAction((Project)model.getProject(), (Runnable)new Runnable(actions, model){
            final /* synthetic */ Action[] $actions;
            final /* synthetic */ Model $model;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void run() {
                try {
                    Action[] $this$forEach$iv = this.$actions;
                    boolean $i$f$forEach = false;
                    Action[] actionArray = $this$forEach$iv;
                    int n = actionArray.length;
                    for (int i = 0; i < n; ++i) {
                        Action element$iv;
                        Action it = element$iv = actionArray[i];
                        boolean bl = false;
                        it.performAction(this.$model);
                    }
                }
                finally {
                    try {
                        Action.Save.INSTANCE.performAction(this.$model);
                        this.$model.getVFile().delete((Object)PsiIndexConsistencyTester.INSTANCE);
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                    }
                }
            }
            {
                this.$actions = actionArray;
                this.$model = model;
            }
        });
    }

    private PsiIndexConsistencyTester() {
    }

    static {
        PsiIndexConsistencyTester psiIndexConsistencyTester;
        INSTANCE = psiIndexConsistencyTester = new PsiIndexConsistencyTester();
        commonRefs = CollectionsKt.listOf((Object[])new RefKind[]{RefKind.PsiFileRef.INSTANCE, RefKind.DocumentRef.INSTANCE, RefKind.DirRef.INSTANCE, new RefKind.AstRef(null), new RefKind.StubRef(null), new RefKind.GreenStubRef(null)});
        commonActions = CollectionsKt.listOf((Object[])new Action.SimpleAction[]{Action.Commit.INSTANCE, Action.Gc.INSTANCE, Action.ReparseFile.INSTANCE, Action.FilePropertiesChanged.INSTANCE, Action.ReloadFromDisk.INSTANCE, Action.Reformat.INSTANCE, Action.PostponedFormatting.INSTANCE, Action.RenamePsiFile.INSTANCE, Action.RenameVirtualFile.INSTANCE, Action.Save.INSTANCE});
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0012\u0010\u0015\u001a\u00020\u00162\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\u0018J\b\u0010\u0019\u001a\u00020\u001aH\u0002J\u0006\u0010\u001b\u001a\u00020\u001cJ\u0006\u0010\u001d\u001a\u00020\u001eJ\b\u0010\u001f\u001a\u00020 H\u0016J\b\u0010!\u001a\u00020 H\u0016J\b\u0010\"\u001a\u00020 H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR1\u0010\r\u001a\"\u0012\u0004\u0012\u00020\u000f\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u000ej\u0010\u0012\u0004\u0012\u00020\u000f\u0012\u0006\u0012\u0004\u0018\u00010\u0001`\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006#"}, d2={"Lcom/intellij/testFramework/propertyBased/PsiIndexConsistencyTester$Model;", "", "vFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "fixture", "Lcom/intellij/testFramework/fixtures/CodeInsightTestFixture;", "(Lcom/intellij/openapi/vfs/VirtualFile;Lcom/intellij/testFramework/fixtures/CodeInsightTestFixture;)V", "getFixture", "()Lcom/intellij/testFramework/fixtures/CodeInsightTestFixture;", "project", "Lcom/intellij/openapi/project/Project;", "getProject", "()Lcom/intellij/openapi/project/Project;", "refs", "Ljava/util/HashMap;", "Lcom/intellij/testFramework/propertyBased/PsiIndexConsistencyTester$RefKind;", "Lkotlin/collections/HashMap;", "getRefs", "()Ljava/util/HashMap;", "getVFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "findPsiFile", "Lcom/intellij/psi/PsiFile;", "language", "Lcom/intellij/lang/Language;", "findViewProvider", "Lcom/intellij/psi/FileViewProvider;", "getDocument", "Lcom/intellij/openapi/editor/Document;", "isCommitted", "", "onCommit", "", "onReload", "onSave", "intellij.platform.testFramework"})
    public static class Model {
        @NotNull
        private final HashMap<RefKind, Object> refs;
        @NotNull
        private final Project project;
        @NotNull
        private final VirtualFile vFile;
        @NotNull
        private final CodeInsightTestFixture fixture;

        @NotNull
        public final HashMap<RefKind, Object> getRefs() {
            return this.refs;
        }

        @NotNull
        public final Project getProject() {
            return this.project;
        }

        @NotNull
        public final PsiFile findPsiFile(@Nullable Language language) {
            FileViewProvider fileViewProvider = this.findViewProvider();
            boolean bl = false;
            boolean bl2 = false;
            FileViewProvider vp = fileViewProvider;
            boolean bl3 = false;
            Language language2 = language;
            if (language2 == null) {
                language2 = vp.getBaseLanguage();
            }
            PsiFile psiFile = vp.getPsi(language2);
            if (psiFile == null) {
                Intrinsics.throwNpe();
            }
            return psiFile;
        }

        public static /* synthetic */ PsiFile findPsiFile$default(Model model, Language language, int n, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: findPsiFile");
            }
            if ((n & 1) != 0) {
                language = null;
            }
            return model.findPsiFile(language);
        }

        private final FileViewProvider findViewProvider() {
            FileViewProvider fileViewProvider = PsiManager.getInstance((Project)this.project).findViewProvider(this.vFile);
            if (fileViewProvider == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)fileViewProvider, (String)"PsiManager.getInstance(p\u2026findViewProvider(vFile)!!");
            return fileViewProvider;
        }

        @NotNull
        public final Document getDocument() {
            Document document = FileDocumentManager.getInstance().getDocument(this.vFile);
            if (document == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)document, (String)"FileDocumentManager.getI\u2026ce().getDocument(vFile)!!");
            return document;
        }

        public final boolean isCommitted() {
            Document document = FileDocumentManager.getInstance().getCachedDocument(this.vFile);
            return document == null || PsiDocumentManager.getInstance((Project)this.project).isCommitted(document);
        }

        public void onCommit() {
        }

        public void onReload() {
        }

        public void onSave() {
        }

        @NotNull
        public final VirtualFile getVFile() {
            return this.vFile;
        }

        @NotNull
        public final CodeInsightTestFixture getFixture() {
            return this.fixture;
        }

        public Model(@NotNull VirtualFile vFile, @NotNull CodeInsightTestFixture fixture) {
            Intrinsics.checkParameterIsNotNull((Object)vFile, (String)"vFile");
            Intrinsics.checkParameterIsNotNull((Object)fixture, (String)"fixture");
            this.vFile = vFile;
            this.fixture = fixture;
            Model model = this;
            boolean bl = false;
            HashMap hashMap = new HashMap();
            model.refs = hashMap;
            Project project2 = this.fixture.getProject();
            if (project2 == null) {
                Intrinsics.throwNpe();
            }
            this.project = project2;
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0010\bf\u0018\u00002\u00020\u0001:\u000f\u0006\u0007\b\t\n\u000b\f\r\u000e\u000f\u0010\u0011\u0012\u0013\u0014J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\u0015"}, d2={"Lcom/intellij/testFramework/propertyBased/PsiIndexConsistencyTester$Action;", "", "performAction", "", "model", "Lcom/intellij/testFramework/propertyBased/PsiIndexConsistencyTester$Model;", "ClearRef", "Commit", "FilePropertiesChanged", "Gc", "LoadRef", "PostponedFormatting", "Reformat", "ReloadFromDisk", "RenamePsiFile", "RenameVirtualFile", "ReparseFile", "Save", "SetDocumentText", "SetFileText", "SimpleAction", "intellij.platform.testFramework"})
    public static interface Action {
        public void performAction(@NotNull Model var1);

        @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016\u00a8\u0006\u0005"}, d2={"Lcom/intellij/testFramework/propertyBased/PsiIndexConsistencyTester$Action$SimpleAction;", "Lcom/intellij/testFramework/propertyBased/PsiIndexConsistencyTester$Action;", "()V", "toString", "", "intellij.platform.testFramework"})
        public static abstract class SimpleAction
        implements Action {
            @NotNull
            public String toString() {
                String string = this.getClass().getSimpleName();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"javaClass.simpleName");
                return string;
            }
        }

        @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/intellij/testFramework/propertyBased/PsiIndexConsistencyTester$Action$Gc;", "Lcom/intellij/testFramework/propertyBased/PsiIndexConsistencyTester$Action$SimpleAction;", "()V", "performAction", "", "model", "Lcom/intellij/testFramework/propertyBased/PsiIndexConsistencyTester$Model;", "intellij.platform.testFramework"})
        public static final class Gc
        extends SimpleAction {
            public static final Gc INSTANCE;

            @Override
            public void performAction(@NotNull Model model) {
                Intrinsics.checkParameterIsNotNull((Object)model, (String)"model");
                GCUtil.tryGcSoftlyReachableObjects();
            }

            private Gc() {
            }

            static {
                Gc gc;
                INSTANCE = gc = new Gc();
            }
        }

        @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/intellij/testFramework/propertyBased/PsiIndexConsistencyTester$Action$Commit;", "Lcom/intellij/testFramework/propertyBased/PsiIndexConsistencyTester$Action$SimpleAction;", "()V", "performAction", "", "model", "Lcom/intellij/testFramework/propertyBased/PsiIndexConsistencyTester$Model;", "intellij.platform.testFramework"})
        public static final class Commit
        extends SimpleAction {
            public static final Commit INSTANCE;

            @Override
            public void performAction(@NotNull Model model) {
                Intrinsics.checkParameterIsNotNull((Object)model, (String)"model");
                PsiDocumentManager.getInstance((Project)model.getProject()).commitAllDocuments();
                model.onCommit();
            }

            private Commit() {
            }

            static {
                Commit commit;
                INSTANCE = commit = new Commit();
            }
        }

        @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/intellij/testFramework/propertyBased/PsiIndexConsistencyTester$Action$Save;", "Lcom/intellij/testFramework/propertyBased/PsiIndexConsistencyTester$Action$SimpleAction;", "()V", "performAction", "", "model", "Lcom/intellij/testFramework/propertyBased/PsiIndexConsistencyTester$Model;", "intellij.platform.testFramework"})
        public static final class Save
        extends SimpleAction {
            public static final Save INSTANCE;

            @Override
            public void performAction(@NotNull Model model) {
                Intrinsics.checkParameterIsNotNull((Object)model, (String)"model");
                PostponedFormatting.INSTANCE.performAction(model);
                FileDocumentManager.getInstance().saveAllDocuments();
                model.onSave();
            }

            private Save() {
            }

            static {
                Save save;
                INSTANCE = save = new Save();
            }
        }

        @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/intellij/testFramework/propertyBased/PsiIndexConsistencyTester$Action$PostponedFormatting;", "Lcom/intellij/testFramework/propertyBased/PsiIndexConsistencyTester$Action$SimpleAction;", "()V", "performAction", "", "model", "Lcom/intellij/testFramework/propertyBased/PsiIndexConsistencyTester$Model;", "intellij.platform.testFramework"})
        public static final class PostponedFormatting
        extends SimpleAction {
            public static final PostponedFormatting INSTANCE;

            @Override
            public void performAction(@NotNull Model model) {
                Intrinsics.checkParameterIsNotNull((Object)model, (String)"model");
                PostprocessReformattingAspect.getInstance((Project)model.getProject()).doPostponedFormatting();
            }

            private PostponedFormatting() {
            }

            static {
                PostponedFormatting postponedFormatting;
                INSTANCE = postponedFormatting = new PostponedFormatting();
            }
        }

        @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/intellij/testFramework/propertyBased/PsiIndexConsistencyTester$Action$ReparseFile;", "Lcom/intellij/testFramework/propertyBased/PsiIndexConsistencyTester$Action$SimpleAction;", "()V", "performAction", "", "model", "Lcom/intellij/testFramework/propertyBased/PsiIndexConsistencyTester$Model;", "intellij.platform.testFramework"})
        public static final class ReparseFile
        extends SimpleAction {
            public static final ReparseFile INSTANCE;

            @Override
            public void performAction(@NotNull Model model) {
                Intrinsics.checkParameterIsNotNull((Object)model, (String)"model");
                PostponedFormatting.INSTANCE.performAction(model);
                FileContentUtilCore.reparseFiles((VirtualFile[])new VirtualFile[]{model.getVFile()});
                model.onSave();
            }

            private ReparseFile() {
            }

            static {
                ReparseFile reparseFile;
                INSTANCE = reparseFile = new ReparseFile();
            }
        }

        @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/intellij/testFramework/propertyBased/PsiIndexConsistencyTester$Action$FilePropertiesChanged;", "Lcom/intellij/testFramework/propertyBased/PsiIndexConsistencyTester$Action$SimpleAction;", "()V", "performAction", "", "model", "Lcom/intellij/testFramework/propertyBased/PsiIndexConsistencyTester$Model;", "intellij.platform.testFramework"})
        public static final class FilePropertiesChanged
        extends SimpleAction {
            public static final FilePropertiesChanged INSTANCE;

            @Override
            public void performAction(@NotNull Model model) {
                Intrinsics.checkParameterIsNotNull((Object)model, (String)"model");
                PostponedFormatting.INSTANCE.performAction(model);
                PushedFilePropertiesUpdater.getInstance((Project)model.getProject()).filePropertiesChanged(model.getVFile(), Conditions.alwaysTrue());
            }

            private FilePropertiesChanged() {
            }

            static {
                FilePropertiesChanged filePropertiesChanged;
                INSTANCE = filePropertiesChanged = new FilePropertiesChanged();
            }
        }

        @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/intellij/testFramework/propertyBased/PsiIndexConsistencyTester$Action$ReloadFromDisk;", "Lcom/intellij/testFramework/propertyBased/PsiIndexConsistencyTester$Action$SimpleAction;", "()V", "performAction", "", "model", "Lcom/intellij/testFramework/propertyBased/PsiIndexConsistencyTester$Model;", "intellij.platform.testFramework"})
        public static final class ReloadFromDisk
        extends SimpleAction {
            public static final ReloadFromDisk INSTANCE;

            @Override
            public void performAction(@NotNull Model model) {
                Intrinsics.checkParameterIsNotNull((Object)model, (String)"model");
                PostponedFormatting.INSTANCE.performAction(model);
                PsiManager.getInstance((Project)model.getProject()).reloadFromDisk(Model.findPsiFile$default(model, null, 1, null));
                model.onReload();
                if (model.isCommitted()) {
                    model.onCommit();
                }
            }

            private ReloadFromDisk() {
            }

            static {
                ReloadFromDisk reloadFromDisk;
                INSTANCE = reloadFromDisk = new ReloadFromDisk();
            }
        }

        @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/intellij/testFramework/propertyBased/PsiIndexConsistencyTester$Action$RenameVirtualFile;", "Lcom/intellij/testFramework/propertyBased/PsiIndexConsistencyTester$Action$SimpleAction;", "()V", "performAction", "", "model", "Lcom/intellij/testFramework/propertyBased/PsiIndexConsistencyTester$Model;", "intellij.platform.testFramework"})
        public static final class RenameVirtualFile
        extends SimpleAction {
            public static final RenameVirtualFile INSTANCE;

            @Override
            public void performAction(@NotNull Model model) {
                Intrinsics.checkParameterIsNotNull((Object)model, (String)"model");
                model.getVFile().rename((Object)this, model.getVFile().getNameWithoutExtension() + "1." + model.getVFile().getExtension());
            }

            private RenameVirtualFile() {
            }

            static {
                RenameVirtualFile renameVirtualFile;
                INSTANCE = renameVirtualFile = new RenameVirtualFile();
            }
        }

        @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/intellij/testFramework/propertyBased/PsiIndexConsistencyTester$Action$RenamePsiFile;", "Lcom/intellij/testFramework/propertyBased/PsiIndexConsistencyTester$Action$SimpleAction;", "()V", "performAction", "", "model", "Lcom/intellij/testFramework/propertyBased/PsiIndexConsistencyTester$Model;", "intellij.platform.testFramework"})
        public static final class RenamePsiFile
        extends SimpleAction {
            public static final RenamePsiFile INSTANCE;

            @Override
            public void performAction(@NotNull Model model) {
                Intrinsics.checkParameterIsNotNull((Object)model, (String)"model");
                String newName = model.getVFile().getNameWithoutExtension() + "1." + model.getVFile().getExtension();
                Model.findPsiFile$default(model, null, 1, null).setName(newName);
                boolean bl = Intrinsics.areEqual((Object)Model.findPsiFile$default(model, null, 1, null).getName(), (Object)newName);
                boolean bl2 = false;
                boolean bl3 = false;
                if (_Assertions.ENABLED && !bl) {
                    boolean bl4 = false;
                    String string = "Assertion failed";
                    throw (Throwable)((Object)new AssertionError((Object)string));
                }
                bl = Intrinsics.areEqual((Object)model.getVFile().getName(), (Object)newName);
                bl2 = false;
                bl3 = false;
                if (_Assertions.ENABLED && !bl) {
                    boolean bl5 = false;
                    String string = "Assertion failed";
                    throw (Throwable)((Object)new AssertionError((Object)string));
                }
            }

            private RenamePsiFile() {
            }

            static {
                RenamePsiFile renamePsiFile;
                INSTANCE = renamePsiFile = new RenamePsiFile();
            }
        }

        @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/intellij/testFramework/propertyBased/PsiIndexConsistencyTester$Action$Reformat;", "Lcom/intellij/testFramework/propertyBased/PsiIndexConsistencyTester$Action$SimpleAction;", "()V", "performAction", "", "model", "Lcom/intellij/testFramework/propertyBased/PsiIndexConsistencyTester$Model;", "intellij.platform.testFramework"})
        public static final class Reformat
        extends SimpleAction {
            public static final Reformat INSTANCE;

            @Override
            public void performAction(@NotNull Model model) {
                Intrinsics.checkParameterIsNotNull((Object)model, (String)"model");
                PostponedFormatting.INSTANCE.performAction(model);
                Commit.INSTANCE.performAction(model);
                CodeStyleManager.getInstance((Project)model.getProject()).reformat((PsiElement)Model.findPsiFile$default(model, null, 1, null));
            }

            private Reformat() {
            }

            static {
                Reformat reformat;
                INSTANCE = reformat = new Reformat();
            }
        }

        @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0015"}, d2={"Lcom/intellij/testFramework/propertyBased/PsiIndexConsistencyTester$Action$LoadRef;", "Lcom/intellij/testFramework/propertyBased/PsiIndexConsistencyTester$Action;", "kind", "Lcom/intellij/testFramework/propertyBased/PsiIndexConsistencyTester$RefKind;", "(Lcom/intellij/testFramework/propertyBased/PsiIndexConsistencyTester$RefKind;)V", "getKind", "()Lcom/intellij/testFramework/propertyBased/PsiIndexConsistencyTester$RefKind;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "performAction", "", "model", "Lcom/intellij/testFramework/propertyBased/PsiIndexConsistencyTester$Model;", "toString", "", "intellij.platform.testFramework"})
        public static final class LoadRef
        implements Action {
            @NotNull
            private final RefKind kind;

            @Override
            public void performAction(@NotNull Model model) {
                Intrinsics.checkParameterIsNotNull((Object)model, (String)"model");
                Object oldValue = model.getRefs().get(this.kind);
                Object newValue = this.kind.loadRef(model);
                if (oldValue != null && newValue != null && oldValue != newValue) {
                    this.kind.checkDuplicates(oldValue, newValue);
                }
                ((Map)model.getRefs()).put(this.kind, newValue);
            }

            @NotNull
            public final RefKind getKind() {
                return this.kind;
            }

            public LoadRef(@NotNull RefKind kind) {
                Intrinsics.checkParameterIsNotNull((Object)kind, (String)"kind");
                this.kind = kind;
            }

            @NotNull
            public final RefKind component1() {
                return this.kind;
            }

            @NotNull
            public final LoadRef copy(@NotNull RefKind kind) {
                Intrinsics.checkParameterIsNotNull((Object)kind, (String)"kind");
                return new LoadRef(kind);
            }

            public static /* synthetic */ LoadRef copy$default(LoadRef loadRef, RefKind refKind, int n, Object object) {
                if ((n & 1) != 0) {
                    refKind = loadRef.kind;
                }
                return loadRef.copy(refKind);
            }

            @NotNull
            public String toString() {
                return "LoadRef(kind=" + this.kind + ")";
            }

            public int hashCode() {
                RefKind refKind = this.kind;
                return refKind != null ? refKind.hashCode() : 0;
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof LoadRef)) break block3;
                        LoadRef loadRef = (LoadRef)object;
                        if (!Intrinsics.areEqual((Object)this.kind, (Object)loadRef.kind)) break block3;
                    }
                    return true;
                }
                return false;
            }
        }

        @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0015"}, d2={"Lcom/intellij/testFramework/propertyBased/PsiIndexConsistencyTester$Action$ClearRef;", "Lcom/intellij/testFramework/propertyBased/PsiIndexConsistencyTester$Action;", "kind", "Lcom/intellij/testFramework/propertyBased/PsiIndexConsistencyTester$RefKind;", "(Lcom/intellij/testFramework/propertyBased/PsiIndexConsistencyTester$RefKind;)V", "getKind", "()Lcom/intellij/testFramework/propertyBased/PsiIndexConsistencyTester$RefKind;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "performAction", "", "model", "Lcom/intellij/testFramework/propertyBased/PsiIndexConsistencyTester$Model;", "toString", "", "intellij.platform.testFramework"})
        public static final class ClearRef
        implements Action {
            @NotNull
            private final RefKind kind;

            @Override
            public void performAction(@NotNull Model model) {
                Intrinsics.checkParameterIsNotNull((Object)model, (String)"model");
                model.getRefs().remove(this.kind);
            }

            @NotNull
            public final RefKind getKind() {
                return this.kind;
            }

            public ClearRef(@NotNull RefKind kind) {
                Intrinsics.checkParameterIsNotNull((Object)kind, (String)"kind");
                this.kind = kind;
            }

            @NotNull
            public final RefKind component1() {
                return this.kind;
            }

            @NotNull
            public final ClearRef copy(@NotNull RefKind kind) {
                Intrinsics.checkParameterIsNotNull((Object)kind, (String)"kind");
                return new ClearRef(kind);
            }

            public static /* synthetic */ ClearRef copy$default(ClearRef clearRef, RefKind refKind, int n, Object object) {
                if ((n & 1) != 0) {
                    refKind = clearRef.kind;
                }
                return clearRef.copy(refKind);
            }

            @NotNull
            public String toString() {
                return "ClearRef(kind=" + this.kind + ")";
            }

            public int hashCode() {
                RefKind refKind = this.kind;
                return refKind != null ? refKind.hashCode() : 0;
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof ClearRef)) break block3;
                        ClearRef clearRef = (ClearRef)object;
                        if (!Intrinsics.areEqual((Object)this.kind, (Object)clearRef.kind)) break block3;
                    }
                    return true;
                }
                return false;
            }
        }

        @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\t\u0010\u0013\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0014"}, d2={"Lcom/intellij/testFramework/propertyBased/PsiIndexConsistencyTester$Action$SetDocumentText;", "Lcom/intellij/testFramework/propertyBased/PsiIndexConsistencyTester$Action;", "text", "", "(Ljava/lang/String;)V", "getText", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "performAction", "", "model", "Lcom/intellij/testFramework/propertyBased/PsiIndexConsistencyTester$Model;", "toString", "intellij.platform.testFramework"})
        public static final class SetDocumentText
        implements Action {
            @NotNull
            private final String text;

            @Override
            public void performAction(@NotNull Model model) {
                Intrinsics.checkParameterIsNotNull((Object)model, (String)"model");
                PostponedFormatting.INSTANCE.performAction(model);
                model.getDocument().setText((CharSequence)this.text);
            }

            @NotNull
            public final String getText() {
                return this.text;
            }

            public SetDocumentText(@NotNull String text) {
                Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
                this.text = text;
            }

            @NotNull
            public final String component1() {
                return this.text;
            }

            @NotNull
            public final SetDocumentText copy(@NotNull String text) {
                Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
                return new SetDocumentText(text);
            }

            public static /* synthetic */ SetDocumentText copy$default(SetDocumentText setDocumentText, String string, int n, Object object) {
                if ((n & 1) != 0) {
                    string = setDocumentText.text;
                }
                return setDocumentText.copy(string);
            }

            @NotNull
            public String toString() {
                return "SetDocumentText(text=" + this.text + ")";
            }

            public int hashCode() {
                String string = this.text;
                return string != null ? string.hashCode() : 0;
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof SetDocumentText)) break block3;
                        SetDocumentText setDocumentText = (SetDocumentText)object;
                        if (!Intrinsics.areEqual((Object)this.text, (Object)setDocumentText.text)) break block3;
                    }
                    return true;
                }
                return false;
            }
        }

        @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\t\u0010\u0013\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0014"}, d2={"Lcom/intellij/testFramework/propertyBased/PsiIndexConsistencyTester$Action$SetFileText;", "Lcom/intellij/testFramework/propertyBased/PsiIndexConsistencyTester$Action;", "text", "", "(Ljava/lang/String;)V", "getText", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "performAction", "", "model", "Lcom/intellij/testFramework/propertyBased/PsiIndexConsistencyTester$Model;", "toString", "intellij.platform.testFramework"})
        public static final class SetFileText
        implements Action {
            @NotNull
            private final String text;

            @Override
            public void performAction(@NotNull Model model) {
                Intrinsics.checkParameterIsNotNull((Object)model, (String)"model");
                PostponedFormatting.INSTANCE.performAction(model);
                Save.INSTANCE.performAction(model);
                VfsUtil.saveText((VirtualFile)model.getVFile(), (String)this.text);
            }

            @NotNull
            public final String getText() {
                return this.text;
            }

            public SetFileText(@NotNull String text) {
                Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
                this.text = text;
            }

            @NotNull
            public final String component1() {
                return this.text;
            }

            @NotNull
            public final SetFileText copy(@NotNull String text) {
                Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
                return new SetFileText(text);
            }

            public static /* synthetic */ SetFileText copy$default(SetFileText setFileText, String string, int n, Object object) {
                if ((n & 1) != 0) {
                    string = setFileText.text;
                }
                return setFileText.copy(string);
            }

            @NotNull
            public String toString() {
                return "SetFileText(text=" + this.text + ")";
            }

            public int hashCode() {
                String string = this.text;
                return string != null ? string.hashCode() : 0;
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof SetFileText)) break block3;
                        SetFileText setFileText = (SetFileText)object;
                        if (!Intrinsics.areEqual((Object)this.text, (Object)setFileText.text)) break block3;
                    }
                    return true;
                }
                return false;
            }
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\b&\u0018\u00002\u00020\u0001:\u0006\n\u000b\f\r\u000e\u000fB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u0001H\u0016J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\u00012\u0006\u0010\b\u001a\u00020\tH&\u00a8\u0006\u0010"}, d2={"Lcom/intellij/testFramework/propertyBased/PsiIndexConsistencyTester$RefKind;", "", "()V", "checkDuplicates", "", "oldValue", "newValue", "loadRef", "model", "Lcom/intellij/testFramework/propertyBased/PsiIndexConsistencyTester$Model;", "AstRef", "DirRef", "DocumentRef", "GreenStubRef", "PsiFileRef", "StubRef", "intellij.platform.testFramework"})
    public static abstract class RefKind {
        @Nullable
        public abstract Object loadRef(@NotNull Model var1);

        public void checkDuplicates(@NotNull Object oldValue, @NotNull Object newValue) {
            Intrinsics.checkParameterIsNotNull((Object)oldValue, (String)"oldValue");
            Intrinsics.checkParameterIsNotNull((Object)newValue, (String)"newValue");
            if (oldValue instanceof PsiElement && ((PsiElement)oldValue).isValid() && newValue instanceof PsiElement) {
                Assert.fail((String)("Duplicate PSI elements: " + oldValue + " and " + newValue));
            }
        }

        @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/intellij/testFramework/propertyBased/PsiIndexConsistencyTester$RefKind$PsiFileRef;", "Lcom/intellij/testFramework/propertyBased/PsiIndexConsistencyTester$RefKind;", "()V", "loadRef", "", "model", "Lcom/intellij/testFramework/propertyBased/PsiIndexConsistencyTester$Model;", "intellij.platform.testFramework"})
        public static final class PsiFileRef
        extends RefKind {
            public static final PsiFileRef INSTANCE;

            @Override
            @Nullable
            public Object loadRef(@NotNull Model model) {
                Intrinsics.checkParameterIsNotNull((Object)model, (String)"model");
                return Model.findPsiFile$default(model, null, 1, null);
            }

            private PsiFileRef() {
            }

            static {
                PsiFileRef psiFileRef;
                INSTANCE = psiFileRef = new PsiFileRef();
            }
        }

        @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/intellij/testFramework/propertyBased/PsiIndexConsistencyTester$RefKind$DocumentRef;", "Lcom/intellij/testFramework/propertyBased/PsiIndexConsistencyTester$RefKind;", "()V", "loadRef", "", "model", "Lcom/intellij/testFramework/propertyBased/PsiIndexConsistencyTester$Model;", "intellij.platform.testFramework"})
        public static final class DocumentRef
        extends RefKind {
            public static final DocumentRef INSTANCE;

            @Override
            @Nullable
            public Object loadRef(@NotNull Model model) {
                Intrinsics.checkParameterIsNotNull((Object)model, (String)"model");
                return model.getDocument();
            }

            private DocumentRef() {
            }

            static {
                DocumentRef documentRef;
                INSTANCE = documentRef = new DocumentRef();
            }
        }

        @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/intellij/testFramework/propertyBased/PsiIndexConsistencyTester$RefKind$DirRef;", "Lcom/intellij/testFramework/propertyBased/PsiIndexConsistencyTester$RefKind;", "()V", "loadRef", "", "model", "Lcom/intellij/testFramework/propertyBased/PsiIndexConsistencyTester$Model;", "intellij.platform.testFramework"})
        public static final class DirRef
        extends RefKind {
            public static final DirRef INSTANCE;

            @Override
            @Nullable
            public Object loadRef(@NotNull Model model) {
                Intrinsics.checkParameterIsNotNull((Object)model, (String)"model");
                return Model.findPsiFile$default(model, null, 1, null).getContainingDirectory();
            }

            private DirRef() {
            }

            static {
                DirRef dirRef;
                INSTANCE = dirRef = new DirRef();
            }
        }

        @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\u000b\u0010\u0007\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u0015\u0010\b\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0014"}, d2={"Lcom/intellij/testFramework/propertyBased/PsiIndexConsistencyTester$RefKind$AstRef;", "Lcom/intellij/testFramework/propertyBased/PsiIndexConsistencyTester$RefKind;", "language", "Lcom/intellij/lang/Language;", "(Lcom/intellij/lang/Language;)V", "getLanguage", "()Lcom/intellij/lang/Language;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "loadRef", "model", "Lcom/intellij/testFramework/propertyBased/PsiIndexConsistencyTester$Model;", "toString", "", "intellij.platform.testFramework"})
        public static final class AstRef
        extends RefKind {
            @Nullable
            private final Language language;

            @Override
            @Nullable
            public Object loadRef(@NotNull Model model) {
                Intrinsics.checkParameterIsNotNull((Object)model, (String)"model");
                return model.findPsiFile(this.language).getNode();
            }

            @Nullable
            public final Language getLanguage() {
                return this.language;
            }

            public AstRef(@Nullable Language language) {
                this.language = language;
            }

            @Nullable
            public final Language component1() {
                return this.language;
            }

            @NotNull
            public final AstRef copy(@Nullable Language language) {
                return new AstRef(language);
            }

            public static /* synthetic */ AstRef copy$default(AstRef astRef, Language language, int n, Object object) {
                if ((n & 1) != 0) {
                    language = astRef.language;
                }
                return astRef.copy(language);
            }

            @NotNull
            public String toString() {
                return "AstRef(language=" + this.language + ")";
            }

            public int hashCode() {
                Language language = this.language;
                return language != null ? language.hashCode() : 0;
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof AstRef)) break block3;
                        AstRef astRef = (AstRef)object;
                        if (!Intrinsics.areEqual((Object)this.language, (Object)astRef.language)) break block3;
                    }
                    return true;
                }
                return false;
            }
        }

        @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\u000b\u0010\u0007\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u0015\u0010\b\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0014"}, d2={"Lcom/intellij/testFramework/propertyBased/PsiIndexConsistencyTester$RefKind$StubRef;", "Lcom/intellij/testFramework/propertyBased/PsiIndexConsistencyTester$RefKind;", "language", "Lcom/intellij/lang/Language;", "(Lcom/intellij/lang/Language;)V", "getLanguage", "()Lcom/intellij/lang/Language;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "loadRef", "model", "Lcom/intellij/testFramework/propertyBased/PsiIndexConsistencyTester$Model;", "toString", "", "intellij.platform.testFramework"})
        public static final class StubRef
        extends RefKind {
            @Nullable
            private final Language language;

            @Override
            @Nullable
            public Object loadRef(@NotNull Model model) {
                Intrinsics.checkParameterIsNotNull((Object)model, (String)"model");
                PsiFile psiFile = model.findPsiFile(this.language);
                if (psiFile == null) {
                    throw new TypeCastException("null cannot be cast to non-null type com.intellij.psi.impl.source.PsiFileImpl");
                }
                return ((PsiFileImpl)psiFile).getStubTree();
            }

            @Nullable
            public final Language getLanguage() {
                return this.language;
            }

            public StubRef(@Nullable Language language) {
                this.language = language;
            }

            @Nullable
            public final Language component1() {
                return this.language;
            }

            @NotNull
            public final StubRef copy(@Nullable Language language) {
                return new StubRef(language);
            }

            public static /* synthetic */ StubRef copy$default(StubRef stubRef, Language language, int n, Object object) {
                if ((n & 1) != 0) {
                    language = stubRef.language;
                }
                return stubRef.copy(language);
            }

            @NotNull
            public String toString() {
                return "StubRef(language=" + this.language + ")";
            }

            public int hashCode() {
                Language language = this.language;
                return language != null ? language.hashCode() : 0;
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof StubRef)) break block3;
                        StubRef stubRef = (StubRef)object;
                        if (!Intrinsics.areEqual((Object)this.language, (Object)stubRef.language)) break block3;
                    }
                    return true;
                }
                return false;
            }
        }

        @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\u000b\u0010\u0007\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u0015\u0010\b\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0014"}, d2={"Lcom/intellij/testFramework/propertyBased/PsiIndexConsistencyTester$RefKind$GreenStubRef;", "Lcom/intellij/testFramework/propertyBased/PsiIndexConsistencyTester$RefKind;", "language", "Lcom/intellij/lang/Language;", "(Lcom/intellij/lang/Language;)V", "getLanguage", "()Lcom/intellij/lang/Language;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "loadRef", "model", "Lcom/intellij/testFramework/propertyBased/PsiIndexConsistencyTester$Model;", "toString", "", "intellij.platform.testFramework"})
        public static final class GreenStubRef
        extends RefKind {
            @Nullable
            private final Language language;

            @Override
            @Nullable
            public Object loadRef(@NotNull Model model) {
                Intrinsics.checkParameterIsNotNull((Object)model, (String)"model");
                PsiFile psiFile = model.findPsiFile(this.language);
                if (psiFile == null) {
                    throw new TypeCastException("null cannot be cast to non-null type com.intellij.psi.impl.source.PsiFileImpl");
                }
                return ((PsiFileImpl)psiFile).getGreenStubTree();
            }

            @Nullable
            public final Language getLanguage() {
                return this.language;
            }

            public GreenStubRef(@Nullable Language language) {
                this.language = language;
            }

            @Nullable
            public final Language component1() {
                return this.language;
            }

            @NotNull
            public final GreenStubRef copy(@Nullable Language language) {
                return new GreenStubRef(language);
            }

            public static /* synthetic */ GreenStubRef copy$default(GreenStubRef greenStubRef, Language language, int n, Object object) {
                if ((n & 1) != 0) {
                    language = greenStubRef.language;
                }
                return greenStubRef.copy(language);
            }

            @NotNull
            public String toString() {
                return "GreenStubRef(language=" + this.language + ")";
            }

            public int hashCode() {
                Language language = this.language;
                return language != null ? language.hashCode() : 0;
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof GreenStubRef)) break block3;
                        GreenStubRef greenStubRef = (GreenStubRef)object;
                        if (!Intrinsics.areEqual((Object)this.language, (Object)greenStubRef.language)) break block3;
                    }
                    return true;
                }
                return false;
            }
        }
    }
}

