/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.history;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.UnorderedPair;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.util.containers.MultiMap;
import com.intellij.vcs.log.graph.api.LinearGraph;
import com.intellij.vcs.log.graph.api.permanent.PermanentGraphInfo;
import com.intellij.vcs.log.graph.impl.facade.GraphModificationUtilKt;
import com.intellij.vcs.log.graph.impl.facade.LinearGraphController;
import com.intellij.vcs.log.history.AdditionDeletion;
import com.intellij.vcs.log.history.FileHistory;
import com.intellij.vcs.log.history.FileHistoryData;
import com.intellij.vcs.log.history.FileHistoryKt;
import com.intellij.vcs.log.history.FileHistoryRefiner;
import com.intellij.vcs.log.history.MaybeDeletedFilePath;
import com.intellij.vcs.log.history.ReachableNodesUtilKt;
import com.intellij.vcs.log.history.Rename;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0005\b\u0000\u0018\u0000 .2\u0014\u0012\u0004\u0012\u00020\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00030\u0001:\u0001.B7\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u000e\b\u0002\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\r\u00a2\u0006\u0002\u0010\u000eJ\u001e\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u00022\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0016J\u001e\u0010#\u001a\u00020 2\u0006\u0010!\u001a\u00020\u00022\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0002J2\u0010$\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00190%2\u0006\u0010&\u001a\u00020\u00042\u0006\u0010'\u001a\u00020(2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0002J9\u0010)\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00190*2\u0006\u0010!\u001a\u00020\u00022\b\u0010\u0005\u001a\u0004\u0018\u00010\u00042\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0002\u00a2\u0006\u0002\u0010+J\u0016\u0010,\u001a\u00020 2\f\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00040\rH\u0002R6\u0010\u000f\u001a*\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\u0004 \u0012*\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u00110\u0011\u0012\f\u0012\n \u0012*\u0004\u0018\u00010\u00130\u00130\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0014\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00190\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001dR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lcom/intellij/vcs/log/history/FileHistoryBuilder;", "Ljava/util/function/BiConsumer;", "Lcom/intellij/vcs/log/graph/impl/facade/LinearGraphController;", "Lcom/intellij/vcs/log/graph/api/permanent/PermanentGraphInfo;", "", "startCommit", "startPath", "Lcom/intellij/openapi/vcs/FilePath;", "fileHistoryData", "Lcom/intellij/vcs/log/history/FileHistoryData;", "oldFileHistory", "Lcom/intellij/vcs/log/history/FileHistory;", "commitsToHide", "", "(Ljava/lang/Integer;Lcom/intellij/openapi/vcs/FilePath;Lcom/intellij/vcs/log/history/FileHistoryData;Lcom/intellij/vcs/log/history/FileHistory;Ljava/util/Set;)V", "commitToRename", "Lcom/intellij/util/containers/MultiMap;", "Lcom/intellij/openapi/util/UnorderedPair;", "kotlin.jvm.PlatformType", "Lcom/intellij/vcs/log/history/Rename;", "fileHistory", "getFileHistory", "()Lcom/intellij/vcs/log/history/FileHistory;", "pathsMap", "", "Lcom/intellij/vcs/log/history/MaybeDeletedFilePath;", "processedAdditionsDeletions", "", "Lcom/intellij/vcs/log/history/AdditionDeletion;", "Ljava/lang/Integer;", "unmatchedAdditionsDeletions", "accept", "", "controller", "permanentGraphInfo", "collectAdditionsDeletions", "findAncestorRowAffectingFile", "Lkotlin/Pair;", "commitId", "visibleLinearGraph", "Lcom/intellij/vcs/log/graph/api/LinearGraph;", "refine", "", "(Lcom/intellij/vcs/log/graph/impl/facade/LinearGraphController;Ljava/lang/Integer;Lcom/intellij/vcs/log/graph/api/permanent/PermanentGraphInfo;)Ljava/util/Map;", "reportTrivialMerges", "trivialMerges", "Companion", "intellij.platform.vcs.log.impl"})
public final class FileHistoryBuilder
implements BiConsumer<LinearGraphController, PermanentGraphInfo<Integer>> {
    private final Map<Integer, MaybeDeletedFilePath> pathsMap;
    private final Set<AdditionDeletion> processedAdditionsDeletions;
    private final Set<AdditionDeletion> unmatchedAdditionsDeletions;
    private final MultiMap<UnorderedPair<Integer>, Rename> commitToRename;
    private final Integer startCommit;
    private final FilePath startPath;
    private final FileHistoryData fileHistoryData;
    private final FileHistory oldFileHistory;
    private final Set<Integer> commitsToHide;
    private static final Logger LOG;
    public static final Companion Companion;

    @NotNull
    public final FileHistory getFileHistory() {
        return new FileHistory(this.pathsMap, this.processedAdditionsDeletions, this.unmatchedAdditionsDeletions, this.commitToRename);
    }

    @Override
    public void accept(@NotNull LinearGraphController controller, @NotNull PermanentGraphInfo<Integer> permanentGraphInfo) {
        Intrinsics.checkParameterIsNotNull((Object)controller, (String)"controller");
        Intrinsics.checkParameterIsNotNull(permanentGraphInfo, (String)"permanentGraphInfo");
        boolean needToRepeat2 = FileHistoryKt.removeTrivialMerges(controller, permanentGraphInfo, this.fileHistoryData, (Function1<? super Set<Integer>, Unit>)((Function1)new Function1<Set<? extends Integer>, Unit>(this){

            public final void invoke(@NotNull Set<Integer> p1) {
                Intrinsics.checkParameterIsNotNull(p1, (String)"p1");
                FileHistoryBuilder.access$reportTrivialMerges((FileHistoryBuilder)this.receiver, p1);
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(FileHistoryBuilder.class);
            }

            public final String getName() {
                return "reportTrivialMerges";
            }

            public final String getSignature() {
                return "reportTrivialMerges(Ljava/util/Set;)V";
            }
        }));
        this.pathsMap.putAll(this.refine(controller, this.startCommit, permanentGraphInfo));
        if (needToRepeat2) {
            LOG.info("Some merge commits were not excluded from file history for " + this.startPath.getPath());
            FileHistoryKt.removeTrivialMerges(controller, permanentGraphInfo, this.fileHistoryData, (Function1<? super Set<Integer>, Unit>)((Function1)new Function1<Set<? extends Integer>, Unit>(this){

                public final void invoke(@NotNull Set<Integer> p1) {
                    Intrinsics.checkParameterIsNotNull(p1, (String)"p1");
                    FileHistoryBuilder.access$reportTrivialMerges((FileHistoryBuilder)this.receiver, p1);
                }

                public final KDeclarationContainer getOwner() {
                    return Reflection.getOrCreateKotlinClass(FileHistoryBuilder.class);
                }

                public final String getName() {
                    return "reportTrivialMerges";
                }

                public final String getSignature() {
                    return "reportTrivialMerges(Ljava/util/Set;)V";
                }
            }));
        }
        this.collectAdditionsDeletions(controller, permanentGraphInfo);
        this.commitToRename.putAllValues(this.fileHistoryData.getCommitToRename$intellij_platform_vcs_log_impl());
        Collection collection = this.commitsToHide;
        boolean bl = false;
        if (!collection.isEmpty()) {
            GraphModificationUtilKt.hideCommits(controller, permanentGraphInfo, this.commitsToHide);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void collectAdditionsDeletions(LinearGraphController controller, PermanentGraphInfo<Integer> permanentGraphInfo) {
        this.processedAdditionsDeletions.addAll((Collection<AdditionDeletion>)this.oldFileHistory.getProcessedAdditionsDeletions$intellij_platform_vcs_log_impl());
        this.processedAdditionsDeletions.addAll((Collection<AdditionDeletion>)this.oldFileHistory.getUnmatchedAdditionsDeletions$intellij_platform_vcs_log_impl());
        boolean bl = false;
        Set additionsDeletions = new LinkedHashSet();
        this.fileHistoryData.iterateUnmatchedAdditionsDeletions$intellij_platform_vcs_log_impl((Function1<? super AdditionDeletion, Unit>)((Function1)new Function1<AdditionDeletion, Unit>(this, additionsDeletions){
            final /* synthetic */ FileHistoryBuilder this$0;
            final /* synthetic */ Set $additionsDeletions;

            public final void invoke(@NotNull AdditionDeletion ad) {
                Intrinsics.checkParameterIsNotNull((Object)ad, (String)"ad");
                if (!FileHistoryBuilder.access$getProcessedAdditionsDeletions$p(this.this$0).contains(ad)) {
                    this.$additionsDeletions.add(ad);
                }
            }
            {
                this.this$0 = fileHistoryBuilder;
                this.$additionsDeletions = set;
                super(1);
            }
        }));
        Collection collection = additionsDeletions;
        boolean bl2 = false;
        if (!collection.isEmpty()) {
            void $this$groupByTo$iv$iv;
            Iterable $this$groupBy$iv22 = additionsDeletions;
            boolean $i$f$groupBy = false;
            Iterable iterable = $this$groupBy$iv22;
            Map destination$iv$iv = new LinkedHashMap();
            boolean $i$f$groupByTo = false;
            for (Object element$iv$iv : $this$groupByTo$iv$iv) {
                Object object;
                AdditionDeletion it = (AdditionDeletion)element$iv$iv;
                boolean bl3 = false;
                Integer key$iv$iv = it.getChild();
                Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
                boolean $i$f$getOrPut = false;
                Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                if (value$iv$iv$iv == null) {
                    boolean bl4 = false;
                    ArrayList answer$iv$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                    object = answer$iv$iv$iv;
                } else {
                    object = value$iv$iv$iv;
                }
                List list$iv$iv = (List)object;
                list$iv$iv.add(element$iv$iv);
            }
            Map grouped = destination$iv$iv;
            int $this$groupBy$iv22 = 0;
            int n = controller.getCompiledGraph().nodesCount();
            while ($this$groupBy$iv22 < n) {
                void row2;
                Integer n2 = permanentGraphInfo.getPermanentCommitsInfo().getCommitId(controller.getCompiledGraph().getNodeId((int)row2));
                Intrinsics.checkExpressionValueIsNotNull((Object)n2, (String)"permanentGraphInfo.perma\u2026iledGraph.getNodeId(row))");
                int commitId = ((Number)n2).intValue();
                if ((List)grouped.get(commitId) != null) {
                    List list;
                    boolean bl5 = false;
                    boolean bl6 = false;
                    List it = list;
                    boolean bl7 = false;
                    this.unmatchedAdditionsDeletions.addAll(it);
                }
                ++row2;
            }
        }
    }

    private final void reportTrivialMerges(Set<Integer> trivialMerges2) {
        LOG.debug("Excluding " + trivialMerges2.size() + " trivial merges from history for " + this.startPath.getPath());
    }

    /*
     * WARNING - void declaration
     */
    private final Map<Integer, MaybeDeletedFilePath> refine(LinearGraphController controller, Integer startCommit, PermanentGraphInfo<Integer> permanentGraphInfo) {
        block6: {
            void row2;
            Object object;
            Pair<Integer, MaybeDeletedFilePath> pair;
            LinearGraph visibleLinearGraph;
            block8: {
                block7: {
                    LinearGraph linearGraph = controller.getCompiledGraph();
                    Intrinsics.checkExpressionValueIsNotNull((Object)linearGraph, (String)"controller.compiledGraph");
                    visibleLinearGraph = linearGraph;
                    if (visibleLinearGraph.nodesCount() <= 0 || !this.fileHistoryData.getHasRenames() || !Registry.is((String)"vcs.history.refine")) break block6;
                    pair = startCommit;
                    if (pair == null) break block7;
                    object = pair;
                    boolean bl = false;
                    boolean bl2 = false;
                    int it = ((Number)object).intValue();
                    boolean bl3 = false;
                    pair = this.findAncestorRowAffectingFile(startCommit.intValue(), visibleLinearGraph, permanentGraphInfo);
                    if (pair != null) break block8;
                }
                pair = new Pair((Object)0, (Object)new MaybeDeletedFilePath(this.startPath));
            }
            Pair<Integer, MaybeDeletedFilePath> pair2 = pair;
            int n = ((Number)pair2.component1()).intValue();
            MaybeDeletedFilePath path = (MaybeDeletedFilePath)pair2.component2();
            if (row2 >= 0) {
                void paths;
                FileHistoryRefiner refiner = new FileHistoryRefiner(visibleLinearGraph, permanentGraphInfo, this.fileHistoryData);
                Object object2 = refiner.refine((int)row2, path);
                object = (Map)object2.component1();
                Set excluded = (Set)object2.component2();
                object2 = excluded;
                boolean bl = false;
                if (!object2.isEmpty()) {
                    LOG.info("Excluding " + excluded.size() + " commits from history for " + this.startPath.getPath());
                    boolean hidden = GraphModificationUtilKt.hideCommits(controller, permanentGraphInfo, excluded);
                    if (!hidden) {
                        LOG.error("Could not hide excluded commits from history for " + this.startPath.getPath());
                    }
                }
                return paths;
            }
        }
        return this.fileHistoryData.buildPathsMap();
    }

    private final Pair<Integer, MaybeDeletedFilePath> findAncestorRowAffectingFile(int commitId, LinearGraph visibleLinearGraph, PermanentGraphInfo<Integer> permanentGraphInfo) {
        MaybeDeletedFilePath existing = new MaybeDeletedFilePath(this.startPath);
        MaybeDeletedFilePath deleted = new MaybeDeletedFilePath(this.startPath, true);
        Ref ref = Ref.create((Object)false);
        Intrinsics.checkExpressionValueIsNotNull((Object)ref, (String)"Ref.create(false)");
        Ref isDeleted = ref;
        Integer n = ReachableNodesUtilKt.findVisibleAncestorRow(commitId, visibleLinearGraph, permanentGraphInfo, (Function1<? super Integer, Boolean>)((Function1)new Function1<Integer, Boolean>(this, permanentGraphInfo, existing, deleted, isDeleted){
            final /* synthetic */ FileHistoryBuilder this$0;
            final /* synthetic */ PermanentGraphInfo $permanentGraphInfo;
            final /* synthetic */ MaybeDeletedFilePath $existing;
            final /* synthetic */ MaybeDeletedFilePath $deleted;
            final /* synthetic */ Ref $isDeleted;

            public final boolean invoke(int nodeId) {
                boolean bl;
                CommitId CommitId2 = this.$permanentGraphInfo.getPermanentCommitsInfo().getCommitId(nodeId);
                Intrinsics.checkExpressionValueIsNotNull(CommitId2, (String)"permanentGraphInfo.perma\u2026sInfo.getCommitId(nodeId)");
                int id = ((Number)CommitId2).intValue();
                if (FileHistoryData.affects$default(FileHistoryBuilder.access$getFileHistoryData$p(this.this$0), id, this.$existing, false, 4, null)) {
                    bl = true;
                } else if (FileHistoryData.affects$default(FileHistoryBuilder.access$getFileHistoryData$p(this.this$0), id, this.$deleted, false, 4, null)) {
                    this.$isDeleted.set((Object)true);
                    bl = true;
                } else {
                    bl = false;
                }
                return bl;
            }
            {
                this.this$0 = fileHistoryBuilder;
                this.$permanentGraphInfo = permanentGraphInfo;
                this.$existing = maybeDeletedFilePath;
                this.$deleted = maybeDeletedFilePath2;
                this.$isDeleted = ref;
                super(1);
            }
        }));
        int row2 = n != null ? n : -1;
        Integer n2 = row2;
        Object object = isDeleted.get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"isDeleted.get()");
        return new Pair((Object)n2, (Object)((Boolean)object != false ? deleted : existing));
    }

    public FileHistoryBuilder(@Nullable Integer startCommit, @NotNull FilePath startPath, @NotNull FileHistoryData fileHistoryData, @NotNull FileHistory oldFileHistory, @NotNull Set<Integer> commitsToHide) {
        Intrinsics.checkParameterIsNotNull((Object)startPath, (String)"startPath");
        Intrinsics.checkParameterIsNotNull((Object)fileHistoryData, (String)"fileHistoryData");
        Intrinsics.checkParameterIsNotNull((Object)oldFileHistory, (String)"oldFileHistory");
        Intrinsics.checkParameterIsNotNull(commitsToHide, (String)"commitsToHide");
        this.startCommit = startCommit;
        this.startPath = startPath;
        this.fileHistoryData = fileHistoryData;
        this.oldFileHistory = oldFileHistory;
        this.commitsToHide = commitsToHide;
        FileHistoryBuilder fileHistoryBuilder = this;
        boolean bl = false;
        Object object = new LinkedHashMap();
        fileHistoryBuilder.pathsMap = object;
        fileHistoryBuilder = this;
        bl = false;
        fileHistoryBuilder.processedAdditionsDeletions = object = (Set)new LinkedHashSet();
        fileHistoryBuilder = this;
        bl = false;
        fileHistoryBuilder.unmatchedAdditionsDeletions = object = (Set)new LinkedHashSet();
        MultiMap multiMap = MultiMap.createSmart();
        Intrinsics.checkExpressionValueIsNotNull((Object)multiMap, (String)"MultiMap.createSmart<UnorderedPair<Int>, Rename>()");
        this.commitToRename = multiMap;
    }

    public /* synthetic */ FileHistoryBuilder(Integer n, FilePath filePath, FileHistoryData fileHistoryData, FileHistory fileHistory, Set set, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 0x10) != 0) {
            set = SetsKt.emptySet();
        }
        this(n, filePath, fileHistoryData, fileHistory, set);
    }

    static {
        Companion = new Companion(null);
        Logger logger = Logger.getInstance(FileHistoryBuilder.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(FileHistoryBuilder::class.java)");
        LOG = logger;
    }

    public static final /* synthetic */ void access$reportTrivialMerges(FileHistoryBuilder $this, Set trivialMerges2) {
        $this.reportTrivialMerges(trivialMerges2);
    }

    public static final /* synthetic */ Set access$getProcessedAdditionsDeletions$p(FileHistoryBuilder $this) {
        return $this.processedAdditionsDeletions;
    }

    public static final /* synthetic */ FileHistoryData access$getFileHistoryData$p(FileHistoryBuilder $this) {
        return $this.fileHistoryData;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/intellij/vcs/log/history/FileHistoryBuilder$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.platform.vcs.log.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

