/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.intelliLang.pattern;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import java.util.Set;
import org.intellij.plugins.intelliLang.Configuration;
import org.intellij.plugins.intelliLang.util.AnnotateFix;
import org.intellij.plugins.intelliLang.util.AnnotationUtilEx;
import org.intellij.plugins.intelliLang.util.PsiUtilEx;
import org.jetbrains.annotations.NotNull;

public class PatternOverriddenByNonAnnotatedMethod
extends LocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PatternOverriddenByNonAnnotatedMethod.$$$reportNull$$$0(0);
        }
        JavaElementVisitor javaElementVisitor = new JavaElementVisitor(){
            final Pair<String, ? extends Set<String>> annotationName;
            {
                this.annotationName = Configuration.getProjectInstance(holder.getProject()).getAdvancedConfiguration().getPatternAnnotationPair();
            }

            public void visitMethod(PsiMethod method) {
                PsiAnnotation[] annotationFromHierarchy;
                PsiIdentifier psiIdentifier = method.getNameIdentifier();
                if (psiIdentifier == null || !PsiUtilEx.isLanguageAnnotationTarget((PsiModifierListOwner)method)) {
                    return;
                }
                PsiAnnotation[] annotationFrom = AnnotationUtilEx.getAnnotationFrom((PsiModifierListOwner)method, this.annotationName, true, false);
                if (annotationFrom.length == 0 && (annotationFromHierarchy = AnnotationUtilEx.getAnnotationFrom((PsiModifierListOwner)method, this.annotationName, true, true)).length > 0) {
                    String annotationClassname = annotationFromHierarchy[annotationFromHierarchy.length - 1].getQualifiedName();
                    String argList = annotationFromHierarchy[annotationFromHierarchy.length - 1].getParameterList().getText();
                    holder.registerProblem((PsiElement)psiIdentifier, "Non-annotated Method overrides @Pattern Method", new LocalQuickFix[]{new AnnotateFix(annotationClassname, argList)});
                }
            }
        };
        if (javaElementVisitor == null) {
            PatternOverriddenByNonAnnotatedMethod.$$$reportNull$$$0(1);
        }
        return javaElementVisitor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/plugins/intelliLang/pattern/PatternOverriddenByNonAnnotatedMethod";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/plugins/intelliLang/pattern/PatternOverriddenByNonAnnotatedMethod";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

