/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.breakpoints;

import com.intellij.configurationStore.XmlSerializer;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.MultiValuesMap;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.ex.http.HttpFileSystem;
import com.intellij.util.EventDispatcher;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xdebugger.XDebuggerUtil;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XBreakpointListener;
import com.intellij.xdebugger.breakpoints.XBreakpointManager;
import com.intellij.xdebugger.breakpoints.XBreakpointProperties;
import com.intellij.xdebugger.breakpoints.XBreakpointType;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import com.intellij.xdebugger.breakpoints.XLineBreakpointType;
import com.intellij.xdebugger.impl.BreakpointManagerState;
import com.intellij.xdebugger.impl.XDebuggerManagerImpl;
import com.intellij.xdebugger.impl.breakpoints.BreakpointState;
import com.intellij.xdebugger.impl.breakpoints.BreakpointsUsageCollector;
import com.intellij.xdebugger.impl.breakpoints.CustomizedBreakpointPresentation;
import com.intellij.xdebugger.impl.breakpoints.LineBreakpointState;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointBase;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointUtil;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointsDialogState;
import com.intellij.xdebugger.impl.breakpoints.XDependentBreakpointManager;
import com.intellij.xdebugger.impl.breakpoints.XLineBreakpointImpl;
import com.intellij.xdebugger.impl.breakpoints.XLineBreakpointManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.Icon;
import one.util.streamex.StreamEx;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XBreakpointManagerImpl
implements XBreakpointManager {
    private static final Logger LOG = Logger.getInstance(XBreakpointManagerImpl.class);
    private final MultiValuesMap<XBreakpointType, XBreakpointBase<?, ?, ?>> myBreakpoints = new MultiValuesMap(true);
    private final Map<XBreakpointType, Set<XBreakpointBase<?, ?, ?>>> myDefaultBreakpoints = new LinkedHashMap();
    private final Map<XBreakpointType, BreakpointState<?, ?, ?>> myBreakpointsDefaults = new LinkedHashMap();
    private final Set<XBreakpointBase<?, ?, ?>> myAllBreakpoints = new LinkedHashSet();
    private final Map<XBreakpointType, EventDispatcher<XBreakpointListener>> myDispatchers = new HashMap<XBreakpointType, EventDispatcher<XBreakpointListener>>();
    private XBreakpointsDialogState myBreakpointsDialogSettings;
    private volatile EventDispatcher<XBreakpointListener> myAllBreakpointsDispatcher;
    private final XLineBreakpointManager myLineBreakpointManager;
    private final Project myProject;
    private final XDebuggerManagerImpl myDebuggerManager;
    private final XDependentBreakpointManager myDependentBreakpointManager;
    private long myTime;
    private String myDefaultGroup;
    private RemovedBreakpointData myLastRemovedBreakpoint = null;

    public XBreakpointManagerImpl(Project project, XDebuggerManagerImpl debuggerManager) {
        this.myProject = project;
        this.myDebuggerManager = debuggerManager;
        this.myDependentBreakpointManager = new XDependentBreakpointManager(this);
        this.myLineBreakpointManager = new XLineBreakpointManager(project);
        if (!project.isDefault()) {
            if (!ApplicationManager.getApplication().isUnitTestMode()) {
                HttpFileSystem.getInstance().addFileListener(this::updateBreakpointInFile, (Disposable)project);
            }
            XBreakpointUtil.breakpointTypes().forEach(this::addDefaultBreakpoint);
        }
        this.myProject.getMessageBus().connect().subscribe(XBreakpointListener.TOPIC, (Object)new XBreakpointListener(){

            public void breakpointAdded(@NotNull XBreakpoint breakpoint) {
                if (breakpoint == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (XBreakpointManagerImpl.this.myAllBreakpointsDispatcher != null) {
                    ((XBreakpointListener)XBreakpointManagerImpl.this.myAllBreakpointsDispatcher.getMulticaster()).breakpointAdded(breakpoint);
                }
            }

            public void breakpointRemoved(@NotNull XBreakpoint breakpoint) {
                if (breakpoint == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (XBreakpointManagerImpl.this.myAllBreakpointsDispatcher != null) {
                    ((XBreakpointListener)XBreakpointManagerImpl.this.myAllBreakpointsDispatcher.getMulticaster()).breakpointRemoved(breakpoint);
                }
            }

            public void breakpointChanged(@NotNull XBreakpoint breakpoint) {
                if (breakpoint == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (XBreakpointManagerImpl.this.myAllBreakpointsDispatcher != null) {
                    ((XBreakpointListener)XBreakpointManagerImpl.this.myAllBreakpointsDispatcher.getMulticaster()).breakpointChanged(breakpoint);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "breakpoint";
                objectArray2[1] = "com/intellij/xdebugger/impl/breakpoints/XBreakpointManagerImpl$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "breakpointAdded";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "breakpointRemoved";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "breakpointChanged";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    private void updateBreakpointInFile(VirtualFile file2) {
        ApplicationManager.getApplication().invokeLater(() -> {
            for (XBreakpointBase<?, ?, ?> breakpoint : this.getAllBreakpoints()) {
                XSourcePosition position = breakpoint.getSourcePosition();
                if (position == null || !Comparing.equal((Object)position.getFile(), (Object)file2)) continue;
                this.fireBreakpointChanged(breakpoint);
            }
        }, this.myProject.getDisposed());
    }

    public XLineBreakpointManager getLineBreakpointManager() {
        return this.myLineBreakpointManager;
    }

    public XDependentBreakpointManager getDependentBreakpointManager() {
        return this.myDependentBreakpointManager;
    }

    public XDebuggerManagerImpl getDebuggerManager() {
        return this.myDebuggerManager;
    }

    public Project getProject() {
        return this.myProject;
    }

    @NotNull
    public <T extends XBreakpointProperties> XBreakpoint<T> addBreakpoint(XBreakpointType<XBreakpoint<T>, T> type, @Nullable T properties) {
        XBreakpoint<T> xBreakpoint = this.doAddBreakpoint(type, properties, false);
        if (xBreakpoint == null) {
            XBreakpointManagerImpl.$$$reportNull$$$0(0);
        }
        return xBreakpoint;
    }

    @NotNull
    public <T extends XBreakpointProperties> XBreakpoint<T> addDefaultBreakpoint(XBreakpointType<XBreakpoint<T>, T> type, @Nullable T properties) {
        XBreakpoint<T> xBreakpoint = this.doAddBreakpoint(type, properties, true);
        if (xBreakpoint == null) {
            XBreakpointManagerImpl.$$$reportNull$$$0(1);
        }
        return xBreakpoint;
    }

    @NotNull
    private <T extends XBreakpointProperties> XBreakpoint<T> doAddBreakpoint(XBreakpointType<XBreakpoint<T>, T> type, @Nullable T properties, boolean defaultBreakpoint) {
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        XBreakpointBase<?, T, ?> breakpoint = this.createBreakpoint(type, properties, true, defaultBreakpoint);
        this.addBreakpoint(breakpoint, defaultBreakpoint, true);
        XBreakpointBase<?, T, ?> xBreakpointBase = breakpoint;
        if (xBreakpointBase == null) {
            XBreakpointManagerImpl.$$$reportNull$$$0(2);
        }
        return xBreakpointBase;
    }

    private <T extends XBreakpointProperties> XBreakpointBase<?, T, ?> createBreakpoint(XBreakpointType<XBreakpoint<T>, T> type, T properties, boolean enabled, boolean defaultBreakpoint) {
        BreakpointState state = new BreakpointState(enabled, type.getId(), defaultBreakpoint ? 0L : (this.myTime = this.myTime + 1L), type.getDefaultSuspendPolicy());
        this.getBreakpointDefaults(type).applyDefaults(state);
        state.setGroup(this.myDefaultGroup);
        return new XBreakpointBase(type, this, properties, state);
    }

    private <T extends XBreakpointProperties> void addBreakpoint(XBreakpointBase<?, T, ?> breakpoint, boolean defaultBreakpoint, boolean initUI) {
        EventDispatcher<XBreakpointListener> dispatcher;
        XBreakpointType<?, T> type = breakpoint.getType();
        if (defaultBreakpoint) {
            Set typeDefaultBreakpoints = this.myDefaultBreakpoints.computeIfAbsent(type, k -> new LinkedHashSet());
            typeDefaultBreakpoints.add(breakpoint);
        } else {
            this.myBreakpoints.put(type, breakpoint);
            if (initUI) {
                BreakpointsUsageCollector.reportNewBreakpoint(breakpoint, type, this.getDebuggerManager().getCurrentSession() != null);
            }
        }
        this.myAllBreakpoints.add(breakpoint);
        if (breakpoint instanceof XLineBreakpointImpl) {
            this.myLineBreakpointManager.registerBreakpoint((XLineBreakpointImpl)breakpoint, initUI);
        }
        if ((dispatcher = this.myDispatchers.get(type)) != null) {
            ((XBreakpointListener)dispatcher.getMulticaster()).breakpointAdded(breakpoint);
        }
        this.getBreakpointDispatcherMulticaster().breakpointAdded(breakpoint);
    }

    @NotNull
    private XBreakpointListener<XBreakpoint<?>> getBreakpointDispatcherMulticaster() {
        XBreakpointListener xBreakpointListener = (XBreakpointListener)this.myProject.getMessageBus().syncPublisher(XBreakpointListener.TOPIC);
        if (xBreakpointListener == null) {
            XBreakpointManagerImpl.$$$reportNull$$$0(3);
        }
        return xBreakpointListener;
    }

    public void fireBreakpointChanged(XBreakpointBase<?, ?, ?> breakpoint) {
        EventDispatcher<XBreakpointListener> dispatcher;
        if (!this.myAllBreakpoints.contains(breakpoint)) {
            return;
        }
        if (breakpoint instanceof XLineBreakpointImpl) {
            this.myLineBreakpointManager.breakpointChanged((XLineBreakpointImpl)breakpoint);
        }
        if ((dispatcher = this.myDispatchers.get(breakpoint.getType())) != null) {
            ((XBreakpointListener)dispatcher.getMulticaster()).breakpointChanged(breakpoint);
        }
        this.getBreakpointDispatcherMulticaster().breakpointChanged(breakpoint);
    }

    public void removeBreakpoint(@NotNull XBreakpoint<?> breakpoint) {
        if (breakpoint == null) {
            XBreakpointManagerImpl.$$$reportNull$$$0(4);
        }
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        this.doRemoveBreakpoint(breakpoint);
    }

    public void removeDefaultBreakpoint(@NotNull XBreakpoint<?> breakpoint) {
        if (breakpoint == null) {
            XBreakpointManagerImpl.$$$reportNull$$$0(5);
        }
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        if (!this.isDefaultBreakpoint(breakpoint)) {
            throw new IllegalStateException("Trying to remove not default breakpoint " + breakpoint);
        }
        this.doRemoveBreakpointImpl(breakpoint);
    }

    private void doRemoveBreakpoint(XBreakpoint<?> breakpoint) {
        if (this.isDefaultBreakpoint(breakpoint)) {
            breakpoint.setEnabled(false);
        } else {
            this.doRemoveBreakpointImpl(breakpoint);
        }
    }

    private void doRemoveBreakpointImpl(XBreakpoint<?> breakpoint) {
        XBreakpointType type = breakpoint.getType();
        XBreakpointBase breakpointBase = (XBreakpointBase)breakpoint;
        this.myBreakpoints.remove((Object)type, (Object)breakpointBase);
        this.myAllBreakpoints.remove(breakpointBase);
        if (breakpointBase instanceof XLineBreakpointImpl) {
            this.myLineBreakpointManager.unregisterBreakpoint((XLineBreakpointImpl)breakpointBase);
        }
        breakpointBase.dispose();
        EventDispatcher<XBreakpointListener> dispatcher = this.myDispatchers.get(type);
        if (dispatcher != null) {
            ((XBreakpointListener)dispatcher.getMulticaster()).breakpointRemoved(breakpoint);
        }
        this.getBreakpointDispatcherMulticaster().breakpointRemoved(breakpoint);
    }

    @NotNull
    public <T extends XBreakpointProperties> XLineBreakpoint<T> addLineBreakpoint(XLineBreakpointType<T> type, @NotNull String fileUrl, int line2, @Nullable T properties) {
        if (fileUrl == null) {
            XBreakpointManagerImpl.$$$reportNull$$$0(6);
        }
        XLineBreakpoint<T> xLineBreakpoint = this.addLineBreakpoint(type, fileUrl, line2, properties, false);
        if (xLineBreakpoint == null) {
            XBreakpointManagerImpl.$$$reportNull$$$0(7);
        }
        return xLineBreakpoint;
    }

    @NotNull
    public <T extends XBreakpointProperties> XLineBreakpoint<T> addLineBreakpoint(XLineBreakpointType<T> type, @NotNull String fileUrl, int line2, @Nullable T properties, boolean temporary) {
        if (fileUrl == null) {
            XBreakpointManagerImpl.$$$reportNull$$$0(8);
        }
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        LineBreakpointState state = new LineBreakpointState(true, type.getId(), fileUrl, line2, temporary, ++this.myTime, type.getDefaultSuspendPolicy());
        this.getBreakpointDefaults((XBreakpointType)type).applyDefaults(state);
        state.setGroup(this.myDefaultGroup);
        XLineBreakpointImpl<T> breakpoint = new XLineBreakpointImpl<T>(type, this, properties, state);
        this.addBreakpoint(breakpoint, false, true);
        XLineBreakpointImpl<T> xLineBreakpointImpl = breakpoint;
        if (xLineBreakpointImpl == null) {
            XBreakpointManagerImpl.$$$reportNull$$$0(9);
        }
        return xLineBreakpointImpl;
    }

    @NotNull
    public XBreakpointBase<?, ?, ?>[] getAllBreakpoints() {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        XBreakpointBase[] xBreakpointBaseArray = this.myAllBreakpoints.toArray(new XBreakpointBase[0]);
        if (xBreakpointBaseArray == null) {
            XBreakpointManagerImpl.$$$reportNull$$$0(10);
        }
        return xBreakpointBaseArray;
    }

    @NotNull
    public <B extends XBreakpoint<?>> Collection<? extends B> getBreakpoints(@NotNull XBreakpointType<B, ?> type) {
        if (type == null) {
            XBreakpointManagerImpl.$$$reportNull$$$0(11);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        Set<B> defaultBreakpoints = this.getDefaultBreakpoints(type);
        ArrayList<B> result2 = new ArrayList<B>(defaultBreakpoints);
        Collection breakpoints = this.myBreakpoints.get(type);
        if (breakpoints != null) {
            result2.addAll(breakpoints);
        }
        List<B> list2 = Collections.unmodifiableList(result2);
        if (list2 == null) {
            XBreakpointManagerImpl.$$$reportNull$$$0(12);
        }
        return list2;
    }

    @NotNull
    public <B extends XBreakpoint<?>> Collection<? extends B> getBreakpoints(@NotNull Class<? extends XBreakpointType<B, ?>> typeClass) {
        XBreakpointType type;
        if (typeClass == null) {
            XBreakpointManagerImpl.$$$reportNull$$$0(13);
        }
        LOG.assertTrue((type = XDebuggerUtil.getInstance().findBreakpointType(typeClass)) != null, (Object)("Unregistered breakpoint type " + typeClass + ", registered: " + Arrays.toString(XBreakpointType.EXTENSION_POINT_NAME.getExtensions())));
        Collection<B> collection = this.getBreakpoints(type);
        if (collection == null) {
            XBreakpointManagerImpl.$$$reportNull$$$0(14);
        }
        return collection;
    }

    @Nullable
    public <B extends XBreakpoint<?>> B getDefaultBreakpoint(@NotNull XBreakpointType<B, ?> type) {
        if (type == null) {
            XBreakpointManagerImpl.$$$reportNull$$$0(15);
        }
        Set<B> defaultBreakpoints = this.getDefaultBreakpoints(type);
        return (B)((XBreakpoint)ContainerUtil.getFirstItem(defaultBreakpoints));
    }

    @NotNull
    public <B extends XBreakpoint<?>> Set<B> getDefaultBreakpoints(@NotNull XBreakpointType<B, ?> type) {
        Set<XBreakpointBase<?, ?, ?>> breakpointsSet;
        if (type == null) {
            XBreakpointManagerImpl.$$$reportNull$$$0(16);
        }
        if ((breakpointsSet = this.myDefaultBreakpoints.get(type)) == null) {
            Set set = Collections.emptySet();
            if (set == null) {
                XBreakpointManagerImpl.$$$reportNull$$$0(17);
            }
            return set;
        }
        Set set = breakpointsSet.stream().map(breakpoint -> breakpoint).collect(Collectors.toSet());
        if (set == null) {
            XBreakpointManagerImpl.$$$reportNull$$$0(18);
        }
        return set;
    }

    @Nullable
    public <P extends XBreakpointProperties> XLineBreakpoint<P> findBreakpointAtLine(@NotNull XLineBreakpointType<P> type, @NotNull VirtualFile file2, int line2) {
        if (type == null) {
            XBreakpointManagerImpl.$$$reportNull$$$0(19);
        }
        if (file2 == null) {
            XBreakpointManagerImpl.$$$reportNull$$$0(20);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        Collection breakpoints = this.myBreakpoints.get(type);
        if (breakpoints == null) {
            return null;
        }
        for (XBreakpointBase breakpoint : breakpoints) {
            XLineBreakpoint lineBreakpoint = (XLineBreakpoint)breakpoint;
            if (!lineBreakpoint.getFileUrl().equals(file2.getUrl()) || lineBreakpoint.getLine() != line2) continue;
            return lineBreakpoint;
        }
        return null;
    }

    public boolean isDefaultBreakpoint(@NotNull XBreakpoint<?> breakpoint) {
        if (breakpoint == null) {
            XBreakpointManagerImpl.$$$reportNull$$$0(21);
        }
        return this.myDefaultBreakpoints.values().stream().anyMatch(s -> s.contains(breakpoint));
    }

    private <T extends XBreakpointProperties> EventDispatcher<XBreakpointListener> getOrCreateDispatcher(XBreakpointType<?, T> type) {
        return this.myDispatchers.computeIfAbsent(type, k -> EventDispatcher.create(XBreakpointListener.class));
    }

    public <B extends XBreakpoint<P>, P extends XBreakpointProperties> void addBreakpointListener(@NotNull XBreakpointType<B, P> type, @NotNull XBreakpointListener<B> listener2) {
        if (type == null) {
            XBreakpointManagerImpl.$$$reportNull$$$0(22);
        }
        if (listener2 == null) {
            XBreakpointManagerImpl.$$$reportNull$$$0(23);
        }
        this.getOrCreateDispatcher(type).addListener(listener2);
    }

    public <B extends XBreakpoint<P>, P extends XBreakpointProperties> void removeBreakpointListener(@NotNull XBreakpointType<B, P> type, @NotNull XBreakpointListener<B> listener2) {
        if (type == null) {
            XBreakpointManagerImpl.$$$reportNull$$$0(24);
        }
        if (listener2 == null) {
            XBreakpointManagerImpl.$$$reportNull$$$0(25);
        }
        this.getOrCreateDispatcher(type).removeListener(listener2);
    }

    public <B extends XBreakpoint<P>, P extends XBreakpointProperties> void addBreakpointListener(@NotNull XBreakpointType<B, P> type, @NotNull XBreakpointListener<B> listener2, Disposable parentDisposable) {
        if (type == null) {
            XBreakpointManagerImpl.$$$reportNull$$$0(26);
        }
        if (listener2 == null) {
            XBreakpointManagerImpl.$$$reportNull$$$0(27);
        }
        this.getOrCreateDispatcher(type).addListener(listener2, parentDisposable);
    }

    public void addBreakpointListener(@NotNull XBreakpointListener<XBreakpoint<?>> listener2, @NotNull Disposable parentDisposable) {
        if (listener2 == null) {
            XBreakpointManagerImpl.$$$reportNull$$$0(28);
        }
        if (parentDisposable == null) {
            XBreakpointManagerImpl.$$$reportNull$$$0(29);
        }
        this.myProject.getMessageBus().connect(parentDisposable).subscribe(XBreakpointListener.TOPIC, listener2);
    }

    public void addBreakpointListener(@NotNull XBreakpointListener<XBreakpoint<?>> listener2) {
        if (listener2 == null) {
            XBreakpointManagerImpl.$$$reportNull$$$0(30);
        }
        this.getDispatcher().addListener(listener2);
    }

    public void removeBreakpointListener(@NotNull XBreakpointListener<XBreakpoint<?>> listener2) {
        if (listener2 == null) {
            XBreakpointManagerImpl.$$$reportNull$$$0(31);
        }
        this.getDispatcher().removeListener(listener2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EventDispatcher<XBreakpointListener> getDispatcher() {
        Map<XBreakpointType, EventDispatcher<XBreakpointListener>> map2 = this.myDispatchers;
        synchronized (map2) {
            if (this.myAllBreakpointsDispatcher == null) {
                this.myAllBreakpointsDispatcher = EventDispatcher.create(XBreakpointListener.class);
            }
            return this.myAllBreakpointsDispatcher;
        }
    }

    public void updateBreakpointPresentation(@NotNull XLineBreakpoint<?> breakpoint, @Nullable Icon icon, @Nullable String errorMessage) {
        XLineBreakpointImpl lineBreakpoint;
        CustomizedBreakpointPresentation presentation;
        if (breakpoint == null) {
            XBreakpointManagerImpl.$$$reportNull$$$0(32);
        }
        if ((presentation = (lineBreakpoint = (XLineBreakpointImpl)breakpoint).getCustomizedPresentation()) == null) {
            if (icon == null && errorMessage == null) {
                return;
            }
            presentation = new CustomizedBreakpointPresentation();
        } else if (Comparing.equal((Object)presentation.getIcon(), (Object)icon) && Comparing.strEqual((String)presentation.getErrorMessage(), (String)errorMessage)) {
            return;
        }
        presentation.setErrorMessage(errorMessage);
        presentation.setIcon(icon);
        lineBreakpoint.setCustomizedPresentation(presentation);
        this.myLineBreakpointManager.queueBreakpointUpdate((XBreakpoint<?>)breakpoint);
    }

    @NotNull
    public BreakpointManagerState saveState(@NotNull BreakpointManagerState state) {
        if (state == null) {
            XBreakpointManagerImpl.$$$reportNull$$$0(33);
        }
        this.myDependentBreakpointManager.saveState();
        SmartList defaultBreakpoints = new SmartList();
        for (Set<XBreakpointBase<?, ?, ?>> typeDefaultBreakpoints : this.myDefaultBreakpoints.values()) {
            if (typeDefaultBreakpoints.stream().noneMatch(breakpoint -> this.differsFromDefault(breakpoint.getType(), (BreakpointState)breakpoint.getState()))) continue;
            for (XBreakpointBase xBreakpointBase : typeDefaultBreakpoints) {
                Object breakpointState = xBreakpointBase.getState();
                defaultBreakpoints.add(breakpointState);
            }
        }
        SmartList breakpoints = new SmartList();
        for (XBreakpointBase breakpoint3 : this.myBreakpoints.values()) {
            breakpoints.add(breakpoint3.getState());
        }
        SmartList breakpointsDefaults = new SmartList();
        for (Map.Entry entry : this.myBreakpointsDefaults.entrySet()) {
            if (!XBreakpointManagerImpl.statesAreDifferent((BreakpointState)entry.getValue(), XBreakpointManagerImpl.createBreakpointDefaults((XBreakpointType)entry.getKey()), false)) continue;
            breakpointsDefaults.add(entry.getValue());
        }
        state.setDefaultBreakpoints((List<BreakpointState<?, ?, ?>>)defaultBreakpoints);
        state.setBreakpoints((List<BreakpointState<?, ?, ?>>)breakpoints);
        state.setBreakpointsDefaults((List<BreakpointState<?, ?, ?>>)breakpointsDefaults);
        state.setBreakpointsDialogProperties(this.myBreakpointsDialogSettings);
        state.setDefaultGroup(this.myDefaultGroup);
        BreakpointManagerState breakpointManagerState = state;
        if (breakpointManagerState == null) {
            XBreakpointManagerImpl.$$$reportNull$$$0(34);
        }
        return breakpointManagerState;
    }

    private <P extends XBreakpointProperties> boolean differsFromDefault(XBreakpointType<?, P> type, BreakpointState state) {
        XBreakpoint<P> defaultBreakpoint = this.createDefaultBreakpoint(type);
        if (defaultBreakpoint == null) {
            return false;
        }
        Object defaultState = ((XBreakpointBase)defaultBreakpoint).getState();
        return XBreakpointManagerImpl.statesAreDifferent(state, defaultState, false);
    }

    public static boolean statesAreDifferent(BreakpointState state1, BreakpointState state2, boolean ignoreTimestamp) {
        Element elem2;
        Element elem1;
        boolean res2;
        long timeStamp1 = state1.getTimeStamp();
        long timeStamp2 = state2.getTimeStamp();
        if (ignoreTimestamp) {
            state1.setTimeStamp(timeStamp2);
        }
        boolean bl = res2 = !JDOMUtil.areElementsEqual((Element)(elem1 = XmlSerializer.serialize((Object)state1)), (Element)(elem2 = XmlSerializer.serialize((Object)state2)));
        if (ignoreTimestamp) {
            state1.setTimeStamp(timeStamp1);
        }
        return res2;
    }

    public void loadState(@NotNull BreakpointManagerState state) {
        if (state == null) {
            XBreakpointManagerImpl.$$$reportNull$$$0(35);
        }
        this.myBreakpointsDialogSettings = state.getBreakpointsDialogProperties();
        this.myAllBreakpoints.clear();
        this.myDefaultBreakpoints.clear();
        this.myBreakpointsDefaults.clear();
        ApplicationManager.getApplication().runReadAction(() -> {
            ContainerUtil.notNullize(state.getDefaultBreakpoints()).forEach(breakpointState -> this.loadBreakpoint((BreakpointState)breakpointState, true));
            ((StreamEx)XBreakpointUtil.breakpointTypes().remove(this.myDefaultBreakpoints::containsKey)).forEach(this::addDefaultBreakpoint);
            this.myBreakpoints.values().forEach(this::doRemoveBreakpoint);
            ContainerUtil.notNullize(state.getBreakpoints()).forEach(breakpointState -> this.loadBreakpoint((BreakpointState)breakpointState, false));
            for (BreakpointState defaults : ContainerUtil.notNullize(state.getBreakpointsDefaults())) {
                XBreakpointType<?, ?> type = XBreakpointUtil.findType(defaults.getTypeId());
                if (type != null) {
                    this.myBreakpointsDefaults.put(type, defaults);
                    continue;
                }
                LOG.warn("Unknown breakpoint type " + defaults.getTypeId());
            }
            this.myDependentBreakpointManager.loadState();
        });
        this.myLineBreakpointManager.updateBreakpointsUI();
        this.myDefaultGroup = state.getDefaultGroup();
    }

    private <P extends XBreakpointProperties> void addDefaultBreakpoint(XBreakpointType<?, P> type) {
        XBreakpoint<P> breakpoint = this.createDefaultBreakpoint(type);
        if (breakpoint != null) {
            this.addBreakpoint((XBreakpointBase)breakpoint, true, false);
        }
    }

    @Nullable
    private <P extends XBreakpointProperties> XBreakpoint<P> createDefaultBreakpoint(XBreakpointType<? extends XBreakpoint<P>, P> type) {
        return type.createDefaultBreakpoint(properties -> this.createBreakpoint(type, properties, false, true));
    }

    private void loadBreakpoint(BreakpointState breakpointState, boolean defaultBreakpoint) {
        XBreakpointBase<?, ?, ?> breakpoint = this.createBreakpoint(breakpointState);
        if (breakpoint != null) {
            this.addBreakpoint(breakpoint, defaultBreakpoint, false);
        }
        this.myTime = Math.max(this.myTime, breakpointState.getTimeStamp());
    }

    public XBreakpointsDialogState getBreakpointsDialogSettings() {
        return this.myBreakpointsDialogSettings;
    }

    public void setBreakpointsDialogSettings(XBreakpointsDialogState breakpointsDialogSettings) {
        this.myBreakpointsDialogSettings = breakpointsDialogSettings;
    }

    public Set<String> getAllGroups() {
        return StreamEx.of(this.myAllBreakpoints).map(XBreakpointBase::getGroup).nonNull().toSet();
    }

    public String getDefaultGroup() {
        return this.myDefaultGroup;
    }

    public void setDefaultGroup(String defaultGroup) {
        this.myDefaultGroup = defaultGroup;
    }

    @Nullable
    private XBreakpointBase<?, ?, ?> createBreakpoint(BreakpointState breakpointState) {
        XBreakpointType<?, ?> type = XBreakpointUtil.findType(breakpointState.getTypeId());
        if (type == null) {
            LOG.warn("Unknown breakpoint type " + breakpointState.getTypeId());
            return null;
        }
        return breakpointState.createBreakpoint(type, this);
    }

    @NotNull
    public BreakpointState getBreakpointDefaults(@NotNull XBreakpointType type) {
        if (type == null) {
            XBreakpointManagerImpl.$$$reportNull$$$0(36);
        }
        BreakpointState breakpointState = this.myBreakpointsDefaults.computeIfAbsent(type, k -> XBreakpointManagerImpl.createBreakpointDefaults(type));
        if (breakpointState == null) {
            XBreakpointManagerImpl.$$$reportNull$$$0(37);
        }
        return breakpointState;
    }

    @Nullable
    <T extends XBreakpointProperties> XLineBreakpoint<T> copyLineBreakpoint(@NotNull XLineBreakpoint<T> source, @NotNull String fileUrl, int line2) {
        if (source == null) {
            XBreakpointManagerImpl.$$$reportNull$$$0(38);
        }
        if (fileUrl == null) {
            XBreakpointManagerImpl.$$$reportNull$$$0(39);
        }
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        if (!(source instanceof XLineBreakpointImpl)) {
            return null;
        }
        this.myDependentBreakpointManager.saveState();
        LineBreakpointState sourceState = (LineBreakpointState)((XLineBreakpointImpl)source).getState();
        Element element = XmlSerializer.serialize((Object)sourceState);
        LineBreakpointState newState = element == null ? new LineBreakpointState() : (LineBreakpointState)XmlSerializer.deserialize((Element)element, LineBreakpointState.class);
        newState.setLine(line2);
        newState.setFileUrl(fileUrl);
        XLineBreakpointImpl breakpoint = (XLineBreakpointImpl)this.createBreakpoint(newState);
        if (breakpoint != null) {
            this.addBreakpoint(breakpoint, false, true);
            XBreakpoint<?> masterBreakpoint = this.myDependentBreakpointManager.getMasterBreakpoint((XBreakpoint<?>)source);
            if (masterBreakpoint != null) {
                this.myDependentBreakpointManager.setMasterBreakpoint(breakpoint, masterBreakpoint, sourceState.getDependencyState().isLeaveEnabled());
            }
        }
        return breakpoint;
    }

    @NotNull
    private static BreakpointState createBreakpointDefaults(@NotNull XBreakpointType type) {
        if (type == null) {
            XBreakpointManagerImpl.$$$reportNull$$$0(40);
        }
        BreakpointState state = new BreakpointState();
        state.setTypeId(type.getId());
        state.setSuspendPolicy(type.getDefaultSuspendPolicy());
        BreakpointState breakpointState = state;
        if (breakpointState == null) {
            XBreakpointManagerImpl.$$$reportNull$$$0(41);
        }
        return breakpointState;
    }

    public void rememberRemovedBreakpoint(@NotNull XBreakpointBase breakpoint) {
        if (breakpoint == null) {
            XBreakpointManagerImpl.$$$reportNull$$$0(42);
        }
        this.myLastRemovedBreakpoint = new RemovedBreakpointData(breakpoint);
    }

    @Nullable
    public XBreakpointBase getLastRemovedBreakpoint() {
        return this.myLastRemovedBreakpoint != null ? this.myLastRemovedBreakpoint.myBreakpoint : null;
    }

    @Nullable
    public XBreakpoint restoreLastRemovedBreakpoint() {
        if (this.myLastRemovedBreakpoint != null) {
            XBreakpoint breakpoint = this.myLastRemovedBreakpoint.restore();
            this.myLastRemovedBreakpoint = null;
            return breakpoint;
        }
        return null;
    }

    public boolean canRestoreLastRemovedBreakpoint() {
        return this.myLastRemovedBreakpoint != null && this.myLastRemovedBreakpoint.isRestorable();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 11: 
            case 13: 
            case 15: 
            case 16: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 35: 
            case 36: 
            case 38: 
            case 39: 
            case 40: 
            case 42: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 11: 
            case 13: 
            case 15: 
            case 16: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 35: 
            case 36: 
            case 38: 
            case 39: 
            case 40: 
            case 42: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/xdebugger/impl/breakpoints/XBreakpointManagerImpl";
                break;
            }
            case 4: 
            case 5: 
            case 21: 
            case 32: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "breakpoint";
                break;
            }
            case 6: 
            case 8: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileUrl";
                break;
            }
            case 11: 
            case 15: 
            case 16: 
            case 19: 
            case 22: 
            case 24: 
            case 26: 
            case 36: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeClass";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 23: 
            case 25: 
            case 27: 
            case 28: 
            case 30: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 33: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "addBreakpoint";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "addDefaultBreakpoint";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "doAddBreakpoint";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getBreakpointDispatcherMulticaster";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 11: 
            case 13: 
            case 15: 
            case 16: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 35: 
            case 36: 
            case 38: 
            case 39: 
            case 40: 
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/xdebugger/impl/breakpoints/XBreakpointManagerImpl";
                break;
            }
            case 7: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "addLineBreakpoint";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllBreakpoints";
                break;
            }
            case 12: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getBreakpoints";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultBreakpoints";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "saveState";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "getBreakpointDefaults";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "createBreakpointDefaults";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "removeBreakpoint";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "removeDefaultBreakpoint";
                break;
            }
            case 6: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addLineBreakpoint";
                break;
            }
            case 11: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getBreakpoints";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultBreakpoint";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultBreakpoints";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "findBreakpointAtLine";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "isDefaultBreakpoint";
                break;
            }
            case 22: 
            case 23: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "addBreakpointListener";
                break;
            }
            case 24: 
            case 25: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "removeBreakpointListener";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "updateBreakpointPresentation";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "saveState";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getBreakpointDefaults";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "copyLineBreakpoint";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "createBreakpointDefaults";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "rememberRemovedBreakpoint";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 11: 
            case 13: 
            case 15: 
            case 16: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 35: 
            case 36: 
            case 38: 
            case 39: 
            case 40: 
            case 42: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class RemovedBreakpointData {
        private final XBreakpointBase myBreakpoint;
        private final XDependentBreakpointManager.DependenciesData myDependenciesData;

        private RemovedBreakpointData(XBreakpointBase breakpoint) {
            if (breakpoint == null) {
                RemovedBreakpointData.$$$reportNull$$$0(0);
            }
            this.myBreakpoint = breakpoint;
            XDependentBreakpointManager xDependentBreakpointManager = XBreakpointManagerImpl.this.myDependentBreakpointManager;
            xDependentBreakpointManager.getClass();
            this.myDependenciesData = new XDependentBreakpointManager.DependenciesData(xDependentBreakpointManager, breakpoint);
        }

        boolean isRestorable() {
            return !(this.myBreakpoint instanceof XLineBreakpointImpl) || ((XLineBreakpointImpl)this.myBreakpoint).getFile() != null;
        }

        @Nullable
        XBreakpoint restore() {
            XBreakpointBase breakpoint;
            if (this.myBreakpoint instanceof XLineBreakpointImpl) {
                XLineBreakpointImpl lineBreakpoint = (XLineBreakpointImpl)this.myBreakpoint;
                VirtualFile file2 = lineBreakpoint.getFile();
                if (file2 == null) {
                    return null;
                }
                XLineBreakpoint existingBreakpoint = XBreakpointManagerImpl.this.findBreakpointAtLine(lineBreakpoint.getType(), file2, lineBreakpoint.getLine());
                if (existingBreakpoint != null) {
                    XBreakpointManagerImpl.this.removeBreakpoint((XBreakpoint<?>)existingBreakpoint);
                }
            }
            if ((breakpoint = XBreakpointManagerImpl.this.createBreakpoint(this.myBreakpoint.getState())) != null) {
                XBreakpointManagerImpl.this.addBreakpoint(breakpoint, false, true);
                this.myDependenciesData.restore(breakpoint);
                return breakpoint;
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "breakpoint", "com/intellij/xdebugger/impl/breakpoints/XBreakpointManagerImpl$RemovedBreakpointData", "<init>"));
        }
    }
}

