/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl;

import com.intellij.diff.DiffContentFactory;
import com.intellij.diff.DiffManager;
import com.intellij.diff.DiffRequestPanel;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.DocumentContent;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.requests.SimpleDiffRequest;
import com.intellij.diff.util.DiffUserDataKeys;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectLocator;
import com.intellij.openapi.ui.DialogBuilder;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.events.VFileContentChangeEvent;
import com.intellij.ui.UIBundle;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.jetbrains.annotations.NotNull;

class MemoryDiskConflictResolver {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.fileEditor.impl.MemoryDiskConflictResolver");
    private final Set<VirtualFile> myConflicts = new LinkedHashSet<VirtualFile>();
    private Throwable myConflictAppeared;

    MemoryDiskConflictResolver() {
    }

    void beforeContentChange(@NotNull VFileContentChangeEvent event) {
        long oldFileStamp;
        if (event == null) {
            MemoryDiskConflictResolver.$$$reportNull$$$0(0);
        }
        if (event.isFromSave()) {
            return;
        }
        VirtualFile file2 = event.getFile();
        if (!file2.isValid() || this.hasConflict(file2)) {
            return;
        }
        Document document = FileDocumentManager.getInstance().getCachedDocument(file2);
        if (document == null || !FileDocumentManager.getInstance().isDocumentUnsaved(document)) {
            return;
        }
        long documentStamp = document.getModificationStamp();
        if (documentStamp != (oldFileStamp = event.getOldModificationStamp())) {
            LOG.info("reload " + file2.getName() + " from disk?");
            LOG.info("  documentStamp:" + documentStamp);
            LOG.info("  oldFileStamp:" + oldFileStamp);
            if (this.myConflicts.isEmpty()) {
                if (ApplicationManager.getApplication().isUnitTestMode()) {
                    this.myConflictAppeared = new Throwable();
                }
                ApplicationManager.getApplication().invokeLater(this::processConflicts);
            }
            this.myConflicts.add(file2);
        }
    }

    boolean hasConflict(VirtualFile file2) {
        return this.myConflicts.contains(file2);
    }

    private void processConflicts() {
        ArrayList<VirtualFile> conflicts = new ArrayList<VirtualFile>(this.myConflicts);
        this.myConflicts.clear();
        for (VirtualFile file2 : conflicts) {
            Document document = FileDocumentManager.getInstance().getCachedDocument(file2);
            if (document == null || file2.getModificationStamp() == document.getModificationStamp() || !this.askReloadFromDisk(file2, document)) continue;
            FileDocumentManager.getInstance().reloadFromDisk(document);
        }
        this.myConflictAppeared = null;
    }

    boolean askReloadFromDisk(final VirtualFile file2, final Document document) {
        if (this.myConflictAppeared != null) {
            Throwable trace = this.myConflictAppeared;
            this.myConflictAppeared = null;
            throw new IllegalStateException("Unexpected memory-disk conflict in tests for " + file2.getPath() + ", please use FileDocumentManager#reloadFromDisk or avoid VFS refresh", trace);
        }
        String message = UIBundle.message((String)"file.cache.conflict.message.text", (Object[])new Object[]{file2.getPresentableUrl()});
        final DialogBuilder builder2 = new DialogBuilder();
        builder2.setCenterPanel((JComponent)new JLabel(message, Messages.getQuestionIcon(), 0));
        builder2.addOkAction().setText(UIBundle.message((String)"file.cache.conflict.load.fs.changes.button", (Object[])new Object[0]));
        builder2.addCancelAction().setText(UIBundle.message((String)"file.cache.conflict.keep.memory.changes.button", (Object[])new Object[0]));
        builder2.addAction((Action)new AbstractAction(UIBundle.message((String)"file.cache.conflict.show.difference.button", (Object[])new Object[0])){

            @Override
            public void actionPerformed(ActionEvent e) {
                Project project = ProjectLocator.getInstance().guessProjectForFile(file2);
                String fsContent = LoadTextUtil.loadText(file2).toString();
                DocumentContent content1 = DiffContentFactory.getInstance().create(project, fsContent, file2.getFileType());
                DocumentContent content2 = DiffContentFactory.getInstance().create(project, document, file2);
                String title = UIBundle.message((String)"file.cache.conflict.for.file.dialog.title", (Object[])new Object[]{file2.getPresentableUrl()});
                String title1 = UIBundle.message((String)"file.cache.conflict.diff.content.file.system.content", (Object[])new Object[0]);
                String title2 = UIBundle.message((String)"file.cache.conflict.diff.content.memory.content", (Object[])new Object[0]);
                SimpleDiffRequest request = new SimpleDiffRequest(title, (DiffContent)content1, (DiffContent)content2, title1, title2);
                request.putUserData(DiffUserDataKeys.GO_TO_SOURCE_DISABLE, (Object)true);
                DialogBuilder diffBuilder = new DialogBuilder(project);
                DiffRequestPanel diffPanel = DiffManager.getInstance().createRequestPanel(project, (Disposable)diffBuilder, diffBuilder.getWindow());
                diffPanel.setRequest((DiffRequest)request);
                diffBuilder.setCenterPanel(diffPanel.getComponent());
                diffBuilder.setDimensionServiceKey("FileDocumentManager.FileCacheConflict");
                diffBuilder.addOkAction().setText(UIBundle.message((String)"file.cache.conflict.save.changes.button", (Object[])new Object[0]));
                diffBuilder.addCancelAction();
                diffBuilder.setTitle(title);
                if (diffBuilder.show() == 0) {
                    builder2.getDialogWrapper().close(1);
                }
            }
        });
        builder2.setTitle(UIBundle.message((String)"file.cache.conflict.dialog.title", (Object[])new Object[0]));
        builder2.setButtonsAlignment(0);
        builder2.setHelpId("reference.dialogs.fileCacheConflict");
        return builder2.show() == 0;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/fileEditor/impl/MemoryDiskConflictResolver", "beforeContentChange"));
    }
}

