/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.plugins.AvailablePluginsTableModel;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.InstallPluginAction;
import com.intellij.ide.plugins.InstalledPluginsState;
import com.intellij.ide.plugins.PluginHostsConfigurable;
import com.intellij.ide.plugins.PluginManagerColumnInfo;
import com.intellij.ide.plugins.PluginManagerMain;
import com.intellij.ide.plugins.PluginManagerUISettings;
import com.intellij.ide.plugins.PluginNode;
import com.intellij.ide.plugins.PluginTable;
import com.intellij.ide.plugins.sorters.SortByDownloadsAction;
import com.intellij.ide.plugins.sorters.SortByRatingAction;
import com.intellij.ide.plugins.sorters.SortByUpdatedAction;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.ex.ComboBoxAction;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.updateSettings.impl.UpdateSettings;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.TableUtil;
import com.intellij.util.net.HttpConfigurable;
import com.intellij.util.ui.update.UiNotifyConnector;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.util.List;
import java.util.TreeSet;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import org.jetbrains.annotations.NotNull;

public class AvailablePluginsManagerMain
extends PluginManagerMain {
    public static final String MANAGE_REPOSITORIES = "Manage repositories...";
    static final String N_A = "N/A";
    private static final InstalledPluginsState ourState = InstalledPluginsState.getInstance();
    private final PluginManagerMain installed;
    private final String myVendorFilter;

    AvailablePluginsManagerMain(PluginManagerMain installed, String vendorFilter) {
        this.installed = installed;
        this.myVendorFilter = vendorFilter;
        this.init();
        JButton manageRepositoriesBtn = new JButton(MANAGE_REPOSITORIES);
        if (this.myVendorFilter == null) {
            manageRepositoriesBtn.setMnemonic('m');
            manageRepositoriesBtn.addActionListener(__ -> {
                if (ShowSettingsUtil.getInstance().editConfigurable((Component)this.myActionsPanel, (Configurable)new PluginHostsConfigurable())) {
                    List<String> pluginHosts = UpdateSettings.getInstance().getPluginHosts();
                    if (!pluginHosts.contains(((AvailablePluginsTableModel)this.pluginsModel).getRepository())) {
                        ((AvailablePluginsTableModel)this.pluginsModel).setRepository("All", StringUtil.toLowerCase((String)this.myFilter.getFilter()));
                    }
                    this.loadAvailablePlugins();
                }
            });
            this.myActionsPanel.add((Component)manageRepositoriesBtn, "East");
        }
        JButton httpProxySettingsButton = new JButton(IdeBundle.message((String)"button.http.proxy.settings", (Object[])new Object[0]));
        httpProxySettingsButton.addActionListener(__ -> {
            if (HttpConfigurable.editConfigurable((JComponent)this.getMainPanel())) {
                this.loadAvailablePlugins();
            }
        });
        this.myActionsPanel.add((Component)httpProxySettingsButton, "West");
        this.myPanelDescription.setVisible(false);
    }

    @Override
    protected JScrollPane createTable() {
        AvailablePluginsTableModel model2 = new AvailablePluginsTableModel();
        model2.setVendor(this.myVendorFilter);
        if (PluginManagerUISettings.getInstance().availableSortByStatus) {
            model2.setSortByStatus(true);
        }
        this.pluginsModel = model2;
        this.pluginTable = new PluginTable(this.pluginsModel);
        return ScrollPaneFactory.createScrollPane((Component)((Object)this.pluginTable));
    }

    @Override
    protected void installTableActions() {
        super.installTableActions();
        new DoubleClickListener(){

            protected boolean onDoubleClick(MouseEvent e) {
                if (AvailablePluginsManagerMain.this.pluginTable.columnAtPoint(e.getPoint()) < 0) {
                    return false;
                }
                if (AvailablePluginsManagerMain.this.pluginTable.rowAtPoint(e.getPoint()) < 0) {
                    return false;
                }
                return AvailablePluginsManagerMain.this.installSelected(AvailablePluginsManagerMain.this.pluginTable);
            }
        }.installOn((Component)((Object)this.pluginTable));
        this.pluginTable.registerKeyboardAction(__ -> this.installSelected(this.pluginTable), KeyStroke.getKeyStroke(32, 0), 0);
    }

    private boolean installSelected(PluginTable pluginTable) {
        IdeaPluginDescriptor[] selection = pluginTable.getSelectedObjects();
        if (selection != null) {
            boolean enabled = true;
            for (IdeaPluginDescriptor descr : selection) {
                if (descr instanceof PluginNode) {
                    enabled &= !PluginManagerColumnInfo.isDownloaded((PluginNode)descr);
                    if (((PluginNode)descr).getStatus() != PluginNode.Status.INSTALLED) continue;
                    enabled &= ourState.hasNewerVersion(descr.getPluginId());
                    continue;
                }
                if (!(descr instanceof IdeaPluginDescriptorImpl)) continue;
                PluginId id = descr.getPluginId();
                enabled &= ourState.hasNewerVersion(id);
            }
            if (enabled) {
                new InstallPluginAction(this, this.installed).install(null);
            }
            return true;
        }
        return false;
    }

    @Override
    public void reset() {
        UiNotifyConnector.doWhenFirstShown((JComponent)((Object)this.getPluginTable()), () -> this.loadAvailablePlugins());
        super.reset();
    }

    @Override
    protected PluginManagerMain getAvailable() {
        return this;
    }

    @Override
    protected PluginManagerMain getInstalled() {
        return this.installed;
    }

    @Override
    @NotNull
    protected ActionGroup getActionGroup(boolean inToolbar) {
        DefaultActionGroup actionGroup = new DefaultActionGroup();
        actionGroup.add((AnAction)new PluginManagerMain.RefreshAction(this));
        if (inToolbar) {
            actionGroup.add((AnAction)new MyFilterRepositoryAction());
            actionGroup.add((AnAction)new MyFilterCategoryAction());
        } else {
            actionGroup.add((AnAction)this.createSortersGroup());
            actionGroup.add((AnAction)Separator.getInstance());
            actionGroup.add((AnAction)new InstallPluginAction(this.getAvailable(), this.getInstalled()));
        }
        DefaultActionGroup defaultActionGroup = actionGroup;
        if (defaultActionGroup == null) {
            AvailablePluginsManagerMain.$$$reportNull$$$0(0);
        }
        return defaultActionGroup;
    }

    @Override
    protected boolean acceptHost(String host) {
        return ((AvailablePluginsTableModel)this.pluginsModel).isHostAccepted(host);
    }

    @Override
    protected void propagateUpdates(List<? extends IdeaPluginDescriptor> list2) {
        this.installed.modifyPluginsList(list2);
    }

    @Override
    protected DefaultActionGroup createSortersGroup() {
        DefaultActionGroup group = super.createSortersGroup();
        group.addAction((AnAction)new SortByDownloadsAction(this.pluginTable, this.pluginsModel));
        group.addAction((AnAction)new SortByRatingAction(this.pluginTable, this.pluginsModel));
        group.addAction((AnAction)new SortByUpdatedAction(this.pluginTable, this.pluginsModel));
        return group;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/plugins/AvailablePluginsManagerMain", "getActionGroup"));
    }

    private class MyFilterRepositoryAction
    extends ComboBoxAction
    implements DumbAware {
        private static final int LENGTH = 15;

        private MyFilterRepositoryAction() {
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                MyFilterRepositoryAction.$$$reportNull$$$0(0);
            }
            super.update(e);
            boolean empty = UpdateSettings.getInstance().getPluginHosts().isEmpty();
            e.getPresentation().setVisible(!empty || ApplicationInfoEx.getInstanceEx().getBuiltinPluginsUrl() != null);
            String repository = ((AvailablePluginsTableModel)AvailablePluginsManagerMain.this.pluginsModel).getRepository();
            if (repository.length() > 15) {
                repository = repository.substring(0, 15) + "...";
            }
            e.getPresentation().setText("Repository: " + repository);
        }

        @NotNull
        protected DefaultActionGroup createPopupActionGroup(JComponent button2) {
            DefaultActionGroup gr = new DefaultActionGroup();
            gr.add(this.createFilterByRepositoryAction("All"));
            gr.add(this.createFilterByRepositoryAction("JetBrains Plugin Repository"));
            if (ApplicationInfoEx.getInstanceEx().getBuiltinPluginsUrl() != null) {
                gr.add(this.createFilterByRepositoryAction("Built-in Plugin Repository"));
            }
            for (String host : UpdateSettings.getInstance().getPluginHosts()) {
                gr.add(this.createFilterByRepositoryAction(host));
            }
            DefaultActionGroup defaultActionGroup = gr;
            if (defaultActionGroup == null) {
                MyFilterRepositoryAction.$$$reportNull$$$0(1);
            }
            return defaultActionGroup;
        }

        private AnAction createFilterByRepositoryAction(final String host) {
            return new DumbAwareAction(host){

                public void actionPerformed(@NotNull AnActionEvent e) {
                    if (e == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    String filter = StringUtil.toLowerCase((String)AvailablePluginsManagerMain.this.myFilter.getFilter());
                    ((AvailablePluginsTableModel)AvailablePluginsManagerMain.this.pluginsModel).setRepository(host, filter);
                    TableUtil.ensureSelectionExists((JTable)((Object)AvailablePluginsManagerMain.this.getPluginTable()));
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/plugins/AvailablePluginsManagerMain$MyFilterRepositoryAction$1", "actionPerformed"));
                }
            };
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ide/plugins/AvailablePluginsManagerMain$MyFilterRepositoryAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ide/plugins/AvailablePluginsManagerMain$MyFilterRepositoryAction";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createPopupActionGroup";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private class MyFilterCategoryAction
    extends ComboBoxAction
    implements DumbAware {
        private MyFilterCategoryAction() {
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                MyFilterCategoryAction.$$$reportNull$$$0(0);
            }
            super.update(e);
            String category = ((AvailablePluginsTableModel)AvailablePluginsManagerMain.this.pluginsModel).getCategory();
            if (category == null) {
                category = AvailablePluginsManagerMain.N_A;
            }
            e.getPresentation().setText("Category: " + category);
        }

        @NotNull
        protected DefaultActionGroup createPopupActionGroup(JComponent button2) {
            TreeSet<String> availableCategories = ((AvailablePluginsTableModel)AvailablePluginsManagerMain.this.pluginsModel).getAvailableCategories();
            DefaultActionGroup gr = new DefaultActionGroup();
            gr.add(this.createFilterByCategoryAction("All"));
            boolean noCategory = availableCategories.remove(AvailablePluginsManagerMain.N_A);
            for (String availableCategory : availableCategories) {
                gr.add(this.createFilterByCategoryAction(availableCategory));
            }
            if (noCategory) {
                gr.add(this.createFilterByCategoryAction(AvailablePluginsManagerMain.N_A));
            }
            DefaultActionGroup defaultActionGroup = gr;
            if (defaultActionGroup == null) {
                MyFilterCategoryAction.$$$reportNull$$$0(1);
            }
            return defaultActionGroup;
        }

        private AnAction createFilterByCategoryAction(final String availableCategory) {
            return new DumbAwareAction(availableCategory){

                public void actionPerformed(@NotNull AnActionEvent e) {
                    if (e == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    String filter = StringUtil.toLowerCase((String)AvailablePluginsManagerMain.this.myFilter.getFilter());
                    ((AvailablePluginsTableModel)AvailablePluginsManagerMain.this.pluginsModel).setCategory(availableCategory, filter);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/plugins/AvailablePluginsManagerMain$MyFilterCategoryAction$1", "actionPerformed"));
                }
            };
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ide/plugins/AvailablePluginsManagerMain$MyFilterCategoryAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ide/plugins/AvailablePluginsManagerMain$MyFilterCategoryAction";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createPopupActionGroup";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

