import { ILogger } from "matrix-bot-sdk";
/**
 * This class provides a "one stop shop" to determine if a user is online. It will use a combination of a
 * local cache, presence endpoints and admin APIs in that order.
 */
export declare class MatrixActivityTracker {
    private serverName;
    private canUsePresence;
    private client;
    private lastActiveTime;
    private canUseWhois;
    constructor(homeserverUrl: string, accessToken: string, serverName: string, canUsePresence?: boolean, logger?: ILogger);
    readonly usingWhois: boolean | null;
    /**
     * This should be called when a user has performed an action to bump their locally stored active time.
     * @param userId The userId of a user who performed an action.
     */
    bumpLastActiveTime(userId: string): void;
    /**
     * Determine if a user is online or offline using a range of metrics.
     * @param userId The userId to check
     * @param maxTimeMs The maximum time a user may be inactive for before they are considered offline.
     */
    isUserOnline(userId: string, maxTimeMs: number): Promise<{
        online: boolean;
        inactiveMs: number;
    }>;
}
