"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IpRangesParamEditor = IpRangesParamEditor;

var _react = _interopRequireDefault(require("react"));

var _eui = require("@elastic/eui");

var _from_to_list = require("./components/from_to_list");

var _mask_list = require("./components/mask_list");

var _ip_range_type = require("./ip_range_type");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; var ownKeys = Object.keys(source); if (typeof Object.getOwnPropertySymbols === 'function') { ownKeys = ownKeys.concat(Object.getOwnPropertySymbols(source).filter(function (sym) { return Object.getOwnPropertyDescriptor(source, sym).enumerable; })); } ownKeys.forEach(function (key) { _defineProperty(target, key, source[key]); }); } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function IpRangesParamEditor(_ref) {
  var agg = _ref.agg,
      _ref$value = _ref.value,
      value = _ref$value === void 0 ? {
    fromTo: [],
    mask: []
  } : _ref$value,
      setTouched = _ref.setTouched,
      setValue = _ref.setValue,
      setValidity = _ref.setValidity,
      showValidation = _ref.showValidation;

  var handleChange = function handleChange(modelName, items) {
    setValue(_objectSpread({}, value, _defineProperty({}, modelName, items)));
  };

  return _react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    id: "visEditorIpRange".concat(agg.id)
  }, agg.params.ipRangeType === _ip_range_type.IpRangeTypes.MASK ? _react.default.createElement(_mask_list.MaskList, {
    list: value.mask,
    showValidation: showValidation,
    onBlur: setTouched,
    onChange: function onChange(items) {
      return handleChange(_ip_range_type.IpRangeTypes.MASK, items);
    },
    setValidity: setValidity
  }) : _react.default.createElement(_from_to_list.FromToList, {
    list: value.fromTo,
    showValidation: showValidation,
    onBlur: setTouched,
    onChange: function onChange(items) {
      return handleChange(_ip_range_type.IpRangeTypes.FROM_TO, items);
    },
    setValidity: setValidity
  }));
}