/**
 * Log any value to the console for debugging purposes and then return a value. This will log the value's underlying
 * representation for low-level debugging
 *
 * @since 1.0.0
 */
export const trace = (message, out) => {
    console.log(message); // tslint:disable-line:no-console
    return out();
};
/**
 * Log any value and return it
 *
 * @since 1.0.0
 */
export const spy = (a) => {
    return trace(a, () => a);
};
export function traceA(F) {
    return x => trace(x, () => F.of(undefined));
}
export function traceM(F) {
    return a => trace(a, () => F.of(a));
}
