/*
 * Copyright 2019 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.gradle.api.internal.tasks.properties.annotations;

import org.gradle.api.Task;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.internal.reflect.ParameterValidationContext;
import org.gradle.model.internal.type.ModelType;

import java.lang.annotation.Annotation;

public class CacheableTaskTypeAnnotationHandler implements TypeAnnotationHandler {
    @Override
    public Class<? extends Annotation> getAnnotationType() {
        return CacheableTask.class;
    }

    @Override
    public void validateTypeMetadata(Class<?> classWithAnnotationAttached, ParameterValidationContext visitor) {
        if (!Task.class.isAssignableFrom(classWithAnnotationAttached)) {
            visitor.visitErrorStrict(String.format("Cannot use @%s with type %s. This annotation can only be used with %s types.", getAnnotationType().getSimpleName(), ModelType.of(classWithAnnotationAttached).getDisplayName(), Task.class.getSimpleName()));
        }
    }
}
