/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.geo;

import java.io.IOException;
import java.text.ParseException;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.geo.GeoJson;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.geo.geometry.Geometry;
import org.elasticsearch.geo.utils.GeographyValidator;
import org.elasticsearch.geo.utils.GeometryValidator;
import org.elasticsearch.geo.utils.WellKnownText;

public final class GeometryParser {
    private final GeoJson geoJsonParser;
    private final WellKnownText wellKnownTextParser;
    private final GeometryValidator validator;

    public GeometryParser(boolean rightOrientation, boolean coerce, boolean ignoreZValue) {
        this.validator = new GeographyValidator(ignoreZValue);
        this.geoJsonParser = new GeoJson(rightOrientation, coerce, this.validator);
        this.wellKnownTextParser = new WellKnownText(coerce, this.validator);
    }

    public Geometry parse(XContentParser parser) throws IOException, ParseException {
        if (parser.currentToken() == XContentParser.Token.VALUE_NULL) {
            return null;
        }
        if (parser.currentToken() == XContentParser.Token.START_OBJECT) {
            return this.geoJsonParser.fromXContent(parser);
        }
        if (parser.currentToken() == XContentParser.Token.VALUE_STRING) {
            return this.wellKnownTextParser.fromWKT(parser.text());
        }
        throw new ElasticsearchParseException("shape must be an object consisting of type and coordinates", new Object[0]);
    }
}

