/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.dtresourceprovider;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.jst.jsf.common.ui.internal.logging.Logger;
import org.eclipse.jst.jsf.common.ui.internal.utils.ResourceUtils;
import org.eclipse.jst.pagedesigner.PDPlugin;
import org.eclipse.jst.pagedesigner.dtresourceprovider.AbstractDTSkin;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSModel;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.w3c.dom.stylesheets.StyleSheet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultDTSkin
extends AbstractDTSkin {
    private List<URL> styleSheetURLs;
    private List<StyleSheet> styleSheets;
    private List<IStructuredModel> models;
    private Logger log = PDPlugin.getLogger(DefaultDTSkin.class);

    public DefaultDTSkin(String name) {
        super(name);
    }

    public DefaultDTSkin(String name, boolean isDefault) {
        super(name, isDefault);
    }

    public DefaultDTSkin(String name, List<URL> styleSheetURLs) {
        this(name);
        this.styleSheetURLs = styleSheetURLs;
    }

    @Override
    public List<StyleSheet> getStyleSheets() {
        if (this.styleSheets == null) {
            this.styleSheets = new ArrayList<StyleSheet>();
            if (this.styleSheetURLs != null) {
                for (URL currentURL : this.styleSheetURLs) {
                    InputStream in = null;
                    try {
                        try {
                            in = currentURL.openStream();
                            if (in != null) {
                                IStructuredModel model = StructuredModelManager.getModelManager().getModelForRead(currentURL.toExternalForm(), in, null);
                                if (model instanceof ICSSModel) {
                                    this.styleSheets.add((StyleSheet)((ICSSModel)model).getDocument());
                                    if (this.models == null) {
                                        this.models = new ArrayList<IStructuredModel>();
                                    }
                                    this.models.add(model);
                                } else {
                                    model.releaseFromRead();
                                }
                            }
                        }
                        catch (IOException ioe) {
                            this.log.error("Warning.DefaultDTSkin.FailureLoadingStyleSheet", this.name, currentURL.toExternalForm(), (Throwable)ioe);
                            ResourceUtils.ensureClosed((InputStream)in);
                            continue;
                        }
                    }
                    catch (Throwable throwable) {
                        ResourceUtils.ensureClosed((InputStream)in);
                        throw throwable;
                    }
                    ResourceUtils.ensureClosed((InputStream)in);
                }
            }
        }
        return Collections.unmodifiableList(this.styleSheets);
    }

    @Override
    public List<String> getStyleSheetLocations() {
        ArrayList<String> locations = new ArrayList<String>();
        if (this.styleSheetURLs != null) {
            for (URL currentURL : this.styleSheetURLs) {
                URL fileURL;
                try {
                    fileURL = FileLocator.toFileURL((URL)currentURL);
                }
                catch (IOException iOException) {
                    fileURL = currentURL;
                }
                locations.add(fileURL.toExternalForm());
            }
        }
        return Collections.unmodifiableList(locations);
    }

    @Override
    public void releaseResources() {
        if (this.models != null) {
            for (IStructuredModel model : this.models) {
                model.releaseFromRead();
            }
            this.models = null;
        }
        this.styleSheets = null;
    }
}

