/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.testsrunner.launcher;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.cdt.testsrunner.internal.TestsRunnerPlugin;
import org.eclipse.cdt.testsrunner.internal.launcher.LauncherMessages;
import org.eclipse.cdt.testsrunner.internal.launcher.TestsRunnerProviderInfo;
import org.eclipse.cdt.testsrunner.internal.ui.view.TestPathUtils;
import org.eclipse.cdt.testsrunner.launcher.ITestsRunnerProvider;
import org.eclipse.cdt.testsrunner.model.TestingException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchDelegate;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.model.ILaunchConfigurationDelegate2;
import org.eclipse.debug.core.model.LaunchConfigurationDelegate;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;

public abstract class BaseTestsLaunchDelegate
extends LaunchConfigurationDelegate {
    private Map<String, String> changesToLaunchConfiguration = new HashMap<String, String>();

    public ILaunch getLaunch(ILaunchConfiguration config, String mode) throws CoreException {
        return this.getPreferredDelegate(config, mode).getLaunch(config, mode);
    }

    public boolean buildForLaunch(ILaunchConfiguration config, String mode, IProgressMonitor monitor) throws CoreException {
        return this.getPreferredDelegate(config, mode).buildForLaunch(config, mode, monitor);
    }

    public boolean finalLaunchCheck(ILaunchConfiguration config, String mode, IProgressMonitor monitor) throws CoreException {
        return this.getPreferredDelegate(config, mode).finalLaunchCheck(config, mode, monitor);
    }

    public boolean preLaunchCheck(ILaunchConfiguration config, String mode, IProgressMonitor monitor) throws CoreException {
        return this.getPreferredDelegate(config, mode).preLaunchCheck(config, mode, monitor);
    }

    public void launch(ILaunchConfiguration config, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        if (mode.equals("run") || mode.equals("debug")) {
            try {
                this.updatedLaunchConfiguration(config);
                this.getPreferredDelegate(config, mode).launch(config, mode, launch, monitor);
            }
            finally {
                this.revertChangedToLaunchConfiguration(config);
            }
            this.activateTestingView();
        }
    }

    private void revertChangedToLaunchConfiguration(ILaunchConfiguration config) throws CoreException {
        ILaunchConfigurationWorkingCopy configWC = config.getWorkingCopy();
        for (Map.Entry<String, String> changeEntry : this.changesToLaunchConfiguration.entrySet()) {
            configWC.setAttribute(changeEntry.getKey(), changeEntry.getValue());
        }
        configWC.doSave();
        this.changesToLaunchConfiguration.clear();
    }

    private void updatedLaunchConfigurationAttribute(ILaunchConfigurationWorkingCopy config, String attributeName, String value) throws CoreException {
        this.changesToLaunchConfiguration.put(attributeName, config.getAttribute(attributeName, ""));
        config.setAttribute(attributeName, value);
    }

    private void updatedLaunchConfiguration(ILaunchConfiguration config) throws CoreException {
        this.changesToLaunchConfiguration.clear();
        ILaunchConfigurationWorkingCopy configWC = config.getWorkingCopy();
        this.setProgramArguments(configWC);
        configWC.doSave();
    }

    private void setProgramArguments(ILaunchConfigurationWorkingCopy config) throws CoreException {
        List packedTestsFilter = config.getAttribute("org.eclipse.cdt.testsrunner.launch.TESTS_FILTER", Collections.EMPTY_LIST);
        String[][] testsFilter = TestPathUtils.unpackTestPaths(packedTestsFilter.toArray(new String[packedTestsFilter.size()]));
        String[] params = null;
        try {
            params = this.getTestsRunner((ILaunchConfiguration)config).getAdditionalLaunchParameters(testsFilter);
        }
        catch (TestingException e) {
            throw new CoreException((IStatus)new Status(4, TestsRunnerPlugin.getUniqueIdentifier(), e.getLocalizedMessage(), null));
        }
        if (params != null && params.length >= 1) {
            StringBuilder sb = new StringBuilder();
            sb.append(config.getAttribute("org.eclipse.cdt.launch.PROGRAM_ARGUMENTS", ""));
            String[] stringArray = params;
            int n = params.length;
            int n2 = 0;
            while (n2 < n) {
                String param = stringArray[n2];
                sb.append(' ');
                sb.append(param);
                ++n2;
            }
            this.updatedLaunchConfigurationAttribute(config, "org.eclipse.cdt.launch.PROGRAM_ARGUMENTS", sb.toString());
        }
    }

    private ITestsRunnerProvider getTestsRunner(ILaunchConfiguration config) throws CoreException {
        TestsRunnerProviderInfo testsRunnerProviderInfo = TestsRunnerPlugin.getDefault().getTestsRunnerProvidersManager().getTestsRunnerProviderInfo(config);
        if (testsRunnerProviderInfo == null) {
            throw new CoreException((IStatus)new Status(4, TestsRunnerPlugin.getUniqueIdentifier(), LauncherMessages.BaseTestsLaunchDelegate_invalid_tests_runner, null));
        }
        ITestsRunnerProvider testsRunnerProvider = testsRunnerProviderInfo.instantiateTestsRunnerProvider();
        if (testsRunnerProvider == null) {
            throw new CoreException((IStatus)new Status(4, TestsRunnerPlugin.getUniqueIdentifier(), LauncherMessages.BaseTestsLaunchDelegate_tests_runner_load_failed, null));
        }
        return testsRunnerProvider;
    }

    private ILaunchConfigurationDelegate2 getPreferredDelegate(ILaunchConfiguration config, String mode) throws CoreException {
        ILaunchManager launchMgr = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType localCfg = launchMgr.getLaunchConfigurationType("org.eclipse.cdt.launch.applicationLaunchType");
        Set modes = config.getModes();
        modes.add(mode);
        String preferredDelegateId = this.getPreferredDelegateId();
        ILaunchDelegate[] iLaunchDelegateArray = localCfg.getDelegates(modes);
        int n = iLaunchDelegateArray.length;
        int n2 = 0;
        while (n2 < n) {
            ILaunchDelegate delegate = iLaunchDelegateArray[n2];
            if (preferredDelegateId.equals(delegate.getId())) {
                return (ILaunchConfigurationDelegate2)delegate.getDelegate();
            }
            ++n2;
        }
        return null;
    }

    public abstract String getPreferredDelegateId();

    private void activateTestingView() {
        Display.getDefault().syncExec(() -> {
            try {
                IWorkbenchWindow activeWindow = TestsRunnerPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
                IViewPart view = activeWindow.getActivePage().showView("org.eclipse.cdt.testsrunner.resultsview");
                TestsRunnerPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage().activate((IWorkbenchPart)view);
            }
            catch (PartInitException e) {
                TestsRunnerPlugin.log(e);
            }
        });
    }
}

