/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.provisional.analysis.lami.core.aspect;

import java.util.Comparator;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.aspect.LamiComparators;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.aspect.LamiGenericAspect;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.aspect.Messages;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.module.LamiTableEntry;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.types.LamiData;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.types.LamiTimeRange;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.types.LamiTimestamp;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestampFormat;

public class LamiTimeRangeEndAspect
extends LamiGenericAspect {
    public LamiTimeRangeEndAspect(String timeRangeName, int colIndex) {
        super(String.valueOf(timeRangeName) + " (" + Messages.LamiAspect_TimeRangeEnd + ')', null, colIndex, true, true);
    }

    @Override
    public @Nullable String resolveString(LamiTableEntry entry) {
        LamiTimeRange range;
        LamiTimestamp ts;
        Long timestamp;
        LamiData data = entry.getValue(this.getColIndex());
        if (data instanceof LamiTimeRange && (timestamp = (ts = (range = (LamiTimeRange)data).getEnd()).getValue()) != null) {
            return TmfTimestampFormat.getDefaulTimeFormat().format(((Number)timestamp).longValue());
        }
        return data.toString();
    }

    @Override
    public @Nullable Number resolveNumber(@NonNull LamiTableEntry entry) {
        LamiData data = entry.getValue(this.getColIndex());
        if (data instanceof LamiTimeRange) {
            LamiTimeRange range = (LamiTimeRange)data;
            LamiTimestamp ts = range.getEnd();
            return ts.getValue();
        }
        return null;
    }

    @Override
    public Comparator<LamiTableEntry> getComparator() {
        return LamiComparators.getLongComparator(this::resolveNumber);
    }
}

