"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var logger_1 = require("./utils/logger");
var postprocess_1 = require("./postprocess");
var transpiler_1 = require("./transpiler");
var run_ts_diagnostics_1 = require("./utils/run-ts-diagnostics");
var get_ts_config_1 = require("./utils/get-ts-config");
var get_ts_jest_config_1 = require("./utils/get-ts-jest-config");
function preprocess(src, filePath, jestConfig, transformOptions) {
    var compilerOptions = get_ts_config_1.default(jestConfig);
    logger_1.logOnce('final compilerOptions:', compilerOptions);
    var isTsFile = /\.tsx?$/.test(filePath);
    var isJsFile = /\.jsx?$/.test(filePath);
    var isHtmlFile = /\.html$/.test(filePath);
    if (isHtmlFile &&
        jestConfig.globals &&
        jestConfig.globals.__TRANSFORM_HTML__) {
        src = 'module.exports=' + JSON.stringify(src) + ';';
    }
    var processFile = compilerOptions.allowJs === true ? isTsFile || isJsFile : isTsFile;
    if (!processFile) {
        return src;
    }
    var tsJestConfig = get_ts_jest_config_1.default(jestConfig);
    logger_1.logOnce('tsJestConfig: ', tsJestConfig);
    if (tsJestConfig.enableTsDiagnostics === true ||
        (typeof tsJestConfig.enableTsDiagnostics === 'string' &&
            new RegExp(tsJestConfig.enableTsDiagnostics).test(filePath))) {
        run_ts_diagnostics_1.default(filePath, compilerOptions);
    }
    var transpileOutput = transpiler_1.transpileTypescript(filePath, src, compilerOptions);
    if (tsJestConfig.ignoreCoverageForAllDecorators === true) {
        transpileOutput.code = transpileOutput.code.replace(/\b__decorate\b/g, '/* istanbul ignore next */__decorate');
    }
    if (tsJestConfig.ignoreCoverageForDecorators === true) {
        transpileOutput.code = transpileOutput.code.replace(/(\b__decorate\(\[\r?\n[^\n\r]*)\/\*\s*istanbul\s+ignore\s+decorator(.*)\*\//g, '/* istanbul ignore next$2*/$1');
    }
    var outputText = postprocess_1.postProcessCode(jestConfig, transformOptions, transpileOutput, filePath);
    logger_1.flushLogs();
    return { code: outputText.code, map: outputText.map };
}
exports.default = preprocess;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoicHJlcHJvY2Vzcy5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uL3NyYy9wcmVwcm9jZXNzLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7O0FBQUEseUNBQW9EO0FBQ3BELDZDQUFnRDtBQUNoRCwyQ0FBbUQ7QUFDbkQsaUVBQTBEO0FBQzFELHVEQUFnRDtBQUNoRCxpRUFBeUQ7QUFFekQsb0JBQ0UsR0FBVyxFQUNYLFFBQW1CLEVBQ25CLFVBQThCLEVBQzlCLGdCQUF3QztJQUl4QyxJQUFNLGVBQWUsR0FBRyx1QkFBVyxDQUFDLFVBQVUsQ0FBQyxDQUFDO0lBRWhELGdCQUFPLENBQUMsd0JBQXdCLEVBQUUsZUFBZSxDQUFDLENBQUM7SUFFbkQsSUFBTSxRQUFRLEdBQUcsU0FBUyxDQUFDLElBQUksQ0FBQyxRQUFRLENBQUMsQ0FBQztJQUMxQyxJQUFNLFFBQVEsR0FBRyxTQUFTLENBQUMsSUFBSSxDQUFDLFFBQVEsQ0FBQyxDQUFDO0lBQzFDLElBQU0sVUFBVSxHQUFHLFNBQVMsQ0FBQyxJQUFJLENBQUMsUUFBUSxDQUFDLENBQUM7SUFHNUMsSUFDRSxVQUFVO1FBQ1YsVUFBVSxDQUFDLE9BQU87UUFDakIsVUFBVSxDQUFDLE9BQWUsQ0FBQyxrQkFBa0IsRUFDOUM7UUFDQSxHQUFHLEdBQUcsaUJBQWlCLEdBQUcsSUFBSSxDQUFDLFNBQVMsQ0FBQyxHQUFHLENBQUMsR0FBRyxHQUFHLENBQUM7S0FDckQ7SUFFRCxJQUFNLFdBQVcsR0FDZixlQUFlLENBQUMsT0FBTyxLQUFLLElBQUksQ0FBQyxDQUFDLENBQUMsUUFBUSxJQUFJLFFBQVEsQ0FBQyxDQUFDLENBQUMsUUFBUSxDQUFDO0lBRXJFLElBQUksQ0FBQyxXQUFXLEVBQUU7UUFDaEIsT0FBTyxHQUFHLENBQUM7S0FDWjtJQUVELElBQU0sWUFBWSxHQUFHLDRCQUFlLENBQUMsVUFBVSxDQUFDLENBQUM7SUFDakQsZ0JBQU8sQ0FBQyxnQkFBZ0IsRUFBRSxZQUFZLENBQUMsQ0FBQztJQUl4QyxJQUNFLFlBQVksQ0FBQyxtQkFBbUIsS0FBSyxJQUFJO1FBQ3pDLENBQUMsT0FBTyxZQUFZLENBQUMsbUJBQW1CLEtBQUssUUFBUTtZQUNuRCxJQUFJLE1BQU0sQ0FBQyxZQUFZLENBQUMsbUJBQW1CLENBQUMsQ0FBQyxJQUFJLENBQUMsUUFBUSxDQUFDLENBQUMsRUFDOUQ7UUFDQSw0QkFBZ0IsQ0FBQyxRQUFRLEVBQUUsZUFBZSxDQUFDLENBQUM7S0FDN0M7SUFFRCxJQUFNLGVBQWUsR0FBRyxnQ0FBbUIsQ0FBQyxRQUFRLEVBQUUsR0FBRyxFQUFFLGVBQWUsQ0FBQyxDQUFDO0lBRzVFLElBQUksWUFBWSxDQUFDLDhCQUE4QixLQUFLLElBQUksRUFBRTtRQUN4RCxlQUFlLENBQUMsSUFBSSxHQUFHLGVBQWUsQ0FBQyxJQUFJLENBQUMsT0FBTyxDQUNqRCxpQkFBaUIsRUFDakIsc0NBQXNDLENBQ3ZDLENBQUM7S0FDSDtJQUNELElBQUksWUFBWSxDQUFDLDJCQUEyQixLQUFLLElBQUksRUFBRTtRQUNyRCxlQUFlLENBQUMsSUFBSSxHQUFHLGVBQWUsQ0FBQyxJQUFJLENBQUMsT0FBTyxDQUNqRCw4RUFBOEUsRUFDOUUsK0JBQStCLENBQ2hDLENBQUM7S0FDSDtJQUVELElBQU0sVUFBVSxHQUFHLDZCQUFlLENBQ2hDLFVBQVUsRUFDVixnQkFBZ0IsRUFDaEIsZUFBZSxFQUNmLFFBQVEsQ0FDVCxDQUFDO0lBRUYsa0JBQVMsRUFBRSxDQUFDO0lBRVosT0FBTyxFQUFFLElBQUksRUFBRSxVQUFVLENBQUMsSUFBSSxFQUFFLEdBQUcsRUFBRSxVQUFVLENBQUMsR0FBRyxFQUFFLENBQUM7QUFDeEQsQ0FBQztBQXZFRCw2QkF1RUMifQ==