/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes} checked by tsc
 */
import { Injectable } from '@angular/core';
import { BlockUIActions } from '../constants/block-ui-actions.constant';
import { BlockUIInstanceService } from './block-ui-instance.service';
var BlockUIService = /** @class */ (function () {
    function BlockUIService(blockUIInstance) {
        this.blockUIInstance = blockUIInstance;
    }
    /**
    * Starts blocking for given BlockUI instance or instances
    */
    /**
     * Starts blocking for given BlockUI instance or instances
     * @param {?} target
     * @param {?=} message
     * @return {?}
     */
    BlockUIService.prototype.start = /**
     * Starts blocking for given BlockUI instance or instances
     * @param {?} target
     * @param {?=} message
     * @return {?}
     */
    function (target, message) {
        this.dispatch(target, BlockUIActions.START, message);
    };
    /**
    * Stops blocking for given BlockUI instance or instances
    */
    /**
     * Stops blocking for given BlockUI instance or instances
     * @param {?} target
     * @return {?}
     */
    BlockUIService.prototype.stop = /**
     * Stops blocking for given BlockUI instance or instances
     * @param {?} target
     * @return {?}
     */
    function (target) {
        this.dispatch(target, BlockUIActions.STOP);
    };
    /**
    * Unsubscribes for given BlockUI instance or instances
    */
    /**
     * Unsubscribes for given BlockUI instance or instances
     * @param {?} target
     * @return {?}
     */
    BlockUIService.prototype.unsubscribe = /**
     * Unsubscribes for given BlockUI instance or instances
     * @param {?} target
     * @return {?}
     */
    function (target) {
        this.dispatch(target, BlockUIActions.UNSUBSCRIBE);
    };
    /**
    * Checks if BlockUI is actively blocking
    */
    /**
     * Checks if BlockUI is actively blocking
     * @param {?=} target
     * @return {?}
     */
    BlockUIService.prototype.isActive = /**
     * Checks if BlockUI is actively blocking
     * @param {?=} target
     * @return {?}
     */
    function (target) {
        if (target === void 0) { target = null; }
        var /** @type {?} */ targets = target ? this.toArray(target) : null;
        var /** @type {?} */ instances = this.blockUIInstance.blockUIInstances;
        return Object.keys(instances).some(function (key) {
            if (!targets) {
                return instances[key].isActive;
            }
            return targets.indexOf(instances[key].name) >= 0 && instances[key].isActive;
        });
    };
    /**
     * @param {?=} target
     * @param {?=} type
     * @param {?=} message
     * @return {?}
     */
    BlockUIService.prototype.dispatch = /**
     * @param {?=} target
     * @param {?=} type
     * @param {?=} message
     * @return {?}
     */
    function (target, type, message) {
        var _this = this;
        if (target === void 0) { target = []; }
        var /** @type {?} */ instances = this.toArray(target);
        instances.forEach(function (i) { return _this.blockUIInstance.decorate(i)[type](message); });
    };
    /**
     * @param {?=} target
     * @return {?}
     */
    BlockUIService.prototype.toArray = /**
     * @param {?=} target
     * @return {?}
     */
    function (target) {
        if (target === void 0) { target = []; }
        return typeof target === 'string' ? [target] : target;
    };
    BlockUIService.decorators = [
        { type: Injectable },
    ];
    /** @nocollapse */
    BlockUIService.ctorParameters = function () { return [
        { type: BlockUIInstanceService }
    ]; };
    return BlockUIService;
}());
export { BlockUIService };
function BlockUIService_tsickle_Closure_declarations() {
    /** @type {?} */
    BlockUIService.prototype.blockUIInstance;
}

//# sourceMappingURL=data:application/json;base64,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