/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes} checked by tsc
 */
import { NgModule, InjectionToken } from '@angular/core';
import { HTTP_INTERCEPTORS } from '@angular/common/http';
import { BlockUIModule } from 'ng-block-ui';
import { BlockUIHttpSettings } from './block-ui-http-settings.service';
import { BlockUIInterceptor } from './block-ui-http.interceptor';
// Needed for AOT compiling
export const /** @type {?} */ BlockUIHttpModuleSettings = new InjectionToken('BlockUIHttpModuleSettings');
/**
 * @param {?} settings
 * @return {?}
 */
export function provideSettingsInstance(settings) {
    return { settings };
}
export class BlockUIHttpModule {
    /**
     * @param {?=} settings
     * @return {?}
     */
    static forRoot(settings = {}) {
        return {
            ngModule: BlockUIHttpModule,
            providers: [
                {
                    provide: BlockUIHttpModuleSettings,
                    useValue: settings
                },
                {
                    provide: BlockUIHttpSettings,
                    useFactory: provideSettingsInstance,
                    deps: [BlockUIHttpModuleSettings]
                },
                {
                    provide: HTTP_INTERCEPTORS,
                    useClass: BlockUIInterceptor,
                    multi: true
                }
            ]
        };
    }
}
BlockUIHttpModule.decorators = [
    { type: NgModule, args: [{
                imports: [BlockUIModule]
            },] },
];

//# sourceMappingURL=data:application/json;base64,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