
/*
 * Copyright (C) 2010-2016 Oracle Corporation
 *
 * This file is part of the VirtualBox SDK, as available from
 * http://www.virtualbox.org.  This library is free software; you can
 * redistribute it and/or modify it under the terms of the GNU Lesser General
 * Public License as published by the Free Software Foundation, in version 2.1
 * as it comes in the "COPYING.LIB" file of the VirtualBox SDK distribution.
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public
 * License for more details.
 *
 * ICloudClient.java
 *
 * DO NOT EDIT! This is a generated file.
 * Generated from: src/VBox/Main/idl/VirtualBox.xidl (VirtualBox's interface definitions in XML)
 * Generator: src/VBox/Main/glue/glue-java.xsl
 */

package org.virtualbox_6_0;

import org.virtualbox_6_0.jaxws.*;
import javax.xml.ws.*;
import java.util.List;

public class ICloudClient extends IUnknown
{

    public ICloudClient(String wrapped, ObjectRefManager objMgr, VboxPortType port)
    {
        super(wrapped, objMgr, port);
    }
    public static ICloudClient queryInterface(IUnknown obj)
    {
        return obj == null ?  null : new ICloudClient(obj.getWrapped(), obj.getObjMgr(), obj.getRemoteWSPort());
    }

/**
Returns parameters to be shown to the user for the cloud export and launch operation.
@return the parameters with values in json format.

*/
    public String getExportLaunchParameters()
    {
        try
        {
            String retVal;
        retVal = port.iCloudClientGetExportLaunchParameters(obj);
           return retVal;
        }
        catch (InvalidObjectFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
    }

/**
Exports and optionally launch a VM described in description parameter
@param description VirtualSystemDescription object which is describing a machine and all required parameters.

@param progress Progress object to track the operation completion.

@param virtualBox Reference to the server-side API root object.

*/
    public void exportLaunchVM(org.virtualbox_6_0.IVirtualSystemDescription description, org.virtualbox_6_0.IProgress progress, org.virtualbox_6_0.IVirtualBox virtualBox)
    {
        try
        {
        port.iCloudClientExportLaunchVM(obj, ((description == null) ? null :description.getWrapped()), ((progress == null) ? null :progress.getWrapped()), ((virtualBox == null) ? null :virtualBox.getWrapped()));
        }
        catch (InvalidObjectFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
    }
}
