/*
 * Decompiled with CFR 0.152.
 */
package sbt.internal.util.logic;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import sbt.internal.util.Dag;
import sbt.internal.util.Dag$;
import sbt.internal.util.Relation;
import sbt.internal.util.Relation$;
import sbt.internal.util.Util$;
import sbt.internal.util.logic.Atom;
import sbt.internal.util.logic.Clause;
import sbt.internal.util.logic.Clauses;
import sbt.internal.util.logic.Formula;
import sbt.internal.util.logic.Formula$True$;
import sbt.internal.util.logic.Literal;
import sbt.internal.util.logic.Logic;
import sbt.internal.util.logic.Logic$Matched$;
import sbt.internal.util.logic.Negated;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.SetLike;
import scala.collection.Traversable;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public final class Logic$ {
    public static Logic$ MODULE$;

    static {
        new Logic$();
    }

    public Either<Logic.LogicException, Logic.Matched> reduceAll(List<Clause> clauses, Set<Literal> initialFacts) {
        return this.reduce(new Clauses(clauses), initialFacts);
    }

    public Either<Logic.LogicException, Logic.Matched> reduce(Clauses clauses, Set<Literal> initialFacts) {
        Tuple2<Seq<Atom>, Seq<Atom>> tuple2 = this.separate((Seq<Literal>)initialFacts.toSeq());
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Seq posSeq = (Seq)tuple2._1();
        Seq negSeq = (Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)posSeq, (Object)negSeq);
        Tuple2 tuple23 = tuple22;
        Seq posSeq2 = (Seq)tuple23._1();
        Seq negSeq2 = (Seq)tuple23._2();
        Tuple2 tuple24 = new Tuple2((Object)posSeq2.toSet(), (Object)negSeq2.toSet());
        if (tuple24 == null) {
            throw new MatchError((Object)tuple24);
        }
        Set pos = (Set)tuple24._1();
        Set neg = (Set)tuple24._2();
        Tuple2 tuple25 = new Tuple2((Object)pos, (Object)neg);
        Tuple2 tuple26 = tuple25;
        Set pos2 = (Set)tuple26._1();
        Set neg2 = (Set)tuple26._2();
        Option problem = this.checkContradictions((Set<Atom>)pos2, (Set<Atom>)neg2).orElse((Function0 & Serializable & scala.Serializable)() -> MODULE$.checkOverlap(clauses, (Set<Atom>)pos2)).orElse((Function0 & Serializable & scala.Serializable)() -> MODULE$.checkAcyclic(clauses));
        return problem.toLeft((Function0 & Serializable & scala.Serializable)() -> MODULE$.reduce0(clauses, initialFacts, Logic$Matched$.MODULE$.empty()));
    }

    private Option<Logic.InitialOverlap> checkOverlap(Clauses clauses, Set<Atom> initialFacts) {
        Logic.Atoms as = this.atoms(clauses);
        Set initialOverlap = (Set)initialFacts.filter(as.inHead());
        return initialOverlap.nonEmpty() ? new Some((Object)new Logic.InitialOverlap((Set<Atom>)initialOverlap)) : None$.MODULE$;
    }

    private Option<Logic.InitialContradictions> checkContradictions(Set<Atom> pos, Set<Atom> neg) {
        Set contradictions = (Set)pos.intersect(neg);
        return contradictions.nonEmpty() ? new Some((Object)new Logic.InitialContradictions((Set<Atom>)contradictions)) : None$.MODULE$;
    }

    private Option<Logic.CyclicNegation> checkAcyclic(Clauses clauses) {
        Map<Atom, Set<Literal>> deps = this.dependencyMap(clauses);
        List cycle = Dag$.MODULE$.findNegativeCycle(this.graph(deps));
        return cycle.nonEmpty() ? new Some((Object)new Logic.CyclicNegation((List<Literal>)cycle)) : None$.MODULE$;
    }

    private Dag.DirectedSignedGraph<Atom> graph(Map<Atom, Set<Literal>> deps) {
        return new Dag.DirectedSignedGraph<Atom>(deps){
            private final Map deps$1;

            public List<Atom> nodes() {
                return this.deps$1.keys().toList();
            }

            public List<Literal> dependencies(Atom a) {
                return ((TraversableOnce)this.deps$1.getOrElse((Object)a, (Function0 & Serializable & scala.Serializable)() -> Predef$.MODULE$.Set().empty())).toList();
            }

            public boolean isNegative(Literal b) {
                boolean bl;
                Literal literal = b;
                if (literal instanceof Negated) {
                    bl = true;
                } else if (literal instanceof Atom) {
                    bl = false;
                } else {
                    throw new MatchError((Object)literal);
                }
                return bl;
            }

            public Atom head(Literal b) {
                return b.atom();
            }
            {
                this.deps$1 = deps$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$dependencies$1()}, serializedLambda);
            }
        };
    }

    private Map<Atom, Set<Literal>> dependencyMap(Clauses clauses) {
        Map map = Predef$.MODULE$.Map().empty();
        return (Map)clauses.clauses().$div$colon((Object)map, (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
            Clause clause;
            Map m;
            block3: {
                Tuple2 tuple2;
                block2: {
                    tuple2 = new Tuple2(x0$1, x1$1);
                    if (tuple2 == null) break block2;
                    m = (Map)tuple2._1();
                    clause = (Clause)tuple2._2();
                    if (clause != null) break block3;
                }
                throw new MatchError((Object)tuple2);
            }
            Formula formula = clause.body();
            Set<Atom> heads = clause.head();
            Set<Literal> deps = MODULE$.literals(formula);
            Map map = m;
            Map map2 = (Map)heads.$div$colon((Object)map, (Function2 & Serializable & scala.Serializable)(n, head) -> n.updated(head, (Object)((SetLike)n.getOrElse(head, (Function0 & Serializable & scala.Serializable)() -> Predef$.MODULE$.Set().empty())).$plus$plus((GenTraversableOnce)deps)));
            return map2;
        });
    }

    private Tuple2<Seq<Atom>, Seq<Atom>> separate(Seq<Literal> lits) {
        return Util$.MODULE$.separate(lits, (Function1 & Serializable & scala.Serializable)x0$1 -> {
            Left left;
            Literal literal = x0$1;
            if (literal instanceof Atom) {
                Atom atom = (Atom)literal;
                left = package$.MODULE$.Left().apply((Object)atom);
            } else if (literal instanceof Negated) {
                Negated negated = (Negated)literal;
                Atom n = negated.atom();
                left = package$.MODULE$.Right().apply((Object)n);
            } else {
                throw new MatchError((Object)literal);
            }
            return left;
        });
    }

    private Tuple2<Set<Atom>, List<Clause>> findProven(Clauses c) {
        Tuple2 tuple2 = c.clauses().partition((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)Logic$.$anonfun$findProven$1(x$8)));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        List proven = (List)tuple2._1();
        List unproven = (List)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)proven, (Object)unproven);
        Tuple2 tuple23 = tuple22;
        List proven2 = (List)tuple23._1();
        List unproven2 = (List)tuple23._2();
        return new Tuple2((Object)((TraversableOnce)proven2.flatMap((Function1 & Serializable & scala.Serializable)x$10 -> x$10.head(), List$.MODULE$.canBuildFrom())).toSet(), (Object)unproven2);
    }

    private Set<Atom> keepPositive(Set<Literal> lits) {
        return ((Set)lits.collect((PartialFunction)new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Literal, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof Atom) {
                    Atom atom = (Atom)A1;
                    object = atom;
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Literal x1) {
                Literal literal = x1;
                boolean bl = literal instanceof Atom;
                return bl;
            }
        }, Set$.MODULE$.canBuildFrom())).toSet();
    }

    private Logic.Matched reduce0(Clauses clauses, Set<Literal> factsToProcess, Logic.Matched state) {
        Logic.Matched matched;
        block3: {
            Option<Clauses> option;
            block4: {
                Logic.Matched newState;
                while (true) {
                    if (None$.MODULE$.equals(option = this.applyAll(clauses, factsToProcess))) {
                        matched = state;
                        break block3;
                    }
                    if (!(option instanceof Some)) break block4;
                    Some some = (Some)option;
                    Clauses applied = (Clauses)some.value();
                    Tuple2<Set<Atom>, List<Clause>> tuple2 = this.findProven(applied);
                    if (tuple2 == null) {
                        throw new MatchError(tuple2);
                    }
                    Set proven = (Set)tuple2._1();
                    List unprovenClauses = (List)tuple2._2();
                    Tuple2 tuple22 = new Tuple2((Object)proven, (Object)unprovenClauses);
                    Tuple2 tuple23 = tuple22;
                    Set proven2 = (Set)tuple23._1();
                    List unprovenClauses2 = (List)tuple23._2();
                    Logic.Matched processedFacts = state.add(this.keepPositive(factsToProcess));
                    Set newlyProven = (Set)proven2.$minus$minus(processedFacts.provenSet());
                    newState = processedFacts.add((Set<Atom>)newlyProven);
                    if (unprovenClauses2.isEmpty()) break;
                    Clauses unproven = new Clauses((List<Clause>)unprovenClauses2);
                    Set<Literal> nextFacts = newlyProven.nonEmpty() ? newlyProven.toSet() : this.inferFailure(unproven);
                    state = newState;
                    factsToProcess = nextFacts;
                    clauses = unproven;
                }
                matched = newState;
                break block3;
            }
            throw new MatchError(option);
        }
        return matched;
    }

    private Set<Literal> inferFailure(Clauses clauses) {
        Set<Literal> set;
        Logic.Atoms allAtoms = this.atoms(clauses);
        Set<Literal> newFacts = this.negated(allAtoms.triviallyFalse());
        if (newFacts.nonEmpty()) {
            set = newFacts;
        } else {
            List<Atom> possiblyTrue = this.hasNegatedDependency((Seq<Clause>)clauses.clauses(), (Relation<Atom, Atom>)Relation$.MODULE$.empty(), (Relation<Atom, Atom>)Relation$.MODULE$.empty());
            Set<Literal> newlyFalse = this.negated((Set<Atom>)((Set)allAtoms.inHead().$minus$minus(possiblyTrue)));
            if (newlyFalse.nonEmpty()) {
                set = newlyFalse;
            } else {
                throw scala.sys.package$.MODULE$.error(new StringBuilder(40).append("No progress:\n\tclauses: ").append(clauses).append("\n\tpossibly true: ").append(possiblyTrue).toString());
            }
        }
        return set;
    }

    private Set<Literal> negated(Set<Atom> atoms) {
        return (Set)atoms.map((Function1 & Serializable & scala.Serializable)a -> new Negated((Atom)a), Set$.MODULE$.canBuildFrom());
    }

    public List<Atom> hasNegatedDependency(Seq<Clause> clauses, Relation<Atom, Atom> posDeps, Relation<Atom, Atom> negDeps) {
        block3: {
            Seq seq;
            while (true) {
                Relation newNeg;
                Some some;
                if (!(some = Seq$.MODULE$.unapplySeq(seq = clauses)).isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(0) == 0) break block3;
                Option option = package$.MODULE$.$plus$colon().unapply(seq);
                if (option.isEmpty()) break;
                Clause clause = (Clause)((Tuple2)option.get())._1();
                Seq tail = (Seq)((Tuple2)option.get())._2();
                if (clause == null) break;
                Formula formula = clause.body();
                Set<Atom> head = clause.head();
                Tuple2<Seq<Atom>, Seq<Atom>> tuple2 = this.directDeps(formula);
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                Seq pos = (Seq)tuple2._1();
                Seq neg = (Seq)tuple2._2();
                Tuple2 tuple22 = new Tuple2((Object)pos, (Object)neg);
                Tuple2 tuple23 = tuple22;
                Seq pos2 = (Seq)tuple23._1();
                Seq neg2 = (Seq)tuple23._2();
                Tuple2 tuple24 = new Tuple2(posDeps, negDeps);
                Tuple2 tuple25 = (Tuple2)head.$div$colon((Object)tuple24, (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
                    Atom d;
                    Tuple2 tuple2;
                    block3: {
                        Tuple2 tuple22;
                        block2: {
                            tuple22 = new Tuple2(x0$1, x1$1);
                            if (tuple22 == null) break block2;
                            tuple2 = (Tuple2)tuple22._1();
                            d = (Atom)tuple22._2();
                            if (tuple2 != null) break block3;
                        }
                        throw new MatchError((Object)tuple22);
                    }
                    Relation pdeps = (Relation)tuple2._1();
                    Relation ndeps = (Relation)tuple2._2();
                    Tuple2 tuple23 = new Tuple2((Object)pdeps.$plus((Object)d, (Traversable)pos2), (Object)ndeps.$plus((Object)d, (Traversable)neg2));
                    return tuple23;
                });
                if (tuple25 == null) {
                    throw new MatchError((Object)tuple25);
                }
                Relation newPos = (Relation)tuple25._1();
                Relation newNeg2 = (Relation)tuple25._2();
                Tuple2 tuple26 = new Tuple2((Object)newPos, (Object)newNeg2);
                Tuple2 tuple27 = tuple26;
                Relation newPos2 = (Relation)tuple27._1();
                negDeps = newNeg = (Relation)tuple27._2();
                posDeps = newPos2;
                clauses = tail;
            }
            throw new MatchError(seq);
        }
        List list = Dag$.MODULE$.topologicalSortUnchecked((Iterable)negDeps._1s(), (Function1 & Serializable & scala.Serializable)_2 -> posDeps.reverse(_2));
        return list;
    }

    private Tuple2<Seq<Atom>, Seq<Atom>> directDeps(Formula formula) {
        return Util$.MODULE$.separate(this.literals(formula).toSeq(), (Function1 & Serializable & scala.Serializable)x0$1 -> {
            Right right;
            Literal literal = x0$1;
            if (literal instanceof Negated) {
                Negated negated = (Negated)literal;
                Atom a = negated.atom();
                right = package$.MODULE$.Right().apply((Object)a);
            } else if (literal instanceof Atom) {
                Atom atom = (Atom)literal;
                right = package$.MODULE$.Left().apply((Object)atom);
            } else {
                throw new MatchError((Object)literal);
            }
            return right;
        });
    }

    private Set<Literal> literals(Formula formula) {
        Set set;
        Formula formula2 = formula;
        if (formula2 instanceof Formula.And) {
            Set lits;
            Formula.And and = (Formula.And)formula2;
            set = lits = and.literals();
        } else if (formula2 instanceof Literal) {
            Literal literal = (Literal)formula2;
            set = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Literal[]{literal}));
        } else if (Formula$True$.MODULE$.equals(formula2)) {
            set = Predef$.MODULE$.Set().empty();
        } else {
            throw new MatchError((Object)formula2);
        }
        return set;
    }

    public Logic.Atoms atoms(Clauses cs) {
        return (Logic.Atoms)((TraversableOnce)cs.clauses().map((Function1 & Serializable & scala.Serializable)c -> new Logic.Atoms(c.head(), MODULE$.atoms(c.body())), List$.MODULE$.canBuildFrom())).reduce((Function2 & Serializable & scala.Serializable)(x$15, x$16) -> x$15.$plus$plus((Logic.Atoms)x$16));
    }

    public Set<Atom> atoms(Formula formula) {
        Set set;
        Formula formula2 = formula;
        if (formula2 instanceof Formula.And) {
            Formula.And and = (Formula.And)formula2;
            Set<Literal> lits = and.literals();
            set = (Set)lits.map((Function1 & Serializable & scala.Serializable)x$17 -> x$17.atom(), Set$.MODULE$.canBuildFrom());
        } else if (formula2 instanceof Negated) {
            Negated negated = (Negated)formula2;
            Atom lit = negated.atom();
            set = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Atom[]{lit}));
        } else if (formula2 instanceof Atom) {
            Atom atom = (Atom)formula2;
            set = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Atom[]{atom}));
        } else if (Formula$True$.MODULE$.equals(formula2)) {
            set = (Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$);
        } else {
            throw new MatchError((Object)formula2);
        }
        return set;
    }

    public Option<Clauses> applyAll(Clauses cs, Set<Literal> facts) {
        List newClauses = facts.isEmpty() ? (List)cs.clauses().filter((Function1 & Serializable & scala.Serializable)x$18 -> BoxesRunTime.boxToBoolean((boolean)Logic$.$anonfun$applyAll$1(x$18))) : (List)((List)cs.clauses().map((Function1 & Serializable & scala.Serializable)c -> MODULE$.applyAll((Clause)c, facts), List$.MODULE$.canBuildFrom())).flatMap((Function1 & Serializable & scala.Serializable)x$19 -> x$19.toList(), List$.MODULE$.canBuildFrom());
        return newClauses.isEmpty() ? None$.MODULE$ : new Some((Object)new Clauses((List<Clause>)newClauses));
    }

    public Option<Clause> applyAll(Clause c, Set<Literal> facts) {
        Set atoms = (Set)facts.map((Function1 & Serializable & scala.Serializable)x$20 -> x$20.atom(), Set$.MODULE$.canBuildFrom());
        Set newHead = (Set)c.head().$minus$minus((GenTraversableOnce)atoms);
        return newHead.isEmpty() ? None$.MODULE$ : this.substitute(c.body(), facts).map((Function1 & Serializable & scala.Serializable)f -> new Clause((Formula)f, (Set<Atom>)newHead));
    }

    public Option<Formula> substitute(Formula formula, Set<Literal> facts) {
        Some some;
        block5: {
            Formula formula2;
            while (true) {
                if ((formula2 = formula) instanceof Formula.And) {
                    None$ none$;
                    Formula.And and = (Formula.And)formula2;
                    Set<Literal> lits = and.literals();
                    if (lits.exists((Function1)Logic$.negated$1(facts))) {
                        none$ = None$.MODULE$;
                    } else {
                        Set newLits = (Set)lits.$minus$minus(facts);
                        Formula newF = newLits.isEmpty() ? Formula$True$.MODULE$ : new Formula.And((Set<Literal>)newLits);
                        none$ = new Some((Object)newF);
                    }
                    some = none$;
                    break block5;
                }
                if (Formula$True$.MODULE$.equals(formula2)) {
                    some = new Some((Object)Formula$True$.MODULE$);
                    break block5;
                }
                if (!(formula2 instanceof Literal)) break;
                Literal literal = (Literal)formula2;
                formula = new Formula.And((Set<Literal>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Literal[]{literal}))));
            }
            throw new MatchError((Object)formula2);
        }
        return some;
    }

    public static final /* synthetic */ boolean $anonfun$findProven$1(Clause x$8) {
        Formula formula = x$8.body();
        Formula$True$ formula$True$ = Formula$True$.MODULE$;
        return !(formula != null ? !formula.equals(formula$True$) : formula$True$ != null);
    }

    public static final /* synthetic */ boolean $anonfun$applyAll$1(Clause x$18) {
        return x$18.head().nonEmpty();
    }

    private static final Set negated$1(Set lits) {
        return (Set)lits.map((Function1 & Serializable & scala.Serializable)a -> a.unary_$bang(), Set$.MODULE$.canBuildFrom());
    }

    private Logic$() {
        MODULE$ = this;
    }
}

