/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util.io;

import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.AssumptionViolatedException;

public class IoTestUtil {
    public static final boolean isSymLinkCreationSupported = SystemInfo.isUnix || SystemInfo.isWinVistaOrNewer && IoTestUtil.canCreateSymlinks();
    private static final String[] UNICODE_PARTS = new String[]{"\u042e\u043d\u0438\u043a\u043e\u0434\u0435", "\u00da\u00f1\u00ed\u00e7\u00f8d\u00ea"};

    private IoTestUtil() {
    }

    @Nullable
    public static String getUnicodeName() {
        return IoTestUtil.filterParts(PathUtil::isValidFileName);
    }

    @Nullable
    public static String getUnicodeName(String forEncoding) {
        return IoTestUtil.filterParts(Charset.forName(forEncoding).newEncoder()::canEncode);
    }

    private static String filterParts(Predicate<? super String> predicate) {
        return StringUtil.nullize((String)Stream.of(UNICODE_PARTS).filter(predicate).collect(Collectors.joining("_")));
    }

    @NotNull
    public static File getTempDirectory() {
        File dir = new File(FileUtil.getTempDirectory());
        File file = dir = IoTestUtil.expandWindowsPath(dir);
        if (file == null) {
            IoTestUtil.$$$reportNull$$$0(0);
        }
        return file;
    }

    private static File expandWindowsPath(File file) {
        if (SystemInfo.isWindows && file.getPath().indexOf(126) > 0) {
            try {
                return file.getCanonicalFile();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return file;
    }

    @NotNull
    public static File createSymLink(@NotNull String target, @NotNull String link) {
        if (target == null) {
            IoTestUtil.$$$reportNull$$$0(1);
        }
        if (link == null) {
            IoTestUtil.$$$reportNull$$$0(2);
        }
        File file = IoTestUtil.createSymLink(target, link, true);
        if (file == null) {
            IoTestUtil.$$$reportNull$$$0(3);
        }
        return file;
    }

    @NotNull
    public static File createSymLink(@NotNull String target, @NotNull String link, boolean shouldExist) {
        if (target == null) {
            IoTestUtil.$$$reportNull$$$0(4);
        }
        if (link == null) {
            IoTestUtil.$$$reportNull$$$0(5);
        }
        File linkFile = IoTestUtil.getFullLinkPath(link);
        try {
            Files.createSymbolicLink(linkFile.toPath(), FileSystems.getDefault().getPath(target, new String[0]), new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        Assert.assertEquals((String)("target=" + target + ", link=" + linkFile), (Object)shouldExist, (Object)linkFile.exists());
        File file = linkFile;
        if (file == null) {
            IoTestUtil.$$$reportNull$$$0(6);
        }
        return file;
    }

    public static void assumeSymLinkCreationIsSupported() throws AssumptionViolatedException {
        Assume.assumeTrue((String)"Expected can create symlinks", (boolean)isSymLinkCreationSupported);
    }

    @NotNull
    public static File createJunction(@NotNull String target, @NotNull String junction) {
        if (target == null) {
            IoTestUtil.$$$reportNull$$$0(7);
        }
        if (junction == null) {
            IoTestUtil.$$$reportNull$$$0(8);
        }
        Assert.assertTrue((boolean)SystemInfo.isWindows);
        File targetFile = new File(target);
        Assert.assertTrue((String)targetFile.getPath(), (boolean)targetFile.isDirectory());
        File junctionFile = IoTestUtil.getFullLinkPath(junction);
        IoTestUtil.runCommand("cmd", "/C", "mklink", "/J", junctionFile.getPath(), targetFile.getPath());
        Assert.assertTrue((String)("target=" + targetFile + ", link=" + junctionFile), (boolean)junctionFile.isDirectory());
        File file = junctionFile;
        if (file == null) {
            IoTestUtil.$$$reportNull$$$0(9);
        }
        return file;
    }

    public static void deleteJunction(@NotNull String junction) {
        if (junction == null) {
            IoTestUtil.$$$reportNull$$$0(10);
        }
        Assert.assertTrue((boolean)SystemInfo.isWindows);
        Assert.assertTrue((boolean)new File(junction).delete());
    }

    @NotNull
    public static File createSubst(@NotNull String target) {
        if (target == null) {
            IoTestUtil.$$$reportNull$$$0(11);
        }
        Assert.assertTrue((boolean)SystemInfo.isWindows);
        File targetFile = new File(target);
        Assert.assertTrue((String)targetFile.getPath(), (boolean)targetFile.isDirectory());
        String substRoot = IoTestUtil.getFirstFreeDriveLetter() + ":";
        IoTestUtil.runCommand("subst", substRoot, targetFile.getPath());
        File rootFile = new File(substRoot + "\\");
        Assert.assertTrue((String)("target=" + targetFile + ", subst=" + rootFile), (boolean)rootFile.isDirectory());
        File file = rootFile;
        if (file == null) {
            IoTestUtil.$$$reportNull$$$0(12);
        }
        return file;
    }

    public static void deleteSubst(@NotNull String substRoot) {
        if (substRoot == null) {
            IoTestUtil.$$$reportNull$$$0(13);
        }
        IoTestUtil.runCommand("subst", StringUtil.trimEnd((String)substRoot, (String)"\\"), "/d");
    }

    private static char getFirstFreeDriveLetter() {
        Set roots = ContainerUtil.map2Set((Object[])File.listRoots(), root -> Character.valueOf(StringUtil.toUpperCase((String)root.getPath()).charAt(0)));
        for (char c = 'E'; c <= 'Z'; c = (char)(c + '\u0001')) {
            if (roots.contains(Character.valueOf(c))) continue;
            return c;
        }
        throw new RuntimeException("No free roots");
    }

    private static File getFullLinkPath(String link) {
        File linkFile = new File(link);
        if (!linkFile.isAbsolute()) {
            linkFile = new File(IoTestUtil.getTempDirectory(), link);
        }
        Assert.assertTrue((String)link, (!linkFile.exists() || linkFile.delete() ? 1 : 0) != 0);
        File parentDir = linkFile.getParentFile();
        Assert.assertTrue((String)("link=" + link + ", parent=" + parentDir), (parentDir != null && (parentDir.isDirectory() || parentDir.mkdirs()) ? 1 : 0) != 0);
        return linkFile;
    }

    private static void runCommand(String ... command) {
        try {
            ProcessBuilder builder = new ProcessBuilder(command);
            builder.redirectErrorStream(true);
            Process process = builder.start();
            StringBuilder output = new StringBuilder();
            Thread thread = new Thread(() -> {
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream(), StandardCharsets.UTF_8));){
                    String line;
                    while ((line = reader.readLine()) != null) {
                        output.append(line).append('\n');
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }, "io test");
            thread.start();
            int ret = process.waitFor();
            thread.join();
            if (ret != 0) {
                throw new RuntimeException(builder.command() + "\nresult: " + ret + "\noutput:\n" + output);
            }
        }
        catch (IOException | InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public static void assertTimestampsEqual(long expected, long actual) {
        long roundedExpected = expected / 1000L * 1000L;
        long roundedActual = actual / 1000L * 1000L;
        Assert.assertEquals((String)("expected: " + expected + ", actual: " + actual), (long)roundedExpected, (long)roundedActual);
    }

    public static void assertTimestampsNotEqual(long expected, long actual) {
        long roundedExpected = expected / 1000L * 1000L;
        long roundedActual = actual / 1000L * 1000L;
        Assert.assertTrue((String)("(un)expected: " + expected + ", actual: " + actual), (roundedExpected != roundedActual ? 1 : 0) != 0);
    }

    @NotNull
    public static File createTestJar() {
        File file;
        try {
            File jarFile = IoTestUtil.expandWindowsPath(FileUtil.createTempFile((String)"test.", (String)".jar"));
            file = IoTestUtil.createTestJar(jarFile);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (file == null) {
            IoTestUtil.$$$reportNull$$$0(14);
        }
        return file;
    }

    @NotNull
    public static File createTestJar(File jarFile) {
        File file = IoTestUtil.createTestJar(jarFile, "META-INF/MANIFEST.MF", "");
        if (file == null) {
            IoTestUtil.$$$reportNull$$$0(15);
        }
        return file;
    }

    /*
     * Loose catch block
     */
    @NotNull
    public static File createTestJar(@NotNull File jarFile, String ... namesAndTexts) {
        if (jarFile == null) {
            IoTestUtil.$$$reportNull$$$0(16);
        }
        if (namesAndTexts == null) {
            IoTestUtil.$$$reportNull$$$0(17);
        }
        ZipOutputStream stream = new ZipOutputStream(new FileOutputStream(jarFile));
        Throwable throwable = null;
        for (int i = 0; i < namesAndTexts.length; i += 2) {
            stream.putNextEntry(new ZipEntry(namesAndTexts[i]));
            if (namesAndTexts[i + 1] != null) {
                stream.write(namesAndTexts[i + 1].getBytes(StandardCharsets.UTF_8));
            }
            stream.closeEntry();
        }
        File file = jarFile;
        File file2 = file;
        if (file2 == null) {
            IoTestUtil.$$$reportNull$$$0(18);
        }
        return file2;
        {
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (stream != null) {
                    if (throwable != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        stream.close();
                    }
                }
            }
            {
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    /*
     * Could not resolve type clashes
     * Loose catch block
     */
    @NotNull
    public static File createTestJar(@NotNull File jarFile, @NotNull Collection<? extends Pair<String, byte[]>> namesAndContents) {
        if (jarFile == null) {
            IoTestUtil.$$$reportNull$$$0(19);
        }
        if (namesAndContents == null) {
            IoTestUtil.$$$reportNull$$$0(20);
        }
        ZipOutputStream stream = new ZipOutputStream(new FileOutputStream(jarFile));
        Throwable throwable = null;
        for (Pair<String, byte[]> p : namesAndContents) {
            String name = (String)p.first;
            byte[] content = (byte[])p.second;
            stream.putNextEntry(new ZipEntry(name));
            stream.write(content);
            stream.closeEntry();
        }
        File file = jarFile;
        Object object = file;
        if (object == null) {
            IoTestUtil.$$$reportNull$$$0(21);
        }
        return object;
        {
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (stream != null) {
                    if (throwable != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        stream.close();
                    }
                }
            }
            {
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    /*
     * Loose catch block
     */
    @NotNull
    public static File createTestJar(@NotNull File jarFile, @NotNull File root) {
        if (jarFile == null) {
            IoTestUtil.$$$reportNull$$$0(22);
        }
        if (root == null) {
            IoTestUtil.$$$reportNull$$$0(23);
        }
        ZipOutputStream stream = new ZipOutputStream(new FileOutputStream(jarFile));
        Throwable throwable = null;
        FileUtil.visitFiles((File)root, file -> {
            if (file.isFile()) {
                String path = FileUtil.toSystemIndependentName((String)((String)ObjectUtils.assertNotNull((Object)FileUtil.getRelativePath((File)root, (File)file))));
                try {
                    stream.putNextEntry(new ZipEntry(path));
                    try (FileInputStream is = new FileInputStream((File)file);){
                        FileUtil.copy((InputStream)is, (OutputStream)stream);
                    }
                    stream.closeEntry();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            return true;
        });
        File file2 = jarFile;
        File file3 = file2;
        if (file3 == null) {
            IoTestUtil.$$$reportNull$$$0(24);
        }
        return file3;
        {
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (stream != null) {
                    if (throwable != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        stream.close();
                    }
                }
            }
            {
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    @NotNull
    public static File createTestDir(@NotNull String name) {
        if (name == null) {
            IoTestUtil.$$$reportNull$$$0(25);
        }
        File file = IoTestUtil.createTestDir(IoTestUtil.getTempDirectory(), name);
        if (file == null) {
            IoTestUtil.$$$reportNull$$$0(26);
        }
        return file;
    }

    @NotNull
    public static File createTestDir(@NotNull File parent, @NotNull String name) {
        if (parent == null) {
            IoTestUtil.$$$reportNull$$$0(27);
        }
        if (name == null) {
            IoTestUtil.$$$reportNull$$$0(28);
        }
        File dir = new File(parent, name);
        Assert.assertTrue((String)dir.getPath(), (boolean)dir.mkdirs());
        File file = dir;
        if (file == null) {
            IoTestUtil.$$$reportNull$$$0(29);
        }
        return file;
    }

    @NotNull
    public static File createTestFile(@NotNull String name) {
        if (name == null) {
            IoTestUtil.$$$reportNull$$$0(30);
        }
        File file = IoTestUtil.createTestFile(name, null);
        if (file == null) {
            IoTestUtil.$$$reportNull$$$0(31);
        }
        return file;
    }

    @NotNull
    public static File createTestFile(@NotNull String name, @Nullable String content) {
        if (name == null) {
            IoTestUtil.$$$reportNull$$$0(32);
        }
        File file = IoTestUtil.createTestFile(IoTestUtil.getTempDirectory(), name, content);
        if (file == null) {
            IoTestUtil.$$$reportNull$$$0(33);
        }
        return file;
    }

    @NotNull
    public static File createTestFile(@NotNull File parent, @NotNull String name) {
        if (parent == null) {
            IoTestUtil.$$$reportNull$$$0(34);
        }
        if (name == null) {
            IoTestUtil.$$$reportNull$$$0(35);
        }
        File file = IoTestUtil.createTestFile(parent, name, null);
        if (file == null) {
            IoTestUtil.$$$reportNull$$$0(36);
        }
        return file;
    }

    @NotNull
    public static File createTestFile(@NotNull File parent, @NotNull String name, @Nullable String content) {
        File file;
        if (parent == null) {
            IoTestUtil.$$$reportNull$$$0(37);
        }
        if (name == null) {
            IoTestUtil.$$$reportNull$$$0(38);
        }
        try {
            Assert.assertTrue((String)parent.getPath(), (parent.isDirectory() || parent.mkdirs() ? 1 : 0) != 0);
            File file2 = new File(parent, name);
            Assert.assertTrue((String)file2.getPath(), (boolean)file2.createNewFile());
            if (content != null) {
                FileUtil.writeToFile((File)file2, (String)content);
            }
            file = file2;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (file == null) {
            IoTestUtil.$$$reportNull$$$0(39);
        }
        return file;
    }

    public static void delete(File ... files) {
        for (File file : files) {
            if (file == null) continue;
            FileUtil.delete((File)file);
        }
    }

    public static void updateFile(@NotNull File file, String content) {
        if (file == null) {
            IoTestUtil.$$$reportNull$$$0(40);
        }
        try {
            FileUtil.writeToFile((File)file, (String)content);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean canCreateSymlinks() {
        File target = null;
        File link = null;
        try {
            target = File.createTempFile("IOTestUtil_link_target.", ".txt");
            link = new File(target.getParent(), target.getName().replace("IOTestUtil_link_target", "IOTestUtil_link"));
            Files.createSymbolicLink(link.toPath(), target.toPath(), new FileAttribute[0]);
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (link != null) {
                link.delete();
            }
            if (target != null) {
                target.delete();
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 13: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 25: 
            case 27: 
            case 28: 
            case 30: 
            case 32: 
            case 34: 
            case 35: 
            case 37: 
            case 38: 
            case 40: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 13: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 25: 
            case 27: 
            case 28: 
            case 30: 
            case 32: 
            case 34: 
            case 35: 
            case 37: 
            case 38: 
            case 40: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/util/io/IoTestUtil";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "link";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "junction";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substRoot";
                break;
            }
            case 16: 
            case 19: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jarFile";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namesAndTexts";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namesAndContents";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 25: 
            case 28: 
            case 30: 
            case 32: 
            case 35: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 27: 
            case 34: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getTempDirectory";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 13: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 25: 
            case 27: 
            case 28: 
            case 30: 
            case 32: 
            case 34: 
            case 35: 
            case 37: 
            case 38: 
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/util/io/IoTestUtil";
                break;
            }
            case 3: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createSymLink";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createJunction";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "createSubst";
                break;
            }
            case 14: 
            case 15: 
            case 18: 
            case 21: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "createTestJar";
                break;
            }
            case 26: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "createTestDir";
                break;
            }
            case 31: 
            case 33: 
            case 36: 
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "createTestFile";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createSymLink";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createJunction";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "deleteJunction";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createSubst";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "deleteSubst";
                break;
            }
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "createTestJar";
                break;
            }
            case 25: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "createTestDir";
                break;
            }
            case 30: 
            case 32: 
            case 34: 
            case 35: 
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "createTestFile";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "updateFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 13: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 25: 
            case 27: 
            case 28: 
            case 30: 
            case 32: 
            case 34: 
            case 35: 
            case 37: 
            case 38: 
            case 40: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

