/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.relaxNG.model.annotation;

import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.SmartList;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.highlighting.DomElementAnnotationHolder;
import com.intellij.util.xml.highlighting.DomElementsAnnotator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.intellij.plugins.relaxNG.model.CommonElement;
import org.intellij.plugins.relaxNG.model.Define;
import org.intellij.plugins.relaxNG.model.Grammar;
import org.intellij.plugins.relaxNG.model.Include;
import org.intellij.plugins.relaxNG.model.annotation.CommonAnnotationHolder;
import org.intellij.plugins.relaxNG.model.annotation.OverriddenDefineRenderer;
import org.intellij.plugins.relaxNG.model.annotation.OverriddenDefineSearcher;
import org.intellij.plugins.relaxNG.model.annotation.OverridingDefineRenderer;
import org.intellij.plugins.relaxNG.model.resolve.DefinitionResolver;
import org.intellij.plugins.relaxNG.model.resolve.GrammarFactory;
import org.intellij.plugins.relaxNG.model.resolve.RelaxIncludeIndex;
import org.intellij.plugins.relaxNG.xml.dom.RngDomElement;
import org.jetbrains.annotations.NotNull;

public final class ModelAnnotator
implements Annotator,
DomElementsAnnotator {
    public void annotate(@NotNull PsiElement psiElement, @NotNull AnnotationHolder holder) {
        if (psiElement == null) {
            ModelAnnotator.$$$reportNull$$$0(0);
        }
        if (holder == null) {
            ModelAnnotator.$$$reportNull$$$0(1);
        }
        if (psiElement instanceof CommonElement) {
            ((CommonElement)psiElement).accept(new MyAnnotator(CommonAnnotationHolder.create(holder)));
        }
    }

    public void annotate(DomElement element, DomElementAnnotationHolder holder) {
        if (element instanceof RngDomElement) {
            ((RngDomElement)element).accept(new MyAnnotator(CommonAnnotationHolder.create(holder)));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "psiElement";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "holder";
                break;
            }
        }
        objectArray[1] = "org/intellij/plugins/relaxNG/model/annotation/ModelAnnotator";
        objectArray[2] = "annotate";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class MyAnnotator<T>
    extends CommonElement.Visitor {
        private final CommonAnnotationHolder<T> myHolder;

        MyAnnotator(CommonAnnotationHolder<T> holder) {
            this.myHolder = holder;
        }

        @Override
        public void visitDefine(Define define) {
            Object element = define.getPsiElement();
            if (element != null) {
                XmlFile xmlFile = (XmlFile)element.getContainingFile();
                SmartList result = new SmartList();
                final OverriddenDefineSearcher searcher = new OverriddenDefineSearcher(define, xmlFile, (List<? super Define>)result);
                PsiElementProcessor.FindElement<XmlFile> processor = new PsiElementProcessor.FindElement<XmlFile>((List)result){
                    final /* synthetic */ List val$result;
                    {
                        this.val$result = list;
                    }

                    public boolean execute(@NotNull XmlFile file) {
                        Grammar grammar;
                        if (file == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        if ((grammar = GrammarFactory.getGrammar(file)) == null) {
                            return true;
                        }
                        grammar.acceptChildren(searcher);
                        return this.val$result.size() == 0 || super.execute((PsiElement)file);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/intellij/plugins/relaxNG/model/annotation/ModelAnnotator$MyAnnotator$1", "execute"));
                    }
                };
                RelaxIncludeIndex.processBackwardDependencies(xmlFile, (PsiElementProcessor<? super XmlFile>)processor);
                if (processor.isFound()) {
                    this.createGutterAnnotation(define, new OverriddenDefineRenderer(define));
                }
            }
        }

        private void createGutterAnnotation(CommonElement t, GutterIconRenderer renderer) {
            Annotation a = this.myHolder.createAnnotation(t, HighlightSeverity.INFORMATION, null);
            a.setGutterIconRenderer(renderer);
        }

        @Override
        public void visitInclude(Include inc) {
            Define[] overrides;
            for (Define define : overrides = inc.getOverrides()) {
                Map<String, Set<Define>> map;
                Grammar grammar;
                PsiFile file = inc.getInclude();
                if (!(file instanceof XmlFile) || (grammar = GrammarFactory.getGrammar((XmlFile)file)) == null || (map = DefinitionResolver.getAllVariants(grammar)) == null) continue;
                Set<Define> set = map.get(define.getName());
                if (set == null || set.size() == 0) {
                    this.myHolder.createAnnotation(define, HighlightSeverity.ERROR, "Definition doesn't override anything from " + file.getName());
                    continue;
                }
                String message = "Overrides '" + define.getName() + "' in " + file.getName();
                this.createGutterAnnotation(define, new OverridingDefineRenderer(message, set));
            }
        }
    }
}

