/*
 * Decompiled with CFR 0.152.
 */
package git4idea.branch;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsNotifier;
import git4idea.branch.GitBranchOperation;
import git4idea.branch.GitBranchUiHandler;
import git4idea.commands.Git;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitCompoundResult;
import git4idea.commands.GitLineHandlerListener;
import git4idea.commands.GitSimpleEventDetector;
import git4idea.repo.GitRepository;
import git4idea.util.GitUIUtil;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

class GitCheckoutNewBranchOperation
extends GitBranchOperation {
    @NotNull
    private final Project myProject;
    @NotNull
    private final String myNewBranchName;

    GitCheckoutNewBranchOperation(@NotNull Project project, @NotNull Git git, @NotNull GitBranchUiHandler uiHandler, @NotNull Collection<? extends GitRepository> repositories, @NotNull String newBranchName) {
        if (project == null) {
            GitCheckoutNewBranchOperation.$$$reportNull$$$0(0);
        }
        if (git == null) {
            GitCheckoutNewBranchOperation.$$$reportNull$$$0(1);
        }
        if (uiHandler == null) {
            GitCheckoutNewBranchOperation.$$$reportNull$$$0(2);
        }
        if (repositories == null) {
            GitCheckoutNewBranchOperation.$$$reportNull$$$0(3);
        }
        if (newBranchName == null) {
            GitCheckoutNewBranchOperation.$$$reportNull$$$0(4);
        }
        super(project, git, uiHandler, repositories);
        this.myNewBranchName = newBranchName;
        this.myProject = project;
    }

    @Override
    protected void execute() {
        boolean fatalErrorHappened = false;
        this.notifyBranchWillChange();
        while (this.hasMoreRepositories() && !fatalErrorHappened) {
            GitSimpleEventDetector unmergedDetector;
            GitRepository repository = this.next();
            GitCommandResult result2 = this.myGit.checkoutNewBranch(repository, this.myNewBranchName, unmergedDetector = new GitSimpleEventDetector(GitSimpleEventDetector.Event.UNMERGED_PREVENTING_CHECKOUT));
            if (result2.success()) {
                GitCheckoutNewBranchOperation.refresh(repository);
                this.markSuccessful(repository);
                continue;
            }
            if (unmergedDetector.hasHappened()) {
                this.fatalUnmergedFilesError();
                fatalErrorHappened = true;
                continue;
            }
            this.fatalError("Couldn't create new branch " + this.myNewBranchName, result2.getErrorOutputAsJoinedString());
            fatalErrorHappened = true;
        }
        if (!fatalErrorHappened) {
            this.notifySuccess();
            this.notifyBranchHasChanged(this.myNewBranchName);
            this.updateRecentBranch();
        }
    }

    private static void refresh(@NotNull GitRepository repository) {
        if (repository == null) {
            GitCheckoutNewBranchOperation.$$$reportNull$$$0(5);
        }
        repository.update();
    }

    @Override
    @NotNull
    public String getSuccessMessage() {
        String string = String.format("Branch <b><code>%s</code></b> was created", this.myNewBranchName);
        if (string == null) {
            GitCheckoutNewBranchOperation.$$$reportNull$$$0(6);
        }
        return string;
    }

    @Override
    @NotNull
    protected String getRollbackProposal() {
        String string = "However checkout has succeeded for the following " + this.repositories() + ":<br/>" + this.successfulRepositoriesJoined() + "<br/>You may rollback (checkout previous branch back, and delete " + this.myNewBranchName + ") not to let branches diverge.";
        if (string == null) {
            GitCheckoutNewBranchOperation.$$$reportNull$$$0(7);
        }
        return string;
    }

    @Override
    @NotNull
    protected String getOperationName() {
        if ("checkout" == null) {
            GitCheckoutNewBranchOperation.$$$reportNull$$$0(8);
        }
        return "checkout";
    }

    @Override
    protected void rollback() {
        GitCompoundResult checkoutResult = new GitCompoundResult(this.myProject);
        GitCompoundResult deleteResult = new GitCompoundResult(this.myProject);
        Collection<GitRepository> repositories = this.getSuccessfulRepositories();
        for (GitRepository repository : repositories) {
            GitCommandResult result2 = this.myGit.checkout(repository, (String)this.myCurrentHeads.get(repository), null, true, false, new GitLineHandlerListener[0]);
            checkoutResult.append(repository, result2);
            if (result2.success()) {
                deleteResult.append(repository, this.myGit.branchDelete(repository, this.myNewBranchName, false, new GitLineHandlerListener[0]));
            }
            GitCheckoutNewBranchOperation.refresh(repository);
        }
        if (checkoutResult.totalSuccess() && deleteResult.totalSuccess()) {
            VcsNotifier.getInstance((Project)this.myProject).notifySuccess("Rollback successful", String.format("Checked out %s and deleted %s on %s %s", GitCheckoutNewBranchOperation.stringifyBranchesByRepos(this.myCurrentHeads), GitUIUtil.code(this.myNewBranchName), StringUtil.pluralize((String)"root", (int)repositories.size()), this.successfulRepositoriesJoined()));
        } else {
            StringBuilder message = new StringBuilder();
            if (!checkoutResult.totalSuccess()) {
                message.append("Errors during checkout: ");
                message.append(checkoutResult.getErrorOutputWithReposIndication());
            }
            if (!deleteResult.totalSuccess()) {
                message.append("Errors during deleting ").append(GitUIUtil.code(this.myNewBranchName));
                message.append(deleteResult.getErrorOutputWithReposIndication());
            }
            VcsNotifier.getInstance((Project)this.myProject).notifyError("Error during rollback", message.toString());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uiHandler";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repositories";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newBranchName";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repository";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/branch/GitCheckoutNewBranchOperation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/branch/GitCheckoutNewBranchOperation";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuccessMessage";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getRollbackProposal";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getOperationName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "refresh";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

