/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profile.codeInspection.ui;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.SeverityRegistrar;
import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.ex.AppInspectionProfilesVisibleTreeState;
import com.intellij.codeInspection.ex.Descriptor;
import com.intellij.codeInspection.ex.GlobalInspectionToolWrapper;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionProfileModifiableModel;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.ProjectInspectionProfilesVisibleTreeState;
import com.intellij.codeInspection.ex.ScopeToolState;
import com.intellij.codeInspection.ex.VisibleTreeState;
import com.intellij.icons.AllIcons;
import com.intellij.ide.BrowserUtil;
import com.intellij.ide.CommonActionsManager;
import com.intellij.ide.DataManager;
import com.intellij.ide.DefaultTreeExpander;
import com.intellij.ide.TreeExpander;
import com.intellij.ide.actions.ShowSettingsUtilImpl;
import com.intellij.ide.ui.search.SearchUtil;
import com.intellij.ide.ui.search.SearchableOptionsRegistrar;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.options.ex.Settings;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Getter;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.profile.codeInspection.BaseInspectionProfileManager;
import com.intellij.profile.codeInspection.InspectionProfileManager;
import com.intellij.profile.codeInspection.ProjectInspectionProfileManager;
import com.intellij.profile.codeInspection.ui.LevelChooserAction;
import com.intellij.profile.codeInspection.ui.ScopesChooser;
import com.intellij.profile.codeInspection.ui.ToolDescriptors;
import com.intellij.profile.codeInspection.ui.filter.InspectionFilterAction;
import com.intellij.profile.codeInspection.ui.filter.InspectionsFilter;
import com.intellij.profile.codeInspection.ui.inspectionsTree.InspectionConfigTreeNode;
import com.intellij.profile.codeInspection.ui.inspectionsTree.InspectionsConfigTreeComparator;
import com.intellij.profile.codeInspection.ui.inspectionsTree.InspectionsConfigTreeRenderer;
import com.intellij.profile.codeInspection.ui.inspectionsTree.InspectionsConfigTreeTable;
import com.intellij.profile.codeInspection.ui.table.ScopesAndSeveritiesTable;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.ui.FilterComponent;
import com.intellij.ui.GuiUtils;
import com.intellij.ui.HintHint;
import com.intellij.ui.HyperlinkAdapter;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.JBSplitter;
import com.intellij.ui.OnePixelSplitter;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.TableUtil;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.UserActivityWatcher;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.labels.LinkLabel;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.Alarm;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Convertor;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.ListSelectionModel;
import javax.swing.border.Border;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SingleInspectionProfilePanel
extends JPanel {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInspection.ex.InspectionToolsPanel");
    @NonNls
    private static final String INSPECTION_FILTER_HISTORY = "INSPECTION_FILTER_HISTORY";
    @NonNls
    private static final String EMPTY_HTML = "<html><body></body></html>";
    private static final float DIVIDER_PROPORTION_DEFAULT = 0.5f;
    public static final String SETTINGS = "settings://";
    private final Map<HighlightDisplayKey, ToolDescriptors> myInitialToolDescriptors;
    private final InspectionConfigTreeNode myRoot;
    private final Alarm myAlarm;
    private final ProjectInspectionProfileManager myProjectProfileManager;
    @NotNull
    private final InspectionProfileModifiableModel myProfile;
    private JEditorPane myBrowser;
    private JPanel myOptionsPanel;
    private JPanel myInspectionProfilePanel;
    private FilterComponent myProfileFilter;
    private final InspectionsFilter myInspectionsFilter;
    private boolean myModified;
    private InspectionsConfigTreeTable myTreeTable;
    private TreeExpander myTreeExpander;
    private boolean myIsInRestore;
    private String[] myInitialScopesOrder;
    private Disposable myDisposable;

    public SingleInspectionProfilePanel(@NotNull ProjectInspectionProfileManager projectProfileManager, @NotNull InspectionProfileModifiableModel profile2) {
        if (projectProfileManager == null) {
            SingleInspectionProfilePanel.$$$reportNull$$$0(0);
        }
        if (profile2 == null) {
            SingleInspectionProfilePanel.$$$reportNull$$$0(1);
        }
        super(new BorderLayout());
        this.myInitialToolDescriptors = new THashMap();
        this.myRoot = new InspectionConfigTreeNode.Group(InspectionsBundle.message((String)"inspection.root.node.title", (Object[])new Object[0]));
        this.myAlarm = new Alarm();
        this.myInspectionsFilter = new InspectionsFilter(){

            @Override
            protected void filterChanged() {
                SingleInspectionProfilePanel.this.filterTree();
            }
        };
        this.myDisposable = Disposer.newDisposable();
        this.myProjectProfileManager = projectProfileManager;
        this.myProfile = profile2;
        this.myProfile.initInspectionTools(projectProfileManager.getProject());
    }

    public boolean differsFromDefault() {
        return this.myRoot.isProperSetting();
    }

    public void performProfileReset() {
        TreeUtil.treeNodeTraverser((TreeNode)this.myRoot).traverse().processEach(n -> {
            InspectionConfigTreeNode node = (InspectionConfigTreeNode)n;
            if (node instanceof InspectionConfigTreeNode.Tool && node.isProperSetting()) {
                ((InspectionConfigTreeNode.Tool)node).getDefaultDescriptor().loadConfig();
            }
            return true;
        });
        this.getProfile().resetToBase(this.myProjectProfileManager.getProject());
        this.loadDescriptorsConfigs(true);
        this.postProcessModification();
        this.updateModificationMarker();
        this.myRoot.dropCache();
    }

    private static VisibleTreeState getExpandedNodes(InspectionProfileImpl profile2) {
        if (profile2.isProjectLevel()) {
            return ProjectInspectionProfilesVisibleTreeState.getInstance(((ProjectInspectionProfileManager)profile2.getProfileManager()).getProject()).getVisibleTreeState(profile2);
        }
        return AppInspectionProfilesVisibleTreeState.getInstance().getVisibleTreeState(profile2);
    }

    private static InspectionConfigTreeNode findGroupNodeByPath(@NotNull String[] path, int idx, @NotNull InspectionConfigTreeNode node) {
        if (path == null) {
            SingleInspectionProfilePanel.$$$reportNull$$$0(2);
        }
        if (node == null) {
            SingleInspectionProfilePanel.$$$reportNull$$$0(3);
        }
        if (path.length == idx) {
            return node;
        }
        String currentKey = path[idx];
        for (int i = 0; i < node.getChildCount(); ++i) {
            InspectionConfigTreeNode currentNode = (InspectionConfigTreeNode)node.getChildAt(i);
            if (!(currentNode instanceof InspectionConfigTreeNode.Group) || !((InspectionConfigTreeNode.Group)currentNode).getGroupName().equals(currentKey)) continue;
            return SingleInspectionProfilePanel.findGroupNodeByPath(path, ++idx, currentNode);
        }
        return null;
    }

    @Nullable
    private static InspectionConfigTreeNode findNodeByKey(String name, InspectionConfigTreeNode root) {
        for (int i = 0; i < root.getChildCount(); ++i) {
            InspectionConfigTreeNode child2 = (InspectionConfigTreeNode)root.getChildAt(i);
            if (child2 instanceof InspectionConfigTreeNode.Tool) {
                if (!((InspectionConfigTreeNode.Tool)child2).getKey().toString().equals(name)) continue;
                return child2;
            }
            InspectionConfigTreeNode node = SingleInspectionProfilePanel.findNodeByKey(name, child2);
            if (node == null) continue;
            return node;
        }
        return null;
    }

    public static String renderSeverity(HighlightSeverity severity) {
        if (HighlightSeverity.INFORMATION.equals((Object)severity)) {
            return "No highlighting, only fix";
        }
        return StringUtil.capitalizeWords((String)StringUtil.toLowerCase((String)severity.getName()), (boolean)true);
    }

    private static boolean isDescriptorAccepted(Descriptor descriptor2, @NonNls String filter, boolean forceInclude, List<Set<String>> keySetList, Set<String> quoted) {
        filter = StringUtil.toLowerCase((String)filter);
        if (StringUtil.containsIgnoreCase((String)descriptor2.getText(), (String)filter)) {
            return true;
        }
        String[] groupPath = descriptor2.getGroup();
        for (String group : groupPath) {
            if (!StringUtil.containsIgnoreCase((String)group, (String)filter)) continue;
            return true;
        }
        for (String string : quoted) {
            if (StringUtil.containsIgnoreCase((String)descriptor2.getText(), (String)string)) {
                return true;
            }
            for (String group : groupPath) {
                if (!StringUtil.containsIgnoreCase((String)group, (String)string)) continue;
                return true;
            }
            String description = descriptor2.getToolWrapper().loadDescription();
            if (description != null && StringUtil.containsIgnoreCase((String)StringUtil.toLowerCase((String)description), (String)string)) {
                if (forceInclude) continue;
                return true;
            }
            if (!forceInclude) continue;
            return false;
        }
        for (Set set : keySetList) {
            if (set.contains(descriptor2.getKey().toString())) {
                if (forceInclude) continue;
                return true;
            }
            if (!forceInclude) continue;
            return false;
        }
        return forceInclude;
    }

    private static void setConfigPanel(JPanel configPanelAnchor, ScopeToolState state) {
        configPanelAnchor.removeAll();
        JComponent additionalConfigPanel = state.getAdditionalConfigPanel();
        if (additionalConfigPanel != null) {
            if (UIUtil.hasScrollPane((Component)additionalConfigPanel)) {
                configPanelAnchor.add(additionalConfigPanel);
            } else {
                configPanelAnchor.add(ScrollPaneFactory.createScrollPane((Component)additionalConfigPanel, (int)0));
            }
        }
    }

    private static InspectionConfigTreeNode getGroupNode(InspectionConfigTreeNode root, String[] groupPath) {
        InspectionConfigTreeNode currentRoot = root;
        for (String group : groupPath) {
            currentRoot = SingleInspectionProfilePanel.getGroupNode(currentRoot, group);
        }
        return currentRoot;
    }

    private static InspectionConfigTreeNode getGroupNode(InspectionConfigTreeNode root, String group) {
        int childCount = root.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            InspectionConfigTreeNode child2 = (InspectionConfigTreeNode)root.getChildAt(i);
            if (!group.equals(child2.getUserObject())) continue;
            return child2;
        }
        InspectionConfigTreeNode.Group child3 = new InspectionConfigTreeNode.Group(group);
        root.add(child3);
        return child3;
    }

    private static void copyUsedSeveritiesIfUndefined(InspectionProfileImpl selectedProfile, BaseInspectionProfileManager profileManager) {
        SeverityRegistrar registrar = profileManager.getSeverityRegistrar();
        Set<HighlightSeverity> severities = selectedProfile.getUsedSeverities();
        severities.removeIf(severity -> registrar.isSeverityValid(severity.getName()));
        if (!severities.isEmpty()) {
            SeverityRegistrar oppositeRegister = selectedProfile.getProfileManager().getSeverityRegistrar();
            for (HighlightSeverity severity2 : severities) {
                TextAttributesKey attributesKey = TextAttributesKey.find((String)severity2.getName());
                TextAttributes textAttributes = oppositeRegister.getTextAttributesBySeverity(severity2);
                if (textAttributes == null) continue;
                HighlightInfoType.HighlightInfoTypeImpl info = new HighlightInfoType.HighlightInfoTypeImpl(severity2, attributesKey);
                registrar.registerSeverity(new SeverityRegistrar.SeverityBasedTextAttributes(textAttributes.clone(), info), textAttributes.getErrorStripeColor());
            }
        }
    }

    private void initUI() {
        this.myInspectionProfilePanel = this.createInspectionProfileSettingsPanel();
        this.add((Component)this.myInspectionProfilePanel, "Center");
        UserActivityWatcher userActivityWatcher = new UserActivityWatcher();
        userActivityWatcher.addUserActivityListener(() -> ApplicationManager.getApplication().invokeLater(() -> {
            if (this.isDisposed()) {
                return;
            }
            this.updateProperSettingsForSelection();
            this.updateModificationMarker();
        }));
        userActivityWatcher.register((Component)this.myOptionsPanel);
        this.updateSelectedProfileState();
        this.reset();
    }

    private void updateSelectedProfileState() {
        if (this.isDisposed()) {
            return;
        }
        this.restoreTreeState();
        this.repaintTableData();
        this.updateSelection();
    }

    public void updateSelection() {
        TreePath selectionPath;
        if (this.myTreeTable != null && (selectionPath = this.myTreeTable.getTree().getSelectionPath()) != null) {
            TreeUtil.selectNode((JTree)this.myTreeTable.getTree(), (TreeNode)((TreeNode)selectionPath.getLastPathComponent()));
            int rowForPath = this.myTreeTable.getTree().getRowForPath(selectionPath);
            TableUtil.selectRows((JTable)((Object)this.myTreeTable), (int[])new int[]{rowForPath});
            this.scrollToCenter();
        }
    }

    private void loadDescriptorsConfigs(boolean onlyModified) {
        this.myInitialToolDescriptors.values().stream().flatMap(ToolDescriptors::getDescriptors).forEach(d -> {
            if (!onlyModified || this.myProfile.isProperSetting(d.getKey().toString())) {
                d.loadConfig();
            }
        });
    }

    private void updateModificationMarker() {
        this.myModified = this.myInitialToolDescriptors.values().stream().flatMap(ToolDescriptors::getDescriptors).anyMatch(descriptor2 -> {
            Element oldConfig = descriptor2.getConfig();
            if (oldConfig == null) {
                return false;
            }
            ScopeToolState state = descriptor2.getState();
            Element newConfig = Descriptor.createConfigElement(state.getTool());
            if (!JDOMUtil.areElementsEqual((Element)oldConfig, (Element)newConfig)) {
                this.myAlarm.cancelAllRequests();
                this.myAlarm.addRequest(() -> this.myTreeTable.repaint(), 300);
                return true;
            }
            return false;
        });
    }

    private void updateProperSettingsForSelection() {
        InspectionConfigTreeNode node;
        TreePath selectionPath = this.myTreeTable.getTree().getSelectionPath();
        if (selectionPath != null && (node = (InspectionConfigTreeNode)selectionPath.getLastPathComponent()) instanceof InspectionConfigTreeNode.Tool) {
            boolean properSetting = this.myProfile.isProperSetting(((InspectionConfigTreeNode.Tool)node).getKey().toString());
            if (node.isProperSetting() != properSetting) {
                this.myAlarm.cancelAllRequests();
                this.myAlarm.addRequest(() -> this.myTreeTable.repaint(), 300);
                InspectionConfigTreeNode.updateUpHierarchy(node);
            }
        }
    }

    private void initToolStates() {
        if (this.isDisposed()) {
            return;
        }
        this.myInitialToolDescriptors.clear();
        Project project = this.myProjectProfileManager.getProject();
        for (ScopeToolState state : this.myProfile.getDefaultStates(this.myProjectProfileManager.getProject())) {
            if (!this.accept(state.getTool())) continue;
            ToolDescriptors descriptors = ToolDescriptors.fromScopeToolState(state, this.myProfile, project);
            this.myInitialToolDescriptors.put(descriptors.getDefaultDescriptor().getKey(), descriptors);
        }
        this.myInitialScopesOrder = this.myProfile.getScopesOrder();
    }

    private boolean isDisposed() {
        return this.myDisposable == null;
    }

    protected boolean accept(InspectionToolWrapper entry) {
        return entry.getDefaultLevel() != HighlightDisplayLevel.NON_SWITCHABLE_ERROR;
    }

    private void postProcessModification() {
        this.updateModificationMarker();
        for (ScopeToolState state : this.myProfile.getAllTools()) {
            state.resetConfigPanel();
        }
        this.fillTreeData(this.myProfileFilter.getFilter(), true);
        this.repaintTableData();
        this.updateOptionsAndDescriptionPanel();
    }

    public void setFilter(String filter) {
        this.myProfileFilter.setFilter(filter);
    }

    private void filterTree() {
        String filter;
        String string = filter = this.myProfileFilter != null ? this.myProfileFilter.getFilter() : null;
        if (this.myTreeTable != null) {
            SingleInspectionProfilePanel.getExpandedNodes(this.myProfile).saveVisibleState((Tree)this.myTreeTable.getTree());
            this.fillTreeData(filter, true);
            this.reloadModel();
            this.restoreTreeState();
            if (this.myTreeTable.getTree().getSelectionPath() == null) {
                TreeUtil.promiseSelectFirst((JTree)this.myTreeTable.getTree());
            }
        }
    }

    private void reloadModel() {
        try {
            this.myIsInRestore = true;
            ((DefaultTreeModel)this.myTreeTable.getTree().getModel()).reload();
        }
        finally {
            this.myIsInRestore = false;
        }
    }

    private void restoreTreeState() {
        try {
            this.myIsInRestore = true;
            SingleInspectionProfilePanel.getExpandedNodes(this.myProfile).restoreVisibleState((Tree)this.myTreeTable.getTree());
        }
        finally {
            this.myIsInRestore = false;
        }
    }

    private ActionToolbar createTreeToolbarPanel() {
        CommonActionsManager actionManager = CommonActionsManager.getInstance();
        DefaultActionGroup actions = new DefaultActionGroup();
        actions.add((AnAction)new InspectionFilterAction(this.myProfile, this.myInspectionsFilter, this.myProjectProfileManager.getProject(), this.myProfileFilter));
        actions.addSeparator();
        actions.add(actionManager.createExpandAllAction(this.myTreeExpander, (JComponent)((Object)this.myTreeTable)));
        actions.add(actionManager.createCollapseAllAction(this.myTreeExpander, (JComponent)((Object)this.myTreeTable)));
        actions.add((AnAction)new DumbAwareAction("Reset to Empty", "Reset to empty", AllIcons.Actions.Unselectall){

            public void update(@NotNull AnActionEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                e.getPresentation().setEnabled(!SingleInspectionProfilePanel.this.isDisposed() && SingleInspectionProfilePanel.this.myProfile.isExecutable(SingleInspectionProfilePanel.this.myProjectProfileManager.getProject()));
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(1);
                }
                SingleInspectionProfilePanel.this.myProfile.resetToEmpty(SingleInspectionProfilePanel.this.myProjectProfileManager.getProject());
                SingleInspectionProfilePanel.this.loadDescriptorsConfigs(false);
                SingleInspectionProfilePanel.this.postProcessModification();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "e";
                objectArray2[1] = "com/intellij/profile/codeInspection/ui/SingleInspectionProfilePanel$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "update";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "actionPerformed";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        ActionToolbar actionToolbar = ActionManager.getInstance().createActionToolbar("SingleInspectionProfile", (ActionGroup)actions, true);
        actionToolbar.setTargetComponent((JComponent)this);
        return actionToolbar;
    }

    private void repaintTableData() {
        if (this.myTreeTable != null) {
            SingleInspectionProfilePanel.getExpandedNodes(this.myProfile).saveVisibleState((Tree)this.myTreeTable.getTree());
            this.reloadModel();
            this.restoreTreeState();
        }
    }

    public void selectInspectionTool(String name) {
        this.selectNode(SingleInspectionProfilePanel.findNodeByKey(name, this.myRoot));
    }

    public void selectInspectionGroup(String[] path) {
        InspectionConfigTreeNode node = SingleInspectionProfilePanel.findGroupNodeByPath(path, 0, this.myRoot);
        this.selectNode(node);
        if (node != null) {
            this.myTreeTable.getTree().expandPath(new TreePath(node.getPath()));
        }
    }

    private void selectNode(InspectionConfigTreeNode node) {
        if (node != null) {
            TreeUtil.selectNode((JTree)this.myTreeTable.getTree(), (TreeNode)node);
            int rowForPath = this.myTreeTable.getTree().getRowForPath(new TreePath(node.getPath()));
            TableUtil.selectRows((JTable)((Object)this.myTreeTable), (int[])new int[]{rowForPath});
            this.scrollToCenter();
        }
    }

    private void scrollToCenter() {
        ListSelectionModel selectionModel = this.myTreeTable.getSelectionModel();
        int maxSelectionIndex = selectionModel.getMaxSelectionIndex();
        int maxColumnSelectionIndex = Math.max(0, this.myTreeTable.getColumnModel().getSelectionModel().getMinSelectionIndex());
        Rectangle maxCellRect = this.myTreeTable.getCellRect(maxSelectionIndex, maxColumnSelectionIndex, false);
        Point selectPoint = maxCellRect.getLocation();
        int allHeight = this.myTreeTable.getVisibleRect().height;
        this.myTreeTable.scrollRectToVisible(new Rectangle(new Point(0, Math.max(0, selectPoint.y - allHeight / 2)), new Dimension(0, allHeight)));
    }

    private JScrollPane initTreeScrollPane() {
        this.fillTreeData(null, true);
        InspectionsConfigTreeRenderer renderer2 = new InspectionsConfigTreeRenderer(){

            @Override
            protected String getFilter() {
                return SingleInspectionProfilePanel.this.myProfileFilter != null ? SingleInspectionProfilePanel.this.myProfileFilter.getFilter() : null;
            }
        };
        this.myTreeTable = InspectionsConfigTreeTable.create(new InspectionsConfigTreeTable.InspectionsConfigTreeTableSettings(this.myRoot, this.myProjectProfileManager.getProject()){

            @Override
            protected void onChanged(@NotNull InspectionConfigTreeNode node) {
                if (node == null) {
                    4.$$$reportNull$$$0(0);
                }
                InspectionConfigTreeNode.updateUpHierarchy(node);
            }

            @Override
            public void updateRightPanel() {
                SingleInspectionProfilePanel.this.updateOptionsAndDescriptionPanel();
            }

            @Override
            @NotNull
            public InspectionProfileImpl getInspectionProfile() {
                InspectionProfileModifiableModel inspectionProfileModifiableModel = SingleInspectionProfilePanel.this.myProfile;
                if (inspectionProfileModifiableModel == null) {
                    4.$$$reportNull$$$0(1);
                }
                return inspectionProfileModifiableModel;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "node";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/profile/codeInspection/ui/SingleInspectionProfilePanel$4";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/profile/codeInspection/ui/SingleInspectionProfilePanel$4";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getInspectionProfile";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "onChanged";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        }, this.myDisposable);
        this.myTreeTable.setTreeCellRenderer((TreeCellRenderer)((Object)renderer2));
        this.myTreeTable.setRootVisible(false);
        TreeUtil.installActions((JTree)this.myTreeTable.getTree());
        this.myTreeTable.getTree().addTreeSelectionListener(__ -> {
            if (this.myTreeTable.getTree().getSelectionPaths() != null) {
                this.updateOptionsAndDescriptionPanel();
            } else {
                this.initOptionsAndDescriptionPanel();
            }
            if (!this.myIsInRestore && !this.isDisposed()) {
                InspectionProfileImpl baseProfile = this.myProfile.getSource();
                SingleInspectionProfilePanel.getExpandedNodes(baseProfile).setSelectionPaths(this.myTreeTable.getTree().getSelectionPaths());
                SingleInspectionProfilePanel.getExpandedNodes(this.myProfile).setSelectionPaths(this.myTreeTable.getTree().getSelectionPaths());
            }
        });
        this.myTreeTable.addMouseListener((MouseListener)new PopupHandler(){

            public void invokePopup(Component comp, int x, int y) {
                int[] selectionRows = SingleInspectionProfilePanel.this.myTreeTable.getTree().getSelectionRows();
                if (selectionRows != null && SingleInspectionProfilePanel.this.myTreeTable.getTree().getPathForLocation(x, y) != null && Arrays.binarySearch(selectionRows, SingleInspectionProfilePanel.this.myTreeTable.getTree().getRowForLocation(x, y)) > -1) {
                    SingleInspectionProfilePanel.this.compoundPopup().show(comp, x, y);
                }
            }
        });
        new TreeSpeedSearch((Tree)this.myTreeTable.getTree(), (Convertor<? super TreePath, String>)((Convertor)o -> {
            InspectionConfigTreeNode node = (InspectionConfigTreeNode)o.getLastPathComponent();
            return InspectionsConfigTreeComparator.getDisplayTextToSort(node.getText());
        }));
        JScrollPane scrollPane = ScrollPaneFactory.createScrollPane((Component)((Object)this.myTreeTable));
        this.myTreeTable.getTree().setShowsRootHandles(true);
        scrollPane.setHorizontalScrollBarPolicy(30);
        scrollPane.setBorder(IdeBorderFactory.createBorder((int)11));
        TreeUtil.collapseAll((JTree)this.myTreeTable.getTree(), (int)1);
        this.myTreeTable.getTree().addTreeExpansionListener(new TreeExpansionListener(){

            @Override
            public void treeCollapsed(TreeExpansionEvent event) {
                InspectionProfileModifiableModel selected2 = SingleInspectionProfilePanel.this.myProfile;
                SingleInspectionProfilePanel.getExpandedNodes(selected2.getSource()).saveVisibleState((Tree)SingleInspectionProfilePanel.this.myTreeTable.getTree());
                SingleInspectionProfilePanel.getExpandedNodes(selected2).saveVisibleState((Tree)SingleInspectionProfilePanel.this.myTreeTable.getTree());
            }

            @Override
            public void treeExpanded(TreeExpansionEvent event) {
                if (!SingleInspectionProfilePanel.this.isDisposed()) {
                    InspectionConfigTreeNode node = (InspectionConfigTreeNode)event.getPath().getLastPathComponent();
                    SingleInspectionProfilePanel.getExpandedNodes(SingleInspectionProfilePanel.this.myProfile.getSource()).expandNode(node);
                    SingleInspectionProfilePanel.getExpandedNodes(SingleInspectionProfilePanel.this.myProfile).expandNode(node);
                }
            }
        });
        this.myTreeExpander = new DefaultTreeExpander((JTree)this.myTreeTable.getTree()){

            public boolean canExpand() {
                return SingleInspectionProfilePanel.this.myTreeTable.isShowing();
            }

            public boolean canCollapse() {
                return SingleInspectionProfilePanel.this.myTreeTable.isShowing();
            }
        };
        this.myProfileFilter = new MyFilterComponent();
        return scrollPane;
    }

    private JPopupMenu compoundPopup() {
        DefaultActionGroup group = new DefaultActionGroup();
        SeverityRegistrar severityRegistrar = this.myProfile.getProfileManager().getSeverityRegistrar();
        for (HighlightSeverity severity : LevelChooserAction.getSeverities(severityRegistrar, this.includeDoNotShow())) {
            final HighlightDisplayLevel level = HighlightDisplayLevel.find((HighlightSeverity)severity);
            group.add(new AnAction(SingleInspectionProfilePanel.renderSeverity(severity), SingleInspectionProfilePanel.renderSeverity(severity), level.getIcon()){

                public void actionPerformed(@NotNull AnActionEvent e) {
                    if (e == null) {
                        8.$$$reportNull$$$0(0);
                    }
                    SingleInspectionProfilePanel.this.setNewHighlightingLevel(level);
                }

                public boolean isDumbAware() {
                    return true;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/profile/codeInspection/ui/SingleInspectionProfilePanel$8", "actionPerformed"));
                }
            });
        }
        group.add((AnAction)Separator.getInstance());
        ActionPopupMenu menu2 = ActionManager.getInstance().createActionPopupMenu("unknown", (ActionGroup)group);
        return menu2.getComponent();
    }

    private boolean includeDoNotShow() {
        TreePath[] paths = this.myTreeTable.getTree().getSelectionPaths();
        if (paths == null) {
            return true;
        }
        return this.includeDoNotShow(this.myTreeTable.getSelectedToolNodes());
    }

    private boolean includeDoNotShow(Collection<InspectionConfigTreeNode.Tool> nodes) {
        Project project = this.myProjectProfileManager.getProject();
        return nodes.stream().noneMatch(node -> {
            InspectionToolWrapper tool = this.myProfile.getToolDefaultState(node.getKey().toString(), project).getTool();
            return tool instanceof GlobalInspectionToolWrapper && ((GlobalInspectionToolWrapper)tool).getSharedLocalInspectionToolWrapper() == null;
        });
    }

    private void fillTreeData(@Nullable String filter, boolean forceInclude) {
        Set filters;
        if (this.isDisposed()) {
            return;
        }
        this.myRoot.removeAllChildren();
        this.myRoot.dropCache();
        ArrayList<Set<String>> keySetList = new ArrayList<Set<String>>();
        HashSet<String> quoted = new HashSet<String>();
        if (filter != null && !filter.isEmpty()) {
            keySetList.addAll(SearchUtil.findKeys(filter, quoted));
        }
        Project project = this.myProjectProfileManager.getProject();
        boolean emptyFilter = this.myInspectionsFilter.isEmptyFilter();
        for (ToolDescriptors toolDescriptors : this.myInitialToolDescriptors.values()) {
            Descriptor descriptor2 = toolDescriptors.getDefaultDescriptor();
            if (filter != null && !filter.isEmpty() && !SingleInspectionProfilePanel.isDescriptorAccepted(descriptor2, filter, forceInclude, keySetList, quoted)) continue;
            InspectionConfigTreeNode.Tool node = new InspectionConfigTreeNode.Tool((Getter<ToolDescriptors>)((Getter)() -> this.myInitialToolDescriptors.get(toolDescriptors.getDefaultDescriptor().getKey())));
            if (!emptyFilter && !this.myInspectionsFilter.matches(this.myProfile.getTools(toolDescriptors.getDefaultDescriptor().getKey().toString(), project), node)) continue;
            SingleInspectionProfilePanel.getGroupNode(this.myRoot, toolDescriptors.getDefaultDescriptor().getGroup()).add(node);
        }
        if (filter != null && forceInclude && this.myRoot.getChildCount() == 0 && ((filters = SearchableOptionsRegistrar.getInstance().getProcessedWords(filter)).size() > 1 || !quoted.isEmpty())) {
            this.fillTreeData(filter, false);
        }
        TreeUtil.sortRecursively((MutableTreeNode)this.myRoot, InspectionsConfigTreeComparator.INSTANCE);
    }

    public static void readHTML(JEditorPane browser, String text2) {
        try {
            browser.read(new StringReader(text2), null);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static String toHTML(JEditorPane browser, String text2, boolean miniFontSize) {
        HintHint hintHint = new HintHint(browser, new Point(0, 0));
        hintHint.setFont(miniFontSize ? UIUtil.getLabelFont((UIUtil.FontSize)UIUtil.FontSize.SMALL) : UIUtil.getLabelFont());
        return HintUtil.prepareHintText(text2, hintHint);
    }

    private void updateOptionsAndDescriptionPanel() {
        if (this.isDisposed()) {
            return;
        }
        final Collection<InspectionConfigTreeNode.Tool> nodes = this.myTreeTable.getSelectedToolNodes();
        if (!nodes.isEmpty()) {
            ScopesAndSeveritiesTable scopesAndScopesAndSeveritiesTable;
            double severityPanelWeightY;
            InspectionConfigTreeNode.Tool singleNode = this.myTreeTable.getStrictlySelectedToolNode();
            if (singleNode != null) {
                Descriptor descriptor2 = singleNode.getDefaultDescriptor();
                if (descriptor2.loadDescription() != null) {
                    Descriptor defaultDescriptor = singleNode.getDefaultDescriptor();
                    String description = defaultDescriptor.loadDescription();
                    try {
                        SingleInspectionProfilePanel.readHTML(this.myBrowser, SearchUtil.markup(SingleInspectionProfilePanel.toHTML(this.myBrowser, description, false), this.myProfileFilter.getFilter()));
                    }
                    catch (Throwable t) {
                        LOG.error("Failed to load description for: " + defaultDescriptor.getToolWrapper().getTool().getClass() + "; description: " + description, t);
                    }
                } else {
                    SingleInspectionProfilePanel.readHTML(this.myBrowser, SingleInspectionProfilePanel.toHTML(this.myBrowser, "Can't find inspection description.", false));
                }
            } else {
                SingleInspectionProfilePanel.readHTML(this.myBrowser, SingleInspectionProfilePanel.toHTML(this.myBrowser, "Multiple inspections are selected. You can edit them as a single inspection.", false));
            }
            this.myOptionsPanel.removeAll();
            final Project project = this.myProjectProfileManager.getProject();
            JPanel severityPanel = new JPanel(new GridBagLayout());
            final JPanel configPanelAnchor = new JPanel(new GridLayout());
            THashSet scopesNames = new THashSet();
            for (InspectionConfigTreeNode.Tool node2 : nodes) {
                List<ScopeToolState> nonDefaultTools = this.myProfile.getNonDefaultTools(node2.getDefaultDescriptor().getKey().toString(), project);
                for (ScopeToolState tool : nonDefaultTools) {
                    scopesNames.add(tool.getScopeName());
                }
            }
            if (scopesNames.isEmpty()) {
                LevelChooserAction severityLevelChooser = new LevelChooserAction(this.myProfile.getProfileManager().getSeverityRegistrar(), this.includeDoNotShow(nodes)){

                    @Override
                    protected void onChosen(HighlightSeverity severity) {
                        HighlightDisplayLevel level = HighlightDisplayLevel.find((HighlightSeverity)severity);
                        SmartList toUpdate = new SmartList();
                        for (InspectionConfigTreeNode.Tool node : nodes) {
                            HighlightDisplayKey key = node.getDefaultDescriptor().getKey();
                            NamedScope scope = node.getDefaultDescriptor().getScope();
                            boolean doUpdate = SingleInspectionProfilePanel.this.myProfile.getErrorLevel(key, scope, project) != level;
                            if (!doUpdate) continue;
                            SingleInspectionProfilePanel.this.myProfile.setErrorLevel(key, level, null, project);
                            toUpdate.add(node);
                        }
                        SingleInspectionProfilePanel.this.updateRecursively((Collection)toUpdate, false);
                        SingleInspectionProfilePanel.this.myTreeTable.updateUI();
                    }
                };
                HighlightSeverity severity = ScopesAndSeveritiesTable.getSeverity(ContainerUtil.map(nodes, node -> node.getDefaultDescriptor().getState()));
                severityLevelChooser.setChosen(severity);
                ScopesChooser scopesChooser = new ScopesChooser(ContainerUtil.map(nodes, node -> node.getDefaultDescriptor()), this.myProfile, project, null){

                    @Override
                    protected void onScopesOrderChanged() {
                        SingleInspectionProfilePanel.this.updateRecursively(nodes, true);
                    }

                    @Override
                    protected void onScopeAdded(@NotNull String scopeName) {
                        if (scopeName == null) {
                            10.$$$reportNull$$$0(0);
                        }
                        SingleInspectionProfilePanel.this.updateRecursively(nodes, true);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scopeName", "com/intellij/profile/codeInspection/ui/SingleInspectionProfilePanel$10", "onScopeAdded"));
                    }
                };
                severityPanel.add((Component)new JLabel(InspectionsBundle.message((String)"inspection.severity", (Object[])new Object[0])), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 3, (Insets)JBInsets.create((int)10, (int)0), 0, 0));
                JComponent severityLevelChooserComponent = severityLevelChooser.createCustomComponent(severityLevelChooser.getTemplatePresentation(), "unknown");
                severityPanel.add((Component)severityLevelChooserComponent, new GridBagConstraints(1, 0, 1, 1, 0.0, 1.0, 17, 1, (Insets)JBInsets.create((int)10, (int)0), 0, 0));
                JComponent scopesChooserComponent = scopesChooser.createCustomComponent(scopesChooser.getTemplatePresentation(), "unknown");
                severityPanel.add((Component)scopesChooserComponent, new GridBagConstraints(2, 0, 1, 1, 0.0, 1.0, 17, 1, (Insets)JBInsets.create((int)10, (int)0), 0, 0));
                JLabel label2 = new JLabel("", 4);
                severityPanel.add((Component)label2, new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 13, 1, (Insets)JBInsets.create((int)2, (int)0), 0, 0));
                severityPanelWeightY = 0.0;
                if (singleNode != null) {
                    SingleInspectionProfilePanel.setConfigPanel(configPanelAnchor, this.myProfile.getToolDefaultState(singleNode.getDefaultDescriptor().getKey().toString(), project));
                }
                scopesAndScopesAndSeveritiesTable = null;
            } else {
                if (singleNode != null) {
                    for (Descriptor descriptor3 : singleNode.getDescriptors().getNonDefaultDescriptors()) {
                        descriptor3.loadConfig();
                    }
                }
                scopesAndScopesAndSeveritiesTable = new ScopesAndSeveritiesTable(new ScopesAndSeveritiesTable.TableSettings(nodes, this.myProfile, project){

                    @Override
                    protected void onScopeChosen(@NotNull ScopeToolState state) {
                        if (state == null) {
                            11.$$$reportNull$$$0(0);
                        }
                        SingleInspectionProfilePanel.setConfigPanel(configPanelAnchor, state);
                        configPanelAnchor.revalidate();
                        configPanelAnchor.repaint();
                    }

                    @Override
                    protected void onSettingsChanged() {
                        SingleInspectionProfilePanel.this.updateRecursively(nodes, false);
                    }

                    @Override
                    protected void onScopeAdded() {
                        SingleInspectionProfilePanel.this.updateRecursively(nodes, false);
                    }

                    @Override
                    protected void onScopesOrderChanged() {
                        SingleInspectionProfilePanel.this.updateRecursively(nodes, true);
                    }

                    @Override
                    protected void onScopeRemoved(int scopesCount) {
                        SingleInspectionProfilePanel.this.updateRecursively(nodes, scopesCount == 1);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/profile/codeInspection/ui/SingleInspectionProfilePanel$11", "onScopeChosen"));
                    }
                });
                ToolbarDecorator wrappedTable = ToolbarDecorator.createDecorator((JTable)((Object)scopesAndScopesAndSeveritiesTable)).disableUpDownActions().setRemoveActionUpdater(__ -> {
                    int selectedRow = scopesAndScopesAndSeveritiesTable.getSelectedRow();
                    int rowCount = scopesAndScopesAndSeveritiesTable.getRowCount();
                    return rowCount - 1 != selectedRow;
                });
                JPanel panel2 = wrappedTable.createPanel();
                panel2.setMinimumSize(new Dimension(this.getMinimumSize().width, 3 * scopesAndScopesAndSeveritiesTable.getRowHeight()));
                severityPanel.add((Component)new JBLabel(InspectionsBundle.message((String)"inspection.scopes.and.severities", (Object[])new Object[0])), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 0, (Insets)JBUI.insets((int)5, (int)0, (int)2, (int)10), 0, 0));
                severityPanel.add((Component)panel2, new GridBagConstraints(0, 1, 1, 1, 0.0, 1.0, 18, 1, (Insets)JBUI.insets((int)0, (int)0, (int)0, (int)0), 0, 0));
                severityPanelWeightY = 0.3;
            }
            this.myOptionsPanel.add((Component)severityPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, severityPanelWeightY, 17, 1, (Insets)JBUI.insets((int)0, (int)2, (int)0, (int)0), 0, 0));
            GuiUtils.enableChildren((Component)this.myOptionsPanel, (boolean)this.isThoughOneNodeEnabled(nodes), (JComponent[])new JComponent[0]);
            if (configPanelAnchor.getComponentCount() != 0) {
                this.myOptionsPanel.add((Component)new ToolOptionsSeparator(configPanelAnchor, scopesAndScopesAndSeveritiesTable), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 2, (Insets)JBUI.emptyInsets(), 0, 0));
                this.myOptionsPanel.add((Component)configPanelAnchor, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 17, 1, (Insets)JBUI.insets((int)0, (int)2, (int)0, (int)0), 0, 0));
            } else if (scopesNames.isEmpty()) {
                this.myOptionsPanel.add((Component)configPanelAnchor, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 17, 1, (Insets)JBUI.insets((int)0, (int)2, (int)0, (int)0), 0, 0));
            }
            this.myOptionsPanel.revalidate();
        } else {
            this.initOptionsAndDescriptionPanel();
        }
        this.myOptionsPanel.repaint();
    }

    private void updateRecursively(Collection<? extends InspectionConfigTreeNode> nodes, boolean updateOptionsAndDescriptionPanel) {
        InspectionConfigTreeNode.updateUpHierarchy(nodes);
        this.myTreeTable.repaint();
        if (updateOptionsAndDescriptionPanel) {
            this.updateOptionsAndDescriptionPanel();
        }
    }

    private boolean isThoughOneNodeEnabled(Collection<InspectionConfigTreeNode.Tool> nodes) {
        Project project = this.myProjectProfileManager.getProject();
        for (InspectionConfigTreeNode.Tool node : nodes) {
            String toolId = node.getKey().toString();
            if (!this.myProfile.getTools(toolId, project).isEnabled()) continue;
            return true;
        }
        return false;
    }

    private void initOptionsAndDescriptionPanel() {
        this.myOptionsPanel.removeAll();
        SingleInspectionProfilePanel.readHTML(this.myBrowser, EMPTY_HTML);
        this.myOptionsPanel.validate();
        this.myOptionsPanel.repaint();
    }

    @NotNull
    public InspectionProfileModifiableModel getProfile() {
        InspectionProfileModifiableModel inspectionProfileModifiableModel = this.myProfile;
        if (inspectionProfileModifiableModel == null) {
            SingleInspectionProfilePanel.$$$reportNull$$$0(4);
        }
        return inspectionProfileModifiableModel;
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(700, 500);
    }

    public void disposeUI() {
        if (this.myInspectionProfilePanel == null) {
            return;
        }
        this.myAlarm.cancelAllRequests();
        this.myProfileFilter.dispose();
        for (ScopeToolState state : this.myProfile.getAllTools()) {
            state.resetConfigPanel();
        }
        Disposer.dispose((Disposable)this.myDisposable);
        this.myDisposable = null;
    }

    public static HyperlinkAdapter createSettingsHyperlinkListener(final Project project) {
        return new HyperlinkAdapter(){

            protected void hyperlinkActivated(HyperlinkEvent e) {
                String description = e.getDescription();
                if (description.startsWith(SingleInspectionProfilePanel.SETTINGS)) {
                    DataContext context = (DataContext)DataManager.getInstance().getDataContextFromFocus().getResult();
                    if (context != null) {
                        Settings settings = (Settings)Settings.KEY.getData(context);
                        String configId = description.substring(SingleInspectionProfilePanel.SETTINGS.length());
                        if (settings != null) {
                            settings.select(settings.find(configId));
                        } else {
                            ShowSettingsUtilImpl.showSettingsDialog(project, configId, "");
                        }
                    }
                } else {
                    BrowserUtil.browse((String)description);
                }
            }
        };
    }

    private JPanel createInspectionProfileSettingsPanel() {
        this.myBrowser = new JEditorPane("text/html", EMPTY_HTML);
        this.myBrowser.setEditable(false);
        this.myBrowser.setBorder(JBUI.Borders.empty((int)5));
        this.myBrowser.addHyperlinkListener((HyperlinkListener)SingleInspectionProfilePanel.createSettingsHyperlinkListener(this.myProjectProfileManager.getProject()));
        this.initToolStates();
        this.fillTreeData(this.myProfileFilter != null ? this.myProfileFilter.getFilter() : null, true);
        JPanel descriptionPanel = new JPanel(new BorderLayout());
        descriptionPanel.setBorder((Border)IdeBorderFactory.createTitledBorder((String)InspectionsBundle.message((String)"inspection.description.title", (Object[])new Object[0]), (boolean)false, (Insets)new JBInsets(2, 2, 0, 0)));
        descriptionPanel.add((Component)ScrollPaneFactory.createScrollPane((Component)this.myBrowser), "Center");
        JBSplitter rightSplitter = new JBSplitter(true, "SingleInspectionProfilePanel.HORIZONTAL_DIVIDER_PROPORTION", 0.5f);
        rightSplitter.setFirstComponent((JComponent)descriptionPanel);
        this.myOptionsPanel = new JPanel(new GridBagLayout());
        this.initOptionsAndDescriptionPanel();
        rightSplitter.setSecondComponent((JComponent)this.myOptionsPanel);
        rightSplitter.setHonorComponentsMinimumSize(true);
        JScrollPane tree = this.initTreeScrollPane();
        JPanel northPanel = new JPanel(new GridBagLayout());
        northPanel.setBorder((Border)JBUI.Borders.empty((int)2, (int)0));
        this.myProfileFilter.setPreferredSize(new Dimension(20, this.myProfileFilter.getPreferredSize().height));
        northPanel.add((Component)this.myProfileFilter, new GridBagConstraints(0, 0, 1, 1, 0.5, 1.0, 768, 2, (Insets)JBUI.emptyInsets(), 0, 0));
        northPanel.add((Component)this.createTreeToolbarPanel().getComponent(), new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 512, 2, (Insets)JBUI.emptyInsets(), 0, 0));
        OnePixelSplitter mainSplitter = new OnePixelSplitter(false, 0.5f, 0.01f, 0.99f);
        mainSplitter.setSplitterProportionKey("SingleInspectionProfilePanel.VERTICAL_DIVIDER_PROPORTION");
        mainSplitter.setFirstComponent((JComponent)tree);
        mainSplitter.setSecondComponent((JComponent)rightSplitter);
        mainSplitter.setHonorComponentsMinimumSize(false);
        JPanel inspectionTreePanel = new JPanel(new BorderLayout());
        inspectionTreePanel.add((Component)northPanel, "North");
        inspectionTreePanel.add((Component)mainSplitter, "Center");
        JPanel panel2 = new JPanel(new BorderLayout());
        panel2.add((Component)inspectionTreePanel, "Center");
        JBCheckBox disableNewInspectionsCheckBox = new JBCheckBox("Disable new inspections by default", this.getProfile().isProfileLocked());
        panel2.add((Component)disableNewInspectionsCheckBox, "South");
        disableNewInspectionsCheckBox.addItemListener(__ -> {
            boolean enabled = disableNewInspectionsCheckBox.isSelected();
            if (!this.isDisposed()) {
                InspectionProfileModifiableModel profile2 = this.getProfile();
                profile2.lockProfile(enabled);
            }
        });
        return panel2;
    }

    public boolean isModified() {
        if (this.myTreeTable == null) {
            return false;
        }
        if (this.myModified) {
            return true;
        }
        if (this.myProfile.isChanged()) {
            return true;
        }
        if (this.myProfile.getSource().isProjectLevel() != this.myProfile.isProjectLevel()) {
            return true;
        }
        if (!Comparing.strEqual((String)this.myProfile.getSource().getName(), (String)this.myProfile.getName())) {
            return true;
        }
        if (!Arrays.equals(this.myInitialScopesOrder, this.myProfile.getScopesOrder())) {
            return true;
        }
        return this.descriptorsAreChanged();
    }

    public void reset() {
        this.myModified = false;
        this.filterTree();
        String filter = this.myProfileFilter.getFilter();
        this.myProfileFilter.reset();
        this.myProfileFilter.setSelectedItem(filter);
        this.myProfile.setName(this.myProfile.getSource().getName());
        this.myProfile.setProjectLevel(this.myProfile.getSource().isProjectLevel());
    }

    public void apply() {
        boolean modified = this.isModified();
        if (!modified) {
            return;
        }
        InspectionProfileModifiableModel selectedProfile = this.myProfile;
        BaseInspectionProfileManager profileManager = selectedProfile.isProjectLevel() ? this.myProjectProfileManager : (BaseInspectionProfileManager)InspectionProfileManager.getInstance();
        InspectionProfileImpl source = selectedProfile.getSource();
        if (source.getProfileManager() != profileManager) {
            source.getProfileManager().deleteProfile(source);
        }
        if (selectedProfile.getProfileManager() != profileManager) {
            SingleInspectionProfilePanel.copyUsedSeveritiesIfUndefined(selectedProfile, profileManager);
            selectedProfile.setProfileManager(profileManager);
        }
        selectedProfile.commit();
        profileManager.addProfile(source);
        profileManager.fireProfileChanged(source);
        this.myModified = false;
        this.myRoot.dropCache();
        this.initToolStates();
        this.updateOptionsAndDescriptionPanel();
    }

    private boolean descriptorsAreChanged() {
        return ContainerUtil.exists(this.myInitialToolDescriptors.values(), toolDescriptors -> SingleInspectionProfilePanel.areToolDescriptorsChanged(this.myProjectProfileManager.getProject(), this.myProfile, toolDescriptors));
    }

    public static boolean areToolDescriptorsChanged(@NotNull Project project, @NotNull InspectionProfileModifiableModel profile2, @NotNull ToolDescriptors toolDescriptors) {
        Descriptor desc;
        if (project == null) {
            SingleInspectionProfilePanel.$$$reportNull$$$0(5);
        }
        if (profile2 == null) {
            SingleInspectionProfilePanel.$$$reportNull$$$0(6);
        }
        if (toolDescriptors == null) {
            SingleInspectionProfilePanel.$$$reportNull$$$0(7);
        }
        if (profile2.isToolEnabled((desc = toolDescriptors.getDefaultDescriptor()).getKey(), null, project) != desc.isEnabled()) {
            return true;
        }
        if (profile2.getErrorLevel(desc.getKey(), desc.getScope(), project) != desc.getLevel()) {
            return true;
        }
        List<Descriptor> descriptors = toolDescriptors.getNonDefaultDescriptors();
        for (Descriptor descriptor2 : descriptors) {
            if (profile2.isToolEnabled(descriptor2.getKey(), descriptor2.getScope(), project) != descriptor2.isEnabled()) {
                return true;
            }
            if (profile2.getErrorLevel(descriptor2.getKey(), descriptor2.getScope(), project) == descriptor2.getLevel()) continue;
            return true;
        }
        List<ScopeToolState> tools = profile2.getNonDefaultTools(desc.getKey().toString(), project);
        if (tools.size() != descriptors.size()) {
            return true;
        }
        for (int i = 0; i < tools.size(); ++i) {
            ScopeToolState pair = tools.get(i);
            if (Comparing.equal((Object)pair.getScope(project), (Object)descriptors.get(i).getScope())) continue;
            return true;
        }
        return false;
    }

    @Override
    public void setVisible(boolean aFlag) {
        if (aFlag && this.myInspectionProfilePanel == null) {
            this.initUI();
        }
        super.setVisible(aFlag);
    }

    private void setNewHighlightingLevel(@NotNull HighlightDisplayLevel level) {
        Collection<InspectionConfigTreeNode.Tool> tools;
        if (level == null) {
            SingleInspectionProfilePanel.$$$reportNull$$$0(8);
        }
        if (!(tools = this.myTreeTable.getSelectedToolNodes()).isEmpty()) {
            for (InspectionConfigTreeNode.Tool tool : tools) {
                this.updateErrorLevel(tool, level);
            }
            this.updateOptionsAndDescriptionPanel();
        } else {
            this.initOptionsAndDescriptionPanel();
        }
        this.repaintTableData();
    }

    private void updateErrorLevel(InspectionConfigTreeNode.Tool child2, @NotNull HighlightDisplayLevel level) {
        if (level == null) {
            SingleInspectionProfilePanel.$$$reportNull$$$0(9);
        }
        HighlightDisplayKey key = child2.getKey();
        this.myProfile.setErrorLevel(key, level, null, this.myProjectProfileManager.getProject());
        child2.dropCache();
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myTreeTable;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectProfileManager";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profile";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/profile/codeInspection/ui/SingleInspectionProfilePanel";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolDescriptors";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "level";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/profile/codeInspection/ui/SingleInspectionProfilePanel";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getProfile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findGroupNodeByPath";
                break;
            }
            case 4: {
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "areToolDescriptorsChanged";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setNewHighlightingLevel";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "updateErrorLevel";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class ToolOptionsSeparator
    extends JPanel {
        private final LinkLabel<?> myResetLink;
        @Nullable
        private final ScopesAndSeveritiesTable myScopesAndSeveritiesTable;

        ToolOptionsSeparator(@Nullable JComponent options, ScopesAndSeveritiesTable scopesAndSeveritiesTable) {
            this.myScopesAndSeveritiesTable = scopesAndSeveritiesTable;
            this.setLayout(new GridBagLayout());
            GridBagConstraints optionsLabelConstraints = new GridBagConstraints(0, 0, 1, 1, 0.0, 1.0, 17, 0, (Insets)JBUI.insets((int)0, (int)2, (int)0, (int)0), 0, 0);
            this.add((Component)new JBLabel("Options"), optionsLabelConstraints);
            GridBagConstraints separatorConstraints = new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 10, 2, (Insets)JBUI.insets((int)2, (int)6, (int)0, (int)3), 0, 0);
            this.add((Component)new JSeparator(0), separatorConstraints);
            GridBagConstraints resetLabelConstraints = new GridBagConstraints(2, 0, 0, 1, 0.0, 1.0, 13, 0, (Insets)JBUI.emptyInsets(), 0, 0);
            UserActivityWatcher userActivityWatcher = new UserActivityWatcher();
            userActivityWatcher.addUserActivityListener(() -> this.setupResetLinkVisibility());
            userActivityWatcher.register((Component)options);
            this.myResetLink = LinkLabel.create((String)"Reset", () -> {
                ScopeToolState state = this.getSelectedState();
                if (state != null) {
                    state.resetConfigPanel();
                    Project project = SingleInspectionProfilePanel.this.myProjectProfileManager.getProject();
                    SingleInspectionProfilePanel.this.myProfile.resetToBase(state.getTool().getTool().getShortName(), state.getScope(project), project);
                    SingleInspectionProfilePanel.this.updateOptionsAndDescriptionPanel();
                }
            });
            this.add((Component)this.myResetLink, resetLabelConstraints);
            this.setupResetLinkVisibility();
        }

        private void setupResetLinkVisibility() {
            if (SingleInspectionProfilePanel.this.myTreeTable == null || SingleInspectionProfilePanel.this.isDisposed()) {
                return;
            }
            InspectionConfigTreeNode.Tool node = SingleInspectionProfilePanel.this.myTreeTable.getStrictlySelectedToolNode();
            if (node != null) {
                ScopeToolState state = this.getSelectedState();
                if (state == null) {
                    return;
                }
                Project project = SingleInspectionProfilePanel.this.myProjectProfileManager.getProject();
                boolean canReset = !SingleInspectionProfilePanel.this.myProfile.isProperSetting(state.getTool().getTool().getShortName(), state.getScope(project), project);
                this.myResetLink.setVisible(canReset);
                this.revalidate();
                this.repaint();
            }
        }

        private ScopeToolState getSelectedState() {
            InspectionConfigTreeNode.Tool node = SingleInspectionProfilePanel.this.myTreeTable.getStrictlySelectedToolNode();
            if (node == null) {
                return null;
            }
            if (this.myScopesAndSeveritiesTable != null) {
                List<ScopeToolState> selectedStates = this.myScopesAndSeveritiesTable.getSelectedStates();
                LOG.assertTrue(selectedStates.size() == 1);
                return selectedStates.get(0);
            }
            return node.getDescriptors().getDefaultDescriptor().getState();
        }
    }

    private class MyFilterComponent
    extends FilterComponent {
        private MyFilterComponent() {
            super(SingleInspectionProfilePanel.INSPECTION_FILTER_HISTORY, 10);
        }

        public void filter() {
            SingleInspectionProfilePanel.this.filterTree();
        }

        protected void onlineFilter() {
            if (SingleInspectionProfilePanel.this.isDisposed()) {
                return;
            }
            String filter = this.getFilter();
            SingleInspectionProfilePanel.getExpandedNodes(SingleInspectionProfilePanel.this.myProfile).saveVisibleState((Tree)SingleInspectionProfilePanel.this.myTreeTable.getTree());
            SingleInspectionProfilePanel.this.fillTreeData(filter, true);
            SingleInspectionProfilePanel.this.reloadModel();
            if (filter == null || filter.isEmpty()) {
                SingleInspectionProfilePanel.this.restoreTreeState();
            } else {
                TreeUtil.expandAll((JTree)SingleInspectionProfilePanel.this.myTreeTable.getTree());
            }
        }
    }
}

