/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.laf.intellij;

import com.intellij.ide.ui.laf.darcula.DarculaUIUtil;
import com.intellij.ide.ui.laf.darcula.ui.DarculaTextBorder;
import com.intellij.ide.ui.laf.intellij.WinIntelliJTextFieldUI;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.JBValue;
import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Path2D;
import javax.swing.JComponent;
import javax.swing.UIManager;

public class WinIntelliJTextBorder
extends DarculaTextBorder {
    static final JBValue MINIMUM_HEIGHT = new JBValue.Float(22.0f);

    @Override
    public Insets getBorderInsets(Component c2) {
        return DarculaUIUtil.isTableCellEditor(c2) || DarculaUIUtil.isCompact(c2) ? JBUI.insets((int)1, (int)1, (int)1, (int)4).asUIResource() : JBUI.insets((int)1).asUIResource();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintBorder(Component c2, Graphics g, int x, int y, int width, int height) {
        JComponent jc = (JComponent)c2;
        if (jc.getClientProperty("JTextField.Search.noBorderRing") == Boolean.TRUE) {
            return;
        }
        Graphics2D g2 = (Graphics2D)g.create();
        try {
            Rectangle r = new Rectangle(x, y, width, height);
            WinIntelliJTextFieldUI.adjustInWrapperRect(r, c2);
            boolean isCellRenderer = DarculaUIUtil.isTableCellEditor(c2);
            int bw = 1;
            Object op = jc.getClientProperty("JComponent.outline");
            if (c2.isEnabled() && op != null) {
                DarculaUIUtil.Outline.valueOf(op.toString()).setGraphicsColor(g2, c2.hasFocus());
                bw = isCellRenderer ? 1 : 2;
            } else {
                if (c2.hasFocus()) {
                    g2.setColor(UIManager.getColor("TextField.focusedBorderColor"));
                } else if (jc.getClientProperty("JTextField.hover") == Boolean.TRUE) {
                    g2.setColor(UIManager.getColor("TextField.hoverBorderColor"));
                } else {
                    g2.setColor(UIManager.getColor(c2.isEnabled() ? "TextField.borderColor" : "Button.intellij.native.borderColor"));
                }
                if (!c2.isEnabled()) {
                    g2.setComposite(AlphaComposite.getInstance(3, 0.47f));
                }
                if (!isCellRenderer) {
                    JBInsets.removeFrom((Rectangle)r, (Insets)JBUI.insets((int)1));
                }
            }
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
            Path2D.Float border = new Path2D.Float(0);
            border.append(r, false);
            Rectangle innerRect = new Rectangle(r);
            JBInsets.removeFrom((Rectangle)innerRect, (Insets)JBUI.insets((int)bw));
            border.append(innerRect, false);
            g2.fill(border);
        }
        finally {
            g2.dispose();
        }
    }
}

