/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.render;

import com.intellij.openapi.ui.GraphicsConfig;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.ImageUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Path2D;
import java.awt.image.BufferedImage;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class LabelIcon
implements Icon {
    public static final float SIZE = 6.25f;
    private final int mySize;
    @NotNull
    private final List<? extends Color> myColors;
    @NotNull
    private final Color myBgColor;
    @NotNull
    private BufferedImage myImage;

    public LabelIcon(@NotNull JComponent component, int size, @NotNull Color bgColor, @NotNull List<? extends Color> colors) {
        if (component == null) {
            LabelIcon.$$$reportNull$$$0(0);
        }
        if (bgColor == null) {
            LabelIcon.$$$reportNull$$$0(1);
        }
        if (colors == null) {
            LabelIcon.$$$reportNull$$$0(2);
        }
        this.mySize = size;
        this.myBgColor = bgColor;
        this.myColors = colors;
        this.myImage = this.createImage(component, null);
    }

    private BufferedImage createImage(Component c, Graphics2D g) {
        BufferedImage image = c != null ? UIUtil.createImage((GraphicsConfiguration)c.getGraphicsConfiguration(), (int)this.getIconWidth(), (int)this.getIconHeight(), (int)2) : UIUtil.createImage((Graphics)g, (int)this.getIconWidth(), (int)this.getIconHeight(), (int)2);
        this.paintIcon(image.createGraphics());
        return image;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        if (ImageUtil.getImageScale((Image)this.myImage) != (double)JBUIScale.sysScale((Graphics2D)((Graphics2D)g))) {
            this.myImage = this.createImage(null, (Graphics2D)g);
        }
        UIUtil.drawImage((Graphics)g, (Image)this.myImage, (int)x, (int)y, null);
    }

    private void paintIcon(@NotNull Graphics2D g2) {
        if (g2 == null) {
            LabelIcon.$$$reportNull$$$0(3);
        }
        GraphicsConfig config = GraphicsUtil.setupAAPainting((Graphics)g2);
        float scale = (float)this.mySize / 6.25f;
        for (int i = this.myColors.size() - 1; i >= 0; --i) {
            if (i != this.myColors.size() - 1) {
                g2.setColor(this.myBgColor);
                this.paintTag(g2, scale, scale * 2.0f * (float)i + 1.0f, 0.0f);
            }
            g2.setColor(this.myColors.get(i));
            this.paintTag(g2, scale, scale * 2.0f * (float)i, 0.0f);
        }
        config.restore();
    }

    public void paintTag(Graphics2D g2, float scale, float x, float y) {
        Path2D.Float path = new Path2D.Float();
        x = (float)((double)x + (double)scale * 0.25);
        path.moveTo(x, y += scale);
        path.lineTo(x + 2.0f * scale, y);
        path.lineTo(x + 5.0f * scale, y + 3.0f * scale);
        path.lineTo(x + 3.0f * scale, y + 5.0f * scale);
        path.lineTo(x, y + 2.0f * scale);
        path.lineTo(x, y);
        path.closePath();
        Ellipse2D.Float hole = new Ellipse2D.Float(x + 1.0f * scale, y + 1.0f * scale, scale, scale);
        Area area = new Area(path);
        area.subtract(new Area(hole));
        g2.fill(area);
    }

    @Override
    public int getIconWidth() {
        return this.getWidth(this.myColors.size());
    }

    protected int getWidth(int labelsCount) {
        return LabelIcon.getWidth(this.mySize, labelsCount);
    }

    public static int getWidth(int height, int labelsCount) {
        float scale = (float)height / 6.25f;
        return Math.round((6.25f + (float)(2 * (labelsCount - 1))) * scale);
    }

    @Override
    public int getIconHeight() {
        return this.mySize;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bgColor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "colors";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "g2";
                break;
            }
        }
        objectArray2[1] = "com/intellij/vcs/log/ui/render/LabelIcon";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "paintIcon";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

