/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.impl;

import com.intellij.ide.DataManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsRoot;
import com.intellij.openapi.vcs.changes.ui.ChangesViewContentEP;
import com.intellij.openapi.vcs.changes.ui.ChangesViewContentProvider;
import com.intellij.ui.components.JBPanel;
import com.intellij.util.Consumer;
import com.intellij.util.NotNullFunction;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.vcs.log.impl.VcsLogManager;
import com.intellij.vcs.log.impl.VcsProjectLog;
import com.intellij.vcs.log.ui.VcsLogPanel;
import com.intellij.vcs.log.ui.VcsLogUiImpl;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.Arrays;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsLogContentProvider
implements ChangesViewContentProvider {
    private static final Logger LOG = Logger.getInstance(VcsLogContentProvider.class);
    public static final String TAB_NAME = "Log";
    @NotNull
    private final VcsProjectLog myProjectLog;
    @NotNull
    private final JPanel myContainer;
    @Nullable
    private Consumer<? super VcsLogUiImpl> myOnCreatedListener;
    @Nullable
    private volatile VcsLogUiImpl myUi;

    public VcsLogContentProvider(@NotNull Project project, @NotNull VcsProjectLog projectLog) {
        if (project == null) {
            VcsLogContentProvider.$$$reportNull$$$0(0);
        }
        if (projectLog == null) {
            VcsLogContentProvider.$$$reportNull$$$0(1);
        }
        this.myContainer = new JBPanel((LayoutManager)new BorderLayout());
        this.myProjectLog = projectLog;
        MessageBusConnection connection = project.getMessageBus().connect((Disposable)projectLog);
        connection.subscribe(VcsProjectLog.VCS_PROJECT_LOG_CHANGED, (Object)new VcsProjectLog.ProjectLogListener(){

            @Override
            public void logCreated(@NotNull VcsLogManager logManager) {
                if (logManager == null) {
                    1.$$$reportNull$$$0(0);
                }
                VcsLogContentProvider.this.addMainUi(logManager);
            }

            @Override
            public void logDisposed(@NotNull VcsLogManager logManager) {
                if (logManager == null) {
                    1.$$$reportNull$$$0(1);
                }
                VcsLogContentProvider.this.disposeMainUi();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "logManager";
                objectArray2[1] = "com/intellij/vcs/log/impl/VcsLogContentProvider$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "logCreated";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "logDisposed";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        VcsLogManager manager = this.myProjectLog.getLogManager();
        if (manager != null) {
            this.addMainUi(manager);
        }
    }

    @Nullable
    public VcsLogUiImpl getUi() {
        return this.myUi;
    }

    private void addMainUi(@NotNull VcsLogManager logManager) {
        if (logManager == null) {
            VcsLogContentProvider.$$$reportNull$$$0(2);
        }
        LOG.assertTrue(ApplicationManager.getApplication().isDispatchThread());
        if (this.myUi == null) {
            this.myUi = logManager.createLogUi("MAIN", true);
            VcsLogPanel panel2 = new VcsLogPanel(logManager, this.myUi);
            this.myContainer.add((Component)((Object)panel2), "Center");
            DataManager.registerDataProvider((JComponent)this.myContainer, (DataProvider)panel2);
            if (this.myOnCreatedListener != null) {
                this.myOnCreatedListener.consume((Object)this.myUi);
            }
            this.myOnCreatedListener = null;
        }
    }

    private void disposeMainUi() {
        LOG.assertTrue(ApplicationManager.getApplication().isDispatchThread());
        this.myContainer.removeAll();
        DataManager.removeDataProvider((JComponent)this.myContainer);
        this.myOnCreatedListener = null;
        if (this.myUi != null) {
            VcsLogUiImpl ui2 = this.myUi;
            this.myUi = null;
            Disposer.dispose((Disposable)ui2);
        }
    }

    @Override
    public JComponent initContent() {
        ApplicationManager.getApplication().executeOnPooledThread(() -> this.myProjectLog.createLog(true));
        return this.myContainer;
    }

    public void executeOnMainUiCreated(@NotNull Consumer<? super VcsLogUiImpl> consumer) {
        if (consumer == null) {
            VcsLogContentProvider.$$$reportNull$$$0(3);
        }
        LOG.assertTrue(ApplicationManager.getApplication().isDispatchThread());
        if (this.myUi == null) {
            this.myOnCreatedListener = consumer;
        } else {
            consumer.consume((Object)this.myUi);
        }
    }

    @Override
    public void disposeContent() {
        this.disposeMainUi();
    }

    @Nullable
    public static VcsLogContentProvider getInstance(@NotNull Project project) {
        if (project == null) {
            VcsLogContentProvider.$$$reportNull$$$0(4);
        }
        for (ChangesViewContentEP ep : ChangesViewContentEP.EP_NAME.getExtensionList((AreaInstance)project)) {
            if (!ep.getClassName().equals(VcsLogContentProvider.class.getName())) continue;
            return (VcsLogContentProvider)ep.getCachedInstance();
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectLog";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logManager";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
        }
        objectArray2[1] = "com/intellij/vcs/log/impl/VcsLogContentProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "addMainUi";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "executeOnMainUiCreated";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getInstance";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class VcsLogVisibilityPredicate
    implements NotNullFunction<Project, Boolean> {
        @NotNull
        public Boolean fun(Project project) {
            VcsRoot[] roots = ProjectLevelVcsManager.getInstance((Project)project).getAllVcsRoots();
            Boolean bl = !VcsLogManager.findLogProviders(Arrays.asList(roots), project).isEmpty();
            if (bl == null) {
                VcsLogVisibilityPredicate.$$$reportNull$$$0(0);
            }
            return bl;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/impl/VcsLogContentProvider$VcsLogVisibilityPredicate", "fun"));
        }
    }
}

