/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class ChangesPreprocess {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.vcs.changes.ChangesPreprocess");

    public static List<Change> preprocessChangesRemoveDeletedForDuplicateMoved(List<? extends Change> list) {
        ArrayList<Change> result2 = new ArrayList<Change>();
        HashMap<FilePath, Change> map2 = new HashMap<FilePath, Change>();
        for (Change change : list) {
            if (change.getBeforeRevision() == null) {
                result2.add(change);
                continue;
            }
            FilePath beforePath = ChangesUtil.getBeforePath((Change)change);
            Change existing = (Change)map2.get(beforePath);
            if (existing == null) {
                map2.put(beforePath, change);
                continue;
            }
            if (change.getAfterRevision() == null && existing.getAfterRevision() == null) continue;
            if (change.getAfterRevision() != null && existing.getAfterRevision() != null) {
                LOG.error("Incorrect changes list: " + list);
            }
            if (existing.getAfterRevision() != null && change.getAfterRevision() == null || change.getAfterRevision() == null || existing.getAfterRevision() != null) continue;
            map2.put(beforePath, change);
        }
        result2.addAll(map2.values());
        return result2;
    }
}

