/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.ui.dashboard;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javafx.animation.FadeTransition;
import javafx.scene.Node;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.StackPane;
import javafx.util.Duration;
import javax.inject.Inject;
import org.pdfsam.ui.dashboard.DashboardItem;
import org.pdfsam.ui.dashboard.DashboardItemPane;
import org.pdfsam.ui.dashboard.QuickbarDashboardButtonsPane;
import org.pdfsam.ui.event.SetActiveDashboardItemRequest;
import org.pdfsam.ui.event.SetTitleEvent;
import org.pdfsam.ui.quickbar.QuickbarPane;
import org.pdfsam.ui.support.Style;
import org.sejda.eventstudio.StaticStudio;
import org.sejda.eventstudio.annotation.EventListener;

public class Dashboard
extends BorderPane {
    private Map<String, DashboardItemPane> items = new HashMap<String, DashboardItemPane>();
    private StackPane center = new StackPane();
    private FadeTransition fade = new FadeTransition(new Duration(300.0), (Node)this.center);

    @Inject
    public Dashboard(List<DashboardItem> itemsList, QuickbarDashboardButtonsPane dashboardButtons) {
        this.getStyleClass().addAll((Object[])Style.CONTAINER.css());
        this.setId("pdfsam-dashboard");
        itemsList.stream().filter(i -> !i.disabled()).forEach(i -> this.items.put(i.id(), new DashboardItemPane((DashboardItem)i)));
        this.fade.setFromValue(0.0);
        this.fade.setToValue(1.0);
        this.setCenter((Node)this.center);
        this.setLeft((Node)new QuickbarPane(dashboardButtons));
        StaticStudio.eventStudio().addAnnotatedListeners((Object)this);
    }

    @EventListener
    public void onSetActiveDashboardItem(SetActiveDashboardItemRequest request) {
        DashboardItemPane requested = this.items.get(request.getActiveItemId());
        if (requested != null) {
            this.center.getChildren().setAll((Object[])new Node[]{requested});
            this.fade.play();
            StaticStudio.eventStudio().broadcast((Object)new SetTitleEvent(requested.getItem().name()));
        }
    }

    public boolean hasItem(String id) {
        return this.items.containsKey(id);
    }
}

