"use strict";

var _modules = require("ui/modules");

var _i18n = require("ui/i18n");

var filterActions = _interopRequireWildcard(require("plugins/kibana/discover/doc_table/actions/filter"));

var _filter_manager = require("ui/filter_manager");

var _query_filter = require("ui/filter_manager/query_filter");

var _dashboard_viewport_provider = require("./viewport/dashboard_viewport_provider");

var _dashboard_app_controller = require("./dashboard_app_controller");

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {}; if (desc.get || desc.set) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } } newObj.default = obj; return newObj; } }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
// @ts-ignore
// @ts-ignore
// @ts-ignore
// @ts-ignore -- going away soon
var app = _modules.uiModules.get('app/dashboard', ['elasticsearch', 'ngRoute', 'react', 'kibana/courier', 'kibana/config']);

app.directive('dashboardViewportProvider', function (reactDirective) {
  return reactDirective((0, _i18n.wrapInI18nContext)(_dashboard_viewport_provider.DashboardViewportProvider));
});
app.directive('dashboardApp', function ($injector) {
  var AppState = $injector.get('AppState');
  var kbnUrl = $injector.get('kbnUrl');
  var confirmModal = $injector.get('confirmModal');
  var config = $injector.get('config');
  var courier = $injector.get('courier');
  var Private = $injector.get('Private');
  var queryFilter = Private(_query_filter.FilterBarQueryFilterProvider);
  var filterGen = (0, _filter_manager.getFilterGenerator)(queryFilter);

  var addFilter = function addFilter(_ref, appState) {
    var field = _ref.field,
        value = _ref.value,
        operator = _ref.operator,
        index = _ref.index;
    filterActions.addFilter(field, value, operator, index, appState, filterGen);
  };

  var indexPatterns = $injector.get('indexPatterns');
  return {
    restrict: 'E',
    controllerAs: 'dashboardApp',
    controller: function controller($scope, $rootScope, $route, $routeParams, getAppState, dashboardConfig, localStorage) {
      return new _dashboard_app_controller.DashboardAppController({
        $route: $route,
        $rootScope: $rootScope,
        $scope: $scope,
        $routeParams: $routeParams,
        getAppState: getAppState,
        dashboardConfig: dashboardConfig,
        localStorage: localStorage,
        Private: Private,
        kbnUrl: kbnUrl,
        AppStateClass: AppState,
        indexPatterns: indexPatterns,
        config: config,
        confirmModal: confirmModal,
        addFilter: addFilter,
        courier: courier
      });
    }
  };
});